<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* Bibliography Import HELP class (English)
*
* NOTE TO TRANSLATORS:  1/  Both the class name and the constructor name should be changed to match the (case-sensitive) name of 
*				the folder your language files are in.  For example, if you are supplying a Klingon translation and 
*				your languages/ folder is languages/kn/, the class and constructor name for the file SUCCESS.php 
*				must both be SUCCESS_kn.
*****/
class HELPIMPORT_en
{
// Constructor
	function HELPIMPORT_en()
	{
////////////////////////////////////////////////////////////////////////////////////
// TRANSLATORS start here.  Translate ONLY the second string in each define().
define("TEXT1", "If you have WIKINDX admin rights, you can import a BibTeX .bib or Endnote XML bibliography into WIKINDX.");
define("TEXT2", "There are a number of options:");
define("TEXT3", "Tagging an import allows you to add a descriptive label to this import. When deleting resources, you may choose to delete individual resources or to delete a tag which will delete all resources that were imported under that tag. Additionally, when listing resources using the 'select' method, you can select by tag.");
define("TEXT4", "If you choose not to import duplicates, WIKINDX will discard resources whose title already exists in the database.");
define("TEXT5", "You may store fields that WIKINDX does not use so that any resources later exported to BibTeX or Endnote can include this original unchanged data. (Doing this, also stores any @string strings that are in the imported BibTeX file.)");
define("TEXT6", "Tips for Importing BibTeX Files into WIKINDX");
define("TEXT7", "WIKINDX will map either the BibTeX field 'note' or 'annote' to the WIKINDX note field. The former takes precedence over the latter.");
// Don't translate '@MISC' and 'howpublished = \"\url{http://www.blah.com}\"'
define("TEXT8", "Since BibTeX (currently) has no entry type for articles published on the web, WIKINDX will convert @MISC entries with a field 'howpublished = \"\url{http://www.blah.com}\"' to its web_article type.");
define("TEXT9", "LaTeX symbols are converted to their UTF-8 equivalents.");
define("TEXT10", "The web server and php.ini file may limit the size of file uploads. If you experience difficulties, try splitting a large file into more manageable chunks or, where possible, adjust memory constraints in php.ini.");
define("TEXT11", "Imports may fail or halt part-way through if max_execution_time in php.ini is exceeded by the script. Again, the best solution is to split the file into manageable chunks or adjust php.ini. As a (very) rough example, a 2.67MB (3800 entry) BibTeX file is imported in 340 seconds on a P4/500MB linux system.");
define("TEXT12", "The BibTeX 'keywords' field is expected to be delimited by ';'");
// Don't translate '@STRING'
define("TEXT13", "WIKINDX happily and indiscriminately substitutes entries of type @STRING.");
define("TEXT14", "WIKINDX expects the BibTeX 'page' field to have the form 45--76 or 45-76 or vii--xi (or with spaces). For any other form, WIKINDX will take the first valid number it finds in the page field and use that for its 'pageStart' field.");
define("TEXT15", "Please note: this version of WIKINDX only supports Endnote v7 and v8 XML importing.  It is untested with earlier versions of Endnote.  Endnote v7 and Endnote v8 have a very different XML export structure; because of the database structure of WIKINDX, you are likely to get better results importing a v8 XML file than a v7 XML file. If you do not have Endnote v8, you may wish to download the v8 demo, import your earlier Endnote libraries, export to XML from v8 and import that XML file to WIKINDX.");
// TRANSLATORS end here
////////////////////////////////////////////////////////////////////////////////////
		include_once("core/html/MISC.php");
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
	}
// Help page
	function display()
	{
		$this->template->setVar('heading', 
			$this->utf8->decodeUtf8($this->messages->text("heading", "helpBibtex")));
		$this->pString = MISC::aName("top");
		$this->bibtexFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p(MISC::a("link", 
			$this->utf8->decodeUtf8($this->messages->text("misc", "top")), "#top"), "small", "right");
		$this->template->setVar('body', $this->pString);
		return $this->template->process();
	}
// print help importing BibTeX files
	function bibtexFiles()
	{
		$this->pString .= TEXT1;
		$this->pString .= MISC::p(MISC::i(TEXT15));
		$this->pString .= MISC::p(TEXT2 . 
		MISC::ul(
		MISC::li(TEXT3) . 
		MISC::li(TEXT4) . 
		MISC::li(TEXT5) . 
		MISC::li(TEXT10) . 
		MISC::li(TEXT11)
		));
		$this->pString .= MISC::p(TEXT6 . ":" . 
		MISC::ul(
		MISC::li(TEXT7) . 
		MISC::li(TEXT8) . 
		MISC::li(TEXT9) . 
		MISC::li(TEXT12) . 
		MISC::li(TEXT13) . 
		MISC::li(TEXT14)
		));
	}
}
