<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* HELP - Admin Configure ENGLISH class
*
* NOTE TO TRANSLATORS:  1/  Both the class name and the constructor name should be changed to match the (case-sensitive) name of 
*				the folder your language files are in.  For example, if you are supplying a Klingon translation and 
*				your languages/ folder is languages/kn/, the class and constructor name for the file SUCCESS.php 
*				must both be SUCCESS_kn.
*****/
class HELPCONFIG_en
{
// Constructor
	function HELPCONFIG_en()
	{
////////////////////////////////////////////////////////////////////////////////////
// TRANSLATORS start here.  Translate ONLY the second string in each define().
define("GENERAL", "General Notes");
define("G_TEXT1", "This help is intended for WIKINDX administrators only.");
define("G_TEXT2", "To use WIKINDX fully, you must have cookies turned on in your web browser preferences.");
define("G_TEXT3", "The files/ directory must be writeable by the general web user and is utilised for the temporary storage of exported RTF and BibTeX files (see below).");
define("CONFIG", "Configuration Parameters");
define("C_TEXT1", "There are a number of default configuration parameters the administrator can set.");
define("C_TEXT2", "The following are required");
define("C_TEXT3", "Superadmin");
define("C_TEXT4", "Your gateway to WIKINDX administration.");
define("C_TEXT5", "File Deletion");
define("C_TEXT6", "When a user exports a bibliographic list, a directory is created in files/ for that user based on their SESSION ID and files are written to that directory. WIKINDX uses a lazy form of garbage disposal: each time any user exports a file, WIKINDX checks all files and directories in the files/ directory to see if their age exceeds the deletion time you have set; if they have, files will be deleted and empty directories the subsequent export. However, when a user actively logs out, that folder and all the files within it are deleted immediately.");
define("C_TEXT7", "Language");
define("C_TEXT8", "Template");
define("C_TEXT9", "The choice of templates allows the user to radically alter the look and feel of WIKINDX and even import WIKINDX into an existing web page.");
define("C_TEXT10", "Bibliographic Style");
define("C_TEXT11", "These are used to display and export WIKINDX resources in a format suitable for inclusion in a bibliography.");
define("C_TEXT12", "Paging Parameters");
define("C_TEXT13", "Paging allows the user to limit the maximum number of resources displayed on the browser. The number of paging links displayed at the bottom of the screen can also be adjusted.");
define("C_TEXT14", "Character Limiting");
define("C_TEXT15", "Sometimes the text displayed in a form select box is long enough to cause problems with the web browser display. This is often the case with journal titles or publisher names. This field allows the user to limit the amount of text with any dropped text being replaced by ' ... '.");
define("C_TEXT16", "The following are optional");
define("C_TEXT17", "Title and Logo parameters");
define("C_TEXT18", "Contact Email and Description");
define("C_TEXT19", "Displayed on the front page");
define("C_TEXT20", "Multi user mode");
define("C_TEXT21", "Checking this enables WIKINDX's multi user mode.  Users can log on and have access to their own preferences, bibliographic lists etc.");
define("C_TEXT22", "Allow user registration");
define("C_TEXT23", "This is disabled if multi user mode above is not checked. Potential users of your WIKINDX can register themselves as users.  It requires a valid mail server to be set up in php.ini as those registering are required to confirm their registration upon receipt of an email. Any persons not registering within 10 days of receipt of that email will have their request for registration removed from the database.");
define("C_TEXT24", "Allow email notification");
define("C_TEXT25", "This is disabled if multi user mode above is not checked. WIKINDX users can opt to be emailed when another user adds edits a resource or any of its text.  It requires a valid mail server to be set up in php.ini.");
define("C_TEXT26", "In Preferences, users can override the following");
define("C_TEXT27", "BBCode Image Display Limit");
define("C_TEXT28", "For users linking to images with BBCode, you can limit the display size.");
define("C_TEXT29", "Allow file attachments");
// Don't translate 'attachments/'
define("C_TEXT30", "Each resource can have one file attached to it. Files are uploaded to the 'attachments/' folder which must be writeable by everyone or at least the web server user.");
define("C_TEXT31", "Allow only logged on users to view file attachments");
define("C_TEXT32", "Checking this ensures that only logged on users can view file attachments.");
// Don't translate "PHP's mkDir()"
define("C_TEXT33", "Please note, due to a well-known 'feature' of PHP's mkDir() function, WIKINDX is unable to remove these directories on some operating systems. If WIKINDX is unable to delete a directory, no warning will be issued so you should occasionally check the files/ directory for this behaviour.");
define("C_TEXT34", "Pasting bibTeX entries");
define("C_TEXT35", "You can control the maximum number of bibTeX entries a user can paste in.  Large numbers (c500+) may require some adjustments to php.ini.");
// TRANSLATORS end here
////////////////////////////////////////////////////////////////////////////////////
		include_once("core/html/MISC.php");
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// Help page
	function display()
	{
		include_once("core/messages/UTF8.php");
		$utf8 = new UTF8();
		$this->template->setVar('heading', $utf8->decodeUtf8($this->messages->text("heading", "help")));
		$this->pString = MISC::aName("top");
		$this->welcome();
		$this->pString .= MISC::p(MISC::hr());
		$this->configHelp();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p(MISC::a("link", $utf8->decodeUtf8($this->messages->text("misc", "top")), "#top"), 
			"small", "right");
		$this->template->setVar('body', $this->pString);
		return $this->template->process();
	}
// print welcome
	function welcome()
	{
		$this->pString .= MISC::p(MISC::b(GENERAL . ":"));
		$this->pString .= MISC::p(G_TEXT1);
		$this->pString .= MISC::p(G_TEXT2);
		$this->pString .= MISC::p(G_TEXT3);
	}
// print help on configure
	function configHelp()
	{
		$this->pString .= MISC::p(MISC::b(CONFIG . ":"));
		$this->pString .= C_TEXT1;
		$this->pString .= MISC::p(C_TEXT2 . ":" . 
		MISC::ul(
		MISC::li(MISC::b(C_TEXT3) . " " . C_TEXT4) . 
		MISC::li(MISC::b(C_TEXT5) . " " . C_TEXT6) . MISC::p(MISC::i(C_TEXT33)) . 
		MISC::li(MISC::b(C_TEXT7)) . 
		MISC::li(MISC::b(C_TEXT8) . " " . C_TEXT9) . 
		MISC::li(MISC::b(C_TEXT10) . " " . C_TEXT11) . 
		MISC::li(MISC::b(C_TEXT12) . " " . C_TEXT13) . 
		MISC::li(MISC::b(C_TEXT14) . " " . C_TEXT15) . 
		MISC::li(MISC::b(C_TEXT27) . " " . C_TEXT28) . 
		MISC::li(MISC::b(C_TEXT34) . " " . C_TEXT35)
		));
		$this->pString .= MISC::p(C_TEXT16 . ":" . 
		MISC::ul(
		MISC::li(MISC::b(C_TEXT17)) . 
		MISC::li(MISC::b(C_TEXT18) . " " . C_TEXT19) . 
		MISC::li(MISC::b(C_TEXT20) . " " . C_TEXT21) . 
		MISC::li(MISC::b(C_TEXT22) . " " . C_TEXT23) . 
		MISC::li(MISC::b(C_TEXT24) . " " . C_TEXT25) . 
		MISC::li(MISC::b(C_TEXT29) . " " . C_TEXT30) . 
		MISC::li(MISC::b(C_TEXT31) . " " . C_TEXT32)
		));
		$this->pString .= MISC::p(C_TEXT26 . ":" . 
		MISC::ul(
		MISC::li(MISC::b(C_TEXT7)) . 
		MISC::li(MISC::b(C_TEXT8)) . 
		MISC::li(MISC::b(C_TEXT10)) . 
		MISC::li(MISC::b(C_TEXT12)) . 
		MISC::li(MISC::b(C_TEXT14))
		));
	}
}
