<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* HELP ENGLISH class
*
* NOTE TO TRANSLATORS:  1/  Both the class name and the constructor name should be changed to match the (case-sensitive) name of 
*				the folder your language files are in.  For example, if you are supplying a Klingon translation and 
*				your languages/ folder is languages/kn/, the class and constructor name for the file SUCCESS.php 
*				must both be SUCCESS_kn.
*****/
class HELP_en
{
// Constructor
	function HELP_en()
	{
////////////////////////////////////////////////////////////////////////////////////
// TRANSLATORS start here.  Translate ONLY the second string in each define().
// Initial message.
define("WELCOME", "Please note, to use WIKINDX fully, you must have cookies turned on in your web browser preferences.");
define("WELCOME2", "Because WIKINDX uses sessions to store temporary data you may experience unexpected results if you open more than one browser window or tab.");
// This is the English/Latin 'nota bene' meaning 'it is important to remember that...'
define("NOTABENE", "NB");
// Preferences help
define("P_HEADING", "Preferences");
define("P_INTRO", "There are a number of preferences the user can set including:");
define("P_LANGUAGE_HEAD", "Language");
define("P_TEMPLATE_HEAD", "Template");
define("P_TEMPLATE", "The choice of templates allows the user to radically alter the look and feel of WIKINDX.");
define("P_BIB_HEAD", "Bibliographic Style");
define("P_BIB", "These are used to display and export WIKINDX resources in a format suitable for inclusion in a bibliography.");
define("P_PAGING_HEAD", "Paging");
define("P_PAGING", "Paging allows the user to limit the maximum number of resources displayed on the browser. The number of paging links displayed at the bottom of the screen can also be adjusted.");
define("P_CHAR_HEAD", "Character Limiting");
define("P_CHAR", "Sometimes the text displayed in a form select box is long enough to cause problems with the web browser display. This is often the case with journal titles or publisher names. This field allows the user to limit the amount of text with any dropped text being replaced by ' ... '.");
// MyWikindx help
define("W_HEADING", "My Wikindx");
define("W_TEXT1", "If multi user mode has been enabled by the WIKINDX administrator and you are logged on as a valid user, you can select 'My Wikindx' from the 'File' menu to manage an unlimited number of personal bibliographies. User bibliographies are browsable by all users (from 'Bibliographies' under the 'File' menu) but only you can edit them.");
define("W_TEXT2", "If you choose to 'Delete from bibliography', you are simply removing the reference to a resource from your chosen bibliography -- the resource remains in the master WIKINDX bibliography.");
// Resources help
define("R_HEADING", "Resources");
define("R_TEXT1", "A resource is body of work which can be referenced.  It may be a complete book, an article in a book or a journal article etc. and is therefore analagous to a single entry in a bibliography.");
define("R_TEXT2", "A resource, in addition to its authorship, publication etc. details, may have one general note, and any number of quotes, paraphrases and musings attached to it. The general note differs from a musing in that the former, of which there can be only one, is intended to be a broad description or opinion about the whole resource while the latter, of which there may be many, is intended for various specific thoughts or musings on aspects of the resource.");
// Text input help
define("T_HEADING", "Text Input");
define("T_TEXT1", "HTML code will be stripped from all input.");
define("T_TEXT2", "Any word beginning with 'www.' or 'ftp.' will be automatically converted to a hyperlink.");
define("T_BBCODE", "BBcode may be used in textarea input:");
define("T_BBCODE1", "[b]bold[/b]");
define("T_BBCODE2", "[i]italics[/i]");
define("T_BBCODE3", "[u]underline[/u]");
define("T_BBCODE4", "[size=xx]font size[/font] ('xx' in range 10 to 30)");
define("T_BBCODE5", "[color=xx]font color[/color] ('xx' is hexadecimal code or colour name)");
define("T_BBCODE6", "[url]http://URL[/url]");
define("T_BBCODE7", "[url=http://URL]label[/url]");
define("T_BBCODE8", "[email]email address[/email]");
define("T_BBCODE9", "[img]image URL[/img]");
define("T_BBCODE10", "[img=xx*yy]image URL[/img] ('xx' = pixel width, 'yy' = pixel height)");
// TRANSLATORS: don't translate ''xx' = left, right, center'
define("T_BBCODE11", "[align=xx]text alignment[/align] ('xx' = left, right, center)");
define("T_BBCODE12", "[code]code[/code]");
define("T_BBCODE13", "[list][*]item 1[*]item 2[*]item 3[/list]");
// TRANSLATORS: don't translate ''x' = i, I, a, A, 1'
define("T_BBCODE14", "[list=x][*]item 1[*]item 2[*]item 3[/list] (list type 'x' = i, I, a, A, 1)");
// TRANSLATORS: don't translate ''xx' = left, right'
define("T_BBCODE15", "[float=xx]float alignment[/float] ('xx' = left, right)");
define("T_TEXT10", "Some bibliographic styles, such as APA, require all initial letters of words in the title (excepting the first) to be lowercased. When entering a new resource, enclosing letters in braces, e.g. {ApA}, in 'title' and 'subtitle' fields ensures that the case of those letters remains unchanged.");
// RTF export help
define("RTF_HEADING", "RTF Files");
define("RTF_TEXT1", "In order to transfer a bibliography to a word processor such as Microsoft Word or OpenOffice, WIKINDX can convert the bibliography to a RTF (Rich Text Format) file for you to download.  RTF files are designed for the transfer of data (and much of the formatting) from one word processor to another so are ideal for use in this case.  Once you have produced a bibliographic list through the use of 'list', 'select' or 'search' functions, you can then create a RTF file.");
define("RTF_TEXT2", "Select 'Export RTF' from the 'File' menu to create and download your RTF file.  (If your browser has been configured to do so, the RTF file will automatically open in your favourite word processor.)");
define("RTF_TEXT3", "A downloaded file that is automatically opened in a word processor may be read only so, in order to be able to edit it, you will need to save it immediately from within the word processor.");
// Endnote export help
define("EN_HEADING", "Endnote Tabbed Files");
define("EN_TEXT1", "Use this to create a tabbed file suitable for importing into Endnote.  Once you have produced a bibliographic list through the use of 'list', 'select' or 'search' functions, you can then create an Endnote tabbed file.");
define("EN_TEXT2", "Select 'Export Endnote' from the 'File' menu to create and download your Endnote file.");
// RIS export help
define("RIS_HEADING", "RIS Files");
define("RIS_TEXT1", "RIS files are widely used for importing bibliographies into programs such as Reference Manager, ProCite, and EndNotes. Once you have produced a bibliographic list through the use of 'list', 'select' or 'search' functions, you can then create a RIS file.");
define("RIS_TEXT2", "Select 'Export RIS' from the 'File' menu to create and download your RIS file.");
// BibTeX export help
define("B_HEADING", "BibTeX Files");
define("B_TEXT1", "BibTeX files are widely used in the scientific, engineering and mathematical worlds for formatting bibliographies in conjuction with LaTeX. Once you have produced a bibliographic list through the use of 'list', 'select' or 'search' functions, you can then create a BibTeX file.");
define("B_TEXT2", "Select 'Export BibTeX' from the 'File' menu to create and download your BibTeX file.");
define("B_TEXT3", "If you are exporting resources that came from a BibTeX import into WIKINDX, you can chose to use the original citation key and to merge in data for each resource that was not recognised by WIKINDX at the time of importing. If no such data was stored during the import, these options will be ignored.");
// HTML export help
define("HTML_HEADING", "HTML Files");
define("HTML_TEXT1", "You may wish to produce a simple HTML bibliographic list suitable for inclusion on a web site. Once you have produced a bibliographic list through the use of 'list', 'select' or 'search' functions, you can then create the HTML file.");
define("HTML_TEXT2", "Select 'Export HTML' from the 'File' menu to create and download your HTML file.");
// TRANSLATORS end here
////////////////////////////////////////////////////////////////////////////////////
		include_once("core/html/MISC.php");
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// Help page
	function display()
	{
		include_once("core/messages/UTF8.php");
		$utf8 = new UTF8();
		$top = MISC::a("link", utf8_decode($this->messages->text("misc", "top")), "#top");
		$this->template->setVar('heading', $utf8->decodeUtf8($this->messages->text("heading", "help")));
		$this->internalAnchors();
		$this->welcome();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->preferencesHelp();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->myWikindxHelp();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->textInputHelp();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->resourceHelp();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->rtfFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->endnoteFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->risFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->htmlFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->bibtexFiles();
		$this->pString .= MISC::p(MISC::hr());
		$this->pString .= MISC::p($top, "small", "right");
		$this->template->setVar('body', $this->pString);
		return $this->template->process();
	}
// print welcome
	function welcome()
	{
		$this->pString .= MISC::br() . WELCOME;
		$this->pString .= MISC::p(WELCOME2);
	}
// print help on preferences
	function preferencesHelp()
	{
		$this->pString .= MISC::aName("preferences") . MISC::b(P_HEADING) . ":" . MISC::br();
		$this->pString .= P_INTRO . 
		MISC::ul(
		MISC::li(MISC::b(P_LANGUAGE_HEAD)) . 
		MISC::li(MISC::b(P_TEMPLATE_HEAD) . " " . P_TEMPLATE) . 
		MISC::li(MISC::b(P_BIB_HEAD) . " " . P_BIB) . 
		MISC::li(MISC::b(P_PAGING_HEAD) . " " . P_PAGING) . 
		MISC::li(MISC::b(P_CHAR_HEAD) . " " . P_CHAR)
		);
	}
// print help on My Wikindx
	function myWikindxHelp()
	{
		$this->pString .= MISC::aName("myWikindx") . MISC::b(W_HEADING) . ":" . MISC::br();
		$this->pString .= W_TEXT1;
		$this->pString .= MISC::p(MISC::b(NOTABENE) . " " . W_TEXT2);
	}
// print help on resources
	function resourceHelp()
	{
		$this->pString .= MISC::aName("resources") . MISC::b(R_HEADING) . ":" . MISC::br();
		$this->pString .= R_TEXT1;
		$this->pString .= MISC::p(R_TEXT2);
	}
// print help on text input
	function textInputHelp()
	{
		$this->pString .= MISC::aName("textInput") . MISC::b(T_HEADING) . ": " . MISC::br();
		$this->pString .= T_TEXT1;
		$this->pString .= MISC::p(T_TEXT2);
		$this->pString .= MISC::p(T_BBCODE);
		$this->pString .= MISC::ul(
		MISC::li(T_BBCODE1) . 
		MISC::li(T_BBCODE2) . 
		MISC::li(T_BBCODE3) . 
		MISC::li(T_BBCODE4) . 
		MISC::li(T_BBCODE5) . 
		MISC::li(T_BBCODE6) . 
		MISC::li(T_BBCODE7) . 
		MISC::li(T_BBCODE8) . 
		MISC::li(T_BBCODE9) . 
		MISC::li(T_BBCODE10) . 
		MISC::li(T_BBCODE11) . 
		MISC::li(T_BBCODE12) . 
		MISC::li(T_BBCODE13) . 
		MISC::li(T_BBCODE14) . 
		MISC::li(T_BBCODE15)
		);
		$this->pString .= MISC::p(T_TEXT10);
	}
// print help on RTF files
	function rtfFiles()
	{
		$this->pString .= MISC::aName("rtf") . MISC::b(RTF_HEADING) . ":" . MISC::br();
		$this->pString .= RTF_TEXT1;
		$this->pString .= MISC::p(RTF_TEXT2);
		$this->pString .= MISC::p(MISC::b(NOTABENE) . " " . RTF_TEXT3);
	}
// print help on Endnote files
	function endnoteFiles()
	{
		$this->pString .= MISC::aName("endnote") . MISC::b(EN_HEADING) . ":" . MISC::br();
		$this->pString .= EN_TEXT1;
		$this->pString .= MISC::p(EN_TEXT2);
	}
// print help on RIS files
	function risFiles()
	{
		$this->pString .= MISC::aName("ris") . MISC::b(RIS_HEADING) . ":" . MISC::br();
		$this->pString .= RIS_TEXT1;
		$this->pString .= MISC::p(RIS_TEXT2);
	}
// print help on BibTeX files
	function bibtexFiles()
	{
		$this->pString .= MISC::aName("bibtex") . MISC::b(B_HEADING) . ":" . MISC::br();
		$this->pString .= B_TEXT1;
		$this->pString .= MISC::p(B_TEXT2);
		$this->pString .= MISC::p(B_TEXT3);
	}
// print help on HTML files
	function htmlFiles()
	{
		$this->pString .= MISC::aName("html") . MISC::b(HTML_HEADING) . ":" . MISC::br();
		$this->pString .= HTML_TEXT1;
		$this->pString .= MISC::p(HTML_TEXT2);
	}
// print internal anchors
	function internalanchors()
	{
		$this->pString = MISC::aName("top");
		$this->pString .= MISC::a("link", P_HEADING, "#preferences") . MISC::br();
		$this->pString .= MISC::a("link", W_HEADING, "#myWikindx") . MISC::br();
		$this->pString .= MISC::a("link", T_HEADING, "#textInput") . MISC::br();
		$this->pString .= MISC::a("link", R_HEADING, "#resources") . MISC::br();
		$this->pString .= MISC::a("link", RTF_HEADING, "#rtf") . MISC::br();
		$this->pString .= MISC::a("link", EN_HEADING, "#endnote") . MISC::br();
		$this->pString .= MISC::a("link", RIS_HEADING, "#ris") . MISC::br();
		$this->pString .= MISC::a("link", HTML_HEADING, "#html") . MISC::br();
		$this->pString .= MISC::a("link", B_HEADING, "#bibtex") . MISC::br();
		$this->pString .= MISC::p(MISC::hr());
	}
}
