<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* CONSTANTS_en class (English)
*
* Various numbers, days, months etc.
* 
*	NOTE TO TRANSLATORS:	Only translate between START TRANSLATION and END TRANSLATION tags.
*
*****/
class CONSTANTS_en
{
// Constructor
	function CONSTANTS_en()
	{
	}
// convert cardinal numbers
	function convertNumbers($number = FALSE, $convert = FALSE)
	{
		if(!is_numeric($number))
			return $number;
// month number to long name	
		$longMonth = $this->monthToLongName();
// short month
		$shortMonth = $this->monthToShortName();
// cardinal -> ordinal word
		$ordinalWord = $this->cardinalToOrdinalWord();
// arabic -> roman numerals
		$roman = $this->cardinalToRoman();
/****************************
 START TRANSLATION
****************************/
// arabic -> ordinal (e.g. 3 -> 3rd, 10 -> 10th)
// Usually used for edition numbers in bibliographic styles that require e.g. '10th edition' rather than 'edition 10'.
// A maximum of 50 seems a reasonable number to go up to....
// If necessary, you may need to add more loops or individual array elements.
		for($i = 4; $i <= 20; $i++)
			$ordinal[$i] = $i . 'th';
		for($i = 24; $i <= 30; $i++)
			$ordinal[$i] = $i . 'th';
		for($i = 34; $i <= 40; $i++)
			$ordinal[$i] = $i . 'th';
		for($i = 44; $i <= 50; $i++)
			$ordinal[$i] = $i . 'th';
		$ordinal[1] = '1st';
		$ordinal[21] = '21st';
		$ordinal[31] = '31st';
		$ordinal[41] = '41st';
		$ordinal[2] = '2nd';
		$ordinal[22] = '22nd';
		$ordinal[32] = '32nd';
		$ordinal[42] = '42nd';
		$ordinal[3] = '3rd';
		$ordinal[23] = '23rd';
		$ordinal[33] = '33rd';
		$ordinal[43] = '43rd';
/****************************
 END TRANSLATION
****************************/
// arabic -> cardinal (i.e. no change)
		$cardinal = range(0, 50);
// !$number, we are simply loading the arrays for use elsewhere, so return
		if(!$number)
			return;
// get rid of leading '0' if necessary
		if($number < 10)
			$number += 0;
// If that number is not actually in array, we return the number as is
		if(array_key_exists($number, ${$convert}))
			return ${$convert}[$number];
		return $number;
	}
// Convert month to long name
	function monthToLongName()
	{
		return array(
/****************************
 START TRANSLATION
****************************/
				1	=>	'January',
				2	=>	'February',
				3	=>	'March',
				4	=>	'April',
				5	=>	'May',
				6	=>	'June',
				7	=>	'July',
				8	=>	'August',
				9	=>	'September',
				10	=>	'October',
				11	=>	'November',
				12	=>	'December',
/****************************
 END TRANSLATION
****************************/
			);
	}
// Convert month to short name
	function monthToShortName()
	{
		return array(
/****************************
 START TRANSLATION
****************************/
				1	=>	'Jan',
				2	=>	'Feb',
				3	=>	'Mar',
				4	=>	'Apr',
				5	=>	'May',
				6	=>	'Jun',
				7	=>	'Jul',
				8	=>	'Aug',
				9	=>	'Sep',
				10	=>	'Oct',
				11	=>	'Nov',
				12	=>	'Dec',
/****************************
 END TRANSLATION
****************************/
			);
	}
// convert cardinal to roman
	function cardinalToRoman()
	{
// arabic -> roman numerals
// Do NOT translate
		return array(
				1	=>	'I',
				2	=>	'II',
				3	=>	'III',
				4	=>	'IV',
				5	=>	'V',
				6	=>	'VI',
				7	=>	'VII',
				8	=>	'VIII',
				9	=>	'IX',
				10	=>	'X',
				11	=>	'XI',
				12	=>	'XII',
				13	=>	'XIII',
				14	=>	'XIV',
				15	=>	'XV',
				16	=>	'XVI',
				17	=>	'XVII',
				18	=>	'XVIII',
				19	=>	'XIX',
				20	=>	'XX',
				21	=>	'XXI',
				22	=>	'XXII',
				23	=>	'XXIII',
				24	=>	'XXIV',
				25	=>	'XXV',
				26	=>	'XXVI',
				27	=>	'XXVII',
				28	=>	'XXVIII',
				29	=>	'XXIX',
				30	=>	'XXX',
				31	=>	'XXXI',
				32	=>	'XXXII',
				33	=>	'XXXIII',
				34	=>	'XXXIV',
				35	=>	'XXXV',
				36	=>	'XXXVI',
				37	=>	'XXXVII',
				38	=>	'XXXVIII',
				39	=>	'XXXIX',
				40	=>	'XXXX',
				41	=>	'XXXXI',
				42	=>	'XXXXII',
				43	=>	'XXXXIII',
				44	=>	'XXXXIV',
				45	=>	'XXXXV',
				46	=>	'XXXXVI',
				47	=>	'XXXXVII',
				48	=>	'XXXXVIII',
				49	=>	'XXXXIX',
				50	=>	'L',
			);
	}
// convert ordinal to word
	function cardinalToOrdinalWord()
	{
		return array(
/****************************
 START TRANSLATION
****************************/
// Usually used for edition numbers in bibliographic styles that require words rather than arabic numerals.
// Any numbers not listed here will be returned without change.  e.g. here, 51 will be returned as 51 rather than 'fifty-first'.
// A maximum of 50 seems a reasonable number to go up to....
						'1'	=>	'First',
						'2'	=>	'Second',
						'3'	=>	'Third',
						'4'	=>	'Fourth',
						'5'	=>	'Fifth',
						'6'	=>	'Sixth',
						'7'	=>	'Seventh',
						'8'	=>	'Eighth',
						'9'	=>	'Ninth',
						'10'	=>	'Tenth',
						'11'	=>	'Eleventh',
						'12'	=>	'Twelfth',
						'13'	=>	'Thirteenth',
						'14'	=>	'Fourteenth',
						'15'	=>	'Fifteenth',
						'16'	=>	'Sixteenth',
						'17'	=>	'Seventeenth',
						'18'	=>	'Eighteenth',
						'19'	=>	'Nineteenth',
						'20'	=>	'Twentieth',
						'21'	=>	'Twenty-first',
						'22'	=>	'Twenty-second',
						'23'	=>	'Twenty-third',
						'24'	=>	'Twenty-fourth',
						'25'	=>	'Twenty-fifth',
						'26'	=>	'Twenty-sixth',
						'27'	=>	'Twenty-seventh',
						'28'	=>	'Twenty-eighth',
						'29'	=>	'Twenty-ninth',
						'30'	=>	'Thirtieth',
						'31'	=>	'Thirty-first',
						'32'	=>	'Thirty-second',
						'33'	=>	'Thirty-third',
						'34'	=>	'Thirty-fourth',
						'35'	=>	'Thirty-fifth',
						'36'	=>	'Thirty-sixth',
						'37'	=>	'Thirty-seventh',
						'38'	=>	'Thirty-eighth',
						'39'	=>	'Thirty-ninth',
						'40'	=>	'Fourtieth',
						'41'	=>	'Fourty-first',
						'42'	=>	'Fourty-second',
						'43'	=>	'Fourty-third',
						'44'	=>	'Fourty-fourth',
						'45'	=>	'Fourty-fifth',
						'46'	=>	'Fourty-sixth',
						'47'	=>	'Fourty-seventh',
						'48'	=>	'Fourty-eighth',
						'49'	=>	'Fourty-ninth',
						'50'	=>	'Fiftieth',
/****************************
 END TRANSLATION
****************************/
			);
	}
}
?>
