<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* ABOUT_en wikindx class - ENGLISH.
*
* NOTE TO TRANSLATORS:  1/  Both the class name and the constructor name should be changed to match the (case-sensitive) name of 
*				the folder your language files are in.  For example, if you are supplying a Klingon translation and 
*				your languages/ folder is languages/kn/, the class and constructor name for the file SUCCESS.php 
*				must both be SUCCESS_kn.
*****/
class ABOUT_en
{
// Constructor
	function ABOUT_en()
	{
		$linkPhemplate = MISC::a("link", "phemplate", "http://pukomuko.esu.lt/phemplate/", "_blank");
		$linkAdodb = MISC::a("link", "ADOdb", "http://adodb.sourceforge.net", "_blank");
		$linkSfWikindx = MISC::a("link", "WIKINDX Sourceforge Project", 
			"http://sourceforge.net/projects/wikindx/", "_blank");
		$linkSf = MISC::a("link", "Sourceforge", "http://www.sourceforge.net", "_blank");

////////////////////////////////////////////////////////////////////////////////////
// TRANSLATORS start here.  Translate ONLY the second string in each define().
define ("TEXT1", "The WIKINDX Bibliographic Management System has been brought to you by the following:");
define ("TEXT2", "<---Administrator--->");
define ("TEXT3", "Mark Grimshaw (New Zealand)");
define ("TEXT4", "<---Developers--->");
define ("TEXT5", "Andreas G. Nie (Germany)");
define ("TEXT13", "Daniel Pozzi (Germany)");
define ("TEXT6", "Jess Collicott (U.S.A)");
define ("TEXT7", "Mark Grimshaw (New Zealand)");
define ("TEXT12", "Mark Tsikanovski (New Zealand)");
define ("TEXT14", "Andrea Rossato (Italy)");
// TRANSLATORS - if you wish to add a credit to yourself here, uncomment the following two lines and add your name
// define ("TRANS1", "<---Translation--->");
// define ("TRANS2", "Your Name Goes Here");
define ("TEXT8", "Thanks to Tim Richter and Pascal Kockaert for their help with BibTeX importing.");
define ("TEXT9", "WIKINDX makes use of the $linkPhemplate HTML templating system and the $linkAdodb SQL abstraction layer.");
define ("TEXT10", "All updates, bug reports, forums, news etc. can be found at the $linkSfWikindx");
define ("TEXT11", "Thanks to $linkSf for hosting the project.");
// TRANSLATORS end here
////////////////////////////////////////////////////////////////////////////////////

		// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
 	       	include_once("core/messages/MESSAGES.php");
        	$this->messages = new MESSAGES();
	}
// English messages
	function display()
	{
		include_once("core/html/MISC.php");
		include_once("core/messages/UTF8.php");
		$utf8 = new UTF8();

		$pString = MISC::p(TEXT1, FALSE, "center");
		$pString .= MISC::p(TEXT2 . MISC::br() . TEXT3, FALSE, "center");

		$pString .= MISC::p(TEXT4 . MISC::br() . TEXT5 . MISC::br() . TEXT6 . MISC::br() . TEXT12 . MISC::br() 
			. TEXT13 . MISC::br() . TEXT14 . MISC::br() . TEXT7, FALSE, "center");
		if(defined("TRANS1") && defined("TRANS2"))
			$pString .= MISC::p(TRANS1 . MISC::br() . TRANS2, FALSE, "center");
		$pString .= MISC::p(MISC::hr());

		$pString .= MISC::p(TEXT8);

		$pString .= MISC::p(TEXT9);

		$pString .= MISC::p(TEXT10);

		$pString .= MISC::p(TEXT11);

		$pString .= MISC::p(MISC::hr());

		$pString .= MISC::p("This program is free software; you can redistribute it and/or modify it 
		under the terms of the GNU General Public License as published by the Free Software Foundation; either
		version 2 of the License, or (at your option) any later version.");
		$pString .= MISC::p("If you do redistribute or modify the program, you must retain the copyright 
		information and WIKINDX contact details as found in each file.");
		
		$link = MISC::a("link", "GNU General Public License", "http://www.opensource.org/licenses/gpl-license.php", "_blank");
		$pString .= MISC::p("This program is distributed in the hope that it will be useful, but WITHOUT 
		ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
		See the $link for more details.");
		$pString .= MISC::p("The WIKINDX Team ~ Copyright (C) 2004");
// End license
		$this->template->setVar('heading', $utf8->decodeUtf8($this->messages->text("heading", 'aboutWikindx')));
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
}
?>
