<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system. v2.x
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Gateway to the system.  Here, the form variable 'action' is parsed to
*	determine the course of action.
*	All actions and requests pass via this gateway.
*
*	$Header: /cvsroot/wikindx/wikindx3/index.php,v 1.30 2005/06/28 22:38:07 sirfragalot Exp $
*****/


// Start the timer
include_once("core/init/SCRIPTTIME.php");
$timer = new SCRIPTTIME();
$WIKINDX_START_TIME = $timer->start;
include_once("core/init/SYSTEMCHECK.php");
include_once("core/init/INIT.php");
include_once("core/authorize/AUTHORIZE.php");
include_once("core/html/TABLE.php");
include_once("core/html/CLOSE.php");
include_once("core/messages/ERRORS.php");
include_once("core/session/SESSION.php");
include_once("core/template/TEMPLATE.php");
$template = new TEMPLATE('footer');

/**
* This is the id of a user from WKX_user and is used to impose restrictions in core/user/USER.php and core/authorize/AUTHORIZE.php for a user who is 
* not allowed to change user details and who will be prompted for a set username and password when logging on.  Setting it to '0' has no effect. It is mainly used 
* for the WIKINDX test server at http://www.sirfragalot.com/wikindx3/ for the test user 'wikindx::wikindx'.
*/
	$WIKINDX_RESTRICT_USER = 0;

/*****
*	Since 99% of actions require the database to be opened, we open it here.
*	Need to chose which class to use based on the type of RDMS required.
*****/
	include_once("core/sql/SQL.php");
	$db = new SQL();
/*****
*	Initialize the system
*	As INIT starts the session, we must check for 'remember me' cookie requests from MYWIKINDX.php prior to 
*	setting the session.
*****/
	$init = new INIT();
// Get user input in whatever form
	$vars = $init->getVars();
	if(!empty($vars) && array_key_exists('cookie', $vars) && $vars['cookie'] && 
		array_key_exists('uname', $vars) && trim($vars['uname']))
	{
// set the cookie if requested
		include_once("core/cookie/COOKIE.php");
		$cookie = new COOKIE();
		$cookie->storeCookie($vars['uname']);
	}
// start the session
	$init->startSession();
// Initialize the db queries counter
	$WIKINDX_DB_QUERIES = $init->initDbQueries();

/*****
*	Create the $authorize object which handles logins and pass the $db object to it.
*****/
	$authorize = new AUTHORIZE($db);
	
// Do system check
	new SYSTEMCHECK($db, $vars);
	$errors = new ERRORS();
	$messages = new MESSAGES();
	$session = new SESSION();
// User bookmarks can only be added when looking at a single resource's details.  Set default behaviour here to remove 'add bookmark' link from menu
	$session->setVar("bookmark_displayAdd", FALSE);
/*****
*	First pass through authentication.
*****/
// return from gatekeep is either TRUE (meaning proceed without change) or FALSE (meaning set $vars['action'] = "front') 
// which will print the front page of WIKINDX.
// gatekeep() can itself exit the script (usually to the initial logon prompt)
	if($authorize->gateKeep($vars) === FALSE)
		$vars['action'] = 'front';
/*****
*	Parse 'action' variable.  If not set we print the front page
*****/
// Front page
	if(!isset($vars["action"]) || ($vars['action'] == 'front'))
	{
		include_once("core/front/FRONT.php");
		$front = new FRONT($db);
		$pString = $front->display();
	}
	else if($vars["action"] == 'frontNoMenu')
	{
		include_once("core/front/FRONT.php");
		$front = new FRONT($db);
		$pString = $front->display(TRUE);
	}
// Superadmin configure options
	else if($vars["action"] == 'adminConfigureDisplay')
	{
		include_once("core/admin/CONFIG.php");
		$config = new CONFIG($db);
		$pString = $config->displaySetup(FALSE, TRUE);
	}
	else if($vars["action"] == 'adminConfigure')
	{
		include_once("core/admin/CONFIG.php");
		$config = new CONFIG($db);
		$pString = $config->write($vars, TRUE);
		$session->clearArray("config");
	}
/* COnverting a v1.x databases has been removed from v2.2
	else if($vars["action"] == 'adminConvertDisplay')
	{
		$session->clearArray("convert");
		include_once("core/admin/CONVERT.php");
		$convert = new CONVERT($db, $vars);
		$pString = $convert->display();
	}
	else if($vars["action"] == 'adminConvert')
	{
		include_once("core/admin/CONVERT.php");
		$convert = new CONVERT($db, $vars);
		$pString = $convert->process();
	}
*/
	else if($vars["action"] == 'deleteResourceDisplay')
	{
		$session->setVar("deleteResourceLock", FALSE);
		include_once("core/admin/DELETERESOURCE.php");
		$admin = new DELETERESOURCE($db, $vars);
		$pString = $admin->gateKeep('display');
	}
	else if($vars["action"] == 'deleteResourceConfirm')
	{
		include_once("core/admin/DELETERESOURCE.php");
		$admin = new DELETERESOURCE($db, $vars);
		$pString = $admin->gateKeep('confirm');
	}
	else if($vars["action"] == 'deleteResource')
	{
		include_once("core/admin/DELETERESOURCE.php");
		$admin = new DELETERESOURCE($db, $vars);
		$pString = $admin->gateKeep('delete');
	}
	else if($vars["action"] == 'customDisplay')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('display');
	}
	else if($vars["action"] == 'customAddInit')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('addInit');
	}
	else if($vars["action"] == 'customAdd')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('add');
	}
	else if($vars["action"] == 'customDeleteInit')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('deleteInit');
	}
	else if($vars["action"] == 'customDeleteConfirm')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('deleteConfirm');
	}
	else if($vars["action"] == 'customDelete')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('delete');
	}
	else if($vars["action"] == 'customEditInit')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('editInit');
	}
	else if($vars["action"] == 'customEditDisplay')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('editDisplay');
	}
	else if($vars["action"] == 'customEdit')
	{
		include_once("core/admin/ADMINCUSTOM.php");
		$admin = new ADMINCUSTOM($db, $vars);
		$pString = $admin->gateKeep('edit');
	}
	else if($vars["action"] == 'adminGroup')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('display');
	}
	else if($vars["action"] == 'adminGroupAddInit')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('addInit');
	}
	else if($vars["action"] == 'adminGroupAdd')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('add');
	}
	else if($vars["action"] == 'adminGroupDeleteInit')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('deleteInit');
	}
	else if($vars["action"] == 'adminGroupDeleteConfirm')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('deleteConfirm');
	}
	else if($vars["action"] == 'adminGroupDelete')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('delete');
	}
	else if($vars["action"] == 'adminGroupEditInit')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('editInit');
	}
	else if($vars["action"] == 'adminGroupEdit')
	{
		include_once("core/admin/ADMINGROUP.php");
		$admin = new ADMINGROUP($db, $vars);
		$pString = $admin->gateKeep('edit');
	}
	else if($vars["action"] == 'resourcePasteBibtex')
	{
		include_once("core/file/import/BIBTEXIMPORT.php");
		$obj = new BIBTEXIMPORT($db, $vars);
		$pString = $obj->gatekeep('resourcePasteBibtex');
	}
	else if($vars["action"] == 'resourcePasteBibtexStage2')
	{
		include_once("core/file/import/BIBTEXIMPORT.php");
		$obj = new BIBTEXIMPORT($db, $vars);
		$pString = $obj->gatekeep('resourcePasteBibtexStage2');
	}
	else if($vars["action"] == 'importBibtexStage1')
	{
		include_once("core/file/import/BIBTEXIMPORT.php");
		$obj = new BIBTEXIMPORT($db, $vars);
		$pString = $obj->gatekeep('importBibtexStage1');
	}
	else if($vars["action"] == 'importBibtexStage2')
	{
		include_once("core/file/import/BIBTEXIMPORT.php");
		$obj = new BIBTEXIMPORT($db, $vars);
		$pString = $obj->gatekeep('importBibtexStage2');
	}
	else if($vars["action"] == 'importEndnoteStage1')
	{
		include_once("core/file/import/ENDNOTEIMPORT.php");
		$obj = new ENDNOTEIMPORT($db, $vars);
		$pString = $obj->gatekeep('importEndnoteStage1');
	}
	else if($vars["action"] == 'importEndnoteStage2')
	{
		include_once("core/file/import/ENDNOTEIMPORT.php");
		$obj = new ENDNOTEIMPORT($db, $vars);
		$pString = $obj->gatekeep('importEndnoteStage2');
	}
	else if($vars["action"] == 'adminNoMenu')
	{
		include_once("core/admin/ADMIN.php");
		$admin = new ADMIN($db);
		$pString = $admin->display(TRUE);
	}
	else if($vars["action"] == 'resourceNew')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('newResource');
	}
	else if($vars["action"] == 'resourceEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editResource');
	}
	else if($vars["action"] == 'resourceWrite')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('writeResource');
	}
	else if($vars["action"] == 'resourceView')
	{
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($db, $vars);
		$pString = $resource->view();
	}
	else if($vars["action"] == 'lastSolo')
	{
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($db, $vars);
		$pString = $resource->view(FALSE, 'lastSolo');
	}
	else if($vars["action"] == 'resourceNoMenu')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->display(TRUE);
	}
	else if($vars["action"] == 'allMusings')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->allMusings();
	}
	else if($vars["action"] == 'randomMusing')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->randomMusing();
	}
	else if($vars["action"] == 'allQuotes')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->allQuotes();
	}
	else if($vars["action"] == 'randomQuote')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->randomQuote();
	}
	else if($vars["action"] == 'allParaphrases')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->allParaphrases();
	}
	else if($vars["action"] == 'randomParaphrase')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->randomParaphrase();
	}
	else if($vars["action"] == 'textNoMenu')
	{
		include_once("core/text/TEXT.php");
		$text = new TEXT($db, $vars);
		$pString = $text->display(TRUE);
	}
	else if($vars["action"] == 'noteEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editNote');
	}
	else if($vars["action"] == 'quoteEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editQuote');
	}
	else if($vars["action"] == 'paraphraseEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editParaphrase');
	}
	else if($vars["action"] == 'musingEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editMusing');
	}
	else if($vars["action"] == 'abstractEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editAbstract');
	}
	else if($vars["action"] == 'userCustomEdit')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('editCustom');
	}
	else if($vars["action"] == 'addResourceTo')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('addResourceTo');
	}
	else if($vars["action"] == 'addResourceToCategory')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('addResourceToCategory');
	}
	else if($vars["action"] == 'addResourceToKeyword')
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($db, $vars);
		$pString = $resource->gateKeep('addResourceToKeyword');
	}
	else if($vars["action"] == 'listDisplay')
	{
		include_once("core/list/LISTRESOURCES.php");
		$list = new LISTRESOURCES($db, $vars);
		$pString = $list->display();
	}
	else if($vars["action"] == 'listProcess')
	{
		include_once("core/list/LISTRESOURCES.php");
		$list = new LISTRESOURCES($db, $vars);
		$pString = $list->process();
	}
	else if($vars["action"] == 'listKeywordProcess')
	{
		include_once("core/list/LISTSOMERESOURCES.php");
		$list = new LISTSOMERESOURCES($db, $vars);
		$pString = $list->keywordProcess();
	}
	else if($vars["action"] == 'listCiteProcess')
	{
		include_once("core/list/LISTSOMERESOURCES.php");
		$list = new LISTSOMERESOURCES($db, $vars);
		$pString = $list->citeProcess();
	}
	else if($vars["action"] == 'selectDisplay')
	{
		include_once("core/list/SELECTRESOURCES.php");
		$select = new SELECTRESOURCES($db, $vars);
		$pString = $select->display();
	}
	else if($vars["action"] == 'selectProcess')
	{
		include_once("core/list/SELECTRESOURCES.php");
		$select = new SELECTRESOURCES($db, $vars);
		$pString = $select->process();
	}
	else if($vars["action"] == 'searchDisplay')
	{
		include_once("core/list/SEARCHRESOURCES.php");
		$search = new SEARCHRESOURCES($db, $vars);
		$pString = $search->display();
	}
	else if($vars["action"] == 'searchProcess')
	{
		include_once("core/list/SEARCHRESOURCES.php");
		$search = new SEARCHRESOURCES($db, $vars);
		$pString = $search->process();
	}
	else if($vars["action"] == 'powerSearchDisplay')
	{
		include_once("core/list/POWERSEARCHRESOURCES.php");
		$search = new POWERSEARCHRESOURCES($db, $vars);
		$pString = $search->display();
	}
	else if($vars["action"] == 'powerSearchProcess')
	{
		include_once("core/list/POWERSEARCHRESOURCES.php");
		$search = new POWERSEARCHRESOURCES($db, $vars);
		$pString = $search->process();
	}
	else if($vars["action"] == 'lastMulti')
	{
		if($session->getVar('sql_lastMulti') == 'select')
		{
			include_once("core/list/SELECTRESOURCES.php");
			$select = new SELECTRESOURCES($db, $vars);
			$pString = $select->process();
		}
		else if($session->getVar('sql_lastMulti') == 'list')
		{
			include_once("core/list/LISTRESOURCES.php");
			$list = new LISTRESOURCES($db, $vars);
			$pString = $list->process();
		}
		else if($session->getVar('sql_lastMulti') == 'search')
		{
			include_once("core/list/SEARCHRESOURCES.php");
			$search = new SEARCHRESOURCES($db, $vars);
			$pString = $search->process();
		}
		else if($session->getVar('sql_lastMulti') == 'powerSearch')
		{
			include_once("core/list/POWERSEARCHRESOURCES.php");
			$search = new POWERSEARCHRESOURCES($db, $vars);
			$pString = $search->process();
		}
		else if($session->getVar('sql_lastMulti') == 'listKeyword')
		{
			include_once("core/list/LISTSOMERESOURCES.php");
			$list = new LISTSOMERESOURCES($db, $vars);
			$pString = $list->keywordProcess();
		}
		else if($session->getVar('sql_lastMulti') == 'listCite')
		{
			include_once("core/list/LISTSOMERESOURCES.php");
			$list = new LISTSOMERESOURCES($db, $vars);
			$pString = $list->citeProcess();
		}
		else
		{
// That session has disappeared so return resource page with noMenu options as kludgey fix
			include_once("core/resource/RESOURCE.php");
			$resource = new RESOURCE($db, $vars);
			$pString = $resource->display(TRUE);
		}
	}
	else if($vars["action"] == 'aboutWikindx')
	{
		include_once("core/messages/ABOUT.php");
		$pString =  ABOUT::display();
	}
	else if($vars["action"] == 'preferencesDisplay')
	{
		$session->clearArray("preferences");
		include_once("core/preferences/PREFERENCES.php");
		$preferences = new PREFERENCES($db);
		$pString = $preferences->display();
	}
	else if($vars["action"] == 'preferencesWrite')
	{
		include_once("core/preferences/PREFERENCES.php");
		$preferences = new PREFERENCES($db);
		$pString = $preferences->write($vars);
	}
	else if($vars["action"] == 'helpNoMenu')
	{
		include_once("core/messages/HELP.php");
		$help = new HELP();
		$pString = $help->display(TRUE);
	}
	else if($vars["action"] == 'helpDisplay')
	{
		include_once("core/messages/HELP.php");
		$help = new HELP();
		$pString = $help->display();
	}
	else if($vars["action"] == 'helpImportDisplay')
	{
		include_once("core/messages/HELPIMPORT.php");
		$pString = HELPIMPORT::display();
	}
	else if($vars["action"] == 'helpConfigDisplay')
	{
		include_once("core/messages/HELPCONFIG.php");
		$pString = HELPCONFIG::display();
	}
	else if($vars["action"] == 'helpStyleDisplay')
	{
		include_once("core/messages/HELPSTYLE.php");
		$pString = HELPSTYLE::display();
	}
	else if($vars["action"] == 'fileNoMenu')
	{
		include_once("core/file/FILE.php");
		$file = new FILE($db);
		$pString = $file->display(TRUE);
	}
	else if($vars["action"] == 'exportRtfSetup')
	{
		include_once("core/file/export/RTF.php");
		$rtf = new RTF($db);
		$pString = $rtf->setup();
	}
	else if($vars["action"] == 'exportRtf')
	{
		include_once("core/file/export/RTF.php");
		$rtf = new RTF($db, $vars);
		$pString = $rtf->process();
	}
	else if($vars["action"] == 'exportBibtexStage1')
	{
		include_once("core/file/export/BIBTEX.php");
		$bibtex = new BIBTEX($db, FALSE);
		$pString = $bibtex->stage1();
	}
	else if($vars["action"] == 'exportBibtex')
	{
		include_once("core/file/export/BIBTEX.php");
		$bibtex = new BIBTEX($db, $vars);
		$pString = $bibtex->process();
	}
	else if($vars["action"] == 'exportRis')
	{
		include_once("core/file/export/RIS.php");
		$ris = new RIS($db);
		$pString = $ris->process();
	}
	else if($vars["action"] == 'exportEndnoteStage1')
	{
		include_once("core/file/export/ENDNOTE.php");
		$en = new ENDNOTE($db, FALSE);
		$pString = $en->stage1();
	}
	else if($vars["action"] == 'exportEndnote')
	{
		include_once("core/file/export/ENDNOTE.php");
		$en = new ENDNOTE($db, $vars);
		$pString = $en->process();
	}
	else if($vars["action"] == 'exportHtml')
	{
		include_once("core/file/export/HTMLEXPORT.php");
		$html = new HTMLEXPORT($db);
		$pString = $html->process();
	}
	else if($vars["action"] == 'showFiles')
	{
		include_once("core/file/FILE.php");
		$file = new FILE($db);
		$pString = $file->show();
	}
	else if($vars["action"] == 'editNoMenu')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->display(TRUE);
	}
	else if($vars["action"] == 'editCreator')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editCreator');
	}
	else if($vars["action"] == 'editCreatorConfirm')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editCreatorConfirm');
	}
	else if($vars["action"] == 'editCollection')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editCollection');
	}
	else if($vars["action"] == 'editCollectionConfirm')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editCollectionConfirm');
	}
	else if($vars["action"] == 'editPublisher')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editPublisher');
	}
	else if($vars["action"] == 'editPublisherConfirm')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editPublisherConfirm');
	}
	else if($vars["action"] == 'editKeyword')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editKeyword');
	}
	else if($vars["action"] == 'editKeywordConfirm')
	{
		include_once("core/edit/EDIT.php");
		$edit = new EDIT($db, $vars);
		$pString = $edit->gatekeep('editKeywordConfirm');
	}
	else if($vars["action"] == 'initLogon')
	{
		$pString = $authorize->initLogon();
		if(!$session->getVar("setup_readOnly"))
		{
			include_once("core/html/CLOSENOMENU.php");
			new CLOSENOMENU($db, $pString);
		}
		else
		{
			include_once("core/html/CLOSE.php");
			new CLOSE($db, $pString);
		}
	}
	else if($vars["action"] == 'adminUser')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('display');
	}
	else if($vars["action"] == 'adminUserAddInit')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('addInit');
	}
	else if($vars["action"] == 'adminUserAdd')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('add');
	}
	else if($vars["action"] == 'adminUserDeleteInit')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('deleteInit');
	}
	else if($vars["action"] == 'adminUserDeleteConfirm')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('deleteConfirm');
	}
	else if($vars["action"] == 'adminUserDelete')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('delete');
	}
	else if($vars["action"] == 'adminUserEditInit')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('editInit');
	}
	else if($vars["action"] == 'adminUserEditDisplay')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('editDisplay');
	}
	else if($vars["action"] == 'adminUserEdit')
	{
		include_once("core/admin/ADMINUSER.php");
		$obj = new ADMINUSER($db, $vars);
		$pString = $obj->gateKeep('edit');
	}
	else if($vars["action"] == 'initMyWikindx')
	{
		include_once("core/user/USER.php");
		$obj = new USER($db, $vars);
		$pString = $obj->gateKeep('initDisplay');
	}
	else if($vars["action"] == 'myWikindxUserEdit')
	{
		include_once("core/user/USER.php");
		$obj = new USER($db, $vars);
		$pString = $obj->gateKeep('userEdit');
	}
	else if($vars["action"] == 'initBibliographies')
	{
		include_once("core/user/BIBLIOGRAPHY.php");
		$obj = new BIBLIOGRAPHY($db, $vars);
		$pString = $obj->initDisplay();
	}
	else if($vars["action"] == 'bibliographies')
	{
		include_once("core/user/BIBLIOGRAPHY.php");
		$obj = new BIBLIOGRAPHY($db, $vars);
		$pString = $obj->sortMethod();
	}
	else if($vars["action"] == 'myWikindxBibliography')
	{
		include_once("core/user/MYWIKINDX.php");
		$obj = new MYWIKINDX($db, $vars);
		$pString = $obj->gateKeep();
	}
	else if($vars["action"] == "myWikindxNotifyEdit")
	{
		include_once("core/user/MYWIKINDX.php");
		$obj = new MYWIKINDX($db, $vars);
		$pString = $obj->gateKeep();
	}
	else if($vars["action"] == "adminNews")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("initAdmin");
	}
	else if($vars["action"] == "newsAddInit")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("initNewsAdd");
	}
	else if($vars["action"] == "newsAdd")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("add");
	}
	else if($vars["action"] == "newsDeleteInit")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("deleteInit");
	}
	else if($vars["action"] == "newsDeleteConfirm")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("deleteConfirm");
	}
	else if($vars["action"] == "newsDelete")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("delete");
	}
	else if($vars["action"] == "newsEditInit")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("editInit");
	}
	else if($vars["action"] == "newsEditDisplay")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("editDisplay");
	}
	else if($vars["action"] == "newsEdit")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->gateKeep("edit");
	}
	else if($vars["action"] == "viewNews")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->viewNews();
	}
	else if($vars["action"] == "viewNewsItem")
	{
		include_once("core/news/NEWS.php");
		$obj = new NEWS($db, $vars);
		$pString = $obj->viewNewsItem();
	}
// Display pop up citation window
	else if($vars["action"] == "citeDisplay")
	{
		include_once("core/cite/CITE.php");
		$obj = new CITE($db, $vars);
		$pString = $obj->display();
	}
// Create WIKINDX citation string and return to main window
	else if($vars["action"] == "addCitation")
	{
		include_once("core/cite/CITE.php");
		$obj = new CITE($db, $vars);
		$pString = $obj->addCitation();
	}
// Administer bibliographic styles
	else if($vars["action"] == 'adminStyle')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('display');
	}
	else if($vars["action"] == 'adminStyleAddInit')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('addInit');
	}
	else if($vars["action"] == 'adminStyleAdd')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('add');
	}
	else if($vars["action"] == 'adminStyleEditInit')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('editInit');
	}
	else if($vars["action"] == 'adminStyleEditDisplay')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('editDisplay');
	}
	else if($vars["action"] == 'adminStyleEdit')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('edit');
	}
	else if($vars["action"] == 'adminStyleCopyInit')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('copyInit');
	}
	else if($vars["action"] == 'adminStyleCopyDisplay')
	{
		include_once("core/admin/ADMINSTYLE.php");
		$admin = new ADMINSTYLE($db, $vars);
		$pString = $admin->gateKeep('copyDisplay');
	}
// File attachments
	else if($vars["action"] == 'fileAddDisplay')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$pString = $obj->gatekeep('addDisplay');
	}
	else if($vars["action"] == 'fileAdd')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$pString = $obj->gatekeep('fileAdd');
	}
	else if($vars["action"] == 'fileDeleteDisplay')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$pString = $obj->gatekeep('deleteDisplay');
	}
	else if($vars["action"] == 'fileDeleteConfirm')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$pString = $obj->gatekeep('deleteConfirm');
	}
	else if($vars["action"] == 'fileDelete')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$pString = $obj->gatekeep('delete');
	}
	else if($vars["action"] == 'fileDownload')
	{
		include_once("core/attachments/ATTACHMENTS.php");
		$obj = new ATTACHMENTS($db, $vars);
		$obj->download(); // Method dies
	}
// Single-user Word Processor functions
	else if($vars["action"] == 'wpNoMenu')
	{
		include_once("core/wp/WP.php");
		$wp = new WP($db, $vars);
		$pString = $wp->display(TRUE);
	}
	else if($vars["action"] == 'wpNew')
	{
		include_once("core/wp/WP.php");
		$wp = new WP($db, $vars);
		$pString = $wp->gateKeep("wpNew");
	}
// User bookmark functions
	else if($vars["action"] == 'bookmarkNoMenu')
	{
		include_once("core/user/BOOKMARK.php");
		$bk = new BOOKMARK($db, $vars);
		$pString = $bk->display(TRUE);
	}
	else if($vars["action"] == 'bookmarkAddInit')
	{
		include_once("core/user/BOOKMARK.php");
		$bk = new BOOKMARK($db, $vars);
		$pString = $bk->addInit();
	}
	else if($vars["action"] == 'bookmarkAdd')
	{
		include_once("core/user/BOOKMARK.php");
		$bk = new BOOKMARK($db, $vars);
		$pString = $bk->add();
	}
// Bibliographic style creation/editing preview
	else if($vars["action"] == 'previewStyle')
	{
		//$pString = print_r($vars);
		include_once("core/styles/PREVIEWSTYLE.php");
		$preview = new PREVIEWSTYLE($vars);
		$pString = $preview->display();
		include_once("core/html/CLOSEPOPUP.php");
		new CLOSEPOPUP($pString);
	}
	else
	{
// nothing found in the core, so check plug-in modules
		include_once("core/modules/LOADMODULES.php");
		$loadmodules = new LOADMODULES();
		$moduleFound = FALSE;
		if($moduleList = $loadmodules->readModulesDirectory())
		{
// To guarantee that the action label is not the same as a core one, the module folder name is prepended to the 
// given action (e.g. folderName_actionName). We must remove the prepend.
			$split = split("_", $vars["action"], 2);
			if(sizeof($split) == 2)
			{
				$moduleName = $split[0];
				$action = $split[1];
				include_once("modules/" . $moduleName . '/index.php');
// class name must be in the form $dirName . MODULE
				$module = $moduleName . "_MODULE";
				$class = new $module($db, $vars);
				if(method_exists($class, $action))
				{
					$pString = $class->{$action}();
					$moduleFound = TRUE;
				}
			}
		}
		if(!$moduleFound)
		{
// We've finally come to a dead end.....
			include_once("core/template/TEMPLATE.php");
			$template = new TEMPLATE('content');
			$template->setVar('heading', "WIKINDX");
			$template->setVar('body', $errors->text("inputError", "invalid"));
			$pString = $template->process();
		}
	}
// Debugging - print all SESSION variables.
// COMMENT OUT IN PRODUCTION!!!!!!!!!!!!!!!!!!!!!
//global $_SESSION ;
//print_r($_SESSION);
/*****
*	Close the HTML code by calling the constructor of CLOSE which also 
*	prints the HTTP header, body, menus, footer, flushes the print buffer and closes the database.
*****/
	new CLOSE($db, $pString);
?>
