<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* Word Processor class
*
*****/
class WP
{
// Constructor
	function WP($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// If $noMenu, display WP submenu links
	function display($noMenu = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "wp"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('wp');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// check we are allowed to write
	function gateKeep($function)
	{
		if(!$this->session->getVar('setup_write'))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			return $authorize->initLogon();
		}
		$this->template->setVar('heading', $this->messages->text("heading", "wp"));
// new resource
		if($function == 'wpNew')
		{
			$pString = $this->newWp();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
/**
* Display blank new WP interface
*/
	function newWp()
	{
		include_once("core/wp/JsFormatBar/FORMATBAR.php");
// Include JavaScript file
		$pString = MISC::jsExternal('core/wp/JsFormatBar/JavaScript/JavaScript.js');
		$pString .= FORMATBAR::printFB();
		return $pString;
	}
// write input to session
	function writeSession()
	{
// Write all input with 'wp_' prefix to session
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^wp_/", $key))
				$temp[$key] = trim($value);
		}
		if(isset($temp))
			$this->session->writeArray($temp);
	}
}
?>
