/**
* Format Bar for Wikindx Word Processor
*
* @author	Mark Tsikanovski
* @version	1
*/
// global variables
var textInput;
var inputElementId;
var selectedText;
var startBBCodeOnly = new Array();
var textInputVersions = new Array();
var textInputVersionsIndexes = new Array();
var textInputVersionsIndex;

var agt=navigator.userAgent.toLowerCase();
var is_nav  = ((agt.indexOf('mozilla')!=-1) && (agt.indexOf('spoofer')==-1)
                && (agt.indexOf('compatible') == -1) && (agt.indexOf('opera')==-1)
                && (agt.indexOf('webtv')==-1) && (agt.indexOf('hotjava')==-1));
var is_ie     = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
var is_opera = (agt.indexOf("opera") != -1);
var is_win   = ( (agt.indexOf("win")!=-1) || (agt.indexOf("16bit")!=-1) );
var is_mac    = (agt.indexOf("mac")!=-1);

// initialization and system specific functions
function onPageLoad() {
  if (!is_win && is_opera) {
    document.getElementById("pageContents").style.height = "97%";
  }
}

// FIRST - determine which input text element we are editing and store it's id
// SECOND - store a snapshot of the text element for use with UNDO/REDO functions
function getInputId(inputElement, keyPressEvent) {
  inputElementId = inputElement.id;
  textInput = document.getElementById(inputElementId);
  if (isNaN(textInputVersionsIndexes[inputElementId])) {
    textInputVersionsIndexes[inputElementId] = -1;
  }
// for backspace, enter, space and each word take a snapshot
  if (arguments.length == 2) {
    var charCode = (keyPressEvent.charCode || keyPressEvent.charCode == 0) ? keyPressEvent.keyCode :
	               ((keyPressEvent.keyCode) ? keyPressEvent.keyCode : keyPressEvent.which);
	if (charCode == 8 || charCode == 13 || charCode == 32 || charCode == 46) {
	  textInputVersionsIndexes[inputElementId] ++;
      textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
      textInputVersions[inputElementId+textInputVersionsIndex] = textInput.value;
	}
	else {
	  return;
	}
	return;
  }

// for all other changes such as insertion of codes take a snapshot
  textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
  if (textInput.value != textInputVersions[inputElementId+textInputVersionsIndex]) {
	textInputVersionsIndexes[inputElementId] ++;
    textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
    textInputVersions[inputElementId+textInputVersionsIndex] = textInput.value;
  }
}

// undo last change to text area
function undo() {
  textInputVersionsIndexes[inputElementId] --;
  textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
  textInput.value = textInputVersions[inputElementId+textInputVersionsIndex];
  if (textInput.value == "undefined") {
    textInput.value = "";
	alert('Nothing else to UNDO');
  }
}

// redo last change to text area
function redo() {
  textInputVersionsIndexes[inputElementId] ++;
  textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
  textInput.value = textInputVersions[inputElementId+textInputVersionsIndex];
  if (textInput.value == "undefined") {
    textInputVersionsIndexes[inputElementId] --;
    textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
    textInput.value = textInputVersions[inputElementId+textInputVersionsIndex];
	alert('Nothing Else to REDO');
  }
}

/*
if there was text selected then wrap the BBCode and /BBCode around selection otherwise
put BBCode or /BBCode as appropriate
*/
function BBCodeFormat(BBCode) {
  if (!textInput) {
    return;
  }
  textInput.focus();
//if '=' appears after initial BBCode, strip it and all that follows to create just /BBCode
  if (BBCode.match(/=/)) {
    var EqualsSign = BBCode.indexOf('=');
    var BBCodeEnd = BBCode.substring(0,EqualsSign);
  }
  else {
    BBCodeEnd = BBCode;
  }

//check if even number of this BBCode tags - i.e. all these tags are closed in the text
  thisBBCode = textInput.value.split(BBCodeEnd);
  if (((thisBBCode.length - 1) % 2) == 0) {
    var BBCodeStartEndBalance = true;
  }
  else {
    var BBCodeStartEndBalance = false;
  }

//Gecko based browsers e.g. Netscape, Mozilla, Firefox
  if (is_nav && typeof window.getSelection != "undefined") {
	var totalTextLength = textInput.textLength;
	var selectedTextStart = textInput.selectionStart;
	var selectedTextEnd = textInput.selectionEnd;
	var beforeSelectedText = (textInput.value).substring(0, selectedTextStart);
	var afterSelectedText = (textInput.value).substring(selectedTextEnd, totalTextLength);
	selectedText = (textInput.value).substring(selectedTextStart, selectedTextEnd);
//if no text is selected but a format code is sent
	if (selectedTextStart == selectedTextEnd) {
	  if (BBCode == "upperCase") {
	    textInput.value = textInput.value.toUpperCase();
        textInput.value = textInput.value.replace(/\[[^\]]*\]/g, function(word) {return word.substring(0).toLowerCase()});
	  }
	  else if (BBCode == "lowerCase") {
	    textInput.value = textInput.value.toLowerCase();
	  }
	  else if (startBBCodeOnly[BBCodeEnd+inputElementId] != BBCode) {
//this BBCode is either multivariate or closed
	    if (BBCode.match(/=[\w]+/)) {
//multivariate codes (select lists) - e.g. font type
		  if (startBBCodeOnly[BBCodeEnd+inputElementId] != "" && typeof startBBCodeOnly[BBCodeEnd+inputElementId] != "undefined") {
//if this multivariate code had a different value last time and is still open, close code first before inserting new code...
            if (BBCodeStartEndBalance == false) {
              textInput.value = beforeSelectedText + "[/" + BBCodeEnd + "]" + "[" + BBCode + "]" + afterSelectedText;
			}
			else {
//unless (see above comment) the tags actually do balance
              textInput.value = beforeSelectedText + "[" + BBCode + "]" + afterSelectedText;
			}
		  }
		  else if (BBCodeStartEndBalance == false) {
//if this multivariate code is already closed, but start/end tags DO NOT balance, close code first before inserting new code
            textInput.value = beforeSelectedText + "[/" + BBCodeEnd + "]" + "[" + BBCode + "]" + afterSelectedText;
		  }
		  else {
//if this multivariate code is already closed, and start/end tags DO balance just insert new code
	        textInput.value = beforeSelectedText + "[" + BBCode + "]" + afterSelectedText;
		  }
		}
		else if (BBCodeStartEndBalance == false) {
//if this non multivariate code is already closed, but start/end tags DO NOT balance, just close code
          textInput.value = beforeSelectedText + "[/" + BBCodeEnd + "]" + afterSelectedText;
		}
//if this non-multivariate code (button) e.g. bold is already closed, and start/end tags DO balance just insert new code
		else {
          textInput.value = beforeSelectedText + "[" + BBCode + "]" + afterSelectedText;
		}
		if (BBCode.match(/=[\w]+/)) {
		  startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
		}
		else {
          startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
		}
	  }
	  else if (startBBCodeOnly[BBCodeEnd+inputElementId] == BBCode) {
//multivariate code or not has same value as last time, so it just needs closing
        if (BBCodeStartEndBalance == false) {
//start/end tags DO NOT balance, which you expect here, put end code
	      textInput.value = beforeSelectedText + "[/" + BBCodeEnd + "]" + afterSelectedText;
		  startBBCodeOnly[BBCodeEnd+inputElementId] = "";
		}
		else {
//start/end tags DO balance, which you NOT expect here, so put the new code		
		  textInput.value = beforeSelectedText + "[" + BBCode + "]" + afterSelectedText;
		  if (BBCode.match(/=[\w]+/)) {
		    startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
		  }
		  else {
            startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
		  }
		}
	  }
	}
//if a text selection is made
	else {
	  if (BBCode == "upperCase") {
	    selectedText = selectedText.toUpperCase();
        selectedText = selectedText.replace(/\[[^\]]*\]/g, function(word) {return word.substring(0).toLowerCase()});
		textInput.value = beforeSelectedText + selectedText + afterSelectedText;
	  }
	  else if (BBCode == "lowerCase") {
	    selectedText = selectedText.toLowerCase();
		textInput.value = beforeSelectedText + selectedText + afterSelectedText;
	  }
	  else {
	    if (BBCodeStartEndBalance == false) {
//before applying code to selection close any open single of this code
	      textInput.value = beforeSelectedText + "[/" + BBCodeEnd + "]" + "[" + BBCode + "]" + selectedText + "[/" + BBCodeEnd + "]" + afterSelectedText;
		  startBBCodeOnly[BBCodeEnd+inputElementId] = "";
		}
		else {
	      textInput.value = beforeSelectedText + "[" + BBCode + "]" + selectedText + "[/" + BBCodeEnd + "]" + afterSelectedText;
		}
	  }
	}
  }

//IE
  else if (is_ie && typeof document.selection.createRange != "undefined") {
    selectedText = document.selection.createRange().text;
	if (selectedText.length == 0) {
//if no text is selected but a format code is sent	
	  if (BBCode == "upperCase") {
	    textInput.value = textInput.value.toUpperCase();
        textInput.value = textInput.value.replace(/\[[^\]]*\]/g, function(word) {return word.substring(0).toLowerCase()});
	  }
	  else if (BBCode == "lowerCase") {
	    textInput.value = textInput.value.toLowerCase();
	  }
	  else if (startBBCodeOnly[BBCodeEnd+inputElementId] != BBCode) {
//this BBCode is either multivariate or closed
	    if (BBCode.match(/=[\w]+/)) {
//multivariate codes (select lists) - e.g. font type
		  if (startBBCodeOnly[BBCodeEnd+inputElementId] != "" && typeof startBBCodeOnly[BBCodeEnd+inputElementId] != "undefined") {
//if this multivariate code had a different value last time and is still open, close code first before inserting new code...
            if (BBCodeStartEndBalance == false) {
              document.selection.createRange().text = selectedText + "[/" + BBCodeEnd + "]" + "[" + BBCode + "]";
			}
			else {
//unless (see above comment) the tags actually do balance
              document.selection.createRange().text = selectedText + "[" + BBCode + "]";
			}
		  }
		  else if (BBCodeStartEndBalance == false) {
//if this multivariate code is already closed, but start/end tags DO NOT balance, close code first before inserting new code
            document.selection.createRange().text = selectedText + "[/" + BBCodeEnd + "]" + "[" + BBCode + "]";
		  }
		  else {
//if this multivariate code is already closed, and start/end tags DO balance just insert new code
	        document.selection.createRange().text = selectedText + "[" + BBCode + "]";
		  }
		}
		else if (BBCodeStartEndBalance == false) {
//if this non multivariate code is already closed, but start/end tags DO NOT balance, just close code
          document.selection.createRange().text = selectedText + "[/" + BBCodeEnd + "]";
		}
//if this non-multivariate code (button) e.g. bold is already closed, and start/end tags DO balance just insert new code
		else {
          document.selection.createRange().text = selectedText + "[" + BBCode + "]";
		}
		if (BBCode.match(/=[\w]+/)) {
		  startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
		}
		else {
          startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
		}
	  }
	  else if (startBBCodeOnly[BBCodeEnd+inputElementId] == BBCode) {
//multivariate code or not has same value as last time, so it just needs closing
        if (BBCodeStartEndBalance == false) {
//start/end tags DO NOT balance, which you expect here, put end code
	      document.selection.createRange().text = selectedText + "[/" + BBCodeEnd + "]";
		  startBBCodeOnly[BBCodeEnd+inputElementId] = "";
		}
		else {
//start/end tags DO balance, which you NOT expect here, so put the new code		
		  document.selection.createRange().text = selectedText + "[" + BBCode + "]";
		  if (BBCode.match(/=[\w]+/)) {
		    startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
		  }
		  else {
            startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
		  }
		}
	  }
	}
//if a text selection is made
	else {
	  if (BBCode == "upperCase") {
	    selectedText = selectedText.toUpperCase();
        selectedText = selectedText.replace(/\[[^\]]*\]/g, function(word) {return word.substring(0).toLowerCase()});
		document.selection.createRange().text = selectedText;
	  }
	  else if (BBCode == "lowerCase") {
	    selectedText = selectedText.toLowerCase();
		document.selection.createRange().text = selectedText;
	  }
	  else {
	    if (BBCodeStartEndBalance == false) {
//before applying code to selection close any open single of this code
	      document.selection.createRange().text = "[/" + BBCodeEnd + "]" + "[" + BBCode + "]" + selectedText + "[/" + BBCodeEnd + "]";
		  startBBCodeOnly[BBCodeEnd+inputElementId] = "";
		}
		else {
	      document.selection.createRange().text = "[" + BBCode + "]" + selectedText + "[/" + BBCodeEnd + "]";
		}
	  }
	}
  }

//Konqueror, Opera - selection not supported
  else {
	if (BBCode == "upperCase") {
	  textInput.value = textInput.value.toUpperCase();
      textInput.value = textInput.value.replace(/\[[^\]]*\]/g, function(word) {return word.substring(0).toLowerCase()});
	}
	else if (BBCode == "lowerCase") {
      textInput.value = textInput.value.toLowerCase();
	}
	else if (startBBCodeOnly[BBCodeEnd+inputElementId] != BBCode) {
//this BBCode is either multivariate or closed
	  if (BBCode.match(/=[\w]+/)) {
//multivariate codes (select lists) - e.g. font type
		if (startBBCodeOnly[BBCodeEnd+inputElementId] != "" && typeof startBBCodeOnly[BBCodeEnd+inputElementId] != "undefined") {
//if this multivariate code had a different value last time and is still open, close code first before inserting new code
          if (BBCodeStartEndBalance == false) {
            textInput.value += "[/" + BBCodeEnd + "]" + "[" + BBCode + "]";
		  }
		  else {
//unless (see above comment) the tags actually do balance
            textInput.value += "[" + BBCode + "]";
		  }
		}
		else if (BBCodeStartEndBalance == false) {
//if this multivariate code is already closed, but start/end tags DO NOT balance, close code first before inserting new code
          textInput.value += "[/" + BBCodeEnd + "]" + "[" + BBCode + "]";
		}
		else {
//if this multivariate code is already closed, and start/end tags DO balance just insert new code
	      textInput.value += "[" + BBCode + "]";
		}
	  }
	  else if (BBCodeStartEndBalance == false) {
//if this non-multivariate code is already closed, but start/end tags DO NOT balance, just close code
        textInput.value += "[/" + BBCodeEnd + "]";
	  }
//if this non-multivariate code (button) e.g. bold is already closed, and start/end tags DO balance just insert new code
	  else {
        textInput.value += "[" + BBCode + "]";
	  }
	  if (BBCode.match(/=[\w]+/)) {
		startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
	  }
	  else {
        startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
	  }
	}
	else if (startBBCodeOnly[BBCodeEnd+inputElementId] == BBCode) {
//multivariate code or not has same value as last time, so it just needs closing
      if (BBCodeStartEndBalance == false) {
//start/end tags DO NOT balance, which you expect here, put end code
	    textInput.value += "[/" + BBCodeEnd + "]";
		startBBCodeOnly[BBCodeEnd+inputElementId] = "";
	  }
	  else {
//start/end tags DO balance, which you NOT expect here, so put the new code		
		textInput.value += "[" + BBCode + "]";
		if (BBCode.match(/=[\w]+/)) {
		  startBBCodeOnly[BBCodeEnd+inputElementId] = BBCode;
		}
		else {
          startBBCodeOnly[BBCodeEnd+inputElementId] = BBCodeEnd;
		}
	  }
	}
  }
  textInputVersionsIndexes[inputElementId] ++;
  textInputVersionsIndex = textInputVersionsIndexes[inputElementId];
  textInputVersions[inputElementId+textInputVersionsIndex] = textInput.value;
}

//Insert a timestamp - system default format
function timestamp() {
  if (!textInput) {
    return;
  }
  textInput.focus();
  var today = new Date();
  textInput.value += today.toString();
}

function hideFormatBar() {
  document.getElementById("formatBar").style.display = "none";
  document.getElementById("formatBarBreak").style.display = "none";
  document.getElementById("formatBarStub").style.display = "block";
}

function displayFormatBar() {
  document.getElementById("formatBar").style.display = "block";
  document.getElementById("formatBarBreak").style.display = "block";
  document.getElementById("formatBarStub").style.display = "none";
}

// Provide some basic statistics on what's typed
function stats() {
  var justText = textInput.value.replace(/\[[^\]]*\]/g, "");
  var charCountEx = justText.replace(/[\s\.,\:;\?\!`'"\(\)\[\]\{\}\-_<>\\\/\|]/g, "").length;
  var charCountIn = justText.replace(/[\s]/g, "").length;
  var wordCount = justText.replace(/[\.,\:;\?\!`'"\(\)\[\]\{\}\-_<>]/g, "")
  wordCount = wordCount.replace(/[\/\\\|]/g, " ")
  wordCount = wordCount.split(/\s./g);
  var lineCount = justText.split(/\n\s*\S+/g);
  var paragraphCount  = justText.split(/\n+\s*[^\S]+/g);

  alert("Character Count (excluding punctuation) = " + charCountEx + "\n" +
        "Character Count (including punctuation) = " + charCountIn + "\n" +
        "Word Count = " + wordCount.length + "\n" +
		"Line Count = " + lineCount.length + "\n" +
		"Paragraph Count = " + paragraphCount.length);
}
