<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	MYWIKINDX class.
*
*	Access My WIKINDX
*****/
class MYWIKINDX
{
// Constructor
	function MYWIKINDX($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
	}
// Check this is a logged in user accessing mywikindx
	function gatekeep()
	{
		if(!$this->session->getVar('setup_userId') || !array_key_exists('method', $this->vars))
			$this->failure($this->errors->text("inputError", "invalid"));
		$method = $this->vars['method'];
		if($this->vars['method'] == 'createInit')
			$this->session->setVar('mywikindx_bibliography_radio', 'create');
		else if($this->vars['method'] == 'editInit')
			$this->session->setVar('mywikindx_bibliography_radio', 'edit');
		else if($this->vars['method'] == 'deleteInit')
			$this->session->setVar('mywikindx_bibliography_radio', 'delete');
		else if($this->vars['method'] == 'deleteFromInit')
			$this->session->setVar('mywikindx_bibliography_radio', 'deleteFrom');
		return $this->$method();
// else, proceed
	}
// List user's bibliographies with options to edit, delete and add new
	function listBibliographies()
	{
		$pString = FORM::formHeader("myWikindxBibliography");
		$pString .= MISC::p(MISC::b($this->messages->text("user", "bib") . ":"));
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if(!$this->session->getVar("mywikindx_bibliographies"))
		{
			$pString .= TABLE::td($this->messages->text("user", "noBibs"));
			$radios = MISC::p(FORM::radioButton(FALSE, "method", "createInit", TRUE) . "&nbsp;&nbsp;" . 
				$this->messages->text("user", "createBib"), FALSE, "left");
		}
		else
		{
			$bibsArray = unserialize($this->session->getVar("mywikindx_bibliographies"));
			asort($bibsArray);
			$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "bibId", $bibsArray, 5));
			if(!$this->session->getVar('mywikindx_bibliography_radio'))
				$checked = TRUE;
			else
				$checked = $this->session->getVar('mywikindx_bibliography_radio') == 'create' ? TRUE : FALSE;
			$radios = MISC::p(FORM::radioButton(FALSE, "method", "createInit", $checked) . "&nbsp;&nbsp;" . 
				$this->messages->text("user", "createBib"), FALSE, "left");
			$checked = $this->session->getVar('mywikindx_bibliography_radio') == 'edit' ? TRUE : FALSE;
			$radios .= MISC::p(FORM::radioButton(FALSE, "method", "editInit", $checked) . "&nbsp;&nbsp;" . 
				$this->messages->text("user", "editBib"), FALSE, "left");
			$checked = $this->session->getVar('mywikindx_bibliography_radio') == 'delete' ? TRUE : FALSE;
			$radios .= MISC::p(FORM::radioButton(FALSE, "method", "deleteInit", $checked) . "&nbsp;&nbsp;" . 
				$this->messages->text("user", "deleteBib"), FALSE, "left");
			$checked = $this->session->getVar('mywikindx_bibliography_radio') == 'deleteFrom' ? TRUE : FALSE;
			$radios .= MISC::p(FORM::radioButton(FALSE, "method", "deleteFromInit", $checked) . "&nbsp;&nbsp;" . 
				$this->messages->text("user", "deleteFromBib"), FALSE, "left");
		}
		$pString .= TABLE::td($radios);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		return $pString;
	}
// List user's bibliographies with options to use one of them or the WIKINDX master bibliography when listing, searching etc.
	function useBibInit()
	{
		$pString = FORM::formHeader("myWikindxBibliography");
		$pString .= FORM::hidden("method", "useBib");
		$pString .= MISC::p(MISC::b($this->messages->text("user", "useBib") . ":"));
		$tempBibs = array();
		if($this->session->issetVar("mywikindx_bibliographies"))
		{
			$bibs = unserialize($this->session->getVar("mywikindx_bibliographies"));
// Check this bibliographies have some resources in them
			foreach($bibs as $key => $value)
			{
				$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
					" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($key));
				$dbBibs = $this->db->fetchOne($recordset);
				if($dbBibs)
					$tempBibs[$key] = $value;
			}
			asort($tempBibs);
		}
// grab other users' bibliographies
		$otherBibs = $tempOtherBibs = array();
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('id', 'title', 'bibliography'), 
			" WHERE " . $this->db->formatfield('userId') . "!=" . 
			$this->db->tidyInput($this->session->getVar('setup_userId')));
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['bibliography'])
				$otherBibs[$row['id']] = $row['title'];
		}
		if(!empty($otherBibs))
		{
			asort($otherBibs);
// Add other users divider with key of -1 (will result in invalid input if selected)
			$tempOtherBibs[-1] = $this->messages->text("user", "otherBibs");
			foreach($otherBibs as $key => $value)
				$tempOtherBibs[$key] = $value;
		}
// add main wikindx bibliography to array with id of 0
		$bibsArray[0] = $this->messages->text("user", "masterBib");
		foreach($tempBibs as $key => $value)
			$bibsArray[$key] = $value;
		if(sizeof($tempOtherBibs) > 1)
		{
			foreach($tempOtherBibs as $key => $value)
				$bibsArray[$key] = $value;
		}
		$selected = $this->session->getVar('mywikindx_bibliography_use');
		if($selected)
			$pString .= FORM::selectedBoxValue(FALSE, "bibId", $bibsArray, $selected, 5);
		else
			$pString .= FORM::selectFBoxValue(FALSE, "bibId", $bibsArray, 5);
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		return $pString;
	}
// Set a bibliography for browsing
	function useBib()
	{
		include_once("core/user/USER.php");
		$user = new USER($this->db, $this->vars);
// bibId of 0 == master bibliography
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->session->delVar('mywikindx_bibliography_use');
		else if($this->vars['bibId'] == -1) // divider!
			$this->badInput($this->errors->text("inputError", "invalid"), "initDisplay", $user);
		else
			$this->session->setVar('mywikindx_bibliography_use', $this->vars['bibId']);
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx"));
		$pString = $this->success->text("bibliography", " " . $this->messages->text("misc", "set") . " ");
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $user->initDisplay($pString));
	}
// Display for deleting resources from a bibliography
	function deleteFromInit($message = FALSE)
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->failure($this->errors->text("inputError", "invalid"));
		$this->checkValidUser("initDisplay");
		$pString = $message ? $message : '';
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		$bibs = $this->db->fetchOne($recordset);
		if(!$bibs)
			$this->failure($this->messages->text("resources", "noResult"));
		include_once("core/user/LISTBIBLIOGRAPHY.php");
		$list = new LISTBIBLIOGRAPHY($this->db, $this->vars);
		list($string, $pageString) = $list->process($bibs);
		$pString .= $string;
		$this->template->setVar('paging', $pageString);
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "deleteFromBib")));
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Delete resources from a bibliography
	function deleteFrom()
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->failure($this->errors->text("inputError", "invalid"));
		$this->checkValidUser("initDisplay");
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/bib_(.*)/", $key, $matches))
				$inputBibs[] = $matches[1];
		}
		if(!isset($inputBibs))
			$this->failure($this->errors->text("inputError", "invalid"));
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
// bibliography is a comma-separated list of unique resource ids.
		$dbBibs = $this->db->fetchOne($recordset);
		$dbBibs = explode(",", $dbBibs);
		$dbBibs = array_diff($dbBibs, $inputBibs);
		if(empty($dbBibs))
			$this->db->updateNull('WKX_user_bibliography', array('bibliography'),
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		else
		{
			$updateArray = array('bibliography' => implode(",", $dbBibs));
			$this->db->update('WKX_user_bibliography', $updateArray, 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		}
		$this->checkPopulatedBibliographies();
		$pString = $this->success->text("deleteFromBib");
		return $this->deleteFromInit($pString);
	}
// Display options for adding a bibliography
	function createInit($error = FALSE)
	{
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "createBib")));
		$this->session->delVar("bibliography_lock");
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("myWikindxBibliography");
		$pString .= FORM::hidden("method", "create");
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$sessVar = $this->session->issetVar("mywikindx_title") ? 
			$this->html->dbToFormTidy($this->session->getVar("mywikindx_title")) : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("user", "bibTitle"), "title", $sessVar, 50, 255)
			 . " " . MISC::span('*', 'required'));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$sessVar = $this->session->issetVar("mywikindx_description") ? 
			$this->html->dbToFormTidy($this->session->getVar("mywikindx_description")) : FALSE;
		$pString .= TABLE::td(FORM::textAreaInput($this->messages->text("user", "bibDescription"), 
			"description", $sessVar, 80, 10) . MISC::br() . 
			$this->messages->text("hint", "format"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::p(FORM::formSubmit("Add"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// create a bibliography
	function create()
	{
		if(array_key_exists('description', $this->vars) && trim($this->vars['description']))
		{
			$this->session->setVar('mywikindx_description', $this->vars['description']);
			$fields[] = 'description';
			$values[] = $this->vars['description'];
		}
		if(!trim($this->vars['title']))
			$this->badInput($this->errors->text("inputError", "missing"), "createInit");
		if($this->session->getVar("bibliography_lock"))
			$this->failure($this->errors->text("done", "bibliography"));
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "createBib")));
		$this->session->setVar('mywikindx_title', $this->vars['title']);
		$fields[] = 'title';
		$values[] = $this->vars['title'];
		$fields[] = 'userId';
		$values[] = $this->session->getVar('setup_userId');
		$this->db->insert('WKX_user_bibliography', $fields, $values);
		$this->session->setVar("bibliography_lock", TRUE);
		$this->session->delVar('mywikindx_description');
		$this->session->delVar('mywikindx_title');
		$pString = $this->success->text("bibliography", " " . $this->messages->text("misc", "added") . " ");
		include_once("core/user/USER.php");
		$user = new USER($this->db, $this->vars);
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $user->initDisplay($pString));
	}
// Display options for editing a bibliography
	function editInit($error = FALSE)
	{
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "editBib")));
		$this->session->delVar("bibliography_lock");
		if(!array_key_exists('bibId', $this->vars) || !trim($this->vars['bibId']))
			$this->failure($this->errors->text("inputError", "missing"));
		$this->checkValidUser("initDisplay");
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("myWikindxBibliography");
		$pString .= FORM::hidden("method", "edit");
		$pString .= FORM::hidden("bibId", $this->vars['bibId']);
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($this->session->issetVar("mywikindx_title"))
		{
			$title = $this->html->dbToFormTidy($this->session->getVar("mywikindx_title"));
			$description = $this->html->dbToFormTidy($this->session->getVar("mywikindx_description"));
		}
		else
		{
			$bibsArray = unserialize($this->session->getVar("mywikindx_bibliographies"));
			$title = $this->html->dbToFormTidy($bibsArray[$this->vars['bibId']]);
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('description'), 
				" WHERE " . $this->db->formatfield('id') . "=" . 
				$this->db->tidyInput($this->vars['bibId']));
			$description = $this->html->dbToFormTidy($this->db->fetchOne($recordset));
		}
		$pString .= TABLE::td(FORM::textInput($this->messages->text("user", "bibTitle"), "title", $title, 50, 255)
			 . " " . MISC::span('*', 'required'));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::textAreaInput($this->messages->text("user", "bibDescription"), 
			"description", $description, 80, 10) . MISC::br() . 
			$this->messages->text("hint", "format"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::p(FORM::formSubmit("Edit"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// edit a bibliography
	function edit()
	{
		if(trim($this->vars['description']))
		{
			$this->session->setVar('mywikindx_description', $this->vars['description']);
			$updateArray['description'] = $this->vars['description'];
		}
		else
			$this->db->updateNull('WKX_user_bibliography', array('description'),
				" WHERE " . $this->db->formatfield('id') . "=" . 
				$this->db->tidyInput($this->vars['bibId']));
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'] || !trim($this->vars['title']))
			$this->badInput($this->errors->text("inputError", "missing"), "editInit");
		$this->checkValidUser("initDisplay");
		if($this->session->getVar("bibliography_lock"))
			$this->failure($this->errors->text("done", "bibliography"));
		$this->session->setVar('mywikindx_title', $this->vars['title']);
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "editBib")));
		$updateArray['title'] = $this->vars['title'];
		$this->db->update('WKX_user_bibliography', $updateArray, 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		$this->session->setVar("bibliography_lock", TRUE);
		$this->session->delVar('mywikindx_description');
		$this->session->delVar('mywikindx_title');
		$pString = $this->success->text("bibliography", " " . $this->messages->text("misc", "edited") . " ");
		include_once("core/user/USER.php");
		$user = new USER($this->db, $this->vars);
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $user->initDisplay($pString));
	}
// Ask for confirmation of delete bibliography
	function deleteInit()
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->failure($this->errors->text("inputError", "invalid"));
		$this->checkValidUser("initDisplay");
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "deleteBib")));
		$bibs = unserialize($this->session->getVar('mywikindx_bibliographies'));
		$title = $bibs[$this->vars['bibId']];
		$pString = MISC::p(MISC::b($this->messages->text("user", "deleteConfirmBib") . ": ") . 
			$this->html->dbToHtmlTidy($title));
		$pString .= FORM::formHeader("myWikindxBibliography");
		$pString .= FORM::hidden("method", "delete");
		$pString .= FORM::hidden("bibId", $this->vars['bibId']);
		$pString .= MISC::br() . FORM::formSubmit('Confirm');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Delete bibliography
	function delete()
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->failure($this->errors->text("inputError", "invalid"));
		$this->checkValidUser("initDisplay");
		$this->db->delete('WKX_user_bibliography',
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		$this->db->optimize('WKX_user_bibliography');
		if($this->vars['bibId'] == $this->session->getVar('mywikindx_bibliography_use'))
			$this->session->delVar('mywikindx_bibliography_use');
		$this->checkPopulatedBibliographies();
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx", 
			": " . $this->messages->text("user", "deleteBib")));
		$pString = $this->success->text("bibliography", " " . $this->messages->text("misc", "deleted") . " ");
		include_once("core/user/USER.php");
		$user = new USER($this->db, $this->vars);
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $user->initDisplay($pString));
	}
// Add resources to a bibliography
	function add()
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->failure($this->errors->text("inputError", "invalid"));
// valid user?
		$bibs = unserialize($this->session->getVar('mywikindx_bibliographies'));
		if(!array_key_exists(trim($this->vars['bibId']), $bibs))
		{
			include_once("core/user/USER.php");
			$user = new USER($this->db, $this->vars);
			include_once("core/html/CLOSE.php");
			new CLOSE($this->db, $this->chooseDisplay($this->errors->text("inputError", "invalid")));
		}
		if(!array_key_exists("addAll", $this->vars))
		{
			foreach($this->vars as $key => $value)
			{
				if(preg_match("/bib_(.*)/", $key, $matches))
					$inputBibs[] = $matches[1];
			}
			if(!isset($inputBibs))
				return $this->chooseDisplay($this->errors->text("inputError", "invalid"));
		}
// else - want to add all in list to bibliography.
		else
		{
			if(!$sql = stripslashes($this->session->getVar('sql_stmt')))
				$this->failure($this->errors->text("file", "noSql"));
			$recordset = $this->db->query($sql);
			while($row = $this->db->loopRecordSet($recordset))
				$inputBibs[] = $row['resourceId'];
		}
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
// bibliography is a comma-separated list of unique resource ids.
		$dbBibsRow = $this->db->fetchOne($recordset);
		if(!$dbBibsRow)
			$updateArray = array('bibliography' => implode(",", $inputBibs));
		else
		{
			$dbBibs = explode(",", $dbBibsRow);
			$updateBibs = array_unique(array_merge($dbBibs, $inputBibs));
			$updateArray = array('bibliography' => implode(",", $updateBibs));
		}
		$this->db->update('WKX_user_bibliography', $updateArray, 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->vars['bibId']));
		$pString = $this->success->text("addBib");
		$this->session->setVar('mywikindx_bibliography_add', $this->vars['bibId']);
		$this->session->setVar("setup_bibliographies", TRUE);
		return $this->chooseDisplay($pString);
	}
// Set email notification
	function notify()
	{
		if(!array_key_exists('notify', $this->vars) || !$this->vars['notify'])
			$this->failure($this->errors->text("inputError", "missing"));
		$updateArray = array('notify' => $this->vars['notify']);
		if(array_key_exists('notifyAdd', $this->vars) && array_key_exists('notifyEdit', $this->vars))
		{
			$this->session->setVar("mywikindx_notifyAdd", TRUE);
			$this->session->setVar("mywikindx_notifyEdit", TRUE);
			$updateArray['notifyAddEdit'] = 'A';
		}
		else if(array_key_exists('notifyAdd', $this->vars))
		{
			$this->session->setVar("mywikindx_notifyAdd", TRUE);
			$this->session->delVar("mywikindx_notifyEdit");
			$updateArray['notifyAddEdit'] = 'N';
		}
		else if(array_key_exists('notifyEdit', $this->vars))
		{
			$this->session->setVar("mywikindx_notifyEdit", TRUE);
			$this->session->delVar("mywikindx_notifyAdd");
			$updateArray['notifyAddEdit'] = 'E';
		}
		else
		{
			$this->session->setVar("mywikindx_notifyAdd", TRUE);
			$this->session->setVar("mywikindx_notifyEdit", TRUE);
			$updateArray['notifyAddEdit'] = 'A';
		}
		$this->db->update('WKX_users', $updateArray, 
			" WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($this->session->getVar('setup_userId')));
		$this->session->setVar("mywikindx_notify", $this->vars['notify']);
		$pString = $this->success->text("notify");
		include_once("core/user/USER.php");
		$user = new USER($this->db, $this->vars);
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $user->initDisplay($pString));
	}
// When adding a resource from list, search, select resources, chose which one to return to
	function chooseDisplay($pString)
	{
		if($this->session->getVar('sql_lastMulti') == 'select')
		{
			include_once("core/list/SELECTRESOURCES.php");
			$select = new SELECTRESOURCES($this->db, $this->vars);
			return $select->process($pString);
		}
		else if($this->session->getVar('sql_lastMulti') == 'list')
		{
			include_once("core/list/LISTRESOURCES.php");
			$list = new LISTRESOURCES($this->db, $this->vars);
			return $list->process($pString);
		}
		else if($this->session->getVar('sql_lastMulti') == 'search')
		{
			include_once("core/list/SEARCHRESOURCES.php");
			$search = new SEARCHRESOURCES($this->db, $this->vars);
			return $search->process($pString);
		}
		else if($this->session->getVar('sql_lastMulti') == 'powerSearch')
		{
			include_once("core/list/POWERSEARCHRESOURCES.php");
			$search = new POWERSEARCHRESOURCES($this->db, $this->vars);
			return $search->process($pString);
		}
		else if($this->session->getVar('sql_lastMulti') == 'listKeyword')
		{
			include_once("core/list/LISTSOMERESOURCES.php");
			$list = new LISTSOMERESOURCES($this->db, $this->vars);
			return $list->keywordProcess($pString);
		}
		else if($this->session->getVar('sql_lastMulti') == 'listCite')
		{
			include_once("core/list/LISTSOMERESOURCES.php");
			$list = new LISTSOMERESOURCES($this->db, $this->vars);
			return $list->citeProcess($pString);
		}
	}
// check this user can edit, delete and deleteFrom
	function checkValidUser($function)
	{
		$bibs = unserialize($this->session->getVar('mywikindx_bibliographies'));
		if(!array_key_exists(trim($this->vars['bibId']), $bibs))
		{
			include_once("core/user/USER.php");
			$user = new USER($this->db, $this->vars);
			include_once("core/html/CLOSE.php");
			new CLOSE($this->db, $user->$function($this->errors->text("inputError", "invalid")));
		}
	}
// Check we still have populated user bibliographies
	function checkPopulatedBibliographies()
	{
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('id'), 
			" WHERE " . $this->db->formatField('bibliography') . ' IS NOT NULL');
		if($this->db->numRows($recordset))
			$this->session->setVar("setup_bibliographies", TRUE);
		else
			$this->session->delVar("setup_bibliographies");
	}
// Error handling
	function badInput($error, $function, $object = FALSE)
	{
		if(!$object)
			$object = $this;
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $object->$function($error));
	}
// failure - bomb out
	function failure($error)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx"));
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
