<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* LISTBIBLIOGRAPHY class
*
* List all database resources belonging to a particular user's bibliography.
* To do......
*****/
class LISTBIBLIOGRAPHY
{
// Constructor
	function LISTBIBLIOGRAPHY($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
//		include_once("core/template/TEMPLATE.php");
//		$this->template = new TEMPLATE('content');
	}
// Display titles....
	function process($bibs)
	{
		include_once("core/html/TABLE.php");
		include_once("core/paging/PAGING.php");
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "html");
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
// Load icons
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
// type of CSS class required.
		$icons->getIconInfo('view');
		$icons->getIconInfo('viewmeta');
		$icons->getIconInfo('edit');
		$viewLink = $icons->viewExists ? "imgLink" : "link";
		$editLink = $icons->editExists ? "imgLink" : "link";
		$bibsArray = explode(",", $bibs);
		$titles = unserialize($this->session->getVar('mywikindx_bibliographies'));
		$bibTitle = $titles[$this->vars['bibId']];
		$condition = " WHERE WKX_resource.id = ";
		foreach($bibsArray as $resourceId)
			$conditionArray[] = $this->db->tidyInput($resourceId);
		$condition .= implode(" OR WKX_resource.id = ", $conditionArray);
		$sqlTotal = $this->db->selectNoExecute(array("WKX_resource"),  
			$stmt->listFields("creator"), 
			$stmt->listJoin("creator", $condition));
		$paging = new PAGING($this->db, $this->vars, $sqlTotal);
		$recordset = $paging->sqlLimit($sqlTotal);
		$index = 0;
		$pString = MISC::p($paging->linksInfo($bibTitle));
		$pString .= FORM::formHeader("myWikindxBibliography");
		$pString .= FORM::hidden("method", "deleteFrom");
		$pString .= FORM::hidden("bibId", $this->vars['bibId']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		while($row = $this->db->loopRecordSet($recordset))
		{
			$links = array();
			$view = ($row['quotes'] || $row['paraphrases'] || $row['musings']) ? 
				$icons->viewmeta : $icons->view;
			$links[] = MISC::a("$viewLink", "&nbsp;" . $view . 
				"&nbsp;", "index.php?action=resourceView" . 
				htmlentities("&id=" . $row['resourceId']));
			if($this->session->getVar('setup_write'))
				$links[] = MISC::a("$editLink", "&nbsp;" . $icons->edit . 
				"&nbsp;", "index.php?action=resourceEdit" . 
				htmlentities("&id=" . $row['resourceId']));
			$checkBox = "&nbsp;" . FORM::checkBox(FALSE, "bib_" . $row['resourceId']);
			$class = $index % 2 ? 'alternate2' : 'alternate1';
			$pString .= TABLE::trStart();
			$pString .= TABLE::td($bibStyle->process($row), $class);
			$pString .= TABLE::td(implode("&nbsp;&nbsp;", $links) . $checkBox, $class, "right", "top");
			$pString .= TABLE::trEnd();
			$index++;
		}
		$pString .= TABLE::tableEnd();
// Encapsulating table in content.tpl
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::formSubmit("Delete") . MISC::br() . 
			$this->messages->text("hint", "deleteFrom"), FALSE, "right");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= FORM::formEnd();
		$queryString = "action=myWikindxBibliography&method=deleteFromInit&bibId=" . $this->vars['bibId'];
		$pageString = $paging->links($queryString);
		return array($pString, $pageString);
	}
}
?>
