<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2005
sirfragalot@users.sourceforge.net
**********************************************************************************/
/**
*BOOKMARK class
* Manage user's bookmarks.
*
* @author Mark Grimshaw
* 
* $Header: /cvsroot/wikindx/wikindx3/core/user/BOOKMARK.php,v 1.2 2005/06/26 22:20:41 sirfragalot Exp $
*/
class BOOKMARK
{
// Constructor
	function BOOKMARK($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// If $noMenu, display bookmark submenu links
	function display($noMenu = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "bookmark"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('bookmark');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Display form for adding a bookmark
	function addInit($error = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "bookmark"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= MISC::p($this->messages->text("misc", "bookmark"));
		$pString .= FORM::formHeader("bookmarkAdd");
		$pString .= MISC::p(FORM::textInput($this->messages->text("misc", "bookmarkName"), 
			"name", FALSE, 16, 15));
		$bookmarks = $this->session->getArray("bookmark");
		if(is_array($bookmarks)) // no space left so display list for replacement
		{
			$max = TRUE;
			for($i = 1; $i <= 10; $i++)
			{
				if(!array_key_exists($i . "_name", $bookmarks))
				{
					$max = FALSE;
					break;
				}
			}
			if($max)
			{
				$pString .= MISC::p($this->messages->text("misc", "bookmarkDelete"));
				$checked = TRUE;
				for($i = 1; $i <= 10; $i++)
				{
					if(array_key_exists($i . "_name", $bookmarks))
					{
						$pString .= MISC::p(FORM::radioButton(FALSE, "bookmark_replace", $i, $checked) . 
						"&nbsp;&nbsp;" . stripslashes($bookmarks[$i . "_name"]));
						$checked = FALSE;
					}
				}
			}
		}
		$pString .= FORM::formSubmit('Add');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add a bookmark
	function add()
	{
		if(!array_key_exists("name", $this->vars))
			$this->badInput($this->errors->text("inputError", "missing"), 'addInit');
		$name = trim($this->vars['name']);
		if(!$name)
			$this->badInput($this->errors->text("inputError", "missing"), 'addInit');
		$bookmarks = $this->session->getArray("bookmark");
		$id = 1; // default
		if(array_key_exists('bookmark_replace', $this->vars))
			$id = $this->vars['bookmark_replace'];
		else
		{
			if(is_array($bookmarks))
			{
				for($i = 1; $i <= 10; $i++)
				{
					if(!array_key_exists($i . "_name", $bookmarks))
					{
						$id = $i;
						break;
					}
				}
			}
		}
		$this->template->setVar('heading', $this->messages->text("heading", "bookmark"));
		$success = $this->success->text("bookmark");
		$this->session->setVar("bookmark_" . $id . "_name", $name);
		$this->session->setVar("bookmark_" . $id . "_id", $this->session->getVar('sql_lastSolo'));
// send back to view this resource with success message
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($success, 'lastSolo'));
	}
// bad Input function
	function badInput($error, $method)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->$method($error));
	}
}
?>
