<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	BIBLIOGRAPHY class.
*
*	User bibliographies
*****/
class BIBLIOGRAPHY
{
// Constructor
	function BIBLIOGRAPHY($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
	}
// decide what to do based on method
	function sortMethod()
	{
		if(!array_key_exists('method', $this->vars) || !$this->vars['method'])
			$this->badInput($this->errors->text("inputError", "missing"), "initDisplay");
		$method = $this->vars['method'];
		$this->session->setVar('mywikindx_bibliography_method', $method);
		return $this->$method();
	}
// List user's bibliographies with options to use one of them or the WIKINDX master bibliography when listing, searching etc.
// Also option to view bibliography description and bibliography owner.
	function initDisplay($message = FALSE)
	{
		$pString = $message ? $message : '';
		$pString .= FORM::formHeader("bibliographies");
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
//		$pString .= MISC::p(MISC::b($this->messages->text("user", "bibliography") . ":"));
// grab other users' bibliographies
		$bibs = array();
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('id', 'title', 'bibliography'), 
			" WHERE " . $this->db->formatfield('bibliography') . ' IS NOT NULL');
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['bibliography'])
				$bibs[$row['id']] = $row['title'];
		}
		asort($bibs);
// add main wikindx bibliography to array with id of 0
		$bibsArray[0] = $this->messages->text("user", "masterBib");
		foreach($bibs as $key => $value)
			$bibsArray[$key] = $value;
		$selected = $this->session->getVar('mywikindx_bibliography_use');
		if($selected)
			$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "bibId", $bibsArray, $selected, 5));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "bibId", $bibsArray, 5));
		
		if(!$this->session->getVar('mywikindx_bibliography_method'))
			$checked = TRUE;
		else
			$checked = $this->session->getVar('mywikindx_bibliography_method') == 'displayBib' ? TRUE : FALSE;
		$radios = MISC::p(FORM::radioButton(FALSE, "method", "displayBib", $checked) . "&nbsp;&nbsp;" . 
			$this->messages->text("user", "displayBib"), FALSE, "left");
		$checked = $this->session->getVar('mywikindx_bibliography_method') == 'useBib' ? TRUE : FALSE;
		$radios .= MISC::p(FORM::radioButton(FALSE, "method", "useBib", $checked) . "&nbsp;&nbsp;" . 
			$this->messages->text("user", "useBib"), FALSE, "left");
		
		$pString .= TABLE::td($radios);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar("heading", $this->messages->text("heading", "bibs"));
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Display bibliography details and owner's details
	function displayBib()
	{
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$pString = $this->messages->text("user", "masterBib");
		else
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title', 'fullname', 
				'username', 'description', 'bibliography'), 
				" LEFT JOIN  " . $this->db->formatTable('WKX_users') . 
				" ON " . $this->db->formatfield("WKX_user_bibliography.userId") . "=" . 
				$this->db->formatfield("WKX_users.id") .  
				" WHERE " . $this->db->formatfield("WKX_user_bibliography.id") . "=" . 
				$this->db->tidyInput($this->vars['bibId']));
			$row = $this->db->fetchRow($recordset);
			$text = MISC::b($this->messages->text("user", "username") . ":&nbsp;&nbsp;") . 
				$this->html->dbToHtmlTidy($row['username']) . MISC::br();
			$text .= MISC::b($this->messages->text("user", "fullname") . ":&nbsp;&nbsp;") . 
				$this->html->dbToHtmlTidy($row['fullname']);
			$pString = MISC::p($text);
			$text = '';
			if($row['bibliography'])
			{
				$bibs = sizeof(explode(',', $row['bibliography']));
// Shouldn't really be using 'menu' here but avoids extra translation....
				$text .= MISC::b($this->messages->text("menu", "res") . ":&nbsp;&nbsp;") . 
					$bibs . MISC::br();
			}
			$text .= MISC::b($this->messages->text("user", "bibTitle") . ":&nbsp;&nbsp;") . 
				$this->html->dbToHtmlTidy($row['title']) . MISC::br();
			$text .= MISC::b($this->messages->text("user", "bibDescription") . ":&nbsp;&nbsp;") . 
				$this->html->dbToHtmlTidy($row['description']);
			$pString .= MISC::p($text);
		}
		$pString .= MISC::br() . MISC::hr() . MISC::br();
		$pString .= FORM::formHeader("bibliographies");
		$pString .= FORM::hidden("method", "useBib");
		$pString .= FORM::hidden("bibId", $this->vars['bibId']);
		$pString .= MISC::p($this->messages->text("user", "useBib") . MISC::br() . 
			FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar("heading", $this->messages->text("heading", "bibs"));
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Set a bibliography for browsing
	function useBib()
	{
// bibId of 0 == master bibliography
		if(!array_key_exists('bibId', $this->vars) || !$this->vars['bibId'])
			$this->session->delVar('mywikindx_bibliography_use');
		else
			$this->session->setVar('mywikindx_bibliography_use', $this->vars['bibId']);
		$this->session->delVar('mywikindx_bibliography_add');
		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar("heading", $this->messages->text("heading", "bibs"));
		$pString = $this->success->text("bibliography", " " . $this->messages->text("misc", "set") . " ");
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->initDisplay($pString));
	}
// Error handling
	function badInput($error, $function, $object = FALSE)
	{
		if(!$object)
			$object = $this;
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $object->$function($error));
	}
// failure - bomb out
	function failure($error)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "myWikindx"));
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
