<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* TEXT class
*
* display all or random musings, quotes, paraphrases
*****/
class TEXT
{
// Constructor
	function TEXT($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/html/MISC.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/cite/CITEFORMAT.php");
		$this->cite = new CITEFORMAT($this->db, $this->vars);
	}
// If $noMenu, display Text submenu links
	function display($noMenu = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('text');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show all Musings
	function allMusings()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$recordset = $this->db->select(array('WKX_resource_musing'), 
			array('resourceId', 'text', 'musingPrivate', 'addUserIdMusing'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_musing_text') . " ON " . 
			$this->db->formatfield("WKX_resource_musing_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_musing.id") . 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_timestamp') . " ON " . 
			$this->db->formatfield("WKX_resource_musing.resourceId") . "=" . 
			$this->db->formatfield("WKX_resource_timestamp.id") .  
			" ORDER BY " . $this->db->tidyInputClause("WKX_resource_timestamp.timestamp") . " DESC");
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noMusing"));
		$index = 0;
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		while($row = $this->db->loopRecordSet($recordset))
		{
			if(($row['musingPrivate'] == 'Y') && 
			($this->session->getVar('setup_userId') != $row['addUserIdMusing']))
				continue;
			$class = $index % 2 ? 'alternate2' : 'alternate1';
			$pString .= $this->dataRow($row['text'], $row['resourceId'], $class);
			$index++;
		}
		if(!$index)
			$this->badInput($this->messages->text("resources", "noMusing"));
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show random Musing
	function randomMusing()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$sql = $this->db->selectNoExecute(array('WKX_resource_musing'), 
			array('resourceId', 'text', 'musingPrivate', 'addUserIdMusing'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_musing_text') . " ON " . 
			$this->db->formatfield("WKX_resource_musing_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_musing.id") . 
			" WHERE " . 
			$this->db->formatfield("addUserIdMusing") . "=" . 
			$this->db->tidyInput($this->session->getVar('setup_userId')) . 
			" OR " . 
			$this->db->formatfield("musingPrivate") . "=" . 
			$this->db->tidyInput('N') . 
			" ORDER BY RAND()");
		$recordset = $this->db->limit($sql, 1, 0);
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noMusing"));
		$row = $this->db->fetchRow($recordset);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= $this->dataRow($row['text'], $row['resourceId'], 'alternate1');
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show all Paraphrases
	function allParaphrases()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$recordset = $this->db->select(array('WKX_resource_paraphrase'), 
			array('resourceId', 'text'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_paraphrase_text') . " ON " . 
			$this->db->formatfield("WKX_resource_paraphrase_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_paraphrase.id") . 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_timestamp') . " ON " . 
			$this->db->formatfield("WKX_resource_paraphrase.resourceId") . "=" . 
			$this->db->formatfield("WKX_resource_timestamp.id") .  
			" ORDER BY " . $this->db->tidyInputClause("timestamp") . " DESC");
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noParaphrase"));
		$index = 0;
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		while($row = $this->db->loopRecordSet($recordset))
		{
			$class = $index % 2 ? 'alternate2' : 'alternate1';
			$pString .= $this->dataRow($row['text'], $row['resourceId'], $class);
			$index++;
		}
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show random Paraphrase
	function randomParaphrase()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$sql = $this->db->selectNoExecute(array('WKX_resource_paraphrase'), 
			array('resourceId', 'text'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_paraphrase_text') . " ON " . 
			$this->db->formatfield("WKX_resource_paraphrase_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_paraphrase.id") . " ORDER BY RAND()");
		$recordset = $this->db->limit($sql, 1, 0);
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noParaphrase"));
		$row = $this->db->fetchRow($recordset);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= $this->dataRow($row['text'], $row['resourceId'], 'alternate1');
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show all Quotes
	function allQuotes()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$recordset = $this->db->select(array('WKX_resource_quote'), 
			array('resourceId', 'text'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_quote_text') . " ON " . 
			$this->db->formatfield("WKX_resource_quote_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_quote.id") . 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_timestamp') . " ON " . 
			$this->db->formatfield("WKX_resource_quote.resourceId") . "=" . 
			$this->db->formatfield("WKX_resource_timestamp.id") .  
			" ORDER BY " . $this->db->tidyInputClause("timestamp") . " DESC");
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noQuote"));
		$index = 0;
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		while($row = $this->db->loopRecordSet($recordset))
		{
			$class = $index % 2 ? 'alternate2' : 'alternate1';
			$pString .= $this->dataRow($row['text'], $row['resourceId'], $class);
			$index++;
		}
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// show random Quote
	function randomQuote()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "text"));
		$sql = $this->db->selectNoExecute(array('WKX_resource_quote'), 
			array('resourceId', 'text'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource_quote_text') . " ON " . 
			$this->db->formatfield("WKX_resource_quote_text.id") . "=" . 
			$this->db->formatfield("WKX_resource_quote.id") . " ORDER BY RAND()");
		$recordset = $this->db->limit($sql, 1, 0);
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noQuote"));
		$row = $this->db->fetchRow($recordset);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= $this->dataRow($row['text'], $row['resourceId'], 'alternate1');
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display a table row of data
	function dataRow($text, $id, $class)
	{
// Load icons
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		$icons->getIconInfo("view");
		$viewEditLink = $icons->viewExists ? "imgLink" : "link";
		$pString = TABLE::trStart();
		$pString .= TABLE::td($this->cite->citeParse($this->html->dbToHtmlTidy($text)), $class);
		$view = MISC::a("$viewEditLink", "&nbsp;" . $icons->view . "&nbsp;", "index.php?action=resourceView" . 
			htmlentities("&id=" . $id));
		$pString .= TABLE::td($view, $class, "right");
		$pString .= TABLE::trEnd();
		return $pString;
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
