<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* TEMPLATE class
*****/
class TEMPLATE
{
// constructor
	function TEMPLATE($handle)
	{
		include_once("core/template/phemplate.php");
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();

		$template = $this->session->getVar("setup_template");

                 $tpl_root = ($template ? 'templates/'. $template. '/' : 'templates/default/');
                 $this->tpl = new phemplate($tpl_root);

		$this->handle = $handle;
                 $this->loopItem = array();
                 $this->loop = FALSE;
                 $this->tpl->set_file($handle, $handle.'.tpl');
	}


// add a menu item to the internal array $this->menuItem
         function addMenuItem($handle, $title = FALSE, $link = FALSE, $submenu = FALSE)
         {
            if($title and $link)
            {
         	if ($submenu)
                 {
			$this->loopItem[$handle][] = array(
                 				'title' => $title,
                                                 'link' => $link,
                                                 'submenu' => $this->loopItem[$submenu]
                                                 );
                 	unset($this->loopItem[$submenu]);
                 } else {
			$this->loopItem[$handle][] = array(
                 				'title' => $title,
                                                 'link' => $link,
                                                 );
                 }
            } else {
            	$this->loopItem[$handle] = array();
            }
         }

// add an input hidden to the internal array $this->menuItem
         function addHiddenInputItem($handle, $name = FALSE, $value = FALSE)
         {
            if($name and $value)
            {
		$this->loopItem[$handle][] = array(
                 				'name' => $name,
                                                 'value' => $value
                                                 );
            } else {
            	$this->loopItem[$handle] = array();
            }
         }

// add a checkbox item to the internal array $this->menuItem
         function addCheckboxItem($handle, $text, $name, $check = FALSE)
         {
		$this->loopItem[$handle][] = array(
                 				'text' => $text,
                                                 'name' => $name,
                                                 'checked' => $check
                                                 );
         }



         function addPasswordItem($handle, $userText, $userName, $userValue, $passText, $passName, $passValue, $size = '30', $maxLength = '100')
         {
		$this->loopItem[$handle][] = array(
		                          	  'usernameText' 	=> $userText,
                 		                  'usernameName' 	=> $userName,
                                 		  'usernameValue' 	=> $userValue,
		                                  'usernameSize'	=> $size,
                 		                  'usernameMaxLength'	=> $maxLength,
                          			  'passwordText' 	=> $passText,
		                                  'passwordName' 	=> $passName,
                 		                  'passwordValue' 	=> $passValue,
                                 		  'passwordSize'	=> $size,
		                                  'passwordMaxLength'	=> $maxLength
                                                 );
         }

         function addSelectboxOption($handle, $text, $value, $select = FALSE)
         {
		$this->loopItem[$handle][] = array(
                 				'text' 		=> $text,
                                                 'value' 	=> $value,
                                                 'selected'	=> $select
                                                 );
         }

/**
                          	  'text' 	=> $this->messages->text("config", "template"),
                                   'name' 	=> 'template',
                                   'size'	=> '3',
                                   'options'	=> $templateOptions,
**/
// add a menu item to the internal array $this->menuItem
         function addSelectboxItem($handle, $text, $name, $options, $size = '3')
         {
		$this->loopItem[$handle][] = array(
                 				'text' => $text,
                                                 'name' => $name,
                                                 'size' => $size,
                                                 'options' => $this->loopItem[$options]
                                                 );
                	unset($this->loopItem[$options]);
         }

         function addTextInputItem($handle, $text, $name, $value, $size = '30', $maxLength = '100')
         {
		$this->loopItem[$handle][] = array(
                 				'text' 		=> $text,
                                                 'name' 		=> $name,
                                                 'value' 	=> $value,
                                                 'size'		=> $size,
                                                 'maxLength'	=> $maxLength,
                                                 );
         }


// set a variable by calling the phemplate function set_var(handle, value)
	function setVar($handle, $value)
         {
         	$this->tpl->set_var($handle, $value);
         }
// remove loops
	function findLoop($code, $loop_name)
         {
	         $start_pos = strpos($code, '<loop name="'.$loop_name.'">');

	         if (!$start_pos)
                         return;
	         $end_tag = strpos($code, '</loop name="'.$loop_name.'">');
	         $end_pos = $end_tag + strlen('</loop name="'.$loop_name.'">');

	         $loop_code = substr($code, $start_pos, $end_pos-$start_pos);
                  return $loop_code;
         }

// clean up HTML source code
	function cleanHTML($code)
         {
         	$tmp = $code;
                 $pattern = '/<loop name="([A-Za-z]+)">/';
                 $replacement = '';
                 $matches = array();
                 if(preg_match_all($pattern, $tmp, $matches))
                 {
                         foreach($matches[1] as $loop)
                         {
                         	$loop_code = $this->findLoop($tmp, $loop);
                                 if($loop_code) {
                                 	$tmp = str_replace($loop_code, '', $tmp);
                                 }
                         }
                 }
         	return $tmp;
         }

// process the template based on the input
         function process()
         {
		$options = TPL_OPTIONAL;
         	if ($this->loopItem)
                 {
                 	foreach($this->loopItem as $key => $value)
                         {
                         	$this->tpl->set_loop($key, $value);
                         }
                         $options = $options | TPL_LOOP | TPL_NOLOOP;
                 }
         	return $this->cleanHTML($this->tpl->process('', $this->handle, $options));
         }
// read templates/ directory for template preferences and check we have a sane environment
	function loadDir()
	{
		$handle = opendir('templates');
		while(FALSE !== ($dir = readdir($handle)))
		{
			if(is_dir('templates/' . $dir) 
				&& file_exists('templates/' . $dir . '/description.txt')
//				&& file_exists('templates/' . $dir . '/' . $dir . '.css')
				&& file_exists('templates/' . $dir . '/body.tpl')
				&& file_exists('templates/' . $dir . '/content.tpl')
				&& file_exists('templates/' . $dir . '/footer.tpl')
				&& file_exists('templates/' . $dir . '/header.tpl')
				&& file_exists('templates/' . $dir . '/menu.tpl'))
			{
// read one line
				if($fh = fopen('templates/' . $dir . '/description.txt', "r"))
					$string = fgets($fh);
				
				if($string)
					$array[$dir] = $string;
			}
		}
// sort alphabetically on the key
		ksort($array);
		return $array;
	}
}
?>
