<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*
*	Session functions
*
*****/
class SESSION
{
// Constructor
	function SESSION()
	{
// whatever array session variables are in, we grab 'em.
		global $HTTP_SESSION_VARS;
		if(isset($_SESSION))
			$this->sessionVars = &$_SESSION;
// We now check that phpversion is 4.3 or above so this is no longer necessary
//		else if(isset($HTTP_SESSION_VARS))
//			$this->sessionVars = &$HTTP_SESSION_VARS;
	}
// Set a session variable
	function setVar($key, $value)
	{
		if(!isset($key) || !isset($value)) return false;
		$this->sessionVars[$key] = $value;
		if(!isset($this->sessionVars[$key]))
		{
			return false;
		}
		return true;
	}
// Get a session variable
	function getVar($key)
	{
		if(isset($this->sessionVars[$key]))
			return $this->sessionVars[$key];
		return false;
	}
// Delete a session variable
	function delVar($key)
	{
		if(isset($this->sessionVars[$key]))
			unset($this->sessionVars[$key]);
	}
// Is a session variable set?
	function issetVar($key)
	{
		if(isset($this->sessionVars[$key])) return true;
		return false;
	}
// Destroy the whole session
	function destroy()
	{
		$this->sessionVars = array();
	}
// Return an associative array of all session variables starting with $prefix_.
// key in returned array is minus the prefix to aid in matching database table fields.
	function getArray($prefix)
	{
		$prefix .= '_';
		foreach($this->sessionVars as $key => $value)
		{
			if(preg_match("/^$prefix(.*)/", $key, $matches))
				$array[$matches[1]] = $value;
		}
		if(isset($array))
			return $array;
		return FALSE;
	}
// Write to session variables named with $prefix_ the given associative array
	function writeArray($row, $prefix = FALSE)
	{
		foreach($row as $key => $value)
		{
			if(!$value)
				$value = FALSE;
			if($prefix)
			{
				if(!$this->setVar($prefix . '_' . $key, $value))
					return FALSE;
			}
			else
			{
				if(!$this->setVar($key, $value))
					return FALSE;
			}
		}
		return TRUE;
	}
// Clear session variables named with $prefix
	function clearArray($prefix)
	{
		$prefix .= '_';
		foreach($this->sessionVars as $key => $value)
		{
			if(preg_match("/^$prefix/", $key))
				$this->delVar($key);
		}
	}
}
?>
