<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	RESOURCEWRITE class
*
*	Write new or edited resources
*
*	$Header: /cvsroot/wikindx/wikindx3/core/resource/RESOURCEWRITE.php,v 1.27 2005/06/28 22:38:08 sirfragalot Exp $
*****/
class RESOURCEWRITE
{
// Constructor
	function RESOURCEWRITE($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
// At this stage, if sessionVar['title'] is missing, the user has hit the back button following a 
// successful write/edit -- we need to block a further write.
		if(!$this->session->getVar('resource_title'))
		{
			include_once("core/html/CLOSE.php");
			$this->template->setVar('heading', $this->messages->text("heading", "resources"));
			$this->template->setVar('body', $this->errors->text("done", "resource"));
			new CLOSE($this->db, $this->template->process());
		}
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/MISC.php");
		include_once("core/publisher/PUBLISHER.php");
		$this->publisher = new PUBLISHER($this->db);
		include_once("core/collection/COLLECTION.php");
		$this->collection = new COLLECTION($this->db);
		include_once("core/keyword/KEYWORD.php");
		$this->keyword = new KEYWORD($this->db);
		include_once("core/creator/CREATOR.php");
		$this->creator = new creator($this->db);
// by default, we INSERT a new resource.  If this is FALSE, we are editing and therefore need to UPDATE
		if($this->resourceId = $this->session->getVar('resource_resourceId'))
		{
// we're editing
			$this->insert = FALSE;
			$this->resourceAutoId = $this->resourceId;
		}
		else
// we're inserting a new resource
		{
			$this->insert = TRUE;
			$this->resourceId = 0;
			$this->resourceAutoId = FALSE;
		}
		$this->publisherAutoId = FALSE;
		$this->confPublisherAutoId = FALSE;
		$this->collectionAutoId = FALSE;
	}
	function writeResource()
	{
		include_once("core/resource/RESOURCEFORM.php");
		$form = new RESOURCEFORM($this->db, $this->vars);
		include_once("core/resource/VALIDATEINPUT.php");
		$validate = new VALIDATEINPUT($this->db, $this->vars, $this);
		$validate = new VALIDATEINPUT($this->db, $this->vars, $this);
		if($this->insert)
			$this->template->setVar('heading', $this->messages->text("heading", "newResource"));
		else
			$this->template->setVar('heading', $this->messages->text("heading", "editResource"));
		if($this->session->getVar("resource_typeConvert"))
		{
			$validate = new VALIDATEINPUT($this->db, $this->vars);
			$sessionVars = $validate->stage4();
//print_r($sessionVars); print "<P>";
		}
		else if(!array_key_exists('resource_finish', $this->vars))
		{
			$validate = new VALIDATEINPUT($this->db, $this->vars, $this);
			$sessionVars = $validate->stage5();
		}
		else if(array_key_exists('resource_finish', $this->vars))
		{
			if($this->vars['resource_finish'] == 'stage3')
				$sessionVars = $validate->stage3();
			else if($this->vars['resource_finish'] == 'stage4')
				$sessionVars = $validate->stage4();
		}
		$this->startWrite($sessionVars);
		include_once("core/notify/NOTIFY.php");
		$notify = new NOTIFY($this->db);
		$resourceId = $this->resourceId ? $this->resourceId : $this->resourceAutoId;
		$notify->email($resourceId, $this->insert);
		if($this->session->getVar("resource_typeConvert"))
			$success = $this->success->text("convertType");
		else
			$success = $this->success->text("resource", " " . $this->messages->text("misc", "edited") . " ");
// finally, clear session
// clear the session but keep resource_type
		$this->session->delVar("resourceEditRow");
		$type = $this->session->getVar('resource_type');
		$this->session->clearArray("resource");
		if($type)
			$this->session->setVar('resource_type', $type);
		if($this->insert)
		{
			include_once("core/resource/RESOURCE.php");
			$resource = new RESOURCE($this->db, $this->vars);
			return $resource->gateKeep('newResource', $this->success->text("resource", 
			" " . $this->messages->text("misc", "added") . " "));
		}
		else
		{
			if($this->session->getVar('sql_lastView') == 'solo')
			{
// send back to view this resource with success message
				include_once("core/resource/RESOURCEVIEW.php");
				$resource = new RESOURCEVIEW($this->db, $this->vars);
				new CLOSE($this->db, $resource->view($success, 'lastSolo'));
			}
// send back to resource list with success message
			else if($this->session->getVar('sql_lastView') == 'multi')
			{
				include_once("core/user/MYWIKINDX.php");
				$mywikindx = new MYWIKINDX($this->db, $this->vars);
// send back to view this resource with success message
				return $mywikindx->chooseDisplay($success);
			}
// Just in case - send back to blank page with success message
			else
				$this->template->setVar('body', $success);
		}
		return $this->template->process();
	}
// write resource table by table.
// Ensure that all input (except textarea (i.e. notes)) is parsed by html->nlReduce().
	function startWrite($sessionVars)
	{
		$this->userId = $this->session->getVar('setup_userId');
		$typeConvert = $this->session->getVar("resource_typeConvert");
		$this->loadMap($sessionVars);
		$this->writeResourceTable($sessionVars);
//		if(!$typeConvert)
//		{
			$creatorIds = $this->creator->writeCreatorTable($sessionVars);
			$this->writeResourceCreatorTable($creatorIds);
//		}
		$this->publisherAutoId = $this->publisher->writePublisherTable($sessionVars);
		$this->collectionAutoId = $this->collection->writeCollectionTable($sessionVars);
// proceedings_article can also have publisher details in addition to organiser details
		if($sessionVars['type'] == 'proceedings_article')
			$this->confPublisherAutoId = $this->publisher->writePublisherTable($sessionVars, FALSE, TRUE);

		$this->writePageTable($sessionVars);
		$this->writeYearTable($sessionVars);
		$this->writeMiscTable($sessionVars);
		if(!$typeConvert)
		{
			$this->writeCategoryTable($sessionVars);
			$keywordIds = $this->keyword->writeKeywordTable($sessionVars);
			$this->writeKeywordTable($keywordIds);
			$this->writeNoteTable($sessionVars);
			$this->writeAbstractTable($sessionVars);
			$this->writeCustomTable($sessionVars);
		}
		if($this->insert)
			$this->writeSummaryTable();
		$this->writeTimestampTable();
// Lock re-inserting
		$this->session->setVar('resourceLock', TRUE);
	}
// Load mappings between resource types and database tables where there is no specifically named field.
// Additionally, if converting a resource type, remove extra creators from sessionVars
	function loadMap(&$sessionVars)
	{
		include_once("core/resource/RESOURCEMAP.php");
		$map = new RESOURCEMAP();
		$type = $sessionVars['type'];
		$this->map = $map->$type;
		$triage = $unset = array();
		if($oldType = $this->session->getVar("resource_oldType"))
		{
			foreach($map->{$oldType}['resource_creator'] as $key => $value)
			{
				if(!array_key_exists($key, $this->map['resource_creator']))
					$triage[] = $key;
			}
			foreach($triage as $creatorDelete)
			{
				foreach($sessionVars as $key => $value)
				{
					if(preg_match("/^$creatorDelete/", $key))
						$unset[] = $key;
				}
				foreach($unset as $key)
					unset($sessionVars[$key]);
			}
		}
	}
// write WKX_resource and grab lastautoID
	function writeResourceTable($sessionVars)
	{
		include_once("core/messages/LANGUAGE.php");
		$noSortArray = LANGUAGE::noSort();
		$foundNoSort = FALSE;
		$fields[] = "type";
		$values[] = $sessionVars['type'];
		foreach($noSortArray as $pattern)
		{
			if(preg_match("/^($pattern)\s(.*)/i", $sessionVars['title'], $matches))
			{
				$fields[] = "title";
				$values[] = trim($this->html->removeNl($matches[2]));
				$fields[] = "noSort";
				$values[] = trim($this->html->removeNl($matches[1]));
				$foundNoSort = TRUE;
				break;
			}
		}
		if(!$foundNoSort)
		{
			$fields[] = "title";
			$values[] = trim($this->html->removeNl($sessionVars['title']));
			$nulls[] = 'noSort';
		}
// subtitle
		if(array_key_exists('subtitle', $sessionVars))
		{
			$fields[] = "subtitle";
			$values[] = trim($this->html->removeNl($sessionVars['subtitle']));
		}
		else
			$nulls[] = "subtitle";
// URL
		if(array_key_exists('url', $sessionVars) && trim($sessionVars['url']))
		{
			$fields[] = "url";
			$values[] = trim($this->html->removeNl($sessionVars['url']));
		}
		else
			$nulls[] = "url";
// ISBN
		if(array_key_exists('isbn', $sessionVars) && trim($sessionVars['isbn']))
		{
			$fields[] = "isbn";
			$values[] = trim($this->html->removeNl($sessionVars['isbn']));
		}
		else
			$nulls[] = "isbn";
// File attachment.  If file input exists, attach it, otherwise, remove file attachment if requested.  We don't do both.
//		global $HTTP_POST_FILES;
/* Removed in 3.1
		if(isset($_FILES) && array_key_exists('resource_fileAttach', $_FILES) && 
			$_FILES['resource_fileAttach']['tmp_name'])
		{
			$existingFileName = FALSE;
			$dirName = "attachments/";
			if(array_key_exists('file', $sessionVars))
				$existingfileName = $sessionVars['file'];
			$fileName = isset($sessionVars['fileName']) ? $sessionVars['fileName'] : 
				$_FILES['resource_fileAttach']['name'];
			if(($fileName == '.') || ($fileName == '..'))
				$this->failure($this->errors->text("bibtex_file", "upload"));
// If file exists and is NOT the same as currently in the database, append a timestamp to it (before any file extension)
			if(!$dh = opendir($dirName))
				$this->failure($this->errors->text("file", "read"));
			while(FALSE !== ($file = readdir($dh)))
			{
				if(($file != $existingFileName) && ($file == $fileName))
				{
					$timestamp = time();
					$revFileName = strrev($fileName);
					$fileNameArray = explode(".", $revFileName, 2);
					if(sizeof($fileNameArray) == 2)
						$fileName = strrev($fileNameArray[0] . '.' . 
						strrev($timestamp) . '.' . $fileNameArray[1]);
					else
						$fileName .= "." . $timestamp;
					break;
				}
			}
			if(!move_uploaded_file($_FILES['resource_fileAttach']['tmp_name'], 
				$dirName . $fileName))
				$this->failure($this->errors->text("bibtex_file", "upload"));
			else if($existingFileName)
				unset($sessionVars['file']);
			$fields[] = "file";
			$values[] = trim($fileName);
// If a file already exists, unlink it
			if(array_key_exists('file', $sessionVars))
				@unlink("attachments/" . $sessionVars['file']); // ignore error in case it's been manually deleted.
		}
		else if(array_key_exists('fileRemove', $sessionVars))
		{
			@unlink("attachments/" . $sessionVars['file']); // ignore error in case it's been manually deleted.
			$nulls[] = 'file';
		}
*/
// fields 'field1' .. 'field9'
//		$fieldList = array_keys($this->map['resource']);
		$fieldList = array('field1', 'field2', 'field3', 'field4', 'field5', 
			'field6', 'field7', 'field8', 'field9');
		foreach($fieldList as $field)
		{
			if(array_key_exists($field, $sessionVars))
			{
				$fields[] = $field;
				$values[] = trim($this->html->removeNl($sessionVars[$field]));
			}
// else, updating to be set to NULL
			else
				$nulls[] = $field;
		}
		if($this->insert)
			$this->db->insert('WKX_resource', $fields, $values);
		else
		{
			foreach($fields as $field)
				$updateArray[$field] = array_shift($values);
			$this->db->update('WKX_resource', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		}
		if($this->insert)
			$this->resourceAutoId = $this->db->lastAutoId('WKX_resource');
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_resource', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
	}
// write WKX_resource_misc
	function writeMiscTable($sessionVars)
	{
		$fieldList = array_keys($this->map['resource_misc']);
		if(!$this->insert)
			$editRow = unserialize($this->session->getVar("resourceEditRow"));
		foreach($fieldList as $field)
		{
			if(array_key_exists($field, $sessionVars))
			{
				$fields[] = $field;
				$values[] = trim($this->html->removeNl($sessionVars[$field]));
			}
		}
// if in multi user mode, add this user's id
		if($this->insert && $this->userId)
		{
			$fields[] = "addUserIdResource";
			$values[] = $this->userId;
		}
		else if($this->userId)
		{
			$fields[] = "editUserIdResource";
			$values[] = $this->userId;
		}
		if($this->publisherAutoId)
		{
			$fields[] = "publisher";
			$values[] = $this->publisherAutoId;
		}
		if($this->collectionAutoId)
		{
			$fields[] = "collection";
			$values[] = $this->collectionAutoId;
		}
		if($this->confPublisherAutoId)
		{
			$fields[] = "miscField1";
			$values[] = $this->confPublisherAutoId;
		}
		array_push($fieldList, "publisher", "collection");
		if(isset($fields))
		{
			$nulls = array_diff($fieldList, $fields);
			$recordset = $this->db->select(array('WKX_resource_misc'), array('id'), 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			if($this->db->numRows($recordset)) // update/edit
			{
				foreach($fields as $field)
					$updateArray[$field] = array_shift($values);
				$this->db->update('WKX_resource_misc', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
				if($sessionVars['type'] == 'proceedings_article')
					$this->publisher->removeHangingSpecial();
				else
					$this->publisher->removeHanging();
				$this->collection->removeHanging();
			}
			else // newinsert
			{
				$fields[] = "id";
				$values[] = $this->resourceAutoId;
				$this->db->insert('WKX_resource_misc', $fields, $values);
			}
		}
		else
		{
			$recordset = $this->db->select(array('WKX_resource_misc'), array('publisher', 'collection'), 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$row = $this->db->fetchRow($recordset);
			$this->db->delete('WKX_resource_misc', 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$this->db->optimize('WKX_resource_misc');
			$this->publisher->removeHanging($row['publisher']);
			$this->collection->removeHanging($row['collection']);
			return;
		}
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_resource_misc', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
// If we're editing and this resource had a publisher but that has been removed here, need to check that that 
// publisher is still used in other resources else we remove it entirely.
		if(!$this->publisherAutoId && isset($editRow) && $editRow['publisher'])
			$this->publisher->removeHanging(stripslashes($editRow['publisher']));
		if(!$this->confPublisherAutoId && isset($editRow) && 
			array_key_exists('confPublisher', $editRow) && $editRow['confPublisher'])
			$this->publisher->removeHanging(stripslashes($editRow['confPublisher']));
// ditto for collection
		if(!$this->collectionAutoId && isset($editRow) && $editRow['collection'])
			$this->collection->removeHanging(stripslashes($editRow['collection']));
	}
// write WKX_resource_page
	function writePageTable($sessionVars)
	{
		$fieldList = array("pageStart", "pageEnd");
		foreach($fieldList as $field)
		{
			if(array_key_exists($field, $sessionVars))
			{
				$fields[] = $field;
				$values[] = trim($this->html->removeNl($sessionVars[$field]));
			}
// else, updating to be set to NULL
			else
				$nulls[] = $field;
		}
		if(isset($fields))
		{
			$recordset = $this->db->select(array('WKX_resource_page'), array('id'), 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			if($this->db->numRows($recordset))
			{
				foreach($fields as $field)
					$updateArray[$field] = array_shift($values);
				$this->db->update('WKX_resource_page', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			}
			else
			{
				$fields[] = "id";
				$values[] = $this->resourceAutoId;
				$this->db->insert('WKX_resource_page', $fields, $values);
			}
		}
		else
		{
			$this->db->delete('WKX_resource_page', 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$this->db->optimize('WKX_resource_page');
			return;
		}
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_resource_page', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
	}
// write to WKX_resource_creator
	function writeResourceCreatorTable($creatorIds)
	{
		if(!$creatorIds)
		{
			$oldIds = $this->creator->removeHangingNoRow($this->resourceId);
			$this->db->delete('WKX_resource_creator', 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$this->db->optimize('WKX_resource_creator');
			$this->creator->checkAttachedNoRow($oldIds);
			return;
		}
		foreach($creatorIds as $type => $idArray)
		{
			$fields[] = $type;
			$values[] = implode(',', $idArray);
		}
		$types = array("creator1", "creator2", "creator3", "creator4", "creator5",);
		if(isset($fields))
		{
			$nulls = array_diff($types, $fields);
// remove creator(s) if they no longer have resources attached to them
			if($this->resourceId) // '0' if new resource
				$this->creator->removeHanging($this->resourceId, $creatorIds);
			$recordset = $this->db->select(array('WKX_resource_creator'), array('id'), 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			if($this->resourceId && $this->db->numRows($recordset))
			{
				foreach($fields as $field)
					$updateArray[$field] = array_shift($values);
				$this->db->update('WKX_resource_creator', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			}
			else
			{
				$fields[] = "id";
				$values[] = $this->resourceAutoId;
				$this->db->insert('WKX_resource_creator', $fields, $values);
			}
		}
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_resource_creator', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
	}
// write to WKX_resource_abstract
	function writeAbstractTable($sessionVars)
	{
		if(!array_key_exists('abstract', $sessionVars))
		{
			if(!$this->insert)
			{
				$this->db->delete('WKX_resource_abstract', 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
				$this->db->optimize('WKX_resource_abstract');
			}
			return;
		}
		$fields[] = "abstract";
		$values[] = trim($sessionVars['abstract']);
		$recordset = $this->db->select(array('WKX_resource_abstract'), array('id'), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		if($this->db->numRows($recordset))
		{
			foreach($fields as $field)
				$updateArray[$field] = array_shift($values);
// if in multi user mode, add this user's id
			if($this->userId)
				$updateArray["editUserIdAbstract"] = $this->userId;
			$this->db->update('WKX_resource_abstract', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		}
		else
		{
			$fields[] = "id";
			$values[] = $this->resourceAutoId;
// if in multi user mode, add this user's id
			if($this->userId)
			{
				$fields[] = "addUserIdAbstract";
				$values[] = $this->userId;
			}
			$this->db->insert('WKX_resource_abstract', $fields, $values);
		}
	}
// write to WKX_resource_note
	function writeNoteTable($sessionVars)
	{
		if(!array_key_exists('note', $sessionVars))
		{
			if(!$this->insert)
			{
				$this->db->delete('WKX_resource_note', 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
				$this->db->optimize('WKX_resource_note');
			}
			return;
		}
		$fields[] = "text";
		$values[] = trim($sessionVars['note']);
		$recordset = $this->db->select(array('WKX_resource_note'), array('id'), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		if($this->db->numRows($recordset))
		{
			foreach($fields as $field)
			$updateArray[$field] = array_shift($values);
// if in multi user mode, add this user's id
			if($this->userId)
				$updateArray["editUserIdNote"] = $this->userId;
			$this->db->update('WKX_resource_note', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		}
		else
		{
			$fields[] = "id";
			$values[] = $this->resourceAutoId;
// if in multi user mode, add this user's id
			if($this->userId)
			{
				$fields[] = "addUserIdNote";
				$values[] = $this->userId;
			}
			$this->db->insert('WKX_resource_note', $fields, $values);
		}
	}
// write to WKX_resource_category
	function writeCategoryTable($sessionVars)
	{
		$fields[] = "categories";
// force to 'General' group if no group selected.
		if(!array_key_exists('group_ids', $sessionVars))
			$values[] = 1;
		else
			$values[] = trim($sessionVars['group_ids']);
		$recordset = $this->db->select(array('WKX_resource_category'), array('id'), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		if($this->db->numRows($recordset))
		{
			foreach($fields as $field)
				$updateArray[$field] = array_shift($values);
			$this->db->update('WKX_resource_category', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		}
		else
		{
			$fields[] = "id";
			$values[] = $this->resourceAutoId;
			$this->db->insert('WKX_resource_category', $fields, $values);
		}
	}
// write to WKX_resource_keyword
	function writeKeywordTable($keywordIds)
	{
		$checkKeywords = FALSE;
// Current keywords for this resource
		$recordset = $this->db->select(array('WKX_resource_keyword'), array('keywords'), 
			" WHERE " . $this->db->formatfield('id') . "=" . 
			$this->db->tidyInput($this->resourceId));
		$oldRow = $this->db->fetchRow($recordset);
		if(!$keywordIds || empty($keywordIds))
		{
			$checkKeywords = $oldRow['keywords'];
			$this->db->delete('WKX_resource_keyword', 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$this->db->optimize('WKX_resource_keyword');
			$this->keyword->removeHanging2($checkKeywords);
			return;
		}
		else if(!empty($oldRow))
			$checkKeywords = array_diff(explode(",", $oldRow['keywords']), $keywordIds);
		$fields[] = "keywords";
		$values[] = implode(',', $keywordIds);
		$recordset = $this->db->select(array('WKX_resource_keyword'), array('id'), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		if($this->db->numRows($recordset))
		{
			$updateArray['keywords'] = array_shift($values);
			$this->db->update('WKX_resource_keyword', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
		}
		else
		{
			$fields[] = "id";
			$values[] = $this->resourceAutoId;
			$this->db->insert('WKX_resource_keyword', $fields, $values);
		}
// remove keyword(s) if they no longer have resource attached to them
		if($checkKeywords)
			$this->keyword->removeHanging2(join(",", $checkKeywords));
	}
// Write to WKX_resource_year
	function writeYearTable($sessionVars)
	{
		$fieldList = array_keys($this->map['resource_year']);
		foreach($fieldList as $field)
		{
			if(array_key_exists($field, $sessionVars))
			{
				$fields[] = $field;
				$values[] = trim($this->html->removeNl($sessionVars[$field]));
			}
			else
				$nulls[] = $field;
		}
		if(isset($fields))
		{
			$recordset = $this->db->select(array('WKX_resource_year'), array('id'), 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			if($this->db->numRows($recordset))
			{
				foreach($fields as $field)
					$updateArray[$field] = array_shift($values);
				$this->db->update('WKX_resource_year', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			}
			else
			{
				$fields[] = "id";
				$values[] = $this->resourceAutoId;
				$this->db->insert('WKX_resource_year', $fields, $values);
			}
		}
		else
		{
			$this->db->delete('WKX_resource_year', 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
			$this->db->optimize('WKX_resource_year');
			return;
		}
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_resource_year', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->resourceId);
	}
// write to WKX_resource_custom
	function writeCustomTable($sessionVars)
	{
		$custom = array();
		foreach($sessionVars as $key => $value)
		{
// expect 'custom_size_id' where size is 'S' or 'L' and 'id' is the id from `WKX_custom`
			$split = split("custom_", $key);
			if(sizeof($split) == 2)
			{
				$split2 = split("_", $split[1]);
				if(sizeof($split2) != 2)
					continue;
				if($split2[0] == 'S')
					$size[] = 'custom_short';
				else
					$size[] = 'custom_long';
				$custom[$split2[1]] = trim($value);
			}
		}
		if(empty($custom) && $this->insert)
			return;
		if(!$this->insert) // Editing
		{
			$writeKeys = array_keys($custom);
			$recordset = $this->db->select(array('WKX_resource_custom'), array('customId'), 
				" WHERE " . $this->db->formatField('resourceId') . "=" . 
				$this->db->tidyInput($this->resourceAutoId));
			while($row = $this->db->loopRecordSet($recordset))
				$storedKeys[] = $row['customId'];
			if(isset($storedKeys))
			{
				$removeKeys = array_diff($storedKeys, $writeKeys);
				foreach($removeKeys as $customId)
					$this->db->delete('WKX_resource_custom', 
						" WHERE " . $this->db->formatField('customId') . "=" . $this->db->tidyInput($customId) . 
						" AND " . $this->db->formatField('resourceId') . "=" . 
						$this->db->tidyInput($this->resourceAutoId));
			}
		}
		foreach($custom as $id => $text)
		{
			$recordset = $this->db->select(array('WKX_resource_custom'), array('id'), 
				" WHERE " . $this->db->formatField('customId') . "=" . $this->db->tidyInput($id) . 
				" AND " . $this->db->formatField('resourceId') . "=" . 
				$this->db->tidyInput($this->resourceAutoId));
			if($this->db->numRows($recordset) && !$this->insert)
			{
				$updateArray = array();
				if($this->userId)
					$updateArray["editUserIdCustom"] = $this->userId;
				$field = array_shift($size);
				$updateArray[$field] = $text;
				$this->db->update("WKX_resource_custom", $updateArray, 
					" WHERE " . $this->db->formatField('customId') . "=" . $this->db->tidyInput($id) . 
					" AND " . $this->db->formatField('resourceId') . "=" . 
					$this->db->tidyInput($this->resourceAutoId));
			}
			else // INSERT
			{
				$fields = $values = array();
// if in multi user mode, add this user's id
				if($this->userId)
				{
					$fields[] = "addUserIdCustom";
					$values[] = $this->userId;
				}
				$fields[] = "customId";
				$values[] = $id;
				$fields[] = "resourceId";
				$values[] = $this->resourceAutoId;
				$fields[] = array_shift($size);
				$values[] = $text;
				$this->db->insert('WKX_resource_custom', $fields, $values);
			}
		}
	}
// Increment WKX_database_summary.totalResources
	function writeSummaryTable()
	{
		$this->db->updateSingle('WKX_database_summary', 
			$this->db->formatField('totalResources') .  "=" . 
			$this->db->formatField('totalResources') . "+" . $this->db->tidyInput(1));
	}
// Write timestamp
	function writeTimestampTable()
	{
		if($this->insert)
		{
			$fields[] = "id";
			$values[] = $this->resourceAutoId;
			$fields[] = 'timestamp';
			$values[] = $this->db->formatTimestamp();
			$this->db->insert('WKX_resource_timestamp', $fields, $values);
		}
// updating
		else
// update resource timestamp
		$this->db->update('WKX_resource_timestamp', array('timestamp' => $this->db->formatTimestamp()), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->resourceId));
	}
// Error handling.
	function failure($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $error);
	}
}
?>
