<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCEVIEW class
*
* View a single resource.
*****/
class RESOURCEVIEW
{
// Constructor
	function RESOURCEVIEW($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/resource/RESOURCEABSTRACT.php");
		$this->abstract = new RESOURCEABSTRACT($this->db, $this->vars);
		include_once("core/resource/RESOURCENOTE.php");
		$this->note = new RESOURCENOTE($this->db, $this->vars);
		include_once("core/resource/RESOURCECUSTOM.php");
		$this->custom = new RESOURCECUSTOM($this->db, $this->vars);
		include_once("core/resource/RESOURCEQUOTE.php");
		$this->quote = new RESOURCEQUOTE($this->db, $this->vars);
		include_once("core/resource/RESOURCEPARAPHRASE.php");
		$this->paraphrase = new RESOURCEPARAPHRASE($this->db, $this->vars);
		include_once("core/resource/RESOURCEMUSING.php");
		$this->musing = new RESOURCEMUSING($this->db, $this->vars);
		include_once("core/cite/CITE.php");
		$this->cite = new CITE($this->db, $this->vars);
		include_once("core/keyword/KEYWORD.php");
		$this->keyword = new KEYWORD($this->db, $this->vars);
		include_once("core/icons/LOADICONS.php");
		$this->icons = new LOADICONS();
		include_once("core/attachments/ATTACHMENTS.php");
		$this->attachments = new ATTACHMENTS($this->db, $this->vars);
	}
	function view($message = FALSE, $lastSolo = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "resources"));
		if($lastSolo)
			$this->vars['id'] = $this->session->getVar('sql_lastSolo');
		if(!array_key_exists('id', $this->vars) || !$this->vars['id'])
			$this->badInput($this->errors->text("inputError", "missing"));
		$this->session->setVar("sql_lastSolo", $this->vars['id']);
		$this->session->setVar("sql_lastView", 'solo');
		$row = $this->grabResource();
		$pString = $message ? $message : FALSE;
		$pString .= $this->showResource($row);
		$pString .= TABLE::tdEnd();
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->attachments->attachedFiles($row['resourceId'], $row['addUserIdResource']));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->showIsbn($row));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->abstract->view($row));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->showUrl($row));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->note->view($row));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->custom->view($row));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->quote->view($this->vars['id']));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->paraphrase->view($this->vars['id']));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::tdStart();
		$pString .= $this->musing->view($this->vars['id']);
// Turn on the 'add bookmark' menu item
		$this->session->setVar("bookmark_displayAdd", TRUE);
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Grab resource from database
	function grabResource()
	{
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
// fields from WKX_resource_note, WKX_resource_category, WKX_resource_keyword and WKX_abstract:
		$array = array("text", "categories", "keywords", "abstract", "addUserIdAbstract", "editUserIdAbstract",
			"addUserIdNote", "editUserIdNote",);
		$sql = $this->db->selectNoExecute(array("WKX_resource"), array_merge($stmt->listFields(), $array),
			$stmt->selectJoin());
		$sql .= " WHERE WKX_resource.id=" . $this->db->tidyInput($this->vars['id']);
		$recordset = $this->db->query($sql);
		if(!$this->db->numRows($recordset))
			$this->badInput($this->messages->text("resources", "noResult"));
		return $this->db->fetchRow($recordset);
	}
// display bibliographic entry
	function showResource($row)
	{
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "html");
		$this->icons->getIconInfo('edit');
		$editLink = $this->icons->editExists ? "imgLink" : "link";
		$this->icons->getIconInfo('delete');
		$deleteLink = $this->icons->editExists ? "imgLink" : "link";
		$edit = $delete = FALSE;
		if($this->session->getVar('setup_write'))
			$edit = MISC::a($editLink, "&nbsp;" . $this->icons->edit .
				"&nbsp;", "index.php?action=resourceEdit" . htmlentities("&id=" . $row['resourceId']));
		if($this->session->getVar('setup_superadmin'))
			$delete = MISC::a($deleteLink, "&nbsp;" . $this->icons->delete .
			"&nbsp;", "index.php?action=deleteResourceConfirm" . 
			htmlentities("&resource_id=" . $row['resourceId']));
		if(array_key_exists("search", $this->vars) && $this->vars["search"] = 'highlight')
		{
			$searchTerms = explode(",", $this->session->getVar('search_highlight'));
			foreach($searchTerms as $term)
				$patterns[] = "/($term)/i";
			$pString = $this->previousNextLinks($row['resourceId'], TRUE);
			$bibStyle->bibformat->patterns = $patterns;
		}
		else
			$pString = $this->previousNextLinks($row['resourceId'], FALSE);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::span($this->messages->text("resourceType", $row['type']) . ":"), "hint");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
// Encapsulating table from template
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		include_once("core/user/USER.php");
		$user = new USER($this->db);
		$userAddEdit = $user->displayUserAddEdit($row['addUserIdResource'], $row['editUserIdResource']);
		$pString .= TABLE::td($bibStyle->process($row) . $userAddEdit, "alternate1");
		$pString .= TABLE::td($edit . $delete, "alternate1", "right", "top");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
// If this resource has keywords, show them
		if($row['keywords'])
			$pString .= $this->showKeywords($row);
// See if this resource has citations or is cited itself
		$pString .= $this->cite->showCitations($row['resourceId']);
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . "&nbsp;" . MISC::br();
		return $pString;
	}
// Show previous and next resource hyperlinks
	function previousNextLinks($thisId, $highlight)
	{
		if(($raw = $this->session->getVar("list_allIds")) === FALSE)
			return FALSE;
// Search highlighting in force?
		$highlight = $highlight ? htmlentities("&search=highlight") : FALSE;
// type of CSS class required.
		$this->icons->getIconInfo("next");
		$this->icons->getIconInfo("previous");
		$nextClass = $this->icons->nextExists ? "imgLink" : "link";
		$previousClass = $this->icons->previousExists ? "imgLink" : "link";
		$allIds = unserialize(base64_decode($raw));
		$thisKey = array_search($thisId, $allIds);
		if($thisKey)
			$tdLeft = MISC::a($previousClass, $this->icons->previous, "index.php?action=resourceView" .
				htmlentities("&id=" . $allIds[$thisKey - 1]) . $highlight);
		else
			$tdLeft = "&nbsp;";
		if($thisKey < (sizeof($allIds) - 1))
			$tdRight = MISC::a($nextClass, $this->icons->next, "index.php?action=resourceView" .
				htmlentities("&id=" . $allIds[$thisKey + 1]) . $highlight);
		else
			$tdRight = "&nbsp;";
		$pString = TABLE::tableStart(FALSE, 0, 10, 0, "center", 0);
		$pString .= TABLE::trStart();
		$pString .= TABLE::TD($tdLeft, FALSE, "right");
		$pString .= TABLE::td($tdRight, FALSE, "left");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		return $pString;
	}
// Show resource keywords
	function showKeywords($row)
	{
		$pString = FALSE;
// First show the keywords
		foreach(split(",", $row['keywords']) as $key => $value)
			$keywords[] = "'$value'";
		$condition = $this->db->formatField('id') . "=" . join(" OR " .
			$this->db->formatField('id') . "=", $keywords);
		$recordset = $this->db->select(array('WKX_keyword'), array("id", "keyword"), " WHERE " . $condition);
		while($line = $this->db->loopRecordSet($recordset))
			$keywordArray[$line['id']] = $line['keyword'];
		$title = $this->messages->text("resources", "keywords");
		if(isset($keywordArray))
		{
			foreach($keywordArray as $keywordId => $keyword)
				$newArray[] = $this->keyword->getKeywordLink($row['resourceId'],
					$keywordId, $keyword);
			$pString = TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::span($title . ": " .
				join(", ", $newArray), "small"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
		}
		return $pString;
	}
// Show ISBN or other identifier
	function showIsbn($row)
	{
		if(!$row['isbn'])
			return FALSE;
		$pString = $this->messages->text("resources", "isbn");
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->html->dbToHtmlTidy($row['isbn']), "alternate1");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
// If resource is not web_article, display any URL given
	function showUrl($row)
	{
		if(($row['type'] == 'web_article') || !$row['url'])
			return FALSE;
		$pString = $this->messages->text("viewResource", "url");
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::a("link", $this->html->dbToHtmlTidy($row['url']),
			$this->html->dbToHtmlTidy($row['url']), "_new"), "alternate1");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>