<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCEPARAPHRASE class
*
* Deal with resource's paraphrases
*****/
class RESOURCEPARAPHRASE
{
// Constructor
	function RESOURCEPARAPHRASE($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/resource/TEXTQP.php");
		$this->textqp = new TEXTQP($db, $vars);
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
	}
// Display resource's paraphrases
	function view($resourceId)
	{
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		$icons->getIconInfo("add");
		$addLink = $icons->addExists ? "imgLink" : "link";
		$pString = MISC::b($this->messages->text("viewResource", "paraphrases"));
		$write = $this->session->getVar('setup_write') ? TRUE : FALSE;
		$pString .= $write ? " " . MISC::a($addLink, $icons->add, 
			"index.php?action=paraphraseEdit" . htmlentities("&resourceId=" . $resourceId)) 
			:
			FALSE;
		$recordset = $this->db->select(array('WKX_resource_paraphrase', 'WKX_resource_paraphrase_text'), 
			array(array('WKX_resource_paraphrase.id' => 'paraphraseId'), 'page_start', 'page_end', 'text', 
			'paragraph', 'section', 'chapter', 'addUserIdParaphrase',), 
			" WHERE " . $this->db->formatField('WKX_resource_paraphrase.resourceId') . '=' . 
			$this->db->tidyInput($resourceId) . 
			" AND " . $this->db->formatField('WKX_resource_paraphrase.id') . '=' . 
			$this->db->formatField('WKX_resource_paraphrase_text.id') .  
			" ORDER BY " . $this->db->tidyInputClause('page_start'));
		if(!$this->db->numRows($recordset))
			return $pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $this->textqp->view($pString, $resourceId, $recordset, 'paraphrase');
	}
// display the editing form:
	function editDisplay()
	{
		$this->checkInput();
		$this->template->setVar('heading', $this->messages->text("heading", "paraphrases"));
		$pString = $this->textqp->editdisplay('paraphrase');
		$this->template->setVar('formStart', FORM::formHeader("paraphraseEdit"));
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
// write to the database.
// if there is no 'paraphraseId' input, we are adding a new resource.  Otherwise, editing one.
	function edit()
	{
		if($this->session->getVar('resourceParaphraseLock'))
			$this->badInput($this->errors->text("done", "paraphrase"));
		$this->checkInput();
		if(!$addEdit = $this->textqp->edit('paraphrase'))
			$this->badInput($this->errors->text("inputError", "missing"));
// update resource timestamp
		$this->db->update('WKX_resource_timestamp', array('timestamp' => $this->db->formatTimestamp()), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['resourceId']));
// lock reload
		$this->session->setVar('resourceParaphraseLock', TRUE);
// send back to view this resource with success message
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($this->success->text("paraphrases", " " . 
			$this->messages->text("misc", $addEdit) . " "), 'lastSolo'));
	}
// Check we have appropriate input.  Page and comment are optional
	function checkInput()
	{
		if(!array_key_exists('resourceId', $this->vars) || !$this->vars['resourceId'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view a resource.
	function badInput($error)
	{
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($error, 'lastSolo'));
	}
}
?>
