<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCENEW class
*
* Enter new resources
*****/
class RESOURCENEW
{
// Constructor
	function RESOURCENEW($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/TABLE.php");
		include_once("core/html/FORM.php");
		include_once("core/resource/RESOURCEFORM.php");
		$this->form = new RESOURCEFORM($this->db, $this->vars);
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// create a new resource.  if vars['method'] is not set, we are starting from scratch
	function resource($message = FALSE)
	{
		include_once("core/resource/VALIDATEINPUT.php");
		$this->validate = new VALIDATEINPUT($this->db, $this->vars, $this);
		$this->template->setVar('heading', $this->messages->text("heading", "newResource"));
		$this->template->setVar('formStart', FORM::formHeader("resourceNew"));
		$pString = $message ? $message : FALSE;
// Some resource types have no creators so need to skip to stage4
		if(isset($this->vars['method']) && ($this->vars['method'] == 'stage2') 
			&& (($this->vars['resource_type'] == 'bill') || ($this->vars['resource_type'] == 'hearing') ||
			($this->vars['resource_type'] == 'statute') || ($this->vars['resource_type'] == 'proceedings')))
			$this->vars['method'] = 'stage4';
		if(!isset($this->vars['method']))
		{
// clear the session but keep resource_type
			$type = $this->session->getVar('resource_type');
			$this->session->clearArray('resource');
			if($type)
				$this->session->setVar('resource_type', $type);
			$pString .= MISC::p($this->messages->text("resources", "new"));
			$pString .= $this->form->stage1();
		}
		else if($this->vars['method'] == 'stage2')
		{
			$sessionVars = $this->validate->stage1();
			$pString .= $this->form->stage2($sessionVars);
		}
		else if($this->vars['method'] == 'stage3')
		{
			$sessionVars = $this->validate->stage2();
// No contributors, skip to stage4
			if(!$pString .= $this->form->stage3($sessionVars))
				$pString .= $this->form->stage4($sessionVars);
		}
		else if($this->vars['method'] == 'stage4')
		{
			$sessionVars = $this->validate->stage3();
			$pString .= $this->form->stage4($sessionVars);
		}
// Final
		else if($this->vars['method'] == 'stage5')
		{
// override previous default setting
			if($this->session->getVar("setup_fileAttach"))
				$this->template->setVar('formStart', FORM::formMultiHeader("resourceWrite"));
			else
				$this->template->setVar('formStart', FORM::formHeader("resourceWrite"));
			$sessionVars = $this->validate->stage4();
			$pString .= $this->form->stage5($sessionVars);
		}
		else
		{
			unset($this->vars['method']);
			$this->badInput($this->errors->text("inputError", "invalid"));
		}
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
}
?>
