<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Resource Map class.
*	Provides mappings between resource types and the database tables where there is no
*	specifically named table field. The values are the form input key names.
*
*	$Header: /cvsroot/wikindx/wikindx3/core/resource/RESOURCEMAP.php,v 1.24 2005/06/22 22:39:30 sirfragalot Exp $
*****/
class RESOURCEMAP
{
/*
* Constructor
*
* @author Mark Grimshaw
* @version 1
*/
	function RESOURCEMAP()
	{
		$this->loadMap();
	}
/*
* Create arrays based on database table and resource type.
* The key of the resource_xxx arrays is the database field within the WKX_resource_xxx database table.
* The value of the resource_xxx arrays is the key input to the MESSAGES class for languge localizations.
* The extra array element 'possible' contains all the possible input fields for FORM input and is used in 
* RESOURCEEDIT when loading data from the database into session variables.
* Array element 'stage4' lists required fields for this type (other than creator fields and noSort, title, 
* subtitle) used when validating stage4 input in VALIDATEINPUT.
*
* The database matrix can be found in docs/resourceDatabaseMatrix.html
*
* @author Mark Grimshaw
* @version 1
*/
	function loadMap()
	{
// WIKINDX resource types and user-displayed description.  The value is the key of the MESSAGES.php resourceType array.
// The order given here is the order displayed in form select boxes.
		$this->types = array('book', 'book_article', 'journal_article', 'newspaper_article', 'magazine_article', 
			'proceedings', 'conference_paper', 'proceedings_article', 'thesis', 'web_article', 
			'film', 'broadcast', 'music_album', 'music_track', 'music_score', 
			'artwork', 'software', 'audiovisual', 'database', 'government_report', 'report', 'hearing', 
			'statute', 'legal_ruling', 'case', 'bill', 'patent', 'personal', 'unpublished', 
			'classical', 'manuscript', 'map', 'chart', 'miscellaneous',);
// Book resource type
		$this->book = array(
				'resource'	=>	array(
					'field1'	=>	'seriesTitle',
					'field2'	=>	'edition',
					'field3'	=>	'seriesNumber',
					'field4'	=>	'bookVolumeNumber',
				),
				'resource_misc'	=>	array(
					'miscField4'	=>	'numberOfVolumes',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year2'		=>	'reprintYear',
					'year3'		=>	'volumeYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'editor',
					'creator3'	=>	'translator',
					'creator4'	=>	'reviser',
					'creator5'	=>	'seriesEditor',
				),
			);
		$this->book['possible'] = array_keys($this->book['resource']);
		$this->book['possible'] = array_merge($this->book['possible'], 
			array_keys($this->book['resource_misc']));
		$this->book['possible'] = array_merge($this->book['possible'], 
			array_keys($this->book['resource_year']));
		$this->book['possible'] = array_merge($this->book['possible'], array("url", "isbn", "publisherName", 
			"publisherLocation", "abstract", "note",));
		$this->book['stage4'] = array(); // nothing required here except empty array
// book article/chapter resource type
		$this->book_article = $this->book;
		$this->book_article['possible'] = array_merge($this->book_article['possible'], 
			array("collection", "pageStart", "pageEnd",));
		$this->book_article['stage4']['collection'] = 'collectionTitle';
// Journal article resource type
		$this->journal_article = array(
				'resource'	=>	array(
					'field1'	=>	'journalVolumeNumber',
					'field2'	=>	'journalIssueNumber',
				),
				'resource_misc'	=>	array(
					'miscField3'	=>	'month',
					'miscField6'	=>	'endMonth',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year3'		=>	'endPublicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->journal_article['possible'] = array_keys($this->journal_article['resource']);
		$this->journal_article['possible'] = array_merge($this->journal_article['possible'], 
			array_keys($this->journal_article['resource_misc']));
		$this->journal_article['possible'] = array_merge($this->journal_article['possible'], 
			array_keys($this->journal_article['resource_year']));
		$this->journal_article['possible'] = array_merge($this->journal_article['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "pageStart", "pageEnd",));
		$this->journal_article['stage4']['collection'] = 'collectionTitle';
// Newspaper article type
		$this->newspaper_article = array(
				'resource'	=>	array(
					'field1'	=>	'section',
					'field2'	=>	'city',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->newspaper_article['possible'] = array_keys($this->newspaper_article['resource']);
		$this->newspaper_article['possible'] = array_merge($this->newspaper_article['possible'], 
			array_keys($this->newspaper_article['resource_misc']));
		$this->newspaper_article['possible'] = array_merge($this->newspaper_article['possible'], 
			array_keys($this->newspaper_article['resource_year']));
		$this->newspaper_article['possible'] = array_merge($this->newspaper_article['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "pageStart", "pageEnd",));
		$this->newspaper_article['stage4']['collection'] = 'collectionTitle';
// proceedings article
// NB - for this type, publisherName and publisherLocation are the conference organise and the conference location
		$this->proceedings_article = array(
				'resource'	=>	array(
					'field1'	=>	'seriesTitle',
					'field3'	=>	'seriesNumber',
				),
				'resource_misc'	=>	array(
//					'miscField1'	=>	'publisher',
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					'miscField5'	=>	'endDay',
					'miscField6'	=>	'endMonth',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year2'		=>	'year',
					'year3'		=>	'endPublicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'editor',
				),
			);
		$this->proceedings_article['possible'] = array_keys($this->proceedings_article['resource']);
		$this->proceedings_article['possible'] = array_merge($this->proceedings_article['possible'], 
			array_keys($this->proceedings_article['resource_misc']));
		$this->proceedings_article['possible'] = array_merge($this->proceedings_article['possible'], 
			array_keys($this->proceedings_article['resource_year']));
		$this->proceedings_article['possible'] = array_merge($this->proceedings_article['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "publisherName", 
			"publisherLocation", "pageStart", "pageEnd",));
		$this->proceedings_article['stage4']['collection'] = 'collectionTitle';
// Web article resource type
		$this->web_article = array(
				'resource'	=>	array(
					'field1'	=>	'journalVolumeNumber',
					'field2'	=>	'journalIssueNumber',
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year2'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->web_article['possible'] = array_keys($this->web_article['resource']);
		$this->web_article['possible'] = array_merge($this->web_article['possible'], 
			array_keys($this->web_article['resource_misc']));
		$this->web_article['possible'] = array_merge($this->web_article['possible'], 
			array_keys($this->web_article['resource_year']));
		$this->web_article['possible'] = array_merge($this->web_article['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "year_accessed", 
			"pageStart", "pageEnd",));
		$this->web_article['stage4'] = array();  // empty array required
// Thesis resource type
		$this->thesis = array(
				'resource'	=>	array(
					'field1'	=>	'thesisLabel',
					'field2'	=>	'thesis',
					'field3'	=>	'journalVolumeNumber',
					'field4'	=>	'journalIssueNumber',
					'field5'	=>	'department',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'thesisYear',
					'year2'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->thesis['possible'] = array_keys($this->thesis['resource']);
		$this->thesis['possible'] = array_merge($this->thesis['possible'], 
			array_keys($this->thesis['resource_misc']));
		$this->thesis['possible'] = array_merge($this->thesis['possible'], 
			array_keys($this->thesis['resource_year']));
		$this->thesis['possible'] = array_merge($this->thesis['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "publisherName", "publisherLocation", 
			"pageStart", "pageEnd",));
		$this->thesis['stage4'] = array();  // empty array required
// Film resource type
		$this->film = array(
				'resource'	=>	array(
					'field1'	=>	'country',
					),
				'resource_misc'	=>	array(
					'miscField1'	=>	'minutes',
					'miscField4'	=>	'hours',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'director',
					'creator2'	=>	'producer',
				),
			);
		$this->film['possible'] = array_keys($this->film['resource']);
		$this->film['possible'] = array_merge($this->film['possible'], 
			array_keys($this->film['resource_misc']));
		$this->film['possible'] = array_merge($this->film['possible'], 
			array_keys($this->film['resource_year']));
		$this->film['possible'] = array_merge($this->film['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName",));
		$this->film['stage4'] = array();  // empty array required
// Broadcast resource type
		$this->broadcast = array(
				'resource'	=>	array(  // empty array required
					),
				'resource_misc'	=>	array(
					'miscField1'	=>	'minutes',
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					'miscField4'	=>	'hours',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'director',
					'creator2'	=>	'producer',
				),
			);
		$this->broadcast['possible'] = array_keys($this->broadcast['resource']);
		$this->broadcast['possible'] = array_merge($this->broadcast['possible'], 
			array_keys($this->broadcast['resource_misc']));
		$this->broadcast['possible'] = array_merge($this->broadcast['possible'], 
			array_keys($this->broadcast['resource_year']));
		$this->broadcast['possible'] = array_merge($this->broadcast['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->broadcast['stage4'] = array();  // empty array required
// Software resource type
		$this->software = array(
				'resource'	=>	array(
					'field2'	=>	'typeOfSoftware',
					'field4'	=>	'version',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->software['possible'] = array_keys($this->software['resource']);
		$this->software['possible'] = array_merge($this->software['possible'], 
			array_keys($this->software['resource_misc']));
		$this->software['possible'] = array_merge($this->software['possible'], 
			array_keys($this->software['resource_year']));
		$this->software['possible'] = array_merge($this->software['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", ));
		$this->software['stage4'] = array();  // empty array required
// Artwork resource type
		$this->artwork = array(
				'resource'	=>	array(
					'field2'	=>	'medium',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'artist',
				),
			);
		$this->artwork['possible'] = array_keys($this->artwork['resource']);
		$this->artwork['possible'] = array_merge($this->artwork['possible'], 
			array_keys($this->artwork['resource_misc']));
		$this->artwork['possible'] = array_merge($this->artwork['possible'], 
			array_keys($this->artwork['resource_year']));
		$this->artwork['possible'] = array_merge($this->artwork['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", ));
		$this->artwork['stage4'] = array();  // empty array required
// Miscellaneous resource type
		$this->miscellaneous = array(
				'resource'	=>	array(
					'field2'	=>	'medium',
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->miscellaneous['possible'] = array_keys($this->miscellaneous['resource']);
		$this->miscellaneous['possible'] = array_merge($this->miscellaneous['possible'], 
			array_keys($this->miscellaneous['resource_misc']));
		$this->miscellaneous['possible'] = array_merge($this->miscellaneous['possible'], 
			array_keys($this->miscellaneous['resource_year']));
		$this->miscellaneous['possible'] = array_merge($this->miscellaneous['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", ));
		$this->miscellaneous['stage4'] = array();  // empty array required
// Audiovisual resource type
		$this->audiovisual = array(
				'resource'	=>	array(
					'field1'	=>	'seriesTitle',
					'field2'	=>	'medium',
					'field3'	=>	'edition',
					'field4'	=>	'seriesNumber',
					'field5'	=>	'bookVolumeNumber',
				),
				'resource_misc'	=>	array(
					'miscField4'	=>	'numberOfVolumes',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year3'		=>	'volumeYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'performer',
					'creator5'	=>	'seriesEditor',
				),
			);
		$this->audiovisual['possible'] = array_keys($this->audiovisual['resource']);
		$this->audiovisual['possible'] = array_merge($this->audiovisual['possible'], 
			array_keys($this->audiovisual['resource_misc']));
		$this->audiovisual['possible'] = array_merge($this->audiovisual['possible'], 
			array_keys($this->audiovisual['resource_year']));
		$this->audiovisual['possible'] = array_merge($this->audiovisual['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", ));
		$this->audiovisual['stage4'] = array();  // empty array required
// case resource type
		$this->case = array(
				'resource'	=>	array(
					'field1'	=>	'reporter',
					'field4'	=>	'reporterVolume',
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator3'	=>	'counsel',
				),
			);
		$this->case['possible'] = array_keys($this->case['resource']);
		$this->case['possible'] = array_merge($this->case['possible'], 
			array_keys($this->case['resource_misc']));
		$this->case['possible'] = array_merge($this->case['possible'], 
			array_keys($this->case['resource_year']));
		$this->case['possible'] = array_merge($this->case['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "pageStart", "pageEnd", ));
		$this->case['stage4'] = array();  // empty array required
// bill resource type
		$this->bill = array(
				'resource'	=>	array(
					'field1'	=>	'section',
					'field2'	=>	'code',
					'field3'	=>	'codeVolume',
					'field4'	=>	'session',
					'field5'	=>	'billNumber',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'sessionYear',
				),
				'resource_creator' =>	array( // we require an empty array to still be present
				),
			);
		$this->bill['possible'] = array_keys($this->bill['resource']);
		$this->bill['possible'] = array_merge($this->bill['possible'], 
			array_keys($this->bill['resource_misc']));
		$this->bill['possible'] = array_merge($this->bill['possible'], 
			array_keys($this->bill['resource_year']));
		$this->bill['possible'] = array_merge($this->bill['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", 
			"pageStart", "pageEnd", ));
		$this->bill['stage4'] = array();  // empty array required
// classical resource type
		$this->classical = array(
				'resource'	=>	array(
					'field4'	=>	'volume',
					),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'		=>	'attributedTo',
				),
			);
		$this->classical['possible'] = array_keys($this->classical['resource']);
		$this->classical['possible'] = array_merge($this->classical['possible'], 
			array_keys($this->classical['resource_misc']));
		$this->classical['possible'] = array_merge($this->classical['possible'], 
			array_keys($this->classical['resource_year']));
		$this->classical['possible'] = array_merge($this->classical['possible'], 
			array("url", "isbn", "abstract", "note",));
		$this->classical['stage4'] = array();  // empty array required
// Conference Paper resource type
		$this->conference_paper = array(
				'resource'	=>	array( // we require an empty array to still be present
				),
				'resource_misc'	=>	array( // we require an empty array to still be present
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->conference_paper['possible'] = array_keys($this->conference_paper['resource']);
		$this->conference_paper['possible'] = array_merge($this->conference_paper['possible'], 
			array_keys($this->conference_paper['resource_misc']));
		$this->conference_paper['possible'] = array_merge($this->conference_paper['possible'], 
			array_keys($this->conference_paper['resource_year']));
		$this->conference_paper['possible'] = array_merge($this->conference_paper['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->conference_paper['stage4'] = array();  // empty array required
// Legal Rule/Regulation resource type
		$this->legal_ruling = array(
				'resource'	=>	array(
					'field1'	=>	'section',
					'field2'	=>	'ruleType',
					'field3'	=>	'edition',
					'field4'	=>	'ruleNumber',
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->legal_ruling['possible'] = array_keys($this->legal_ruling['resource']);
		$this->legal_ruling['possible'] = array_merge($this->legal_ruling['possible'], 
			array_keys($this->legal_ruling['resource_misc']));
		$this->legal_ruling['possible'] = array_merge($this->legal_ruling['possible'], 
			array_keys($this->legal_ruling['resource_year']));
		$this->legal_ruling['possible'] = array_merge($this->legal_ruling['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName",  "publisherLocation", 
			"pageStart", "pageEnd",));
		$this->legal_ruling['stage4'] = array();  // empty array required
// Government Report/Documentation resource type
		$this->government_report = array(
				'resource'	=>	array(
					'field1'	=>	'section',
					'field2'	=>	'department',
					'field3'	=>	'edition',
					'field4'	=>	'volume',
					'field5'	=>	'issueNumber',
					),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->government_report['possible'] = array_keys($this->government_report['resource']);
		$this->government_report['possible'] = array_merge($this->government_report['possible'], 
			array_keys($this->government_report['resource_misc']));
		$this->government_report['possible'] = array_merge($this->government_report['possible'], 
			array_keys($this->government_report['resource_year']));
		$this->government_report['possible'] = array_merge($this->government_report['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "pageStart", "pageEnd",));
		$this->government_report['stage4'] = array();  // empty array required
// Report/Documentation resource type
		$this->report = array(
				'resource'	=>	array(
					'field1'	=>	'seriesTitle',
					'field2'	=>	'typeOfReport',
					'field5'	=>	'issueNumber',
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->report['possible'] = array_keys($this->report['resource']);
		$this->report['possible'] = array_merge($this->report['possible'], 
			array_keys($this->report['resource_misc']));
		$this->report['possible'] = array_merge($this->report['possible'], 
			array_keys($this->report['resource_year']));
		$this->report['possible'] = array_merge($this->report['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", 
			"pageStart", "pageEnd",));
		$this->report['stage4'] = array();  // empty array required
// Hearing resource type
		$this->hearing = array(
				'resource'	=>	array(
					'field1'	=>	'committee',
					'field2'	=>	'legislativeBody',
					'field3'	=>	'session',
					'field4'	=>	'documentNumber',
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					'miscField4'	=>	'numberOfVolumes',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(  // empty array required
				),
			);
		$this->hearing['possible'] = array_keys($this->hearing['resource']);
		$this->hearing['possible'] = array_merge($this->hearing['possible'], 
			array_keys($this->hearing['resource_misc']));
		$this->hearing['possible'] = array_merge($this->hearing['possible'], 
			array_keys($this->hearing['resource_year']));
		$this->hearing['possible'] = array_merge($this->hearing['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", 
			"pageStart", "pageEnd",));
		$this->hearing['stage4'] = array();  // empty array required
// Online database resource type
		$this->database = array(
				'resource'	=>	array(  // empty array required
					),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year2'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->database['possible'] = array_keys($this->database['resource']);
		$this->database['possible'] = array_merge($this->database['possible'], 
			array_keys($this->database['resource_misc']));
		$this->database['possible'] = array_merge($this->database['possible'], 
			array_keys($this->database['resource_year']));
		$this->database['possible'] = array_merge($this->database['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->database['stage4'] = array();  // empty array required
// Magazine article type
		$this->magazine_article = array(
				'resource'	=>	array(
					'field2'	=>	'typeOfArticle',
					'field4'	=>	'volume',
					'field3'	=>	'issueNumber',
					'field1'	=>	'edition',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					'miscField5'	=>	'endDay',
					'miscField6'	=>	'endMonth',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year3'		=>	'endPublicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->magazine_article['possible'] = array_keys($this->magazine_article['resource']);
		$this->magazine_article['possible'] = array_merge($this->magazine_article['possible'], 
			array_keys($this->magazine_article['resource_misc']));
		$this->magazine_article['possible'] = array_merge($this->magazine_article['possible'], 
			array_keys($this->magazine_article['resource_year']));
		$this->magazine_article['possible'] = array_merge($this->magazine_article['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "pageStart", "pageEnd",));
		$this->magazine_article['stage4']['collection'] = 'collectionTitle';
// Manuscript type
		$this->manuscript = array(
				'resource'	=>	array(
					'field2'	=>	'typeOfManuscript',
					'field3'	=>	'manuscriptNumber',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->manuscript['possible'] = array_keys($this->manuscript['resource']);
		$this->manuscript['possible'] = array_merge($this->manuscript['possible'], 
			array_keys($this->manuscript['resource_misc']));
		$this->manuscript['possible'] = array_merge($this->manuscript['possible'], 
			array_keys($this->manuscript['resource_year']));
		$this->manuscript['possible'] = array_merge($this->manuscript['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "pageStart", "pageEnd",));
		$this->manuscript['stage4']['collection'] = 'collectionTitle';
// Map type
		$this->map = array(
				'resource'	=>	array(
					'field1'	=>	'seriesTitle',
					'field2'	=>	'typeOfMap',
					'field3'	=>	'edition',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'cartographer',
					'creator5'	=>	'seriesEditor',
				),
			);
		$this->map['possible'] = array_keys($this->map['resource']);
		$this->map['possible'] = array_merge($this->map['possible'], 
			array_keys($this->map['resource_misc']));
		$this->map['possible'] = array_merge($this->map['possible'], 
			array_keys($this->map['resource_year']));
		$this->map['possible'] = array_merge($this->map['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->map['stage4'] = array();  // empty array required
// Chart type
		$this->chart = array(
				'resource'	=>	array(
					'field1'	=>	'nameOfFile',
					'field2'	=>	'imageProgram',
					'field3'	=>	'imageSize',
					'field4'	=>	'imageType',
					'field5'	=>	'version',
					'field6'	=>	'number',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'creator',
				),
			);
		$this->chart['possible'] = array_keys($this->chart['resource']);
		$this->chart['possible'] = array_merge($this->chart['possible'], 
			array_keys($this->chart['resource_misc']));
		$this->chart['possible'] = array_merge($this->chart['possible'], 
			array_keys($this->chart['resource_year']));
		$this->chart['possible'] = array_merge($this->chart['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->chart['stage4'] = array();  // empty array required
// Statute type
		$this->statute = array(
				'resource'	=>	array(
					'field1'	=>	'publicLawNumber',
					'field2'	=>	'code',
					'field3'	=>	'session',
					'field4'	=>	'section',
					'field5'	=>	'codeNumber',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(  // empty array required
				),
			);
		$this->statute['possible'] = array_keys($this->statute['resource']);
		$this->statute['possible'] = array_merge($this->statute['possible'], 
			array_keys($this->statute['resource_misc']));
		$this->statute['possible'] = array_merge($this->statute['possible'], 
			array_keys($this->statute['resource_year']));
		$this->statute['possible'] = array_merge($this->statute['possible'], 
			array("url", "isbn", "abstract", "note", "pageStart", "pageEnd",));
		$this->statute['stage4'] = array();  // empty array required
// Patent type
		$this->patent = array(
				'resource'	=>	array(
					'field1'	=>	'publishedSource',
					'field2'	=>	'patentVersionNumber',
					'field3'	=>	'applicationNumber',
					'field4'	=>	'patentType',
					'field5'	=>	'intPatentNumber',
					'field6'	=>	'intPatentTitle',
					'field7'	=>	'intPatentClassification',
					'field8'	=>	'patentNumber',
					'field9'	=>	'legalStatus',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'inventor',
					'creator2'	=>	'issuingOrganisation',
					'creator3'	=>	'agent',
					'creator4'	=>	'intAuthor',
				),
			);
		$this->patent['possible'] = array_keys($this->patent['resource']);
		$this->patent['possible'] = array_merge($this->patent['possible'], 
			array_keys($this->patent['resource_misc']));
		$this->patent['possible'] = array_merge($this->patent['possible'], 
			array_keys($this->patent['resource_year']));
		$this->patent['possible'] = array_merge($this->patent['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation",));
		$this->patent['stage4'] = array();  // empty array required
// Personal Communication type
		$this->personal = array(
				'resource'	=>	array(
					'field2'	=>	'typeOfCommunication',
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
					'creator2'	=>	'recipient',
				),
			);
		$this->personal['possible'] = array_keys($this->personal['resource']);
		$this->personal['possible'] = array_merge($this->personal['possible'], 
			array_keys($this->personal['resource_misc']));
		$this->personal['possible'] = array_merge($this->personal['possible'], 
			array_keys($this->personal['resource_year']));
		$this->personal['possible'] = array_merge($this->personal['possible'], 
			array("url", "isbn", "abstract", "note",));
		$this->personal['stage4'] = array();  // empty array required
// Unpublished type
		$this->unpublished = array(
				'resource'	=>	array(
					'field2'	=>	'typeOfWork',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'year',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'author',
				),
			);
		$this->unpublished['possible'] = array_keys($this->unpublished['resource']);
		$this->unpublished['possible'] = array_merge($this->unpublished['possible'], 
			array_keys($this->unpublished['resource_misc']));
		$this->unpublished['possible'] = array_merge($this->unpublished['possible'], 
			array_keys($this->unpublished['resource_year']));
		$this->unpublished['possible'] = array_merge($this->unpublished['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation", 
			"pageStart", "pageEnd",));
		$this->unpublished['stage4'] = array();  // empty array required
// proceedings (complete set)
		$this->proceedings = array(
				'resource'	=>	array( // we require an empty array to still be present
				),
				'resource_misc'	=>	array(
					'miscField2'	=>	'day',
					'miscField3'	=>	'month',
					'miscField5'	=>	'endDay',
					'miscField6'	=>	'endMonth',
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
					'year2'		=>	'year',
					'year3'		=>	'endPublicationYear',
				),
				'resource_creator' =>	array(
				),
			);
		$this->proceedings['possible'] = array_keys($this->proceedings['resource']);
		$this->proceedings['possible'] = array_merge($this->proceedings['possible'], 
			array_keys($this->proceedings['resource_misc']));
		$this->proceedings['possible'] = array_merge($this->proceedings['possible'], 
			array_keys($this->proceedings['resource_year']));
		$this->proceedings['possible'] = array_merge($this->proceedings['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "publisherName", "publisherLocation",));
		$this->proceedings['stage4'] = array();  // empty array required
// Music Album type
		$this->music_album = array(
				'resource'	=>	array(
					'field2'	=>	'medium',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'performer',
					'creator2'	=>	'composer',
					'creator3'	=>	'conductor',
				),
			);
		$this->music_album['possible'] = array_keys($this->music_album['resource']);
		$this->music_album['possible'] = array_merge($this->music_album['possible'], 
			array_keys($this->music_album['resource_misc']));
		$this->music_album['possible'] = array_merge($this->music_album['possible'], 
			array_keys($this->music_album['resource_year']));
		$this->music_album['possible'] = array_merge($this->music_album['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName",));
		$this->music_album['stage4'] = array();  // empty array required
// Music Track type
		$this->music_track = array(
				'resource'	=>	array(
					'field2'	=>	'medium',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'performer',
					'creator2'	=>	'composer',
					'creator3'	=>	'conductor',
				),
			);
		$this->music_track['possible'] = array_keys($this->music_track['resource']);
		$this->music_track['possible'] = array_merge($this->music_track['possible'], 
			array_keys($this->music_track['resource_misc']));
		$this->music_track['possible'] = array_merge($this->music_track['possible'], 
			array_keys($this->music_track['resource_year']));
		$this->music_track['possible'] = array_merge($this->music_track['possible'], 
			array("url", "isbn", "collection", "abstract", "note", "publisherName",));
		$this->music_track['stage4']['collection'] = 'collectionTitle';
// Music Score type
		$this->music_score = array(
				'resource'	=>	array(
					'field3'	=>	'edition',
				),
				'resource_misc'	=>	array(  // empty array required
					),
				'resource_year'	=>	array(
					'year1'		=>	'publicationYear',
				),
				'resource_creator' =>	array(
					'creator1'	=>	'composer',
					'creator2'	=>	'editor',
				),
			);
		$this->music_score['possible'] = array_keys($this->music_score['resource']);
		$this->music_score['possible'] = array_merge($this->music_score['possible'], 
			array_keys($this->music_score['resource_misc']));
		$this->music_score['possible'] = array_merge($this->music_score['possible'], 
			array_keys($this->music_score['resource_year']));
		$this->music_score['possible'] = array_merge($this->music_score['possible'], 
			array("url", "isbn", "abstract", "note", "publisherName", "publisherLocation"));
		$this->music_score['stage4'] = array();  // empty array required
	}
}
?>
