<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	RESOURCEFORM class.
*
*	FORM creation for new/edit resources
*
*	$Header: /cvsroot/wikindx/wikindx3/core/resource/RESOURCEFORM.php,v 1.42 2005/06/28 22:38:08 sirfragalot Exp $
*****/
class RESOURCEFORM
{
// Constructor
	function RESOURCEFORM($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/html/MISC.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/resource/RESOURCEMAP.php");
		$this->map = new RESOURCEMAP();
	}
/*
* Make a form text field ready for printing.
*
* @author Mark Grimshaw
* @version 1
* @param array/string field
* @param array session variables
* @param integer text input size (optional)
* @param integer text input maxSize (optional)
* @return string
*/
	function makeTextInput($field, $sessionVars, $size = FALSE, $maxSize = FALSE)
	{
		if(is_array($field))
			list($field, $message) = array_values($field);
		else
			$message = $field;
		if(array_key_exists($field, $sessionVars))
			return FORM::textInput($this->messages->text("resources", $message), "resource_$field", 
				$sessionVars[$field], $size, $maxSize);
		else
			return FORM::textInput($this->messages->text("resources", $message), "resource_$field", 
				FALSE, $size, $maxSize);
	}
// start creating a new resource
	function stage1($new = TRUE)
	{
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
		foreach($this->map->types as $key)
			$array[$key] = $this->utf8->encodeUtf8($this->messages->text("resourceType", $key));
		$pString = '';
		$sessionVars = $this->session->getArray('resource');
		if(!$sessionVars)
			$sessionVars = array();
// editing
		if(!$new)
			$pString .= FORM::hidden("resource_type", $sessionVars['type']);
		$pString .= FORM::hidden("method", 'stage2');
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		if($new)
		{
			if(array_key_exists('type', $sessionVars))
				$pString .= TABLE::td(FORM::selectedBoxValue(
				$this->messages->text("resources", "type"), 
				"resource_type", $array, $sessionVars['type'], 10) . " " . 
				MISC::span('*', 'required'));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue($this->messages->text("resources", "type"), 
				"resource_type", $array, 10) . " " . MISC::span('*', 'required'));
		}
// Navigation hyperlinks when editing
		else
		{
			$pString .= TABLE::td($this->messages->text("resources", "jump"));
			$pString .= TABLE::td(MISC::a("link", $this->messages->text("resources", "jumpNumCreators"), 
				"index.php?action=resourceEdit&method=stage2&resource_type=" . 
				$sessionVars['type'] . "&jump=1"));
			$pString .= TABLE::td(MISC::a("link", $this->messages->text("resources", "jumpCreators"), 
				"index.php?action=resourceEdit&method=stage3&jump=1"));
			$pString .= TABLE::td(MISC::a("link", $this->messages->text("resources", "jumpDetails"), 
				"index.php?action=resourceEdit&method=stage4&jump=1"));
			$pString .= TABLE::td(MISC::a("link", $this->messages->text("resources", "jumpMisc"), 
				"index.php?action=resourceEdit&method=stage5&jump=1"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
// Encapsulating cell from body.tpl
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$pString .= MISC::br() . MISC::hr() . MISC::br();
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
		}
		$title = array_key_exists("title", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars['title']) : FALSE;
		$title = array_key_exists("noSort", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars['noSort']) . " $title" : FALSE . $title;
		$subtitle = array_key_exists("subtitle", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars['subtitle']) : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "title"), 
			"resource_title", $title, 50) . " " . MISC::span('*', 'required') . MISC::br() . 
			FORM::textInput($this->messages->text("resources", "subtitle"), "resource_subtitle", 
			$subtitle, 50) . MISC::br() . $this->messages->text("hint", "capitals"));
		$pString .= TABLE::trEnd();
		if(!$new)
		{
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::br() . MISC::hr() . MISC::br() . FORM::selectedBoxValue(
				$this->messages->text("resources", "convertType"), 
				"resource_typeConvert", $array, $sessionVars['type'], 10) . " " . 
				MISC::span('*', 'required'));
			$pString .= TABLE::trEnd();
		}
		$pString .= TABLE::tableEnd();
// Encapsulating cell from body.tpl
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::br() . "&nbsp;" . MISC::hr() . "&nbsp;" . MISC::br() . 
			MISC::p(FORM::formSubmit("Proceed"), FALSE, "right"), FALSE, "left", "top", 4);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Stage 2 - select number of creators for this resource.
// Dependent on resource type
	function stage2($sessionVars, $new = TRUE)
	{
		if(!$new)
			$sessionVars = $this->addNamesToSession($sessionVars);
		$pString = FORM::hidden("method", 'stage3');
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$message = $new ? $this->messages->text("resources", "numContributors") : 
			$this->messages->text("resources", "numContributorsEdit");
		$pString .= TABLE::td(MISC::p($message), "", "left", "top");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= $this->creatorInput($new, $sessionVars);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
// Encapsulating cell from body.tpl
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::br() . "&nbsp;" . MISC::hr() . "&nbsp;" . MISC::br() . 
			MISC::p(FORM::formSubmit("Proceed"), FALSE, "right"), FALSE, "left", "top");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// set numcreators, names etc. in session.  Needs to be here in stage2 in case user hits back button when editing to get
// back to this stage.  With this function in RESOURCEEDIT at start of process, num_creatorx was not being picked 
// up.
	function addNamesToSession($sessionVars)
	{
		$row = unserialize($this->session->getVar("resourceEditRow"));
		$creatorTypes = array("creator1", "creator2", "creator3", "creator4", "creator5");
		$names = array("surname", "firstname", "initials", "prefix");
		foreach($creatorTypes as $creatorType)
		{
			if($row[$creatorType])
				$temp['num_' . $creatorType] = sizeof(explode(',', $row[$creatorType]));
		}
		$sqlArray = $names;
		$sqlArray[] = 'id';
		foreach($creatorTypes as $creatorType)
		{
			if($row[$creatorType])
			{
				$condition = array();
				$ids = explode(',', $row[$creatorType]);
				foreach($ids as $id)
					$condition[] = $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($id);
				$recordset = $this->db->select(array('WKX_creator'), $sqlArray, 
					" WHERE " . implode(" OR ", $condition));
				while($line = $this->db->loopRecordSet($recordset))
				{
					foreach($names as $name)
					{
						if($name == 'initials')
							$line[$name] = implode("", explode(" ", $line[$name]));
						$collectNames[$line['id']][$name] = $line[$name];
					}
				}
				$index = 1;
				foreach($ids as $id)
				{
					foreach($names as $name)
					{
						if(!$collectNames[$id][$name])
							continue;
						$temp[$creatorType . "_" . $index . "_" . $name] =
							$collectNames[$id][$name];
					}
					$index ++;
				}
			}
		}
		if(isset($temp))
		{
			foreach($temp as $key => $value)
			{
				$sessionVars[$key] = $value;
				$this->session->setVar("resource_" . $key, $value);
			}
		}
		return $sessionVars;
	}
// Create creator input for stage2
// 5 creator fields
	function creatorInput($new, $sessionVars)
	{
		$pString = '';
		$type = $sessionVars['type'];
		foreach($this->map->{$type}['resource_creator'] as $key => $label)
		{
			$typeLabel = 'num_' . $key;
			$pString .= TABLE::td($this->createOneCreator($new, $sessionVars, $label, $typeLabel));
		}
		return $pString;
	}
// Create a creator field
	function createOneCreator($new, $sessionVars, $label, $typeLabel)
	{
		$inputName = "resource_" . $typeLabel;
		if(array_key_exists($typeLabel, $sessionVars) && is_numeric($sessionVars[$typeLabel]))
		{
			$rangeStart = $new ? 0 : $sessionVars[$typeLabel];
			$rangeEnd = $sessionVars[$typeLabel] + 5;
			$td = FORM::selectedBox($this->messages->text("creators", $label), 
				$inputName, range($rangeStart, $rangeEnd), $sessionVars[$typeLabel], "6");
		}
		else
			$td = FORM::textInput($this->messages->text("creators", $label), $inputName, FALSE, 4, 3);
		return $td;
	}
// new resource: Stage 3 (enter contributor names)
	function stage3($sessionVars, $new = TRUE)
	{
		if(array_key_exists("jump", $this->vars))
			$sessionVars = $this->addNamesToSession($sessionVars);
		include_once("core/creator/CREATOR.php");
		$creator = new CREATOR($this->db);
		$creators = $creator->grabAll();
		$type = $sessionVars['type'];
// editing
//		if(!$new)
//		{
// add 0 => IGNORE to creators array
			if($creators)
			{
				$temp[0] = $this->messages->text("misc", "ignore");
				foreach($creators as $key => $value)
					$temp[$key] = $value;
				$creators = $temp;
			}
//		}
		$pString = FORM::hidden("method", 'stage4');
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$found = FALSE;
		foreach($this->map->{$type}['resource_creator'] as $typeLabel => $label)
		{
			$sessionType = "resource_num_" . $typeLabel;
			if($num = $this->session->getVar($sessionType))
			{
				$pString .= TABLE::trStart();
				$pString .= TABLE::td(MISC::b($this->messages->text("creators", $label)), 
					"", "", "", 5);
				$pString .= TABLE::trEnd();
				$found = TRUE;
				$pString .= $this->nameForm($creators, $sessionVars, $num, $typeLabel);
				$this->session->delVar($sessionType);
			}
		}
		if(!$new)
			$finish = $this->messages->text("resources", "finish") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "resource_finish") . "&nbsp;&nbsp;";
		else
			$finish = FALSE;
		$pString .= TABLE::trEnd() . TABLE::trStart();
		$pString .= TABLE::td(MISC::br() . "&nbsp;" . MISC::br() . 
			MISC::p($finish . FORM::formSubmit("Proceed"), FALSE, "right"), FALSE, "left", "top", 5);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		if($found)
			$pString = $creators ? 
				MISC::p($this->messages->text("hint", "resourceName")) . $pString : $pString;
		else
// skip to stage 3
			return FALSE;
		return $pString;
	}
// new resource: Stage 4 (Fields specific to resource types)
	function stage4($sessionVars, $new = TRUE)
	{
//print_r($sessionVars); print "<P>";
		if(array_key_exists("jump", $this->vars) || $this->session->getVar('resource_typeConvert'))
			$sessionVars = $this->addNamesToSession($sessionVars);
		$pString = FORM::hidden("method", 'stage5');
// book type
		if($sessionVars['type'] == 'book')
			$pString .= $this->bookForm($sessionVars);
// book_article type
		else if($sessionVars['type'] == 'book_article')
			$pString .= $this->bookArticleForm($sessionVars);
// journal_article type
		else if($sessionVars['type'] == 'journal_article')
			$pString .= $this->journalArticleForm($sessionVars);
// web_article type
		else if($sessionVars['type'] == 'web_article')
			$pString .= $this->webArticleForm($sessionVars);
// newspaper_article type
		else if($sessionVars['type'] == 'newspaper_article')
			$pString .= $this->newspaperArticleForm($sessionVars);
// magazine_article type
		else if($sessionVars['type'] == 'magazine_article')
			$pString .= $this->magazineArticleForm($sessionVars);
// proceedings type
		else if($sessionVars['type'] == 'proceedings')
			$pString .= $this->proceedingsForm($sessionVars);
// conference_paper type
		else if($sessionVars['type'] == 'conference_paper')
			$pString .= $this->conferencePaperForm($sessionVars);
// proceedings_article type
		else if($sessionVars['type'] == 'proceedings_article')
			$pString .= $this->proceedingsArticleForm($sessionVars);
// thesis type
		else if($sessionVars['type'] == 'thesis')
			$pString .= $this->thesisForm($sessionVars);
// film type
		else if($sessionVars['type'] == 'film')
			$pString .= $this->filmForm($sessionVars);
// broadcast type
		else if($sessionVars['type'] == 'broadcast')
			$pString .= $this->broadcastForm($sessionVars);
// software type
		else if($sessionVars['type'] == 'software')
			$pString .= $this->softwareForm($sessionVars);
// artwork type
		else if($sessionVars['type'] == 'artwork')
			$pString .= $this->artworkForm($sessionVars);
// audiovisual type
		else if($sessionVars['type'] == 'audiovisual')
			$pString .= $this->audiovisualForm($sessionVars);
// (legal) case type
		else if($sessionVars['type'] == 'case')
			$pString .= $this->caseForm($sessionVars);
// legal_ruling / regulation type
		else if($sessionVars['type'] == 'legal_ruling')
			$pString .= $this->legalRuleForm($sessionVars);
// (parliamentary) bill type
		else if($sessionVars['type'] == 'bill')
			$pString .= $this->billForm($sessionVars);
// classical work type
		else if($sessionVars['type'] == 'classical')
			$pString .= $this->classicalForm($sessionVars);
// government report (and documentation)type
		else if($sessionVars['type'] == 'government_report')
			$pString .= $this->governmentReportForm($sessionVars);
// report (and documentation)type
		else if($sessionVars['type'] == 'report')
			$pString .= $this->reportForm($sessionVars);
// government/legal hearing type
		else if($sessionVars['type'] == 'hearing')
			$pString .= $this->hearingForm($sessionVars);
// online database type
		else if($sessionVars['type'] == 'database')
			$pString .= $this->databaseForm($sessionVars);
// online manuscript type
		else if($sessionVars['type'] == 'manuscript')
			$pString .= $this->manuscriptForm($sessionVars);
// map type
		else if($sessionVars['type'] == 'map')
			$pString .= $this->mapForm($sessionVars);
// chart type
		else if($sessionVars['type'] == 'chart')
			$pString .= $this->chartForm($sessionVars);
// statute type
		else if($sessionVars['type'] == 'statute')
			$pString .= $this->statuteForm($sessionVars);
// patent type
		else if($sessionVars['type'] == 'patent')
			$pString .= $this->patentForm($sessionVars);
// personal type
		else if($sessionVars['type'] == 'personal')
			$pString .= $this->personalForm($sessionVars);
// music_album type
		else if($sessionVars['type'] == 'music_album')
			$pString .= $this->musicAlbumForm($sessionVars);
// music_track type
		else if($sessionVars['type'] == 'music_track')
			$pString .= $this->musicTrackForm($sessionVars);
// music_score type
		else if($sessionVars['type'] == 'music_score')
			$pString .= $this->musicScoreForm($sessionVars);
// unpublished type
		else if($sessionVars['type'] == 'unpublished')
			$pString .= $this->unpublishedForm($sessionVars);
// miscellaneous type
		else if($sessionVars['type'] == 'miscellaneous')
			$pString .= $this->miscellaneousForm($sessionVars);
		if(!$new)
			$finish = $this->messages->text("resources", "finish") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "resource_finish") . "&nbsp;&nbsp;";
		else
			$finish = FALSE;
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . MISC::hr() . MISC::br();
		$pString .= MISC::p($finish . FORM::formSubmit("Proceed"), FALSE, "right");
		return $pString;
	}
// new resource: Stage 5 - Final stage
	function stage5($sessionVars, $new = TRUE)
	{
		if(array_key_exists("jump", $this->vars))
			$sessionVars = $this->addNamesToSession($sessionVars);
		$pString = $this->abstractForm($sessionVars);
		if(($sessionVars['type'] == 'web_article') || ($sessionVars['type'] == 'database'))
			$pString .= $this->urlIsbnForm($sessionVars, TRUE);
		else
			$pString .= $this->urlIsbnForm($sessionVars, FALSE);
		$pString .= $this->groupKeywordForm($sessionVars);
		$pString .= $this->noteForm($sessionVars);
//		$pString .= $this->fileAttachForm($sessionVars, $new);
		$pString .= $this->customFields($sessionVars, $new);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		return $pString;
	}
// Display stage4 for book type
	function bookForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year2', 31, 30);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "integer",
			$this->messages->text("resources", "numberOfVolumes") . " ");
		$field = array_search("numberOfVolumes", $this->map->{$type}['resource_misc']);
		$pString .= $this->textElement($sessionVars, 'resource_misc', $field, 5, 4, $extra);
		$field = array_search("bookVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$extra = MISC::br() . $this->messages->text("hint", "volumeYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year3', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$field = array_search("seriesNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
// Display stage4 for book_article type
	function bookArticleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year2', 31, 30);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "integer",
			$this->messages->text("resources", "numberOfVolumes") . " ");
		$field = array_search("numberOfVolumes", $this->map->{$type}['resource_misc']);
		$pString .= $this->textElement($sessionVars, 'resource_misc', $field, 5, 4, $extra);
		$field = array_search("bookVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$extra = MISC::br() . $this->messages->text("hint", "volumeYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year3', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$field = array_search("seriesNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for journal_article type
	function journalArticleForm($sessionVars)
	{
		include_once("core/messages/CONSTANTS.php");
		$constant = new CONSTANTS();
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
/* Removed for 3.0.8 to allow for a date range.
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$months[] = $this->messages->text("misc", "ignore");
		$months = array_merge($months, $constant->constants->monthToLongName());
		$monthText = 0;// 'IGNORE'
		if(array_key_exists('miscField3', $sessionVars) && $sessionVars['miscField3'])
			$monthText = $sessionVars['miscField3'];
		$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "month"), 
			"resource_miscField3", $months, $monthText, "6"));
		$field = array_search("journalVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("journalIssueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
*/
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars, TRUE);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("journalVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("journalIssueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for newspaper_article type
	function newspaperArticleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$field = array_search("section", $this->map->{$type}['resource']);
		$pString .= TABLE::td($this->makeTextInput(array($field, 
			$this->map->{$type}['resource'][$field]), $sessionVars, 20, 255));
		$field = array_search("city", $this->map->{$type}['resource']);
		$pString .= TABLE::td($this->makeTextInput(array($field, 
			$this->map->{$type}['resource'][$field]), $sessionVars, 20, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for magazine_article type
	function magazineArticleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars, TRUE);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= $this->textElement($sessionVars, 'resource', 'field4', 30, 255);
		$field = array_search("issueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("typeOfArticle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for web_article type
	function webArticleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->urlForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("journalVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("journalIssueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource' , $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for proceedings type
	function proceedingsForm($sessionVars)
	{
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars, TRUE);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for conference_paper type
	function conferencePaperForm($sessionVars)
	{
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for proceedings_article type
	function proceedingsArticleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars, TRUE);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$field = array_search("seriesNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for thesis type
	function thesisForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::b($this->messages->text("resources", "thesis")));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field1 = array(
			0	=>	"UNKNOWN", 
			1	=>	"master's",
			2	=>	"doctoral",
			3	=>	"PhD",
			4	=>	"diploma");
		$field = array_search("thesisLabel", $this->map->{$type}['resource']);
		if(array_key_exists($field, $sessionVars))
		{
			if(($value = array_search($sessionVars[$field], $field1)) === FALSE)
				$value = $sessionVars[$field];
			$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "thesisType"), 
			"resource_$field", $field1, $value, "4"));
		}
		else
			$pString .= TABLE::td(FORM::selectFBoxValue($this->messages->text("resources", "thesisType"), 
			"resource_$field", $field1, "4"));
		$field2 = array(
			1	=>	"thesis",
			2	=>	"dissertation",);
		$field = array_search("thesis", $this->map->{$type}['resource']);
		if(array_key_exists($field, $sessionVars) && $sessionVars[$field])
		{
			if(($value = array_search($sessionVars[$field], $field2)) === FALSE)
				$value = $sessionVars[$field];
			$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "thesisLabel"), 
			"resource_$field", $field2, $value, "2"));
		}
		else
			$pString .= TABLE::td(FORM::selectFBoxValue($this->messages->text("resources", "thesisLabel"), 
			"resource_$field", $field2, "2"));
		$field = array_search("thesisYear", $this->map->{$type}['resource_year']);
		$pString .= TABLE::td($this->makeTextInput(array($field, 
			$this->map->{$type}['resource_year'][$field]), $sessionVars, 31, 30) . MISC::br() . 
			$this->messages->text("hint", "year"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::td(MISC::b($this->messages->text("resources", "thesisAbstract")));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year2', 31, 30, $extra);
		$field = array_search("journalVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("journalIssueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for film type
	function filmForm($sessionVars)
	{
		$pString = $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->filmTVForm($sessionVars);
		return $pString;
	}
// Display stage4 for broadcast type
	function broadcastForm($sessionVars)
	{
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->filmTVForm($sessionVars);
		return $pString;
	}
// Display stage4 for artwork type
	function artworkForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("medium", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for software type
	function softwareForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("version", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("typeOfSoftware", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for audiovisual type
	function audiovisualForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("medium", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "integer",
			$this->messages->text("resources", "numberOfVolumes") . " ");
		$field = array_search("numberOfVolumes", $this->map->{$type}['resource_misc']);
		$pString .= $this->textElement($sessionVars, 'resource_misc', $field, 5, 4, $extra);
		$field = array_search("bookVolumeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$extra = MISC::br() . $this->messages->text("hint", "volumeYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year3', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$field = array_search("seriesNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for legal_rule type
	function legalruleForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("section", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("ruleNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("ruleType", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for case type
	function caseForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("reporter", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("reporterVolume", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for bill type
	function billForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("code", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("codeVolume", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$extra =  MISC::br() . $this->messages->text("hint", "year");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("session", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("section", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("billNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for classical type
	function classicalForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("volume", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for government_report type
	function governmentReportForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("department", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$field = array_search("section", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("volume", $this->map->{$type}['resource']);
		$field = array_search("issueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for report type
	function reportForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("issueNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("typeOfReport", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for hearing type
	function hearingForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("legislativeBody", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("committee", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("session", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "integer",
			$this->messages->text("resources", "numberOfVolumes") . ' ');
		$field = array_search("numberOfVolumes", $this->map->{$type}['resource_misc']);
		$pString .= $this->textElement($sessionVars, 'resource_misc', $field, 5, 4, $extra);
		$field = array_search("documentNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for database type
	function databaseForm($sessionVars)
	{
		$pString = $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->urlForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for manuscript type
	function manuscriptForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("typeOfManuscript", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("manuscriptNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for map type
	function mapForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("seriesTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("typeOfMap", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for chart type
	function chartForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("nameOfFile", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("version", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$field = array_search("number", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("imageProgram", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("imageType", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("imageSize", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for statute type
	function statuteForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("code", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("codeNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("publicLawNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("session", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("section", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 20, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for patent type
	function patentForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("patentNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("patentVersionNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("patentType", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("intPatentTitle", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("intPatentNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("intPatentClassification", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("applicationNumber", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$field = array_search("publishedSource", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$field = array_search("legalStatus", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 30, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for personal type
	function personalForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->dateForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$field = array_search("typeOfCommunication", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for unpublished type
	function unpublishedForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "year");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("typeOfWork", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->pagesForm($sessionVars);
		return $pString;
	}
// Display stage4 for music_album type
	function musicAlbumForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("medium", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for music_track type
	function musicTrackForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->collectionForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= $this->publisherFormB($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("medium", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for music_score type
	function musicScoreForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("edition", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Display stage4 for miscellaneous type
	function miscellaneousForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = $this->publisherForm($sessionVars);
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$extra = MISC::br() . $this->messages->text("hint", "publicationYear");
		$pString .= $this->textElement($sessionVars, 'resource_year', 'year1', 31, 30, $extra);
		$field = array_search("medium", $this->map->{$type}['resource']);
		$pString .= $this->textElement($sessionVars, 'resource', $field, 50, 255);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// Form element for database table fields.
	function textElement($sessionVars, $table, $field, $size, $maxSize, $extra = FALSE)
	{
		$type = $sessionVars['type'];
		return TABLE::td($this->makeTextInput(array($field, $this->map->{$type}[$table][$field]),
			$sessionVars, $size, $maxSize) . $extra);
	}
/////////////////////////////////////////////////////////////////////////////////////// General methods
// create form for inputting names
	function nameForm($creators, $sessionVars, $num, $type)
	{
		$pString = '';
		for($index = 1; $index <= $num; $index++)
		{
			$pString .= TABLE::trStart();
			$subEntry = $type . "_" . $index . "_firstname";
			$entry = "resource_" . $subEntry;
			$id = $type . "_" . $index . "_id";
			$idLabel = 'resource_' . $id;
			$text = array_key_exists($subEntry, $sessionVars) ? $sessionVars[$subEntry] : FALSE;
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "firstname"), 
				$entry, $text, 30, 255));
			$subEntry = $type . "_" . $index . "_initials";
			$entry = "resource_" . $subEntry;
			$text = array_key_exists($subEntry, $sessionVars) ? $sessionVars[$subEntry] : FALSE;
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "initials"), 
				$entry, $text, 6, 255));
			$subEntry = $type . "_" . $index . "_prefix";
			$entry = "resource_" . $subEntry;
			$text = array_key_exists($subEntry, $sessionVars) ? $sessionVars[$subEntry] : FALSE;
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "prefix"), 
				$entry, $text, 11, 10));
			$subEntry = $type . "_" . $index . "_surname";
			$entry = "resource_" . $subEntry;
			$text = array_key_exists($subEntry, $sessionVars) ? $sessionVars[$subEntry] : FALSE;
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "surname"), 
				$entry, $text, 30, 255) . " " . MISC::span('*', 'required'));
			if($creators)
			{
				if(array_key_exists($id, $sessionVars))
					$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, $idLabel, 
					$creators, $sessionVars[$id], "6"));
				else
					$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, $idLabel, $creators, "6"));
			}
			$pString .= TABLE::trEnd();
		}
		return $pString;
	}
// form input for collection information where 'collection' is the medium that a resource article is in
// e.g. journal for journal_article, CD for music track, newspaper for newspaper article.
	function collectionForm($sessionVars)
	{
		$type = $sessionVars['type'];
		include_once("core/collection/COLLECTION.php");
		$collection = new COLLECTION($this->db);
		$collections = $collection->grabAll($type);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$hint = $collections ? $this->messages->text("hint", "collectionTitle") : FALSE;
		if($type == 'newspaper_article')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "newspaper")) . 
			MISC::br() . $hint);
		else if($type == 'magazine_article')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "magazine")) . 
			MISC::br() . $hint);
		else if($type == 'manuscript')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "manuscript")) . 
			MISC::br() . $hint);
		else if($type == 'proceedings_article')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "conference")) . 
			MISC::br() . $hint);
		else if(($type == 'journal_article') || ($type == 'web_article'))
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "journal")) . 
			MISC::br() . $hint);
		else if($type == 'book_article')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "bookTitle")) . 
			MISC::br() . $hint);
		else if($type == 'music_track')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "album")) . 
			MISC::br() . $hint);
		if(($type == 'thesis') || ($type == 'web_article'))
			$required = FALSE;
		else
			$required = " " . MISC::span('*', 'required');
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->makeTextInput(array('collection', 'collectionTitle'), 
			$sessionVars, 40, 255) . $required);
		$pString .= TABLE::td($this->makeTextInput(array('collectionShort', 'collectionShort'), 
			$sessionVars, 20, 255));
		if($collections)
		{
// add 0 => IGNORE to collections array
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($collections as $key => $value)
				$temp[$key] = $value;
			$collections = $temp;
			if(array_key_exists("collection_id", $sessionVars))
				$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "resource_collection_id", 
				$collections, $sessionVars["collection_id"], "6"));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "resource_collection_id", 
				$collections, "6"));
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// form input for publisher information.
	function publisherForm($sessionVars)
	{
		$type = $sessionVars['type'];
		include_once("core/publisher/PUBLISHER.php");
		$publisher = new publisher($this->db);
// Want all publishers for resource type miscellaneous
		if($sessionVars['type'] == 'miscellaneous')
			$publishers = $publisher->grabAll();
		else
			$publishers = $publisher->grabAll($sessionVars['type']);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$hint = $publishers ? $this->messages->text("hint", "publisherName") : FALSE;
		if($type == 'proceedings_article')
		{
			$title = '';
			$name = "conferenceOrganiser";
			$location = "conferenceLocation";
		}
		else if($type == 'report')
		{
			$title = '';
			$name = "institution";
			$location = "publisherLocation";
		}
		else if($type == 'unpublished')
		{
			$title = '';
			$name = "institution";
			$location = "publisherLocation";
		}
		else if($type == 'patent')
		{
			$title = '';
			$name = "assignee";
			$location = "publisherLocation";
		}
		else if($type == 'legal_ruling')
		{
			$title = '';
			$name = "publisherName";
			$location = "publisherLocation";
		}
		else if($type == 'hearing')
		{
			$title = '';
			$name = "hearing";
			$location = "publisherLocation";
		}
		else if($sessionVars['type'] == 'bill')
		{
			$title = '';
			$name = "legislativeBody";
			$location = "publisherLocation";
		}
		else if($type == 'thesis')
		{
			$title = '';
			$name = "institution";
			$location = "publisherLocation";
		}
		else if($type == 'broadcast')
		{
			$title = $this->messages->text("resources", "channel");
			$name = "channel";
			$location = "publisherLocation";
		}
		else
		{
			$title = $this->messages->text("resources", "publisher");
			$name = "publisherName";
			$location = "publisherLocation";
		}
		$pString .= TABLE::td(MISC::b($title) . MISC::br() . $hint);
		if($publishers)
		{
// add 0 => IGNORE to publishers array
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($publishers as $key => $value)
				$temp[$key] = $value;
			$publishers = $temp;
			if(array_key_exists("publisher_id", $sessionVars))
				$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "resource_publisher_id", 
				$publishers, $sessionVars["publisher_id"], "6"));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "resource_publisher_id", 
				$publishers, "6"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= MISC::br() . "&nbsp;" . MISC::br();
		}
		else
		{
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
		}
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->makeTextInput(array('publisherName', $name), $sessionVars, 40, 255));
		if($type == 'thesis')
		{
			$field = array_search("department", $this->map->{$type}['resource']);
			$pString .= $this->textElement($sessionVars, 'resource', $field, 40, 255);
		}
		$pString .= TABLE::td($this->makeTextInput(array('publisherLocation', $location), $sessionVars, 30, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
// Proceedings article can also have a publisher in addition to conference organiser etc.
// This is a hack until I have time to code it better.
		if($type == 'proceedings_article')
		{
			$pString .= MISC::br() . "&nbsp;" . MISC::br();
			$title = $this->messages->text("resources", "publisher");
			$name = "publisherName";
			$location = "publisherLocation";
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($title) . MISC::br() . $hint);
			if($publishers)
			{
// add 0 => IGNORE to publishers array
				$temp[0] = $this->messages->text("misc", "ignore");
				foreach($publishers as $key => $value)
					$temp[$key] = $value;
				$publishers = $temp;
				if(array_key_exists("publisher_id", $sessionVars))
					$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "resource_confPublisher_id", 
					$publishers, $sessionVars["publisher_id"], "6"));
				else
					$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "resource_confPublisher_id", 
					$publishers, "6"));
				$pString .= TABLE::trEnd();
				$pString .= TABLE::tableEnd();
				$pString .= MISC::br() . "&nbsp;" . MISC::br();
			}
			else
			{
				$pString .= TABLE::trEnd();
				$pString .= TABLE::tableEnd();
			}
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td($this->makeTextInput(array('confPublisherName', $name), $sessionVars, 40, 255));
			$pString .= TABLE::td($this->makeTextInput(array('confPublisherLocation', $location), 
				$sessionVars, 30, 255));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
		}
		return $pString;
	}
// form input for publisher information where there is no location information (e.g. film distributors etc.).
	function publisherFormB($sessionVars)
	{
		$type = $sessionVars['type'];
		include_once("core/publisher/PUBLISHER.php");
		$publisher = new publisher($this->db);
		$publishers = $publisher->grabAll($sessionVars['type']);
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$hint = $publishers ? $this->messages->text("hint", "publisherName") : FALSE;
		if($type == 'institution')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "institution")) . 
			MISC::br() . $hint);
		else if($type == 'film')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "distributor")) . 
			MISC::br() . $hint);
		else if($type == 'music_album')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "recordLabel")) . 
			MISC::br() . $hint);
		else if($type == 'music_track')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "recordLabel")) . 
			MISC::br() . $hint);
		else if($type == 'case')
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "court")) . 
			MISC::br() . $hint);
		else
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "publisher")) . 
			MISC::br() . $hint);
		if($publishers)
		{
// add 0 => IGNORE to publishers array
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($publishers as $key => $value)
				$temp[$key] = $value;
			$publishers = $temp;
			if(array_key_exists("publisher_id", $sessionVars))
				$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "resource_publisher_id", 
				$publishers, $sessionVars["publisher_id"], "6"));
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, "resource_publisher_id", 
				$publishers, "6"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= MISC::br() . "&nbsp;" . MISC::br();
		}
		else
		{
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
		}
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		if($type == 'film')
			$label = 'distributor';
		else if($type == 'case')
			$label = 'court';
		else if($type == 'thesis')
			$label = 'institution';
		else
			$label = 'publisherName';
		$pString .= TABLE::td($this->makeTextInput(array("publisherName", $label), 
			$sessionVars, 50, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// form input for films/TV
	function filmTVForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		if($type == 'film')
		{
			$field = array_search("publicationYear", $this->map->{$type}['resource_year']);
			$pString .= TABLE::td($this->makeTextInput(array($field, 
				$this->map->{$type}['resource_year'][$field]), 
				$sessionVars, 31, 30) . MISC::br() . 
				$this->messages->text("hint", "publicationYear"));
			$field = $this->map->{$type}['resource']['field1'];
			$pString .= TABLE::td($this->makeTextInput(array('field1', $field), 
				$sessionVars, 30, 255));
		}
		$pString .= TABLE::td(MISC::b($this->messages->text("resources", "runningTime") . ":&nbsp;"), 
			FALSE, 'right', 'middle');
		$field = $this->map->{$type}['resource_misc']['miscField4'];
		$pString .= TABLE::td($this->makeTextInput(array('miscField4', $field), 
			$sessionVars, 5, 4));
		$field = $this->map->{$type}['resource_misc']['miscField1'];
		$pString .= TABLE::td($this->makeTextInput(array('miscField1', $field), 
			$sessionVars, 3, 2));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		return $pString;
	}
// form input for groups and keywords.
	function groupKeywordForm($sessionVars)
	{
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$groups = $group->grabAll();
		if(sizeof($groups) > 1)
		{
// Put 1 => 'General' group at top of list
			unset($groups[1]);
			$temp[1] = 'General';
			foreach($groups as $key => $value)
				$temp[$key] = $value;
			$groups = $temp;
		}
		else
			$groups = FALSE;
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$keywords = $keyword->grabAll();
// add 0 => IGNORE to keywords array
		$temp = array();
		if($keywords)
		{
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($keywords as $key => $value)
				$temp[$key] = $value;
			$keywords = $temp;
		}
		$pString = '';
		if($groups)
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "categories")) . MISC::br() . 
			$this->messages->text("hint", "categories"));
			if(array_key_exists("group_ids", $sessionVars))
			{
				$selectedArray = explode(",", $sessionVars['group_ids']);
				$td = FORM::selectedBoxValueMultiple(FALSE, "resource_group_ids", 
				$groups, $selectedArray, "6");
			}
			else
				$td = FORM::selectFBoxValueMultiple(FALSE, "resource_group_ids", $groups, "6");
			$pString .= TABLE::td($td . MISC::br() . $this->messages->text("hint", "multiples"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		}
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("keywords", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars["keywords"]) : FALSE;
		$pString .= TABLE::td(MISC::b($this->messages->text("resources", "keywords")) . MISC::br() . 
			$this->messages->text("hint", "keywords") . MISC::p(FORM::textInput(FALSE, 
			"resource_keywords", $text, 40, 255) . MISC::br() . 
			$this->messages->text("hint", "keywordList")));
		if($keywords)
		{
			if(array_key_exists("keyword_ids", $sessionVars))
			{
				$selectedArray = explode(",", $sessionVars['keyword_ids']);
				$td = FORM::selectedBoxValueMultiple(FALSE, "resource_keyword_ids", 
				$keywords, $selectedArray, "6");
			}
			else
				$td = FORM::selectFBoxValueMultiple(FALSE, "resource_keyword_ids", $keywords, "6");
			$pString .= TABLE::td($td . MISC::br() . $this->messages->text("hint", "multiples"));
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for URLs at stage 4 (web_article and online databases)
	function urlForm($sessionVars)
	{
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("url", $sessionVars) ? $this->html->dbToFormTidy($sessionVars["url"]) : 
			$this->messages->text("resources", "urlForm");
		$td = MISC::b($this->messages->text("resources", "url")) . MISC::br();
		$required = " " . MISC::span('*', 'required');
		$url = array_key_exists("url", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars['url']) : "http://";
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "url"), 
			"resource_url", $url, 70, 255) . " " . $required  . 
			MISC::br() . $this->messages->text("hint", "url"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		return $pString;
	}
// form input for URLs and ISBN/ISSN at Stage5
	function urlIsbnForm($sessionVars, $webArticle = FALSE)
	{
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("url", $sessionVars) ? $this->html->dbToFormTidy($sessionVars["url"]) : 
			$this->messages->text("resources", "urlForm");
		$td = MISC::b($this->messages->text("resources", "url")) . MISC::br();
		if(!$webArticle)
		{
			$td .= $this->messages->text("hint", "urlNote") . MISC::br();
			$required = FALSE;
			$url = array_key_exists("url", $sessionVars) ? 
				$this->html->dbToFormTidy($sessionVars['url']) : "http://";
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "url"), 
				"resource_url", $url, 70, 255) . " " . $required  . 
				MISC::br() . $this->messages->text("hint", "url"));
		}
		$pString .= TABLE::td($this->makeTextInput('isbn', $sessionVars, 30, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for date (day/month/year) - miscField2, miscField3 and yearx fields.
// If $endDate, this is end date so handles miscField5, miscField6 and year3
	function dateForm($sessionVars, $endDate = FALSE)
	{
		$type = $sessionVars['type'];
		if(!$endDate)
		{
			$dayField = "miscField2";
			$monthField = "miscField3";
			$yearField = "year1";
		}
		else
		{
			$dayField = "miscField5";
			$monthField = "miscField6";
			$yearField = "year3";
		}
// Load month arrays
		include_once("core/messages/CONSTANTS.php");
		$constant = new CONSTANTS();
		$pString = '';
		$days[] = $this->messages->text("misc", "ignore");
		$days = array_merge($days, range(1, 31));
		$months[] = $this->messages->text("misc", "ignore");
		$months = array_merge($months, $constant->constants->monthToLongName());
		$dayText = $monthText = 0;// 'IGNORE'
		if(array_key_exists($dayField, $sessionVars) && $sessionVars[$dayField])
			$dayText = $sessionVars[$dayField];
		if(array_key_exists($monthField, $sessionVars) && $sessionVars[$monthField])
			$monthText = $sessionVars[$monthField];
		if(!isset($sessionVars[$yearField]) || !$sessionVars[$yearField])
			$sessionVars[$yearField] = FALSE;
		$required = '';
		if(($sessionVars['type'] == 'web_article') || ($sessionVars['type'] == 'database'))
		{
			$days = range(1, 31);
			$months = $constant->constants->monthToLongName();
			$dayText = date("j");
			$monthText = date("n");
			$yearField = "year2";
			if(!isset($sessionVars["year2"]) || !$sessionVars["year2"])
				$sessionVars["year2"] = date("Y");
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "dateAccessed")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = " " . MISC::span('*', 'required');
		}
		else if($sessionVars['type'] == 'broadcast')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "broadcastDate")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'legal_ruling')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "codeEditionDate")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'case')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "dateDecided")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'patent')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "issueDate")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'statute')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "dateEnacted")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'report')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "reportDate")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if($sessionVars['type'] == 'hearing')
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b($this->messages->text("resources", "hearingDate")));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if(($sessionVars['type'] == 'proceedings') || ($sessionVars['type'] == 'proceedings_article'))
		{
			if(!$endDate)
				$yearField = "year2";
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			if($endDate)
				$pString .= TABLE::td(MISC::b($this->messages->text("resources", "conferenceDate") . 
					" (" . $this->messages->text("resources", "dateEnd") . ")"));
			else
				$pString .= TABLE::td(MISC::b($this->messages->text("resources", "conferenceDate") . 
					" (" . $this->messages->text("resources", "dateStart") . ")"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		else if((($sessionVars['type'] == 'magazine_article') || 
			($sessionVars['type'] == 'journal_article')) && $endDate)
		{
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td(MISC::b(" (" . $this->messages->text("resources", "dateEnd") . ")"));
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
			$required = '';
		}
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		if($sessionVars['type'] != 'journal_article')
			$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "day"),
			"resource_$dayField", $days, $dayText, "6") . $required);
		$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "month"), 
			"resource_$monthField", $months, $monthText, "6") . $required);
		$pString .= TABLE::td($this->makeTextInput(array($yearField, "year"), $sessionVars, 31, 30) . 
			$required . MISC::br() . $this->messages->text("hint", "year"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		return $pString;
	}
// form input for resource Abstract
	function abstractForm($sessionVars)
	{
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("abstract", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars["abstract"]) : FALSE;
		$pString .= TABLE::td(FORM::textareaInput($this->messages->text("resources", "abstract"), 
			"resource_abstract", $text, 80, 10));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for resource Note
	function noteForm($sessionVars)
	{
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("note", $sessionVars) ? 
			$this->html->dbToFormTidy($sessionVars["note"]) : FALSE;
		$pString .= TABLE::td(FORM::textareaInput($this->messages->text("resources", "note"), 
			"resource_note", $text, 80, 10));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for file attachments
	function fileAttachForm($sessionVars, $new)
	{
		if(!$this->session->getVar("setup_fileAttach"))
			return FALSE;
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("fileAttach", $sessionVars) ? $sessionVars["fileAttach"] : FALSE;
		$pString .= TABLE::td(FORM::fileUpload($this->messages->text("resources", "fileAttach"), 
			"resource_fileAttach", 20), FALSE, "left", "bottom");
		$pString .= TABLE::td($this->messages->text("resources", "fileName") . "&nbsp;" . FORM::textInput(FALSE, 
			"resource_fileName"), FALSE, "left", "bottom");
		if(!$new && array_key_exists('file', $sessionVars)) // editing
		{
			$pString .= TABLE::td($this->messages->text("resources", "fileRemove", $sessionVars['file']) . 
				":&nbsp;&nbsp;" . FORM::checkbox(FALSE, "resource_fileRemove"), FALSE, "left", "bottom");
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for custom fields
	function customFields($sessionVars, $new)
	{
		$recordset = $this->db->select(array("WKX_custom"), array('id', 'custom_label', 'custom_size'));
		if(!$this->db->numRows($recordset))
			return FALSE;
// existing data
		if(!$new)
		{
			$recordset2 = $this->db->select(array('WKX_resource_custom'), array('id', 'customId', 
				'custom_short', 'custom_long'), 
				" WHERE " . $this->db->formatfield('resourceId') ."=" . 
				$this->db->tidyInput($sessionVars['resourceId']));
			while($row = $this->db->loopRecordSet($recordset2))
			{
				if(trim($row['custom_short']))
					$customText[$row['customId']] = 
					$this->html->dbToFormTidy(trim($row['custom_short']));
				else if(trim($row['custom_long']))
					$customText[$row['customId']] = 
					$this->html->dbToFormTidy(trim($row['custom_long']));
			}
		}
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(MISC::b($this->messages->text("custom", "customFields")));
		$pString .= TABLE::trEnd();
		while($row = $this->db->loopRecordSet($recordset))
		{
			if(isset($customText) && array_key_exists($row['id'], $customText))
				$text = $customText[$row['id']];
			else
				$text = FALSE;
			$formName = "resource_custom_" . $row['custom_size'] . "_" . $row['id'];
			$pString .= TABLE::trStart();
			if($row['custom_size'] == 'S') // small VARCHAR(255)
				$pString .= TABLE::td(MISC::br() . "&nbsp;" . 
					FORM::textInput($this->html->dbToHtmlTidy($row['custom_label']), 
					$formName, $text, 50, 255));
			else // large TEXT
				$pString .= TABLE::td(MISC::br() . "&nbsp;" . 
					FORM::textareaInput($this->html->dbToHtmlTidy($row['custom_label']), 
					$formName, $text, 80, 10));
			$pString .= TABLE::trEnd();
		}
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		return $pString;
	}
// form input for pages
	function pagesForm($sessionVars)
	{
		$type = $sessionVars['type'];
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$pString .= TABLE::td($this->messages->text("resources", "pages") . MISC::br() . 
			$this->messages->text("hint", "pages"));
		$pString .= TABLE::td($this->makeTextInput(array("pageStart", "pageStart"), $sessionVars, 6, 5));
		$pString .= TABLE::td($this->makeTextInput(array("pageEnd", "pageEnd"), $sessionVars, 6, 5));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
}
?>
