<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCECUSTOM class
*
* Deal with resource's custom fields
*****/
class RESOURCECUSTOM
{
// Constructor
	function RESOURCECUSTOM($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML($this->db);
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
	}
// Display resource's custom fields
	function view($row)
	{
// Load icons
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		include_once("core/user/USER.php");
		$user = new USER($this->db);
		$icons->getIconInfo("edit");
		$viewEditLink = $icons->editExists ? "imgLink" : "link";
		$recordset = $this->db->select(array("WKX_custom"), array(array("WKX_resource_custom.id" => 'customId'), 
			'custom_label', 'custom_size', 'custom_short', 'custom_long', 
			'addUserIdCustom', 'editUserIdCustom'), 
			" LEFT JOIN " . $this->db->formatTable("WKX_resource_custom") . " ON " . 
			$this->db->formatfield("WKX_custom.id") . "=" . 
			$this->db->formatfield("WKX_resource_custom.customId") . 
			" WHERE " . $this->db->formatfield("WKX_resource_custom.resourceId") . "=" . $row['resourceId']
			);
		if(!$this->db->numRows($recordset))
			return FALSE; // no custom fields
		$pString = '';
		$write = $this->session->getVar('setup_write') ? TRUE : FALSE;
		if(array_key_exists("search", $this->vars) && $this->vars["search"] = 'highlight')
		{
			$searchTerms = explode(",", $this->session->getVar('search_highlight'));
			foreach($searchTerms as $term)
				$patterns[] = "/($term)/i";
		}
		while($rowC = $this->db->loopRecordSet($recordset))
		{
			$text = FALSE;
			if($rowC['custom_short'])
				$text = trim($rowC['custom_short']);
			if($rowC['custom_long'])
				$text = trim($rowC['custom_long']);
			if(!$text)
				continue;
			if(isset($patterns))
				$entry = preg_replace($patterns, MISC::span("$1", "highlight"), 
					$this->html->dbToHtmlTidy($text));
			else
				$entry = $this->html->dbToHtmlTidy($text);
			$userAddEdit = $user->displayUserAddEdit($rowC['addUserIdCustom'], $rowC['editUserIdCustom']);
			$pString .= MISC::b($this->html->dbToHtmlTidy($rowC['custom_label']));
			$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
			$pString .= TABLE::trStart();
			$pString .= TABLE::td($entry . $userAddEdit, "alternate1");
			if($write)
			{
				$editLink = MISC::a("$viewEditLink", "&nbsp;" . $icons->edit . 
				"&nbsp;", "index.php?action=userCustomEdit" . 
				htmlentities("&id=" . $rowC['customId'] . "&size=" . $rowC['custom_size']));
				$pString .= TABLE::td($editLink, "alternate1", "right", "top");
			}
			$pString .= TABLE::trEnd();
			$pString .= TABLE::tableEnd();
			$pString .= MISC::br() . "&nbsp;" . MISC::br();
		}
		return $pString;
	}
// display the editing form:
	function editDisplay()
	{
		$this->checkInput();
		$this->template->setVar('heading', $this->messages->text("heading", "userEditField"));
		if($this->vars['size'] == 'L')
			$fieldName = 'custom_long';
		else
			$fieldName = 'custom_short';
		$recordset = $this->db->select(array('WKX_resource_custom'), array($fieldName, 'custom_label', 'resourceId'), 
			" LEFT JOIN " . $this->db->formatTable("WKX_custom") . " ON " . 
			$this->db->formatfield("WKX_custom.id") . "=" . 
			$this->db->formatfield("WKX_resource_custom.customId") .  
			" WHERE " . $this->db->formatfield("WKX_resource_custom.id") . "=" . 
			$this->db->tidyInput($this->vars['id']));
		$row = $this->db->fetchRow($recordset);
		$hint = MISC::br() . $this->messages->text("hint", 'format');
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
// The second parameter ('customText') to textareaInput is the textarea name
		$pString .= TABLE::td(FORM::hidden("id", $this->vars['id']) . 
			FORM::hidden("resourceId", $row['resourceId']) . 
			FORM::hidden("size", $this->vars['size']) . 
			FORM::textareaInput($this->html->dbToHtmlTidy($row['custom_label']), 
			"customText", $this->html->dbToFormTidy($row[$fieldName]), 80, 10) . $hint);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::formSubmit("Proceed"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('formStart', FORM::formHeader("userCustomEdit"));
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('resourceCustomLock'))
			$this->badInput($this->errors->text("done", "custom"));
		$this->checkInput();
		$userId = $this->session->getVar('setup_userId');
			$addEdit = 'edited';
// if noteText is empty, delete the row
		if(!trim($this->vars['customText']))
		{
			$addEdit = 'deleted';
			$this->db->delete('WKX_resource_custom', "WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($this->vars['id']));
		}
		else
		{
			$addEdit = 'edited';
			if($this->vars['size'] == 'S')
				$field = 'custom_short';
			else
				$field = 'custom_long';
			$updateArray[$field] = trim($this->vars['customText']);
			if($userId)
				$updateArray["editUserIdCustom"] = $userId;
			$this->db->update('WKX_resource_custom', $updateArray, 
				" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['id']));
		}
// update resource timestamp
		$this->db->update('WKX_resource_timestamp', array('timestamp' => $this->db->formatTimestamp()), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['resourceId']));
// lock reload
		$this->session->setVar('resourceCustomLock', TRUE);
// email notification
		include_once("core/notify/NOTIFY.php");
		$notify = new NOTIFY($this->db);
		$notify->email($this->vars['id']);
// send back to view this resource with success message
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($this->success->text("field", " " . 
			$this->messages->text("misc", $addEdit) . " "), 'lastSolo'));
	}
// Check we have appropriate input
	function checkInput()
	{
		if(!array_key_exists('id', $this->vars) || !$this->vars['id'])
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!array_key_exists('size', $this->vars) || !$this->vars['size'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view a resource.
	function badInput($error)
	{
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($error, 'lastSolo'));
	}
}
?>
