<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCEABSTRACT class
*
* Deal with resource's abstract
*****/
class RESOURCEABSTRACT
{
// Constructor
	function RESOURCEABSTRACT($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML($this->db);
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
	}
// Display resource's abstract
	function view($row)
	{
// Load icons
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		$icons->getIconInfo("edit");
		$viewEditLink = $icons->editExists ? "imgLink" : "link";
		$icons->getIconInfo("add");
		$addLink = $icons->addExists ? "imgLink" : "link";
		$pString = MISC::b($this->messages->text("resources", "abstract"));
		$write = $this->session->getVar('setup_write') ? TRUE : FALSE;
		if(!$row['abstract'])
		{
			$pString .= $write ? " " . MISC::a($addLink, $icons->add, 
				"index.php?action=abstractEdit" . htmlentities("&id=" . $row['resourceId'])) 
				:
				FALSE;
			return $pString .= MISC::br() . "&nbsp;" . MISC::br();
		}
		if(array_key_exists("search", $this->vars) && $this->vars["search"] = 'highlight')
		{
			$searchTerms = explode(",", $this->session->getVar('search_highlight'));
			foreach($searchTerms as $term)
				$patterns[] = "/($term)/i";
		}
		include_once("core/user/USER.php");
		$user = new USER($this->db);
		$userAddEdit = $user->displayUserAddEdit($row['addUserIdAbstract'], $row['editUserIdAbstract']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		if(isset($patterns))
		{
			$entry = preg_replace($patterns, MISC::span("$1", "highlight"), 
				$this->html->dbToHtmlTidy($row['abstract']));
		}
		else
			$entry = $this->html->dbToHtmlTidy($row['abstract']);
// check for any citation strings
		include_once("core/cite/CITEFORMAT.php");
		$cf = new CITEFORMAT($this->db, $this->vars);
		$pString .= TABLE::td($cf->citeParse($entry) . $userAddEdit, 'alternate1');
		if($write)
		{
			$editLink = MISC::a("$viewEditLink", "&nbsp;" . $icons->edit . 
			"&nbsp;", "index.php?action=abstractEdit" . htmlentities("&id=" . $row['resourceId']));
			$pString .= TABLE::td($editLink, "alternate1", "right", "top");
		}
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
// display the editing form:
	function editDisplay()
	{
		$this->checkInput();
		$this->template->setVar('heading', $this->messages->text("heading", "abstract"));
		$recordset = $this->db->select(array('WKX_resource_abstract'), array('abstract'), 
			"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['id']));
		$row = $this->db->fetchRow($recordset);
		$hint = MISC::br() . $this->messages->text("hint", 'format');
		$pString = TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
// Create citation link for this type
		include_once("core/cite/CITE.php");
		$citeLink = CITE::makeCiteLink('abstract');
// The second parameter ('abstractText') to textareaInput is the textarea name
		$pString .= TABLE::td(FORM::hidden("id", $this->vars['id']) . 
			FORM::textareaInput($this->messages->text("resources", "abstract"), 
			"abstractText", $this->html->dbToFormTidy($row['abstract']), 80, 10) . $citeLink . $hint);
		$pString .= TABLE::trEnd();
		$pString .= TABLE::trStart();
		$pString .= TABLE::td(FORM::formSubmit("Proceed"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('formStart', FORM::formHeader("abstractEdit"));
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('resourceAbstractLock'))
			$this->badInput($this->errors->text("done", "abstract"));
		$this->checkInput();
		$userId = $this->session->getVar('setup_userId');
// insert new or update?
		$recordset = $this->db->select(array('WKX_resource_abstract'), array('id'), 
			"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['id']));
		if(!$this->db->numRows($recordset))
		{
			$addEdit = 'added';
			$fields[] = "id";
			$values[] = $this->vars['id'];
			$fields[] = "abstract";
			$values[] = trim($this->vars['abstractText']);
			if($userId)
			{
				$fields[] = "addUserIdAbstract";
				$values[] = $userId;
			}
			$this->db->insert('WKX_resource_abstract', $fields, $values);
		}
		else
		{
			$addEdit = 'edited';
// if abstractText is empty, delete the row
			if(!$this->vars['abstractText'])
			{
				$addEdit = 'deleted';
				$this->db->delete('WKX_resource_abstract', 
					"WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($this->vars['id']));
			}
			else
			{
				$addEdit = 'edited';
				$updateArray["abstract"] = trim($this->vars['abstractText']);
				if($userId)
					$updateArray["editUserIdAbstract"] = $userId;
				$this->db->update('WKX_resource_abstract', $updateArray, 
					"WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($this->vars['id']));
			}
		}
// update resource timestamp
		$this->db->update('WKX_resource_timestamp', array('timestamp' => $this->db->formatTimestamp()), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($this->vars['id']));
// lock reload
		$this->session->setVar('resourceAbstractLock', TRUE);
// email notification
		include_once("core/notify/NOTIFY.php");
		$notify = new NOTIFY($this->db);
		$notify->email($this->vars['id']);
// send back to view this resource with success message
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($this->success->text("abstract", " " . 
			$this->messages->text("misc", $addEdit) . " "), 'lastSolo'));
	}
// Check we have appropriate input
	function checkInput()
	{
		if(!array_key_exists('id', $this->vars) || !$this->vars['id'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view a resource.
	function badInput($error)
	{
		include_once("core/resource/RESOURCEVIEW.php");
		$resource = new RESOURCEVIEW($this->db, $this->vars);
		new CLOSE($this->db, $resource->view($error, 'lastSolo'));
	}
}
?>
