<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* RESOURCE class
*
*****/
class RESOURCE
{
// Constructor
	function RESOURCE($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// If $noMenu, display Resources submenu links
	function display($noMenu = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "resources"));
		if($noMenu)
		{
			include_once("core/html/MENU.php");
			$menu = new MENU();
			$pString = $menu->noMenu('resource');
			$this->template->setVar('noMenu', $pString);
			return $this->template->process();
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// check we are allowed to write
	function gateKeep($function, $message = FALSE)
	{
		if(!$this->session->getVar('setup_write'))
		{
			include_once("core/authorize/AUTHORIZE.php");
			$authorize = new AUTHORIZE($this->db);
			return $authorize->initLogon();
		}
// new resource
		if($function == 'newResource')
		{
			$this->session->setVar('resourceLock', FALSE);
			include_once("core/resource/RESOURCENEW.php");
			$newResource = new RESOURCENEW($this->db, $this->vars);
			return $newResource->resource($message);
		}
// edit resource
		if($function == 'editResource')
		{
			$this->session->setVar('resourceLock', FALSE);
			include_once("core/resource/RESOURCEEDIT.php");
			$editResource = new RESOURCEEDIT($this->db, $this->vars);
			return $editResource->resource();
		}
// write resource input
		if($function == 'writeResource')
		{
			if($this->session->getVar('resourceLock'))
			{
				include_once("core/html/CLOSE.php");
				include_once("core/messages/ERRORS.php");
				$this->errors = new ERRORS();
				$this->template->setVar('heading', $this->messages->text("heading", "resources"));
				$this->template->setVar('body', $this->errors->text("done", "resource"));
				new CLOSE($this->db, $this->template->process());
			}
			include_once("core/resource/RESOURCEWRITE.php");
			$writeResource = new RESOURCEWRITE($this->db, $this->vars);
			return $writeResource->writeResource();
		}
// edit/add note
		if($function == 'editNote')
		{
			include_once("core/resource/RESOURCENOTE.php");
			$obj = new RESOURCENOTE($this->db, $this->vars);
			if(!array_key_exists('noteText', $this->vars))
			{
				$this->session->setVar('resourceNoteLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// edit/add quote
		if($function == 'editQuote')
		{
			include_once("core/resource/RESOURCEQUOTE.php");
			$obj = new RESOURCEQUOTE($this->db, $this->vars);
			if(!array_key_exists('quoteText', $this->vars) && !array_key_exists('commentOnly', $this->vars))
			{
				$this->session->setVar('resourceQuoteLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// edit/add paraphrase
		if($function == 'editParaphrase')
		{
			include_once("core/resource/RESOURCEPARAPHRASE.php");
			$obj = new RESOURCEPARAPHRASE($this->db, $this->vars);
			if(!array_key_exists('paraphraseText', $this->vars) && !array_key_exists('commentOnly', $this->vars))
			{
				$this->session->setVar('resourceParaphraseLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// edit/add musing
		if($function == 'editMusing')
		{
			include_once("core/resource/RESOURCEMUSING.php");
			$obj = new RESOURCEMUSING($this->db, $this->vars);
			if(!array_key_exists('musingText', $this->vars))
			{
				$this->session->setVar('resourceMusingLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// edit/add abstract
		if($function == 'editAbstract')
		{
			include_once("core/resource/RESOURCEABSTRACT.php");
			$obj = new RESOURCEABSTRACT($this->db, $this->vars);
			if(!array_key_exists('abstractText', $this->vars))
			{
				$this->session->setVar('resourceAbstractLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// edit custom field
		if($function == 'editCustom')
		{
			include_once("core/resource/RESOURCECUSTOM.php");
			$obj = new RESOURCECUSTOM($this->db, $this->vars);
			if(!array_key_exists('customText', $this->vars))
			{
				$this->session->setVar('resourceCustomLock', FALSE);
				return $obj->editDisplay();
			}
			return $obj->edit();
		}
// add selected resources to user bibliographies, categories or keywords - display initial forms
		if($function == 'addResourceTo')
		{
			if(!array_key_exists('resourceAddTo', $this->vars))
				$this->failure($this->errors->text("inputError", "missing"));
			$this->session->setVar("resourceAddTo", $this->vars['resourceAddTo']);
			if($this->vars['resourceAddTo'] == 1)	// add to categories
				return $this->addToCategoryInit();
			else if($this->vars['resourceAddTo'] == 2)	// add to keywords
				return $this->addToKeywordInit();
			else	// add to user bibs
				return $this->addToUserBibInit();
		}
// add selected resources to categories
		if($function == 'addResourceToCategory')
			return $this->addToCategory();
// add selected resources to keywords
		if($function == 'addResourceToKeyword')
			return $this->addToKeyword();
	}
// write input to session
	function writeSession()
	{
// Write all input with 'resource_' prefix to session
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^resource_/", $key))
				$temp[$key] = trim($value);
		}
		if(isset($temp))
			$this->session->writeArray($temp);
	}
// Add selected resources to category(s)
	function addToCategory()
	{
		include_once("core/user/MYWIKINDX.php");
		$mywikindx = new MYWIKINDX($this->db, $this->vars);
		$addAll = $replaceExisting = FALSE;
		if(!array_key_exists("categories", $this->vars))
			return $mywikindx->chooseDisplay($this->errors->text("inputError", "missing"));
		$categoryIds = $this->vars['categories'];
		if(array_key_exists("replaceExisting", $this->vars))
			$replaceExisting = TRUE;
		if(array_key_exists("addAll", $this->vars))
		{
			if(!$sql = stripslashes($this->session->getVar('sql_stmt')))
				$this->failure($this->errors->text("file", "noSql"));
			$recordset = $this->db->query($sql);
			while($row = $this->db->loopRecordSet($recordset))
				$resourceIds[] = $row['resourceId'];
		}
		else
		{
			foreach($this->vars as $key => $value)
			{
				if(strpos($key, "bib_") !== FALSE)
				{
					$split = explode("_", $key);
					$resourceIds[] = $split[1];
				}
			}
		}
		if(!isset($resourceIds))
			return $mywikindx->chooseDisplay($this->errors->text("inputError", "missing"));
		$this->session->setVar("resourceAddToCategories", join(",", $categoryIds));
		foreach($resourceIds as $resourceId)
		{
// Current keywords for this resource
			$fields = $values = array();
			$cIds = $categoryIds;
			$checkCategories = FALSE;
			$recordset = $this->db->select(array('WKX_resource_category'), array('categories'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($resourceId));
			if($this->db->numRows($recordset))
			{
				$oldRow = $this->db->fetchRow($recordset);
				$checkCategories = array_diff(explode(",", $oldRow['categories']), $categoryIds);
			}
			if(!$replaceExisting && is_array($checkCategories))
				$kIds = array_merge($checkCategories, $categoryIds);
			$fields[] = "categories";
			$values[] = implode(',', $cIds);
//			$recordset = $this->db->select(array('WKX_resource_keyword'), array('id'), 
//				" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
			if($this->db->numRows($recordset))
			{
				$updateArray['categories'] = array_shift($values);
				$this->db->update('WKX_resource_category', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
			}
			else
			{
				$fields[] = "id";
				$values[] = $resourceId;
				$this->db->insert('WKX_resource_category', $fields, $values);
			}
		}
		return $mywikindx->chooseDisplay($this->success->text("addResourceToCategory"));
	}
// Add selected resources to keyword(s)
	function addToKeyword()
	{
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		include_once("core/user/MYWIKINDX.php");
		$mywikindx = new MYWIKINDX($this->db, $this->vars);
		$addAll = $replaceExisting = FALSE;
		if(!array_key_exists("keywords", $this->vars))
			return $mywikindx->chooseDisplay($this->errors->text("inputError", "missing"));
		$keywordIds = $this->vars['keywords'];
		if(array_key_exists("replaceExisting", $this->vars))
			$replaceExisting = TRUE;
		if(array_key_exists("addAll", $this->vars))
		{
			if(!$sql = stripslashes($this->session->getVar('sql_stmt')))
				$this->failure($this->errors->text("file", "noSql"));
			$recordset = $this->db->query($sql);
			while($row = $this->db->loopRecordSet($recordset))
				$resourceIds[] = $row['resourceId'];
		}
		else
		{
			foreach($this->vars as $key => $value)
			{
				if(strpos($key, "bib_") !== FALSE)
				{
					$split = explode("_", $key);
					$resourceIds[] = $split[1];
				}
			}
		}
		if(!isset($resourceIds))
			return $mywikindx->chooseDisplay($this->errors->text("inputError", "missing"));
		$checkKIds = array();
		$this->session->setVar("resourceAddToKeywords", join(",", $keywordIds));
		foreach($resourceIds as $resourceId)
		{
// Current keywords for this resource
			$fields = $values = array();
			$kIds = $keywordIds;
			$checkKeywords = FALSE;
			$recordset = $this->db->select(array('WKX_resource_keyword'), array('keywords'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($resourceId));
			if($this->db->numRows($recordset))
			{
				$oldRow = $this->db->fetchRow($recordset);
				$checkKeywords = array_diff(explode(",", $oldRow['keywords']), $keywordIds);
			}
			if(!$replaceExisting && is_array($checkKeywords))
				$kIds = array_merge($checkKeywords, $keywordIds);
			else if(is_array($checkKeywords))
			{
				$checkKIds = array_merge($checkKIds, $checkKeywords);
				$checkKIds = array_unique($checkKIds);
			}
			$fields[] = "keywords";
			$values[] = implode(',', $kIds);
//			$recordset = $this->db->select(array('WKX_resource_keyword'), array('id'), 
//				" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
			if($this->db->numRows($recordset))
			{
				$updateArray['keywords'] = array_shift($values);
				$this->db->update('WKX_resource_keyword', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
			}
			else
			{
				$fields[] = "id";
				$values[] = $resourceId;
				$this->db->insert('WKX_resource_keyword', $fields, $values);
			}
		}
// remove keyword(s) if they no longer have resource attached to them
		if(!empty($checkKIds))
			$keyword->removeHanging2(join(",", $checkKIds));
		return $mywikindx->chooseDisplay($this->success->text("addResourceToKeyword"));
	}
// Add selected resources to categories - display form for this.
	function addToCategoryInit()
	{
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/html/HTML.php");
		$html = new HTML();
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$categories = $group->grabAll();
		$this->template->setVar('heading', $this->messages->text("heading", "addToCategory"));
		$pString = FORM::formHeader("addResourceToCategory");
		$pString .= FORM::hidden("method", "add");
		if(array_key_exists("addAll", $this->vars))
			$pString .= FORM::hidden("addAll", "on");
		foreach($this->vars as $key => $value)
		{
			if(strstr($key, "bib_"))
				$pString .= FORM::hidden($key, "on");
		}
		$checkBox = $this->messages->text("resources", "addToExistingCategory") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "replaceExisting");
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($string = $this->session->getVar("resourceAddToCategories"))
		{
			$selectedArray = explode(",", $string);
			$pString .= TABLE::td(FORM::selectedBoxValueMultiple(FALSE, "categories", $categories, 
				$selectedArray, 10) . 
				MISC::br() . $this->messages->text("hint", "multiples") . 
				MISC::p($checkBox) . MISC::p(FORM::formSubmit("Add")));
		}
		else
			$pString .= TABLE::td(FORM::selectFBoxValueMultiple(FALSE, "categories", $categories, 10) . 
				MISC::br() . $this->messages->text("hint", "multiples") . 
				MISC::p($checkBox) . 
				MISC::p(FORM::formSubmit("Add")));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add selected resources to keywords - display form for this.
	function addToKeywordInit()
	{
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/html/HTML.php");
		$html = new HTML();
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$keywords = $keyword->grabAll();
		$this->template->setVar('heading', $this->messages->text("heading", "addToKeyword"));
		$pString = FORM::formHeader("addResourceToKeyword");
		$pString .= FORM::hidden("method", "add");
		if(array_key_exists("addAll", $this->vars))
			$pString .= FORM::hidden("addAll", "on");
		foreach($this->vars as $key => $value)
		{
			if(strstr($key, "bib_"))
				$pString .= FORM::hidden($key, "on");
		}
		$checkBox = $this->messages->text("resources", "addToExistingKeyword") . "&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "replaceExisting");
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($string = $this->session->getVar("resourceAddToKeywords"))
		{
			$selectedArray = explode(",", $string);
			$pString .= TABLE::td(FORM::selectedBoxValueMultiple(FALSE, "keywords", $keywords, 
				$selectedArray, 10) . 
				MISC::br() . $this->messages->text("hint", "multiples") . 
				MISC::p($checkBox) . MISC::p(FORM::formSubmit("Add")));
		}
		else
			$pString .= TABLE::td(FORM::selectFBoxValueMultiple(FALSE, "keywords", $keywords, 10) . 
				MISC::br() . $this->messages->text("hint", "multiples") . 
				MISC::p($checkBox) . MISC::p(FORM::formSubmit("Add")));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// in multi user mode, handle the display of different bibliographies. 
// This is called from list, search and select process methods
	function addToUserBibInit()
	{
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/html/HTML.php");
		$html = new HTML();
		$usingBib = $pString = FALSE;
		$useBib = $this->session->getVar('mywikindx_bibliography_use');
		if($useBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
			$row = $this->db->fetchRow($recordset);
			$usingBib = $row['title'];
		}
		if($this->session->getVar('mywikindx_bibliographies'))
		{
			$bibs = unserialize($this->session->getVar("mywikindx_bibliographies"));
// remove currently in use bibliography - if we're browsing it, all resources shown are already part of that bibliography
// if mywikindx_bibliography_use is not in mywikindx_bibliographies, this is another user's bibliography we are browsing - 
// if so, do not remove it as we might like to add to our own bibliography from it.
			if($useBib)
			{
				if(array_key_exists($useBib, $bibs))
				{
					$usingBib = $bibs[$useBib];
					unset($bibs[$useBib]);
				}
			}
			if(!empty($bibs))
			{
				$this->template->setVar('heading', $this->messages->text("heading", "addToBib"));
				$pString = FORM::formHeader("myWikindxBibliography");
				$pString .= FORM::hidden("method", "add");
				if(array_key_exists("addAll", $this->vars))
					$pString .= FORM::hidden("addAll", "on");
				foreach($this->vars as $key => $value)
				{
					if(strstr($key, "bib_"))
						$pString .= FORM::hidden($key, "on");
				}
				$pString .= TABLE::tableStart();
				$pString .= TABLE::trStart();
				$sessVar = $this->session->getVar("mywikindx_bibliography_add");
				if($sessVar)
					$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, "bibId", $bibs, $sessVar, 3) . 
						MISC::p(FORM::formSubmit("Add")));
				else
					$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, 
						"bibId", $bibs, 3) . MISC::p(FORM::formSubmit("Add")));
				$pString .= TABLE::trEnd();
				$pString .= TABLE::tableEnd();
			}
		}
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// failure - bomb out
	function failure($error)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "resources"));
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
