<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Publisher Map class.
*	Provides mappings between resource types and publisher types.  Allows for displaying only certain 
*	publishers appropriate to the resource type when entering a new resource.
*
*	$Header: /cvsroot/wikindx/wikindx3/core/publisher/PUBLISHERMAP.php,v 1.5 2005/02/27 19:11:31 sirfragalot Exp $
*****/
class PUBLISHERMAP
{
/*
* Constructor
*
* @author Mark Grimshaw
* @version 1
*/
	function PUBLISHERMAP()
	{
		$this->loadMap();
	}
/*
* @author Mark Grimshaw
* @version 1
*/
	function loadMap()
	{
		$this->publisherTypes = array(
				'book'				=>	'book',
				'book_article'			=>	'book',
				'software'			=>	'book',
				'artwork'			=>	'book',
				'audiovisual'			=>	'book',
				'report'			=>	'book',
				'database'			=>	'book',
				'thesis'			=>	'institution',
				'unpublished'			=>	'institution',
				'broadcast'			=>	'distributor',
				'film'				=>	'distributor',
				'case'				=>	'legal',
				'legal_ruling'			=>	'legal',
				'bill'				=>	'legal',
				'government_report'		=>	'legal',
				'hearing'			=>	'legal',
				'patent'			=>	'legal',
				'conference_paper'		=>	'conference',
				'proceedings_article'		=>	'conference',
				'proceedings'			=>	'conference',
				'map'				=>	'chart',
				'chart'				=>	'chart',
				'music_album'			=>	'music',
				'music_track'			=>	'music',
				'music_score'			=>	'music',
			);
	}
}
?>
