<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Publisher class.
*
*	$Header: /cvsroot/wikindx/wikindx3/core/publisher/PUBLISHER.php,v 1.11 2005/06/11 01:46:49 sirfragalot Exp $
*****/
class PUBLISHER
{
// Constructor
	function PUBLISHER($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/publisher/PUBLISHERMAP.php");
		$this->map = new PUBLISHERMAP();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/html/CLOSE.php");
	}
// Get publishers from WKX_publisher.  Return associative array of id => type
	function grabAll($type = FALSE, $userBib = FALSE)
	{
		if($type)
			$condition[] = " (" . $this->db->formatField('publisherType') . "=" . 
			$this->db->tidyInput($this->map->publisherTypes[$type]) . 
			" OR " . $this->db->formatField('publisherType') . "IS NULL)";
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			$condition[] = " (WKX_resource_misc.id = " . 
				implode(" OR WKX_resource_misc.id = ", $bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_publisher'), array(array('WKX_publisher.id' => 'id'), 
				"publisherName", "publisherLocation"));
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_misc") . " ON " . 
				$this->db->formatfield("WKX_publisher.id") . "=" . $this->db->formatfield("publisher");
			$sql .= $join;
		}
		else
			$sql = $this->db->selectNoExecute(array("WKX_publisher"), 
			array("id", "publisherName", "publisherLocation"));
		if(isset($condition))
			$condition = " WHERE " . join(" AND ", $condition);
		else
			$condition = FALSE;
		$sql .= $condition . " ORDER BY " . $this->db->tidyInputClause("publisherName");
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['publisherLocation'])
				$publishers[$row['id']] = $this->html->dbToFormTidy($row['publisherName'] . 
				": " . $row['publisherLocation']);
			else
				$publishers[$row['id']] = $this->html->dbToFormTidy($row['publisherName']);
		}
		if(isset($publishers))
			return $publishers;
		return FALSE;
	}
// Get conference organisers from WKX_publisher.  Return associative array of id => type
	function grabAllConfOrganisers($userBib = FALSE)
	{
		$condition[] = " (" . $this->db->formatField('publisherType') . "=" . 
			$this->db->tidyInput('conference') . 
			" AND " . $this->db->formatField('WKX_resource_misc.publisher') . "=" . 
			$this->db->formatField('WKX_publisher.id') . ")";
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			$condition[] = " (WKX_resource_misc.id = " . 
				implode(" OR WKX_resource_misc.id = ", $bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_publisher'), array(array('WKX_publisher.id' => 'id'), 
				"publisherName", "publisherLocation"));
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_misc") . " ON " . 
				$this->db->formatfield("WKX_publisher.id") . "=" . $this->db->formatfield("publisher");
			$sql .= $join;
		}
		else
			$sql = $this->db->selectNoExecute(array("WKX_publisher", "WKX_resource_misc"), 
			array(array('WKX_publisher.id' => 'id'), "publisherName", "publisherLocation"));
		if(isset($condition))
			$condition = " WHERE " . join(" AND ", $condition);
		else
			$condition = FALSE;
		$sql .= $condition . " ORDER BY " . $this->db->tidyInputClause("publisherName");
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['publisherLocation'])
				$publishers[$row['id']] = $this->html->dbToFormTidy($row['publisherName'] . 
				": " . $row['publisherLocation']);
			else
				$publishers[$row['id']] = $this->html->dbToFormTidy($row['publisherName']);
		}
		if(isset($publishers))
			return $publishers;
		return FALSE;
	}
// return a SQL condition clause when selecting by publisher
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['publisher']);
		foreach($selectArray as $key => $value)
			$conditionArray[] = $this->db->formatfield('publisher') . "=" . $this->db->tidyInput($value);
		$condition .= implode(" " . $input['publisherMethod'] . " ", $conditionArray);
		
		return $condition;
	}
// write to WKX_publisher
	function writePublisherTable($sessionVars, $id = FALSE, $confPublisher = FALSE)
	{
		$type = $sessionVars['type'];
		if(array_key_exists('publisher_id', $sessionVars) && !$confPublisher)
		{
// If $type == 'miscellaneous', we set `publisherType` to NULL so that this publisher is available in all lists
			if($type == 'miscellaneous')
				$this->db->updateNull('WKX_publisher', array('publisherType'), 
					" WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($sessionVars['publisher_id']));
			return $sessionVars['publisher_id'];
		}
		if(array_key_exists('confPublisher_id', $sessionVars) && $confPublisher)
		{
// If $type == 'miscellaneous', we set `publisherType` to NULL so that this publisher is available in all lists
			if($type == 'miscellaneous')
				$this->db->updateNull('WKX_publisher', array('publisherType'), 
					" WHERE " . $this->db->formatField('id') . "=" . 
					$this->db->tidyInput($sessionVars['confPublisher_id']));
			return $sessionVars['confPublisher_id'];
		}
		if($confPublisher)
		{
			$name = array_key_exists('confPublisherName', $sessionVars) ? 
				stripslashes($this->html->removeNl($sessionVars['confPublisherName'])) : FALSE;
			$location = array_key_exists('confPublisherLocation', $sessionVars) ? 
				stripslashes($this->html->removeNl($sessionVars['confPublisherLocation'])) : FALSE;
		}
		else
		{
			$name = array_key_exists('publisherName', $sessionVars) ? 
				stripslashes($this->html->removeNl($sessionVars['publisherName'])) : FALSE;
			$location = array_key_exists('publisherLocation', $sessionVars) ? 
				stripslashes($this->html->removeNl($sessionVars['publisherLocation'])) : FALSE;
		}
		$publisherType = array_key_exists($type, $this->map->publisherTypes) ? 
			$this->map->publisherTypes[$type] : FALSE;
		if(!$name && !$location)
			return FALSE;
// If publisher type in database does not match this resource type, set publisherType to NULL so publisher
// is available in all lists.
		list($id, $publisherTypeDB) = $this->checkExists($name, $location);
		if($id && $publisherTypeDB)
		{
			if(($type == 'miscellaneous') || ($publisherType != $publisherTypeDB))
				$this->db->updateNull('WKX_publisher', array('publisherType'), 
					" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
			return $id;
		}
// publisher not yet in db, so write to db.
		if($name)
		{
			$fields[] = "publisherName";
			$values[] = $name;
		}
		if($location)
		{
			$fields[] = "publisherLocation";
			$values[] = $location;
		}
		if($publisherType)
		{
			$fields[] = "publisherType";
			$values[] = $publisherType;
		}
		if(!isset($fields))
			return FALSE;
		$this->db->insert('WKX_publisher', $fields, $values);
		return $this->db->lastAutoId('WKX_publisher');
	}
// check to see if publisher name: location already exists
	function checkExists($name, $location)
	{
		if($name)
			$conditions[] = "LOWER(" . $this->db->formatField('publisherName') . ")=" . 
				$this->db->tidyInput(strtolower($name));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('publisherName') . ") IS NULL";
		if($location)
			$conditions[] = "LOWER(" . $this->db->formatField('publisherLocation') . ")=" . 
				$this->db->tidyInput(strtolower($location));
		else
			$conditions[] = "LOWER(" . $this->db->formatField('publisherLocation') . ") IS NULL";
		$condition = " WHERE " . implode(" AND ", $conditions);
		$recordset = $this->db->select(array('WKX_publisher'), array('id', 'publisherType'), $condition);
		if($this->db->numRows($recordset))
		{
			$row = $this->db->fetchRow($recordset);
			return array($row['id'], $row['publisherType']);
		}
		return FALSE;
	}
// Remove resource-less publisher
	function removeHanging($id = FALSE)
	{
		if($id)
		{
			$recordset = $this->db->select(array('WKX_resource_misc'), 
				array('id'), 
				" WHERE " . $this->db->formatField('publisher') . " = $id");
			if(!$this->db->numRows($recordset))
				$this->db->delete('WKX_publisher', " WHERE " . $this->db->formatField('id') . "=" . $id);
		}
		else
		{
			$recordset = $this->db->select(array('WKX_publisher'), array('id'));
			while($row = $this->db->loopRecordSet($recordset))
				$publisherIds[] = $row['id'];
			$recordset = $this->db->select(array('WKX_resource_misc'), array("publisher"));
			while($row = $this->db->loopRecordSet($recordset))
			{
				if($row['publisher'])
					$miscPublisherIds[] = $row['publisher'];
			}
			if(isset($publisherIds))
			{
				$deleteIds = isset($miscPublisherIds) ? 
					array_diff($publisherIds, $miscPublisherIds) :
					$publisherIds;
				foreach($deleteIds as $id)
					$this->db->delete('WKX_publisher', 
					" WHERE " . $this->db->formatField('id') . "=" . $id);
			}
		}
		$this->db->optimize('WKX_publisher');
	}
// Remove resource-less publisher - deals with updating type proceedings_article which can have 2 'publishers'
	function removeHangingSpecial()
	{
		$recordset = $this->db->select(array('WKX_publisher'), array('id'));
		while($row = $this->db->loopRecordSet($recordset))
			$publisherIds[] = $row['id'];
		$recordset = $this->db->select(array('WKX_resource_misc'), array("publisher", "miscField1"));
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['publisher'])
				$miscPublisherIds[] = $row['publisher'];
			if($row['miscField1'])
				$miscPublisherIds[] = $row['miscField1'];
		}
		if(isset($publisherIds))
		{
			$deleteIds = isset($miscPublisherIds) ? 
				array_diff($publisherIds, $miscPublisherIds) :$publisherIds;
			foreach($deleteIds as $id)
				$this->db->delete('WKX_publisher', " WHERE " . $this->db->formatField('id') . "=" . $id);
		}
		$this->db->optimize('WKX_publisher');
	}
// display the list of publishers:
	function editDisplay($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "publisher") . ")"));
		$pString = $message ? $message : FALSE;
		$creators = $this->grabAll();
		if(!$creators)
		{
			$this->template->setVar('body', $this->messages->text("misc", "noPublishers"));
			return $this->template->process();
		}
		$pString .= FORM::formHeader("editPublisher");
		$pString .= FORM::selectFBoxValue(FALSE, "edit_publisherId", $creators, 20);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display the editing form:
	function editDisplayPublisher()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "publisher") . ")"));
		$this->checkInput1();
		$sessionVars = $this->fromDbToSession($this->vars['edit_publisherId']);
		$pString = FORM::formHeader("editPublisher");
		$pString .= FORM::hidden("edit_publisherId", $this->vars['edit_publisherId']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("publisher", $sessionVars) ? $sessionVars["publisher"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "publisher"), 
			"edit_publisher", $text, 30, 255) . " " . MISC::span('*', 'required'));
		$text = array_key_exists("location", $sessionVars) ? $sessionVars["location"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "publisherLocation"), 
			"edit_location", $text, 30, 255));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('editPublisherLock'))
			$this->badInput($this->errors->text("done", "publisher"));
		$this->checkInput2();
		$fields[] = 'publisherName';
		$values[] = $this->vars['edit_publisher'];
		if(trim($this->vars['edit_location']))
		{
			$fields[] = 'publisherLocation';
			$values[] = $this->vars['edit_location'];
		}
		else
			$nulls[] = 'publisherLocation';
		foreach($fields as $field)
			$updateArray[$field] = array_shift($values);
		if($publisherExistArray = $this->checkExists(trim($this->vars['edit_publisher']), 
			trim($this->vars['edit_location'])))
		{
			$publisherExistId = $publisherExistArray[0];
			if($publisherExistId != $this->vars['edit_publisherId'])
				return $this->confirmDuplicate($publisherExistId, $this->vars['edit_publisher'], 
					$this->vars['edit_location']);
		}
		$this->db->update('WKX_publisher', $updateArray, 
			"WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($this->vars['edit_publisherId']));
// set to NULL empty location field
		if(isset($nulls) && !empty($nulls))
			$this->db->updateNull('WKX_publisher', $nulls, 
				" WHERE " . $this->db->formatField('id') . "=" . 
				$this->db->tidyInput($this->vars['edit_publisherId']));
// lock reload
		$this->session->setVar('editPublisherLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("publisher")));
	}
/**
* The new name equals one already in the database. Confirm that this edited one is to be removed and 
* all references to it replaced by the existing one.
*/
	function confirmDuplicate($publisherExistId, $name, $location)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "publisher") . ")"));
		$pString = $this->errors->text("warning", "publisherExists");
		$pString .= MISC::p($this->messages->text("misc", "publisherExists"));
		$pString .= FORM::formHeader("editPublisherConfirm");
		$pString .= FORM::hidden("edit_publisherId", $this->vars['edit_publisherId']);
		$pString .= FORM::hidden("edit_publisherExistId", $publisherExistId);
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database.
	function editConfirm()
	{
		if($this->session->getVar('editPublisherLock'))
			$this->badInput($this->errors->text("done", "publisher"));
		$editId = $this->vars['edit_publisherId'];
		$existId = $this->vars['edit_publisherExistId'];
// Delete old publisher
		$this->db->delete("WKX_publisher", "WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($editId));
// Select all resources referencing this old publisher and replace reference with existing publisher.
// NB - proceedings_article has two publishers - publisher + conf. organiser
		$sql = $this->db->selectNoExecute(array("WKX_resource_misc"), 
			array(array("WKX_resource.id" => 'resourceId'), 'type'), 
			" LEFT JOIN " . $this->db->formatTable('WKX_resource') . " ON " . 
			$this->db->formatField('WKX_resource.id') . "=" . 
			$this->db->formatField('WKX_resource_misc.id') .
			" WHERE " . $this->db->formatField('publisher') . "=" . $this->db->tidyInput($editId) . 
			" OR " . 
			"(" . $this->db->formatfield('type') . "=" . $this->db->tidyInput('proceedings_article') . 
			" AND " . $this->db->formatField('miscField1') . "=" . $this->db->tidyInput($editId) . 
			")"
			);
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			if($row['type'] == 'proceedings_article')
				$this->db->update('WKX_resource_misc', array('miscField1' => $existId), 
						"WHERE " . $this->db->formatField('id') . "=" . 
						$this->db->tidyInput($row['resourceId']));
			else
				$this->db->update('WKX_resource_misc', array('publisher' => $existId), 
						"WHERE " . $this->db->formatField('id') . "=" . 
						$this->db->tidyInput($row['resourceId']));
		}
// lock reload
		$this->session->setVar('editPublisherLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("publisher")));
	}
// from database to session
	function fromDbToSession($id)
	{
		$recordset = $this->db->select(array('WKX_publisher'), array("publisherName", "publisherLocation"), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
		$row = $this->db->fetchRow($recordset);
		if($row['publisherLocation'])
			$this->session->setVar("edit_location", $this->html->dbToFormTidy($row['publisherLocation']));
		$this->session->setVar("edit_publisher", $this->html->dbToFormTidy($row['publisherName']));
		return $this->session->getArray("edit");
	}
// Check we have appropriate input
	function checkInput1()
	{
		if(!array_key_exists('edit_publisherId', $this->vars) || !$this->vars['edit_publisherId'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Check we have appropriate input
	function checkInput2()
	{
		if(!array_key_exists('edit_publisherId', $this->vars) || !$this->vars['edit_publisherId'])
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!array_key_exists('edit_publisher', $this->vars) || !trim($this->vars['edit_publisher']))
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Error handling - send them back to view creator list.
	function badInput($error)
	{
		new CLOSE($this->db, $this->editDisplay($error));
	}
}
?>
