<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* PREFERENCES class
*
* User preferences
*****/
class PREFERENCES
{
// Constructor
	function PREFERENCES($db)
	{
		$this->db = $db;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// display options
	function display($error = FALSE)
	{
		include("config.php");
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		$pString = FORM::formHeader('preferencesWrite');
		if($error)
		{
			$pString .= $error;
// As language may have changed, we create a new MESSAGES and SUCCESS object.
			$this->messages = new MESSAGES();
		}
		$this->template->setVar('heading', $this->messages->text("heading", "preferences"));
		$pString .= MISC::p(FORM::textInput($this->messages->text("config", "paging"), "paging", 
			$this->session->getVar("setup_paging"), 5) . " " . MISC::span('*', 'required') . MISC::br() . 
			$this->messages->text("hint", "pagingLimit"));
		$pString .= MISC::p(FORM::textInput($this->messages->text("config", "maxPaging"), "pagingMaxLinks", 
			$this->session->getVar("setup_pagingMaxLinks"), 5) . " " . MISC::span('*', 'required'));
		$pString .= MISC::p(FORM::textInput($this->messages->text("config", "stringLimit"), "stringLimit", 
			$this->session->getVar("setup_stringLimit"), 5) . " " . MISC::span('*', 'required') . MISC::br() . 
			$this->messages->text("hint", "pagingLimit"));
		$templates = TEMPLATE::loadDir();
		$pString .= MISC::p(FORM::selectedBoxValue($this->messages->text("config", "template"), 
				"template", $templates, $this->session->getVar("setup_template"), 4)
				 . " " . MISC::span('*', 'required'));
		include_once("core/messages/LOADLANGUAGE.php");
		$languages = LOADLANGUAGE::loadDir();
		$pString .= MISC::p(FORM::selectedBoxValue($this->messages->text("config", "language"), 
				"language", $languages, $this->session->getVar("setup_language")) 
				 . " " . MISC::span('*', 'required'));
		include_once("core/styles/LOADSTYLE.php");
		$styles = LOADSTYLE::loadDir("styles/bibliography");
		$pString .= MISC::p(FORM::selectedBoxValue($this->messages->text("config", "style") , "style", 
			$styles, $this->session->getVar("setup_style"), 4) . " " . MISC::span('*', 'required'));
		
		$pString .= MISC::p(FORM::formSubmit(), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write preferences
	function write($vars)
	{
// checkInput writes the session
		$this->checkInput($vars);
// If this is a logged on user, write preferences to WKX_user_preferences
		if($userId = $this->session->getVar("setup_userId"))
		{
			include_once("core/user/USER.php");
			$user = new USER($this->db);
			$user->writePreferences($userId);
		}
// As template may have changed, create new template object.
		$this->template = new TEMPLATE('content');
// As language may have changed, we create a new SUCCESS object.
		$success = NEW SUCCESS();
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($success->text("config")));
	}
// Check input
	function checkInput($vars)
	{
		include_once("core/html/MISC.php");
		include_once("core/init/SYSTEMCHECK.php");
// Store in session first and remove unrequired session variables
		include_once("core/session/SESSION.php");
		$session = new SESSION();
		$required = array("language", "template", "style", "paging", "pagingMaxLinks", "stringLimit",);
		foreach($required as $key)
		{
			if(array_key_exists($key, $vars))
				$array[$key] = $vars[$key];
                         else
				$session->delVar("preferences_" . $key);
		}
		if(isset($array))
			$session->writeArray($array, "preferences");
		foreach($required as $value)
		{
			if(!array_key_exists($value, $vars) || !$vars[$value])
				$this->badInput($this->errors->text("inputError", "missing", " ($value) "));
		}
		if(!is_numeric($vars['paging']))
			$this->badInput($this->errors->text("inputError", "nan", " (paging) "));
		if(!is_numeric($vars['pagingMaxLinks']))
			$this->badInput($this->errors->text("inputError", "nan", " (pagingMaxLinks) "));
		if(!is_numeric($vars['stringLimit']))
			$this->badInput($this->errors->text("inputError", "nan", " (stringLimit) "));
// All input good - write to session
		$session->writeArray($array, "setup");
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($error));
	}
}
?>
