<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Resource PAGING class
*****/
class PAGING
{
// Constructor
	function PAGING($db, $vars, $sqlTotal)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
//		$recordset = $this->db->query($sqlTotal);
//		$this->total = $this->db->numRows($recordset);
		if(array_key_exists('pagingStart', $this->vars))
		{
			$this->session->setVar('mywikindx_pagingStart', $this->vars['pagingStart']);
			$this->start = $this->vars['pagingStart'];
		}
		else
		{
//			$this->session->setVar('mywikindx_pagingStart', 0);
			if($start = $this->session->getVar('mywikindx_pagingStart'))
				$this->start = $start;
			else
				$this->start = 0;
		}
// Grab all resource IDs in query and write to session for use in 'previous' and 'next' links 
// when viewing a single resource.  Only need to do this if this is a different list operation.
//		if(stripslashes($this->session->getVar('sql_stmt')) != $sqlTotal)
//		{
			$recordset = $this->db->query($sqlTotal);
			$this->total = $this->db->numRows($recordset);
			while($row = $this->db->loopRecordSet($recordset))
				$allIds[] = $row['resourceId'];
			if(isset($allIds))
				$this->session->setVar('list_allIds', base64_encode(serialize($allIds)));
			else
				$this->session->delVar("list_allIds");
//		}
		$this->getPaging();
	}
// grab paging either from default or from session
	function getPaging()
	{
		$this->paging = $this->session->getVar('setup_paging');
		$this->maxLinks = $this->session->getVar('setup_pagingMaxLinks');
		$this->maxLinksHalf = round($this->maxLinks/2);
	}
// get where to start display from
	function getPagingStart()
	{
		if(!array_key_exists('pagingStart', $this->vars))
		{
			if($start = $this->session->getVar('mywikindx_pagingStart'))
				return $start;
			else
				return 0;
		}
		else
		{
			$this->session->setVar('mywikindx_pagingStart', $this->vars['pagingStart']);
			return $this->vars['pagingStart'];
		}
	}
// format SQL LIMIT clause
	function sqlLimit($sqlTotal)
	{
// Has the paging limit been overriden in user preferences for this selection?
		if($this->paging == -1)
			return FALSE;
		return $this->db->limit($sqlTotal, $this->paging, $this->getPagingStart());
	}
// Links at bottom of display screens to move to more resources.
// $this->total is total resources found for this operation.
// $this->start is where we currently are.
	function links($queryString)
	{
		if(($this->paging <= 0) || ($this->total <= $this->paging))
			return;
		include_once("core/html/MISC.php");
		$end = $advanced = 0;
		$index = $maxLinks = 1;
		$advance = $this->start;
		while($advance >= (($this->maxLinksHalf * $this->paging) - $this->paging))
		{
			$end += $this->paging;
			$index += $this->paging;
			$advance -= $this->paging;
			$advanced++;
		}
		if($advanced)
		{
			$links[] = MISC::a("page", $this->messages->text("resources", "pagingStart"), 
				"index.php?" . htmlentities($queryString . "&pagingStart=0"));
			$maxLinks++;
		}
		while($index <= $this->total)
		{
			if($maxLinks++ >= $this->maxLinks)
				break;
			$end += $this->paging;
			if($end > $this->total)
				$end = $this->total;
			$start = $index - 1;
			$link = htmlentities($queryString . "&pagingStart=$start");
			$name = $index . " - " . $end;
			if($this->start == $start)
				$links[] = $name;
			else
				$links[] = MISC::a("page", $name, "index.php?" . $link);
			$index += $this->paging;
		}
		if($end < $this->total)
		{
			if($this->start && sizeof($links) == 1)
			{
				$links = array(MISC::a("page", $this->messages->text("resources", "pagingStart"), 
					"index.php?" . htmlentities($queryString . "&pagingStart=0")));
			}
			else if (sizeof($links) > 1)
			{
				$start = $this->total - ($this->total % $this->paging);
				if($start == $this->total)
					$start = $this->total - $this->paging;
				$links[] = MISC::a("page", $this->messages->text("resources", "pagingEnd"), 
					"index.php?" . htmlentities($queryString . "&pagingStart=$start"));
			}
		}
		return implode("&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;", $links);
	}
// Format display information string
	function linksInfo($bibTitle = FALSE)
	{
		if(!$this->total)
			return $this->messages->text("resources", "noResult");
		$displayEnd = $this->start + $this->paging;
		if(($this->paging <= 0) || ($displayEnd > $this->total))
			$displayEnd = $this->total;
		$displayStart = $this->start + 1;
		$bib = FALSE;
		if($bibTitle)
			$bib = " (" . $this->messages->text("user", "bibliography") . ": " . $bibTitle . ")";
		else if($this->session->getVar('setup_multiUser'))
			$bib = " (" . $this->messages->text("user", "bibliography") . ": " . 
				$this->messages->text("user", "masterBib") . ")";
		return $this->messages->text("hint", "pagingInfo", 
			" $displayStart - $displayEnd of " . $this->total . $bib);
	}
}
?>
