<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	NOTIFY class.
*
*	Email notification of resource changes
*****/
class NOTIFY
{
// Constructor
	function NOTIFY($db)
	{
		$this->db = $db;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
	}
// Send email
	function email($resourceId, $newResource = FALSE)
	{
// do nothing if admin does not allow notification
		if(!$this->session->getVar('setup_notify'))
			return;
		$userId = $this->session->getVar('setup_userId');
// Get this user's name (the user adding/editing a resource)
		include_once("core/user/USER.php");
		$user = new USER($this->db);
		$userAddEdit = $user->displayUserAddEditPlain($userId);
// Are there any users wanting notification?
		$recordset = $this->db->select(array('WKX_users'), array('id', 'email', 'notify', 'notifyAddEdit'), 
			"WHERE id != " . $this->db->tidyInput($userId) . 
			" AND " . $this->db->formatField('notify') . "!=" . $this->db->tidyInput('N'));
		if(!$this->db->numRows($recordset)) // nothing to do
			return;
// Grab resource details
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, 'plain');
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$array = array();
		$sql = $this->db->selectNoExecute(array("WKX_resource"), array_merge($stmt->listFields(), $array), 
			$stmt->selectJoin());
		$sql .= " WHERE WKX_resource.id=" . $this->db->tidyInput($resourceId);
		$recordset2 = $this->db->query($sql);
		$row = $this->db->fetchRow($recordset2);
// Data stored in database as UTF-8
		$title = utf8_decode($bibStyle->process($row));
		$wikindxTitle = $this->session->getVar("setup_title");
		if(!$wikindxTitle)
			$wikindxTitle = "WIKINDX";
		$subject = "$wikindxTitle Resource Notification";
		$message = $this->messages->text("user", "notify", $userAddEdit) . "\n\n$title\n";
		$headers = "From: WIKINDX\n";
		$headers .= "Reply-to: noReply\n";
		while($row = $this->db->loopRecordset($recordset))
		{
// User wants notification only on new resources
			if(($row['notifyAddEdit'] == 'N') && !$newResource)
				continue;
// User wants notification only on edited resources
			if(($row['notifyAddEdit'] == 'E') && $newResource)
				continue;
			if(!$row['email']) // This should only happen if superadmin has not entered email
				continue;
			$email = $row['email'];
			if($row['notify'] == 'A') // notify on all resources
// We're not concerned about failure
				@mail($email, $subject, $message, $headers);
			else if($row['notify'] == 'M') // notify on resources in a user's bibliography
			{
				$recordset2 = $this->db->select(array('WKX_user_bibliography'), array('id'), 
					" WHERE " . $this->db->formatField('userId') . '=' . 
					$this->db->tidyInput($row['id']) . 
					" AND FIND_IN_SET(" . $this->db->tidyInput($resourceId) . ", " . 
					$this->db->formatField('bibliography') . ")");
				if(!$this->db->numRows($recordset2)) // This resource not in user's bibliography
					continue;
// We're not concerned about failure
				@mail($email, $subject, $message, $headers);
			}
		}
	}
}
?>
