<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	NEWS class.
*
*	Email notification of resource changes
*****/
class NEWS
{
// Constructor
	function NEWS($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// Only an admin can add news
	function gatekeep($method = FALSE)
	{
		if(!$this->session->getVar('setup_superadmin') || !$method)
		{
			$authorize = new AUTHORIZE($this->db);
			if($pString = $authorize->initLogon())
				return $pString;
		}
		return $this->$method();
// else, proceed
	}
// display for adminstering news
	function initAdmin($message = FALSE)
	{
		$this->news = $this->grabAll();
		$this->template->setVar("heading", $this->messages->text("heading", "news"));
		$pString = '';
		if($message)
			$pString .= MISC::p($message);
		$pString .= MISC::p(MISC::a("link", $this->messages->text("news", "addNews"), 
			"index.php?action=newsAddInit"));
		if(is_array($this->news))
		{
			$pString .= MISC::p(MISC::a("link", $this->messages->text("news", "deleteNews"), 
				"index.php?action=newsDeleteInit"));
			$pString .= MISC::p(MISC::a("link", $this->messages->text("news", "editNews"), 
				"index.php?action=newsEditInit"));
		}
		else // no news anymore so make sure 'View news' item does not appear in File menu
			$this->session->delVar('setup_news');
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add a news item - display options.
	function initNewsAdd($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
			" (" . $this->messages->text("news", "addNews") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("newsAdd");
		$sessVar = $this->session->issetVar("news_title") ? 
			$this->html->dbToHtmlTidy($this->session->getVar("news_title")) : FALSE;
		$pString .= FORM::textInput($this->messages->text("news", "title"), "title", $sessVar, 30, 255);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$sessVar = $this->session->issetVar("news_body") ? 
			$this->html->dbToHtmlTidy($this->session->getVar("news_body")) : FALSE;
		$pString .= FORM::textAreaInput($this->messages->text("news", "body"), "body", $sessVar, 80, 10) . 
			MISC::br() . $this->messages->text("hint", 'format');
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= FORM::formSubmit('Add');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Add a news item
	function add()
	{
		if(!array_key_exists('title', $this->vars) || !trim($this->vars['title']) || 
			!array_key_exists('body', $this->vars) || !trim($this->vars['body']))
		{
			$this->session->setVar("news_title", trim($this->vars['title']));
			$this->session->setVar("news_body", trim($this->vars['body']));
			$this->badInput($this->errors->text("inputError", "invalid"), 'initNewsAdd');
		}
		$pString = $this->success->text("news", " " . $this->messages->text("misc", "added") . " ");
		$title = $this->vars['title'];
		$news = $this->vars['body'];
		$this->db->insert("WKX_news", array('title', 'news', 'timestamp'), 
			array($title, $news, $this->db->formatTimestamp()));
		$this->session->delVar('news_title');
		$this->session->delVar('news_body');
		$this->session->setVar('setup_news', TRUE);
		return $this->initAdmin($pString);
	}
// Delete news display.
	function deleteInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
			" (" . $this->messages->text("news", "deleteNews") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("newsDeleteConfirm");
		$this->news = $this->grabAll();
		foreach($this->news as $key => $value)
			$pString .= FORM::checkbox(FALSE, "newsDelete_" . $key) . " $value" . MISC::br();
		$pString .= MISC::br() . FORM::formSubmit('Delete');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Ask for confirmation of delete groups
	function deleteConfirm()
	{
		foreach($this->vars as $key => $value)
		{
			if(!preg_match("/newsDelete_(.*)/", $key, $match))
				continue;
			$input[] = $match[1];
		}
		if(!isset($input))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
			" (" . $this->messages->text("news", "deleteNews") . ")"));
		$this->news = $this->grabAll();
		$news = "'" . implode("', '", array_keys(array_intersect(array_flip($this->news), $input))) . "'";
		$news = html_entity_decode($news);
		$pString = MISC::p($this->messages->text("news", "deleteConfirm", ": $news"));
		$pString .= FORM::formHeader("newsDelete");
		foreach($input as $id)
			$pString .= FORM::hidden("newsDelete_" . $id, $id);
		$pString .= MISC::br() . FORM::formSubmit('Confirm');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Delete group(s)
	function delete()
	{
		foreach($this->vars as $key => $value)
		{
			if(!preg_match("/newsDelete_(.*)/", $key, $match))
				continue;
			$input[] = $match[1];
		}
		if(!isset($input))
			$this->badInput($this->errors->text("inputError", "invalid"), 'deleteInit');
		foreach($input as $value)
			$this->db->delete('WKX_news', "WHERE " . $this->db->formatfield('id') . "=" . 
				$this->db->tidyInput($value));
		$this->db->optimize('WKX_news');
		$pString = $this->success->text("news", " " . $this->messages->text("misc", "deleted") . " ");
		$this->news = $this->grabAll();
		return $this->initAdmin($pString);
	}
// display news items for editing
	function editInit($error = FALSE)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
		" (" . $this->messages->text("news", "editNews") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$pString .= FORM::formHeader("newsEditDisplay");
		$this->news = $this->grabAll();
		$pString .= FORM::selectFBoxValue(FALSE, "editId", $this->news, 20) . MISC::br() . FORM::formSubmit('Edit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display news item for editing
	function editDisplay($error = FALSE)
	{
		if(array_key_exists("editId", $this->vars))
			$editId = trim($this->vars["editId"]);
		else
			$this->badInput($this->errors->text("inputError", "invalid"), 'editInit');
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
			" (" . $this->messages->text("news", "editNews") . ")"));
		$pString = '';
		if($error)
			$pString .= MISC::p($error, "error", "center");
		$recordset = $this->db->select(array("WKX_news"), array("id", "title", "news"), 
			'WHERE ' . $this->db->formatField('id') . '=' . $this->db->tidyInput($editId));
		$row = $this->db->fetchRow($recordset);
		$pString .= FORM::formHeader("newsEdit");
		$pString .= FORM::hidden('editId', $editId);
		$pString .= FORM::textInput($this->messages->text("news", "title"), "title", 
			$this->html->dbToFormTidy($row['title']), 30, 255);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= FORM::textAreaInput($this->messages->text("news", "body"), "body", 
			$this->html->dbToFormTidy($row['news']), 80, 10) . MISC::br() . $this->messages->text("hint", 'format');
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= FORM::formSubmit('Edit');
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Edit news item
	function edit()
	{
		if(array_key_exists("editId", $this->vars))
			$editId = trim($this->vars["editId"]);
		else
			$this->badInput($this->errors->text("inputError", "invalid"), 'editDisplay');
		if(!array_key_exists('title', $this->vars) || !trim($this->vars['title']) || 
			!array_key_exists('body', $this->vars) || !trim($this->vars['body']))
			$this->badInput($this->errors->text("inputError", "invalid"), 'editDisplay');
		$this->template->setVar("heading", $this->messages->text("heading", "news", 
			" (" . $this->messages->text("news", "editNews") . ")"));
		$updateArray['title'] = $this->vars['title'];
		$updateArray['news'] = $this->vars['body'];
		$updateArray['timestamp'] = $this->db->formatTimestamp();
		$this->db->update('WKX_news', $updateArray, 
			"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($editId));
// Update timestamp
//		$this->db->updateNull('WKX_news', array('timestamp'), 
//			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($editId));
		$pString = $this->success->text("news", " " . $this->messages->text("misc", "edited") . " ");
		$this->news = $this->grabAll();
		return $this->initAdmin($pString);
	}
// View all available news items
	function viewNews()
	{
		$this->news = $this->grabAll();
		$this->template->setVar("heading", $this->messages->text("heading", "news"));
		$pString = '';
		if(is_array($this->news))
		{
			foreach($this->news as $id => $title)
				$pString .= MISC::p(MISC::a("link", $title, "index.php?action=viewNewsItem&amp;id=" . $id));
		}
		else
			$pString .= $this->messages->text("news", "noNews");
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// View one news item
	function viewNewsItem()
	{
		if(array_key_exists("id", $this->vars))
			$id = trim($this->vars["id"]);
		else
			$this->badInput($this->errors->text("inputError", "invalid"), 'viewNews');
		$this->template->setVar("heading", $this->messages->text("heading", "news"));
		$recordset = $this->db->selectWithExceptions(array("WKX_news"), array(
			array($this->db->db->SQLDate('d/M/Y', 'timestamp') => 'timestamp'), 'title', 'news'), 
			'WHERE ' . $this->db->formatField('id') . '=' . $this->db->tidyInput($id));
		$row = $this->db->fetchRow($recordset);
		$pString = MISC::p(MISC::b($this->html->dbToHtmlTidy($row['title'])) . MISC::br() . 
			$row['timestamp']);
		$pString .= MISC::p($this->html->dbToHtmlTidy($row['news']));
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Get news titles and id from WKX_news.  Return associative array of id => title.
	function grabAll()
	{
		$recordset = $this->db->select(array("WKX_news"), array("id", "title", "timestamp"), 
			'ORDER BY ' . $this->db->tidyInputClause('timestamp') . ' DESC');
		while($row = $this->db->loopRecordSet($recordset))
			$news[$row['id']] = $this->html->dbToFormTidy($row['title']);
		if(isset($news))
			return $news;
		return FALSE;
	}
// Error handling
	function badInput($error, $function, $object = FALSE)
	{
		if(!$object)
			$object = $this;
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $object->$function($error));
	}
// failure - bomb out
	function failure($error)
	{
		$this->template->setVar("heading", $this->messages->text("heading", "news"));
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
