<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* SUCCESS class
*
*****/
class SUCCESS
{
// Constructor
	function SUCCESS()
	{
		include_once("core/messages/LOADLANGUAGE.php");
		$language = new LOADLANGUAGE("SUCCESS");
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
		$this->array = $language->loadArray();
	}
// Format and return the success string.
// $extra is an optional string that replaces '###' in the array element value string.
	function text($indexName, $extra = FALSE)
	{
		include_once("core/html/MISC.php");
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
// if message missing from language pack, use default English
		if(!array_key_exists($indexName, $this->array))
		{
			include_once("languages/en/SUCCESS.php");
			$class = "SUCCESS_en";
			$messages = new $class();
			$arrayEnglish = $messages->loadArrays();
			$temp = $arrayEnglish["$indexName"];
//			return MISC::p("The selected message is not available.", "error");
		}
		else
			$temp = $this->array["$indexName"];
// Need to UTF-8 decode $extra as it will have been UTF-8 encoded....
		$pString = $extra ?	preg_replace("/###/", $this->utf8->smartUtf8_decode($extra), $temp) :
					preg_replace("/###/", "", $temp);
//		return MISC::p(htmlspecialchars(utf8_encode($pString), ENT_QUOTES), "success", "center");
		return MISC::p($this->utf8->encodeUtf8($pString), "success", "center");
	}
}
?>
