<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* MESSAGES class
*
*****/
class MESSAGES
{
// Constructor
	function MESSAGES()
	{
		include_once("core/messages/LOADLANGUAGE.php");
		$language = new LOADLANGUAGE("MESSAGES");
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
		$this->array = $language->loadArray();
	}
// Format and return the message string.
// $extra is an optional string that replaces '###' in the array element value string.
	function text($arrayName, $indexName, $extra = FALSE)
	{
		include_once("core/html/MISC.php");
//PHP doesn't like accessing an array element as $this->$arrayName["$indexName"] so copy array to $temp
		if(array_key_exists($arrayName, $this->array))
			$temp = $this->array[$arrayName];
// if message missing from language pack, use default English
		if(!isset($temp) || !array_key_exists($indexName, $temp))
		{
			include_once("languages/en/MESSAGES.php");
			$class = "MESSAGES_en";
			$messages = new $class();
			$arrayEnglish = $messages->loadArrays();
			$temp = $arrayEnglish[$arrayName];
//			return MISC::p("The selected message is not available.", "error");
		}
		$string = $extra ?	preg_replace("/###/", $this->utf8->smartUtf8_decode($extra), $temp["$indexName"]) :
					preg_replace("/###/", "", $temp["$indexName"]);
//		$string = htmlspecialchars($string, ENT_QUOTES);
// Display hints as per the CSS hint class.
		if($arrayName == 'hint')
			$string = MISC::span($string, "hint");
//		return utf8_encode($string);
		return $this->utf8->encodeUtf8($string);
	}
}
?>
