<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* LOADLANGUAGE class
*
*****/
class LOADLANGUAGE
{
// Constructor
	function LOADLANGUAGE($type)
	{
		include_once("core/session/SESSION.php");
		$session = new SESSION();
		if(!$languageDir = $session->getVar("setup_language"))
			$languageDir = "en";
// Sometimes a directory may have been removed but that language is still in the session or database preferences 
// ... fall back to default English.
		if(!is_dir("languages/$languageDir"))
			$languageDir = "en";
		include_once("languages/$languageDir/$type.php");
		$class = $type . "_" . $languageDir;
		$this->class = new $class();
	}
// load language array
	function loadArray()
	{
		return $this->class->loadArrays();
	}
// read languages/ directory for language preferences and check we have a sane environment
	function loadDir()
	{
		$handle = opendir('languages');
		while(FALSE !== ($dir = readdir($handle)))
		{
			if(is_dir('languages/' . $dir) 
				&& file_exists('languages/' . $dir . '/description.txt')
				&& file_exists('languages/' . $dir . '/ABOUT.php')
				&& file_exists('languages/' . $dir . '/CONSTANTS.php')
				&& file_exists('languages/' . $dir . '/ERRORS.php')
				&& file_exists('languages/' . $dir . '/HELP.php')
				&& file_exists('languages/' . $dir . '/HELPIMPORT.php')
				&& file_exists('languages/' . $dir . '/HELPSTYLE.php')
				&& file_exists('languages/' . $dir . '/HELPCONFIG.php')
				&& file_exists('languages/' . $dir . '/MESSAGES.php')
				&& file_exists('languages/' . $dir . '/SUCCESS.php'))
			{
// read one line
				if($fh = fopen('languages/' . $dir . '/description.txt', "r"))
					$string = fgets($fh);
				
				if($string)
					$array[$dir] = $string;
			}
		}
// sort alphabetically on the key
		ksort($array);
		return $array;
	}
}
?>
