<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* SELECTRESOURCES class
*
* Select database resources on a variety of parameters
*****/
class SELECTRESOURCES
{
// Constructor
	function SELECTRESOURCES($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
	}
// display form options
	function display($error = FALSE)
	{
//		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar('heading', $this->messages->text("heading", "select"));
///First check, do we have resources?
		$recordset = $this->db->select(array('WKX_database_summary'), array('totalResources'));
		if(!$this->db->fetchOne($recordset))
		{
			$this->template->setVar('body', $this->messages->text('misc', 'noResources'));
			return $this->template->process();
		}
		$this->userBib = $this->session->getVar("mywikindx_bibliography_use");
		$bib = FALSE;
		if($this->userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->userBib));
			$row = $this->db->fetchRow($recordset);
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
				$row['title'] . ")", "hint"));
		}
		else if($this->session->getVar('setup_multiUser'))
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
			$this->messages->text("user", "masterBib") . ")", "hint"));
		include_once("core/html/MISC.php");
		include_once("core/html/TABLE.php");
		$pString = $error ? $error : FALSE;
		$pString .= $bib;
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$this->grabTypes();
		$pString .= TABLE::td($this->makeFormMultiple("type", $this->type));
// There may not yet be tags in the database.
		$this->grabTags();
		if($this->tag)
			$pString .= TABLE::td($this->makeFormMultiple("tag", $this->tag));
		else
			$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart() . MISC::hr();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$this->grabGroups();
		$pString .= TABLE::td($this->makeFormMultiple("category", $this->group));
// There may not yet be keywords in the database.
		$this->grabKeywords();
		if($this->keyword)
			$pString .= TABLE::td($this->makeFormMultiple("keyword", $this->keyword));
		else
			$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::td($this->userBibs());
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart() . MISC::hr();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$this->grabCreators();
		if($this->creator)
			$pString .= TABLE::td($this->makeFormMultiple("creator", $this->creator));
		else
			$pString .= TABLE::td("&nbsp;");
		$this->grabPublishers();
		if($this->publisher)
			$pString .= TABLE::td($this->makeFormMultiple("publisher", $this->publisher));
		else
			$pString .= TABLE::td("&nbsp;");
		$this->grabCollections();
		if($this->collection)
			$pString .= TABLE::td($this->makeFormMultiple("collection", $this->collection));
		else
			$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// Return select box of user bibliographies for this user if browsing the master bibliography
	function userBibs()
	{
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		if(!$this->session->getVar("mywikindx_bibliographies"))
			return "&nbsp;";
		$bibs = unserialize($this->session->getVar("mywikindx_bibliographies"));
		if($this->userBib)
			unset($bibs[$this->userBib]);
		if(empty($bibs))
			return "&nbsp;";
		$pString = FORM::formHeader("selectProcess");
		$pString .= FORM::hidden("select_method", "bibId");
		$selected = $this->session->getVar("select_bibId");
		if($selected && array_key_exists($selected, $bibs))
			$pString .= FORM::selectedBoxValue($this->messages->text("select", "selectBy", " " . 
			$this->messages->text("select", "notInUserBib")), "select_bibId", $bibs, $selected, 5);
		else
			$pString .= FORM::selectFBoxValue($this->messages->text("select", "selectBy", " " . 
			$this->messages->text("select", "notInUserBib")), "select_bibId", $bibs, 5);
		$pString .= MISC::br() . FORM::formSubmit("Select");
		$pString .= FORM::formEnd();
		return $pString;
	}
// make a self-contained form with a multiple select box
	function makeFormMultiple($type, $array)
	{
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		$pString = FORM::formHeader("selectProcess");
		$pString .= FORM::hidden("select_method", $type);
		if($selected = $this->session->getVar("select_" . $type))
		{
			$selectedArray = explode(",", $selected);
			$pString .= FORM::selectedBoxValueMultiple(
				$this->messages->text("select", "selectBy", " " . 
				$this->messages->text("select", $type)), 
				"select_" . $type, $array, $selectedArray, "5");
		}
		else
			$pString .= FORM::selectFBoxValueMultiple(
				$this->messages->text("select", "selectBy", " " . 
				$this->messages->text("select", $type)), 
				"select_" . $type, $array, "5");
		$pString .= MISC::br() . $this->messages->text("hint", "multiples") . MISC::br();
		if($this->radioButtons)
			$pString .= $this->radioButtons . MISC::br();
		$pString .= FORM::formSubmit("Select");
		$pString .= FORM::formEnd();
		return $pString;
	}
// get types from database.
	function grabTypes()
	{
		include_once("core/resource/RESOURCEMAP.php");
		$resourceMap = new RESOURCEMAP();
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
		foreach($resourceMap->types as $key)
			$this->type[$key] = $this->utf8->encodeUtf8($this->messages->text("resourceType", $key));
		$this->radioButtons = FALSE;
	}
// get tags from database.
	function grabTags()
	{
		include_once("core/file/TAG.php");
		$tag = new TAG($this->db);
		$this->tag = $tag->grabAll();
		$this->radioButtons = FALSE;
	}
// get groups from database.
	function grabGroups()
	{
		include_once("core/html/FORM.php");
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$this->group = $group->grabAll();
		$this->makeRadioButtons('category');
	}
// get keywords from database.
	function grabKeywords()
	{
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$this->keyword = $keyword->grabAll($this->userBib);
		$this->makeRadioButtons('keyword');
	}
// get creators from database.
	function grabCreators()
	{
		include_once("core/html/FORM.php");
		include_once("core/creator/CREATOR.php");
		$creator = new CREATOR($this->db);
		$this->creator = $creator->grabAll($this->userBib);
		$this->makeRadioButtons('creator');
	}
// get publishers from database.
	function grabPublishers()
	{
		include_once("core/html/FORM.php");
		include_once("core/publisher/PUBLISHER.php");
		$publisher = new PUBLISHER($this->db);
		$this->publisher = $publisher->grabAll(FALSE, $this->userBib);
		$this->radioButtons = FALSE;
	}
// get collections from database.
	function grabCollections()
	{
		include_once("core/html/FORM.php");
		include_once("core/collection/COLLECTION.php");
		$collection = new COLLECTION($this->db);
		$this->collection = $collection->grabAll(FALSE, $this->userBib);
		$this->radioButtons = FALSE;
	}
// Create radio buttons for AND and OR
	function makeRadioButtons($type)
	{
		include_once("core/html/FORM.php");
		$type = 'select_' . $type . 'Method';
		if($this->session->getVar($type) == 'AND')
		{
			$pString = MISC::span(FORM::radioButton(FALSE, $type, 'OR') . " OR", "small") . MISC::br();
			$pString .= MISC::span(FORM::radioButton(FALSE, $type, 'AND', TRUE) . " AND", "small");
		}
// Default
		else
		{
			$pString = MISC::span(FORM::radioButton(FALSE, $type, 'OR', TRUE) . " OR", "small") . MISC::br();
			$pString .= MISC::span(FORM::radioButton(FALSE, $type, 'AND') . " AND", "small");
		}
		$this->radioButtons = $pString;
	}
	function process($message = FALSE)
	{
		$input = $this->checkInput();
		include_once("core/html/MISC.php");
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$this->template->setVar('heading', $this->messages->text("heading", "select"));
		$tableArray = $stmt->idIsIdTables();
		$condition = FALSE;
		switch($input['method'])
		{
			case 'type':
				include_once("core/type/TYPE.php");
				$method = new TYPE($this->db);
				$condition = $method->selectCondition($input);
				break;
			case 'category':
				include_once("core/group/GROUP.php");
				$method = new GROUP($this->db);
				$condition = $method->selectCondition($input);
				break;
			case 'keyword':
				include_once("core/keyword/KEYWORD.php");
				$method = new KEYWORD($this->db);
				$condition = $method->selectCondition($input);
				break;
			case 'tag':
				include_once("core/file/TAG.php");
				$method = new TAG($this->db);
				$condition = $method->selectCondition($input);
				break;
			case 'creator':
				include_once("core/creator/CREATOR.php");
				$method = new CREATOR($this->db);
				$condition = $method->selectCondition($input);
				break;
			case 'publisher':
				include_once("core/publisher/PUBLISHER.php");
				$method = new PUBLISHER($this->db, $this->vars, $input);
				$condition = $method->selectCondition($input);
				break;
			case 'collection':
				include_once("core/collection/COLLECTION.php");
				$method = new COLLECTION($this->db, $this->vars, $input);
				$condition = $method->selectCondition($input);
				break;
			case 'bibId':
				$recordSet = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
					" WHERE " . $this->db->formatField('WKX_user_bibliography.id') . "=" . 
					$this->db->tidyInput($input['bibId']));
				if($bibliography = $this->db->fetchOne($recordSet))
				{
					$ids = explode(",", $bibliography);
					$condition = $this->db->formatField('WKX_resource.id') ."!=" . 
						join(" AND " . $this->db->formatField('WKX_resource.id') ."!=", $ids);
				}
				break;
			default:
				$this->badInput($this->errors->text("inputError", "missing", " (select_method) "));
		}
		if($userBibCondition = $this->common->userBibCondition())
			$userBibCondition = $condition ? " AND " . $userBibCondition : " WHERE " . $userBibCondition;
// Always order by creator surname
		$condition = $condition ? " WHERE ($condition)" . $userBibCondition : $userBibCondition;		
		$condition .= " ORDER BY " . $this->db->tidyInputClause('surname') . ", " . 
			$this->db->formatField('firstname') . ", " . 
			" COALESCE(" . $this->db->formatField('year1') . 
			", " . $this->db->formatField('year2') . 
			", " . $this->db->formatField('year3') . ")"; 
		$sqlTotal = $this->db->selectNoExecute(array("WKX_resource"),  
			$stmt->listFields(), $stmt->selectJoin() . " " . $condition);
		$queryString = "action=selectProcess";
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 'select', 
			FALSE, $message);
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
// write input to session
	function writeSession()
	{
// If this is a different type of select to the previous one, reset the paging counter.
// Write all input with 'select_' prefix to session
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^select_/", $key))
			{
// Is this a multiple select box input?  If so, multiple choices are written to session as 
// comma-delimited string (no spaces).
				if(is_array($value))
					$value = implode(",", $value);
				$temp[$key] = $value;
				if($this->session->getVar("select_$key") != $value)
					$this->session->delVar('mywikindx_pagingStart');
			}
		}
		if(isset($temp))
			$this->session->writeArray($temp);
	}
// validate user input
// Input comes either from form input or, when paging, from the session.
	function checkInput()
	{
		if(array_key_exists("select_method", $this->vars) && $this->vars["select_method"])
			$type = $this->vars["select_method"];
		else if($this->session->issetVar('select_method'))
			$type = $this->session->getVar("select_method");
		else
			$this->badInput($this->errors->text("inputError", "missing", " (select_method) "));
		if(!array_key_exists("select_" . $type, $this->vars) &&  
			!$this->session->issetVar("select_" . $type))
			$this->badInput($this->errors->text("inputError", "missing", " (select_" . $type . ") "));
// If missing the following, set to default 'OR'.
		if(!array_key_exists("select_" . $type . "Method", $this->vars) &&
		!$this->session->issetVar("select_" . $type . "Method"))
			$this->vars["select_" . $type . "Method"] = 'OR';
		$this->writeSession();
		return $this->session->getArray("select");
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($error));
	}
}
?>
