<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	SEARCHRESOURCES class
*
*	Search database resources on a variety of parameters
*
*	$Header: /cvsroot/wikindx/wikindx3/core/list/SEARCHRESOURCES.php,v 1.13 2005/06/26 02:03:41 sirfragalot Exp $
*****/
class SEARCHRESOURCES
{
// Constructor
	function SEARCHRESOURCES($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
	}
// display form options
	function display($error = FALSE)
	{
//		$this->session->delVar('mywikindx_pagingStart');
		$this->template->setVar('heading', $this->messages->text("heading", "search"));
///First check, do we have resources?
		$recordset = $this->db->select(array('WKX_database_summary'), array('totalResources'));
		if(!$this->db->fetchOne($recordset))
		{
			$this->template->setVar('body', $this->messages->text('misc', 'noResources'));
			return $this->template->process();
		}
		$this->userBib = $this->session->getVar("mywikindx_bibliography_use");
		$bib = FALSE;
		if($this->userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->userBib));
			$row = $this->db->fetchRow($recordset);
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
				$row['title'] . ")", "hint"));
		}
		else if($this->session->getVar('setup_multiUser'))
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
			$this->messages->text("user", "masterBib") . ")", "hint"));
// load the session
		$sessionVars = $this->session->getArray("search");
		$pString = $error ? $error : FALSE;
		$pString .= $bib;
		$this->template->setVar('formStart', FORM::formHeader("searchProcess"));
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		$this->grabTypes();
// add 0 => IGNORE to $array
		$temp[0] = $this->messages->text("misc", "ignore");
		foreach($this->type as $key => $value)
			$temp[$key] = $value;
		if($selected = $this->session->getVar("search_type"))
		{
			$selectedArray = explode(",", $selected);
			$pString .= TABLE::td(FORM::selectedBoxValueMultiple(
			$this->messages->text("search", "member", " " . 
			$this->messages->text("search", "type")), "search_type", $temp, $selectedArray, 5) . 
			MISC::br() . $this->messages->text("hint", "multiples") . MISC::br());
		}
		else
			$pString .= TABLE::td(FORM::selectFBoxValueMultiple(
			$this->messages->text("search", "member", " " . 
			$this->messages->text("search", "type")), "search_type", $temp, 5) . 
			MISC::br() . $this->messages->text("hint", "multiples") . MISC::br());
		$this->grabGroups();
		$pString .= TABLE::td($this->makeFormMultiple("category", $this->group));
// There may not yet be keywords in the database.
		$this->grabKeywords();
		if($this->keyword)
			$pString .= TABLE::td($this->makeFormMultiple("keyword", $this->keyword));
		else
			$pString .= TABLE::td("&nbsp;");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::br() . "&nbsp;" . MISC::hr() . MISC::br();
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
// array of database fields that can be searched on:
		$fields = array("title"	=>	$this->messages->text("search", "title"),
				"note"		=>	$this->messages->text("search", "note"),
				"abstract"	=>	$this->messages->text("search", "abstract"),
				"quote"	=>	$this->messages->text("search", "quote"),
				"paraphrase"	=>	$this->messages->text("search", "paraphrase"),
				"musing"	=>	$this->messages->text("search", "musing"),
			);
		$this->makeRadioButtons('field');
		$pString .= TABLE::td($this->makeFormMultiple("field", $fields, TRUE));
		$this->radioButtons = FALSE;
		$word = $this->session->issetVar("search_word") ? 
			$this->session->getVar("search_word") : FALSE;
		$checked = $this->session->issetVar("search_partial") ? 'CHECKED' : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("search", "word"), "search_word", 
			$word, 40) . " " . MISC::span('*', 'required') . 
			MISC::p($this->messages->text("search", "partial") . ":&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "search_partial", $checked)));
// array of search methods:
		$methods = array("OR"		=>	"OR",
				"AND"		=>	"AND",
				"exact"		=>	$this->messages->text("search", "exact"),
			);
		if($selected = $this->session->getVar("search_method"))
			$pString .= TABLE::td(FORM::selectedBoxValue(
			$this->messages->text("search", "search", " " . 
			$this->messages->text("search", "method")), "search_method", $methods, $selected, 3));
		else
			$pString .= TABLE::td(FORM::selectFBoxValue(
			$this->messages->text("search", "search", " " . 
			$this->messages->text("search", "method")), "search_method", $methods, 3));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= MISC::p(FORM::formSubmit("Search"), FALSE, "right");
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
// make a multiple select box
	function makeFormMultiple($type, $array, $noIgnore = FALSE)
	{
// add 0 => IGNORE to $array
		if(!$noIgnore)
		{
			$temp[0] = $this->messages->text("misc", "ignore");
			foreach($array as $key => $value)
				$temp[$key] = $value;
		}
		else
			$temp = $array;
		if(($type == 'category') || ($type == 'keyword') || ($type == 'type'))
			$label = 'member';
		else
			$label = 'search';
		if($selected = $this->session->getVar("search_" . $type))
		{
			$selectedArray = explode(",", $selected);
			$pString = FORM::selectedBoxValueMultiple(
				$this->messages->text("search", $label, " " . 
				$this->messages->text("search", $type)), 
				"search_" . $type, $temp, $selectedArray, 5);
		}
		else
		{
// If $type == 'field', select all fields as default
			if($type == 'field')
			{
				$pString = FORM::selectedBoxValueMultiple(
					$this->messages->text("search", $label, " " . 
					$this->messages->text("search", $type)), 
					"search_" . 'field', $temp, array_keys($array), 5);
			}
			else
				$pString = FORM::selectFBoxValueMultiple(
					$this->messages->text("search", $label, " " . 
					$this->messages->text("search", $type)), 
					"search_" . $type, $temp, 5);
		}
		$pString .= MISC::br() . $this->messages->text("hint", "multiples") . MISC::br();
		$pString .= $this->radioButtons . MISC::br();
		return $pString;
	}
// get types from database.
	function grabTypes()
	{
		include_once("core/resource/RESOURCEMAP.php");
		$resourceMap = new RESOURCEMAP();
		include_once("core/messages/UTF8.php");
		$this->utf8 = new UTF8();
		foreach($resourceMap->types as $key)
			$this->type[$key] = $this->utf8->encodeUtf8($this->messages->text("resourceType", $key));
		$this->makeRadioButtons('type');
	}
// get groups from database.
	function grabGroups()
	{
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$this->group = $group->grabAll();
		$this->makeRadioButtons('category');
	}
// get keywords from database.
	function grabKeywords()
	{
// Load groups
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$userBib = $this->session->getVar("mywikindx_bibliography_use");
		$this->keyword = $keyword->grabAll($userBib);
		$this->makeRadioButtons('keyword');
	}
// Create radio buttons for AND and OR
	function makeRadioButtons($type)
	{
		$type = 'search_' . $type . 'Method';
		if($this->session->getVar($type) == 'AND')
		{
			$pString = MISC::span(FORM::radioButton(FALSE, $type, 'OR') . " OR", "small") . MISC::br();
			$pString .= MISC::span(FORM::radioButton(FALSE, $type, 'AND', TRUE) . " AND", "small");
		}
// Default
		else
		{
			$pString = MISC::span(FORM::radioButton(FALSE, $type, 'OR', TRUE) . " OR", "small") . 
				MISC::br();
			$pString .= MISC::span(FORM::radioButton(FALSE, $type, 'AND') . " AND", "small");
		}
		$this->radioButtons = $pString;
	}
// parse the search word(s)
	function parseWord($input)
	{
		if(($input['method'] == 'OR') || ($input['method'] == 'AND'))
			$string = explode(" ", trim($input['word']));
		else
			$string = array(trim($input['word']));
		foreach($string as $term)
			$terms[] = trim($term);
		$this->session->setVar("search_highlight", implode(",", $terms));
// partial or complete word searching?
		if(array_key_exists('partial', $input))
		{
			foreach($string as $word)
				$this->words[] = " LIKE '%" . trim($word) . "%'";
		}
		else
		{
			foreach($string as $word)
				$this->words[] = " REGEXP '[[:<:]]" . trim($word) . "[[:>:]]'";
		}
	}
// add to SQL conditional statement and add fields to fieldArray for database fields
	function fieldSql($input)
	{
		if(!array_key_exists('field', $input))
			return;
		$fields = explode(",", $input['field']);
		foreach($fields as $field)
		{
			$condition = array();
			if($field == 'title')
			{
				foreach($this->words as $word)
					$condition[] = $this->db->formatField('WKX_resource.title') . $word . 
						" OR " . 
						$this->db->formatField('subtitle') . $word;
//					$condition[] = $this->db->concat(
//						array($this->db->formatField('WKX_resource.title'), 
//						$this->db->tidyInputNoTrim(" "), 
//						$this->db->formatField('subtitle'))) . $word;
//					$condition[] = "CONCAT_WS(' ', WKX_resource.title, " . 
//					$this->db->formatField('subtitle') . ") " . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
			else if($field == 'note')
			{
				$this->fieldArray = array_merge($this->fieldArray, 
					array(array('WKX_resource_note.text' => "note")));
				foreach($this->words as $word)
					$condition[] = 'WKX_resource_note.text' . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
			else if($field == 'abstract')
			{
				$this->fieldArray = array_merge($this->fieldArray, array('abstract'));
				foreach($this->words as $word)
					$condition[] = 'WKX_resource_abstract.abstract' . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
			else if($field == 'quote')
			{
				$this->fieldArray = array_merge($this->fieldArray, 
					array(array('WKX_resource_quote_text.text' => "quote"),
						array('WKX_resource_quote_comment.comment' => "quoteComment")));
				$this->joinStmt .= " LEFT JOIN " . $this->db->formatTable("WKX_resource_quote") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote.resourceId") .  
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_quote_text") .  
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote_text.id") . 
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_quote_comment") . 
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote_comment.quoteId");
				foreach($this->words as $word)
					$condition[] = $this->db->formatfield("WKX_resource_quote_text.text") . 
					$word . ' OR ' . 
					$this->db->formatfield("WKX_resource_quote_comment.comment") . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
			else if($field == 'paraphrase')
			{
				$this->fieldArray = array_merge($this->fieldArray, 
					array(array('WKX_resource_paraphrase_text.text' => "paraphrase"),
						array('WKX_resource_paraphrase_comment.comment' => "paraphraseComment")));
				$this->joinStmt .= " LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase.resourceId") .  
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase_text") .  
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase_text.id") .  
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_paraphrase_comment") . 
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase_comment.paraphraseId");
				foreach($this->words as $word)
					$condition[] = $this->db->formatfield("WKX_resource_paraphrase_text.text") . 
					$word . ' OR ' . 
					$this->db->formatfield("WKX_resource_paraphrase_comment.comment") . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
			else if($field == 'musing')
			{
				$this->fieldArray = array_merge($this->fieldArray, 
					array(array('WKX_resource_musing_text.text' => "musing")));
				$this->joinStmt .= " LEFT JOIN " . $this->db->formatTable("WKX_resource_musing") . 
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing.resourceId") .  
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_musing_text") .  
					" ON " . $this->db->formatfield("WKX_resource_musing.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing_text.id");
				foreach($this->words as $word)
					$condition[] = $this->db->formatfield("WKX_resource_musing_text.text") . $word;
				$conditionArray[] = "(" . implode(' ' . $input['method'] . ' ', $condition) . ")";
			}
		}
		$this->condition[] = implode(' ' .  $input['fieldMethod'] . ' ', $conditionArray);
	}
// add to SQL conditional statement and add fields to fieldArray for resource types
	function typeSql($input)
	{
		if(!array_key_exists('type', $input))
			return;
		$types = explode(",", $input['type']);
		foreach($types as $type)
			$conditionArray[] = $this->db->formatField('type') . "=" . $this->db->tidyInput($type);
		$this->condition[] = "(" . implode(' OR ', $conditionArray) . ")";
	}
// add to SQL conditional statement and add fields to fieldArray for categories
	function groupSql($input)
	{
		if(!array_key_exists('category', $input))
			return;
		$this->fieldArray = array_merge($this->fieldArray, array('categories'));
		$groups = explode(",", $input['category']);
		foreach($groups as $group)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($group) . ", " . 
				$this->db->formatField('categories') . ")";
		$this->condition[] = "(" . implode(' ' .  $input['categoryMethod'] . ' ', $conditionArray) . ")";
	}
// add to SQL conditional statement and add fields to fieldArray for keywords
	function keywordSql($input)
	{
		if(!array_key_exists('keyword', $input))
			return;
		$this->fieldArray = array_merge($this->fieldArray, array('keywords'));
		$keywords = explode(",", $input['keyword']);
		foreach($keywords as $keyword)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($keyword) . ", " . 
				$this->db->formatField('keywords') . ")";
		$this->condition[] = "(" . implode(' ' .  $input['keywordMethod'] . ' ', $conditionArray) . ")";
	}
// create the basic sql statement before we apply LIMIT
	function createTotalSql($input)
	{
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$this->fieldArray = $stmt->listFields();
		$this->joinStmt = $stmt->selectJoin();
		$this->parseWord($input);
		if($userBibCondition = $this->common->userBibCondition())
			$userBibCondition = " AND " . $userBibCondition;
		$this->fieldSql($input);
		$this->typeSql($input);
		$this->groupSql($input);
		$this->keywordSql($input);
// Always order by creator surname
		$order = " ORDER BY " . $this->db->tidyInputClause('surname') . ", " . 
			$this->db->formatField('firstname') . 
			", WKX_resource.title" . 
			", " . " COALESCE(" . $this->db->formatField('year1') . 
			", " . $this->db->formatField('year2') . 
			", " . $this->db->formatField('year3') . ")";
		$sql = $this->db->selectNoExecute(array("WKX_resource"),  
			$this->fieldArray, $this->joinStmt . " WHERE (" . 
			implode(') AND (', $this->condition) . ")" . $userBibCondition . 
			" GROUP BY " . $this->db->tidyInputClause("resourceId") . " " . $order);
//			$order);
// write statement to session
		$this->session->setVar('sql_stmt', addslashes($sql));
		return $sql;
	}
	function process($message = FALSE)
	{
		$input = $this->checkInput();
		$this->template->setVar('heading', $this->messages->text("heading", "search"));
		$sqlTotal = $this->createTotalSql($input);
		$searchTerms = explode(",", $this->session->getVar('search_highlight'));
		foreach($searchTerms as $term)
			$patterns[] = "/($term)/i";
		$queryString = "action=searchProcess";
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 'search', 
			$patterns, $message, 'search');
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
// write input to session
	function writeSession()
	{
// First, write all input with 'search_' prefix to session
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^search_/", $key))
			{
// Is this a multiple select box input?  If so, multiple choices are written to session as 
// comma-delimited string (no spaces).
// Don't write any FALSE or '0' values.
				if(is_array($value))
				{
					if(!$value[0] || ($value[0] == $this->messages->text("misc", "ignore")))
						unset($value[0]);
					if(empty($value))
					{
						$this->session->delVar($key);
						continue;
					}
					$value = implode(",", $value);
				}
// If this is a different listing to the previous one, reset the paging counter.
				if($this->session->getVar("search_$key") != $value)
					$this->session->delVar('mywikindx_pagingStart');
				if(!trim($value))
					continue;
				$temp[$key] = trim($value);
			}
		}
// remove search_type, search_partial and search_word if not checked or empty
		if(isset($temp))
		{
			if(!array_key_exists('search_type', $temp))
				$this->session->delVar('search_type');
			if(!array_key_exists('search_partial', $temp))
				$this->session->delVar('search_partial');
			if(!array_key_exists('search_word', $temp))
				$this->session->delVar('search_word');
			if(isset($temp))
				$this->session->writeArray($temp);
		}
	}
// validate user input - method, word and field are required.
// Input comes either from form input or, when paging, from the session.
	function checkInput()
	{
		$this->writeSession();
		if(array_key_exists("search_method", $this->vars) && $this->vars["search_method"])
			$type = $this->vars["search_method"];
		else if($this->session->issetVar('search_method'))
			$type = $this->session->getVar("search_method");
		else
			$this->badInput($this->errors->text("inputError", "missing"));
		if(array_key_exists("search_field", $this->vars) && $this->vars["search_field"])
			$type = $this->vars["search_field"];
		else if($this->session->issetVar('search_field'))
			$type = $this->session->getVar("search_field");
		else
			$this->badInput($this->errors->text("inputError", "missing"));
		if((array_key_exists("search_word", $this->vars) && !trim($this->vars["search_word"])) 
		|| !$this->session->getVar("search_word"))
			$this->badInput($this->errors->text("inputError", "missing"));
		return $this->session->getArray("search");
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($error));
	}
}
?>
