<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/**
*	POWERSEARCHRESOURCES class
*
*	Power search database resources on a variety of parameters
*
*	@author		Mark Grimshaw
*	@version	1
*	$Header: /cvsroot/wikindx/wikindx3/core/list/POWERSEARCHRESOURCES.php,v 1.25 2005/06/27 22:01:42 sirfragalot Exp $
*/
class POWERSEARCHRESOURCES
{
// Constructor
	function POWERSEARCHRESOURCES($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/TABLE.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
		include_once("core/resource/RESOURCEMAP.php");
		$this->resourceMap = new RESOURCEMAP();
		$this->template->setVar('heading', $this->messages->text("heading", "search"));
	}
/**
* Display the search form.
* 
* @author	Mark Grimshaw
* @version	1
*
* @param	string $error
* @return	string
*/
	function display($error = FALSE)
	{
//		$this->session->delVar('mywikindx_pagingStart');
/**
* First check, do we have resources?
*/
		$recordset = $this->db->select(array('WKX_database_summary'), array('totalResources'));
		if(!$this->db->fetchOne($recordset))
		{
			$this->template->setVar('body', $this->messages->text('misc', 'noResources'));
			return $this->template->process();
		}
		$this->userBib = $this->session->getVar("mywikindx_bibliography_use");
		$bib = FALSE;
		if($this->userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->userBib));
			$row = $this->db->fetchRow($recordset);
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
				$row['title'] . ")", "hint"));
		}
		else if($this->session->getVar('setup_multiUser'))
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
			$this->messages->text("user", "masterBib") . ")", "hint"));
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		$this->loadArrays();
		$fields = array_keys($this->availableFields);
		$pString = $error ? $error : FALSE;
		$pString .= $bib;
		$this->template->setVar('formStart', FORM::formHeader("powerSearchProcess"));
		$pString .= MISC::p($this->messages->text("hint", "boolean1") . MISC::br() . 
			$this->messages->text("hint", "boolean2") . MISC::br() . 
			$this->messages->text("hint", "boolean3") . MISC::br() . 
			$this->messages->text("hint", "boolean4"));
		$pString .= MISC::p($this->messages->text("hint", "boolean5"));
		$pString .= MISC::p($this->messages->text("hint", "refineSearch"));
/**
* Add checkall and uncheckall javascript
*/
		$icons->getIconInfo('checkall');
		$checkAllLink = $icons->checkallExists ? "imgLink linkCiteHidden" : "link linkCiteHidden";
		$icons->getIconInfo('uncheckall');
		$uncheckAllLink = $icons->uncheckallExists ? "imgLink linkCiteHidden" : "link linkCiteHidden";
		$pString .= TABLE::tableStart(FALSE, 0, FALSE, 5, FALSE, 10);
		$pString .= TABLE::trStart();
		if(!$icons->checkallExists)
			$icons->checkall = str_replace(' ', "&nbsp;", $icons->checkall);
		$pString .= TABLE::td(MISC::a($checkAllLink, $icons->checkall, 
			"javascript:checkAll()"));
		if(!$icons->uncheckallExists)
			$icons->uncheckall = str_replace(' ', "&nbsp;", $icons->uncheckall);
		$pString .= TABLE::td(MISC::a($uncheckAllLink, $icons->uncheckall, 
			"javascript:uncheckAll()"));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
/**
* Create form elements for each field
*/
		foreach($fields as $field)
			$pString .= $this->createTextElement($field);
		if(array_key_exists("custom", $this->selectBoxes))
		{
			foreach($this->selectBoxes['custom'] as $field => $label)
				$pString .= $this->createCustomElement($field, $label);
		}
		$pString .= $this->finalizeForm();
		$this->template->setVar('body', $pString);
		$this->template->setVar('formEnd', FORM::formEnd());
		return $this->template->process();
	}
/**
* Create ordering and submit elements of form
* 
* @author	Mark Grimshaw
* @version	1
*
* @return	string
*/
	function finalizeForm()
	{
		$orders = array("order1", "order2", "order3");
		$orderSelect = array(
				'surname' => $this->messages->text("powerSearch", "creator1"), 
				'year1' => $this->messages->text("powerSearch", "year1"), 
				'title' => $this->messages->text("powerSearch", "title"), 
				'type' => $this->messages->text("powerSearch", "type"), 
				'timestamp' => $this->messages->text("powerSearch", "timestamp"), 
				'publisher' => $this->messages->text("powerSearch", "publisher"), 
				'conferenceOrganiser' => $this->messages->text("powerSearch", "conferenceOrganiser"), 
				'collectionTitle' => $this->messages->text("powerSearch", "collectionTitle"), 
				'collectionTitleShort' => $this->messages->text("powerSearch", "collectionTitleShort"), 
				'creator2' => $this->messages->text("powerSearch", "creator2"), 
				'creator3' => $this->messages->text("powerSearch", "creator3"), 
				'creator4' => $this->messages->text("powerSearch", "creator4"), 
				'creator5' => $this->messages->text("powerSearch", "creator5"), 
				'quotes' => $this->messages->text("powerSearch", "numQuotes"), 
				'paraphrases' => $this->messages->text("powerSearch", "numParaphrases"), 
				'musings' => $this->messages->text("powerSearch", "numMusings"), 
				'addUserIdResource' => $this->messages->text("powerSearch", "addUserIdResource"), 
				'isbn' => $this->messages->text("powerSearch", "isbn"), 
				'year2' => $this->messages->text("powerSearch", "year2"), 
				'year3' => $this->messages->text("powerSearch", "year3"), 
				'field1' => $this->messages->text("powerSearch", "field1"), 
				'field2' => $this->messages->text("powerSearch", "field2"), 
				'field3' => $this->messages->text("powerSearch", "field3"), 
				'field4' => $this->messages->text("powerSearch", "field4"), 
				'field5' => $this->messages->text("powerSearch", "field5"), 
				'field6' => $this->messages->text("powerSearch", "field6"), 
				'field7' => $this->messages->text("powerSearch", "field7"), 
				'field8' => $this->messages->text("powerSearch", "field8"), 
				'field9' => $this->messages->text("powerSearch", "field9"), 
				'miscField1' => $this->messages->text("powerSearch", "miscField1"), 
				'miscField2' => $this->messages->text("powerSearch", "miscField2"), 
				'miscField3' => $this->messages->text("powerSearch", "miscField3"), 
				'miscField4' => $this->messages->text("powerSearch", "miscField4"), 
				'miscField5' => $this->messages->text("powerSearch", "miscField5"), 
				'miscField6' => $this->messages->text("powerSearch", "miscField6"), 
			);
		$pString = TABLE::tableStart(FALSE, 0, 5);
		foreach($orders as $order)
		{
			$pString .= TABLE::trStart();
			if($selected = base64_decode($this->session->getVar("powerSearch_" . $order . "_order")))
			{
				$pString .= TABLE::td(FORM::selectedBoxValue(
				MISC::i($this->messages->text("powerSearch", $order)), 
				"powerSearch_" . $order . "_order", $orderSelect, $selected, 5), 
				FALSE, "right", "bottom");
			}
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(
				MISC::i($this->messages->text("powerSearch", $order)), 
				"powerSearch_" . $order . "_order", $orderSelect, 5), 
				FALSE, "right", "bottom");
			if(base64_decode($this->session->getVar("powerSearch_" . $order . "_order_upDown")) 
				== 'DESC')
				$pString .= TABLE::td(
					FORM::radioButton(FALSE, "powerSearch_" . $order . "_order_upDown", 
					'ASC') . " " . $this->messages->text("powerSearch", "ascending")
					. "&nbsp;&nbsp;&nbsp;&nbsp;" . 
					FORM::radioButton(FALSE, "powerSearch_" . 
					$order . "_order_upDown", 'DESC', TRUE) . " " . 
					$this->messages->text("powerSearch", "descending"),
					"small", FALSE, "bottom");
// Default
			else
				$pString .= TABLE::td(
					FORM::radioButton(FALSE, "powerSearch_" . $order . "_order_upDown", 
					'ASC', TRUE) . " " . $this->messages->text("powerSearch", "ascending")
					. "&nbsp;&nbsp;&nbsp;&nbsp;" . 
					FORM::radioButton(FALSE, "powerSearch_" . 
					$order . "_order_upDown", 'DESC') . " " . 
					$this->messages->text("powerSearch", "descending"),
					"small", FALSE, "bottom");
			if($order == 'order3')
				$pString .= TABLE::td(FORM::formSubmit("Search"), FALSE, "right", "bottom");
			else
				$pString .= TABLE::td("&nbsp;");
			$pString .= TABLE::trEnd();
		}
		$pString .= TABLE::tableEnd();
		return $pString;
	}
/**
* Create a text input display element for custom database fields
* 
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field		The field's name
* @param	string $label	The field's name
* @return	string
*/
	function createCustomElement($field, $label)
	{
		$pString = TABLE::tableStart();
		$pString .= TABLE::trStart();
		$check = $this->session->getVar("powerSearch_" . $field) ? TRUE : FALSE;
		$partial = $this->session->getVar("powerSearch_" . $field . "_partial") ? TRUE : FALSE;
		$string = $this->session->getVar("powerSearch_" . $field . "_string") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_string")) : FALSE;
		$type = "powerSearch_" . $field . "_radio";
		$pString .= $this->makeAndOr($type);
		$fieldLabel = MISC::b($this->messages->text("powerSearch", "custom") . ": ") . $label;
		$pString .= TABLE::td(FORM::checkbox($fieldLabel, 
			"powerSearch_" . $field, $check), FALSE, "left", FALSE, FALSE, 150);
		$pString .= TABLE::td(FORM::textInput($this->messages->text("hint", "boolean"), 
			"powerSearch_" . $field . "_string", htmlentities(stripslashes($string)), 50, 255) . 
			MISC::br() . $this->messages->text("search", "partial") . " " . 
			FORM::checkbox(FALSE, "powerSearch_" . $field . "_partial", $partial), 
			FALSE, "right", "bottom");
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
/**
* Create a text input display element
* 
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field	The Field name to search on.
* @param	string $table	The database table the field is in.
* @return	string
*/
	function createTextElement($field)
	{
// make sure custom fields are not handled here
		if(preg_match("/^custom_/", $field))
			return;
		if(
			(($field == 'categories') && (sizeof($this->selectBoxes['categories']) == 1))
			||
			(($field == 'resourceKeywords')&& !$this->selectBoxes['resourceKeywords'])
			||
			(($field == 'quoteKeywords') && !$this->selectBoxes['quoteKeywords'])
			||
			(($field == 'paraphraseKeywords') && !$this->selectBoxes['paraphraseKeywords'])
			||
			(($field == 'musingKeywords')&& !$this->selectBoxes['musingKeywords']) 
			|| 
			(($field == 'publisher') && !$this->selectBoxes['publishers']) 
			|| 
			(($field == 'conferenceOrganiser') && !$this->selectBoxes['conferenceOrganiser']) 
			|| 
			(($field == 'collectionTitle') && !$this->selectBoxes['collectionTitle']) 
			|| 
			(($field == 'collectionTitleShort') && !$this->selectBoxes['collectionTitleShort']) 
			|| 
			((($field == 'addUserIdResource') || ($field == 'editUserIdResource') 
			 || ($field == 'addUserIdQuote') || ($field == 'addUserIdParaphrase')
			 || ($field == 'addUserIdQuoteComment') || ($field == 'addUserIdParaphraseComment')
			 || ($field == 'addUserIdMusing')) 
			&& (sizeof($this->selectBoxes['users']) == 1))
			|| 
			(($field == 'creator1') && !$this->selectBoxes['creator1'])
			|| 
			(($field == 'creator2') && !$this->selectBoxes['creator2'])
			|| 
			(($field == 'creator3') && !$this->selectBoxes['creator3'])
			|| 
			(($field == 'creator4') && !$this->selectBoxes['creator4'])
			|| 
			(($field == 'creator5') && !$this->selectBoxes['creator5'])
//			((($field == 'creator1') || ($field == 'creator2') 
//			 || ($field == 'creator3')  || ($field == 'creator4')  || ($field == 'creator5')) 
//			&& !$this->selectBoxes['creators'])
			)
			return;
/**
* Logic choices for integer fields and timestamp field
*/
		$logicInteger = array("<" => $this->messages->text("powerSearch", "lessThan"), 
			"<=" => $this->messages->text("powerSearch", "lessThanOrEqualTo"), 
			"=" => $this->messages->text("powerSearch", "equalTo"), 
			">=" => $this->messages->text("powerSearch", "greaterThanOrEqualTo"), 
			">" => $this->messages->text("powerSearch", "greaterThan"));
		$pString = TABLE::tableStart();
		$pString .= TABLE::trStart();
		$check = $this->session->getVar("powerSearch_" . $field) ? TRUE : FALSE;
		$type = "powerSearch_" . $field . "_radio";
		$pString .= $this->makeAndOr($type);
// If anonymous field array size == 1 (i.e. can only represent one possible item) use that item as a label
		if(array_key_exists($field, $this->createForm) and (sizeof($this->createForm[$field]) == 1))
			$pString .= TABLE::td(FORM::checkbox(MISC::b(array_shift($this->createForm[$field])), 
				"powerSearch_" . $field, $check), FALSE, "left", FALSE, FALSE, 150);
		else
			$pString .= TABLE::td(FORM::checkbox(MISC::b($this->messages->text("powerSearch", $field)), 
				"powerSearch_" . $field, $check), FALSE, "left", FALSE, FALSE, 150);
// Is this an anonymous field which is flexible in its meaning? An array will exist of possible meanings.
		if(array_key_exists($field, $this->createForm) and (sizeof($this->createForm[$field]) > 1))
		{
			if($selected = unserialize(base64_decode(
				$this->session->getVar("powerSearch_" . $field . "_select"))))
			{
				$pString .= TABLE::td(FORM::selectedBoxValueMultiple(
				MISC::i($this->messages->text("powerSearch", "possibleFields")), 
				"powerSearch_" . $field . "_select", $this->createForm[$field], $selected, 5) . 
				MISC::br() . $this->messages->text("hint", "multiples"), 
				FALSE, "left", "bottom", FALSE);
			}
			else
				$pString .= TABLE::td(FORM::selectFBoxValueMultiple(
				MISC::i($this->messages->text("powerSearch", "possibleFields")), 
				"powerSearch_" . $field . "_select", $this->createForm[$field], 5) . 
				MISC::br() . $this->messages->text("hint", "multiples"), 
				FALSE, "left", "bottom", FALSE);
		}
		$check = $this->session->getVar("powerSearch_" . $field . "_partial") ? TRUE : FALSE;
		$string = $this->session->getVar("powerSearch_" . $field . "_string") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_string")) : FALSE;
		$integer = $this->session->getVar("powerSearch_" . $field . "_integer") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_integer")) : FALSE;
		$logic = $this->session->getVar("powerSearch_" . $field . "_logicInteger") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_logicInteger")) : FALSE;
		$day = $this->session->getVar("powerSearch_" . $field . "_day") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_day")) : FALSE;
		$month = $this->session->getVar("powerSearch_" . $field . "_month") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_month")) : FALSE;
		$year = $this->session->getVar("powerSearch_" . $field . "_year") ? 
			base64_decode($this->session->getVar("powerSearch_" . $field . "_year")) : FALSE;
// These fields are integer type fields (or (e.g. pageXXX) can only be searched as integers)
		if(($field == 'miscField1') || ($field == 'miscField2') || ($field == 'miscField3') || 
			($field == 'miscField4') || ($field == 'miscField5') || ($field == 'miscField6') || 
			($field == 'pageStart') || ($field == 'pageEnd')
			 || ($field == 'year1') || ($field == 'year2') || ($field == 'year3')
			 || ($field == 'numQuotes') || ($field == 'numParaphrases') || ($field == 'numMusings'))
		{
			if($logic)
			{
				$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, 
				"powerSearch_" . $field . "_logicInteger", $logicInteger, $logic, 3), 
				FALSE, "right", "bottom");
			}
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, 
				"powerSearch_" . $field . "_logicInteger", $logicInteger, 3), 
				FALSE, "right", "bottom");
			$pString .= TABLE::td(FORM::textInput($this->messages->text("hint", "integer"), 
				"powerSearch_" . $field . "_integer", htmlentities(stripslashes($integer)), 9, 255), 
				FALSE, "right", "bottom", FALSE, 80);
		}
		else if(($field == 'type') || 
			($field == 'categories') ||
			($field == 'publisher') ||
			($field == 'conferenceOrganiser') ||
			($field == 'collectionTitle') ||
			($field == 'collectionTitleShort') ||
			($field == 'addUserIdResource') || ($field == 'editUserIdResource') || 
			($field == 'addUserIdQuote') || ($field == 'addUserIdParaphrase') || 
			($field == 'addUserIdQuoteComment') || ($field == 'addUserIdParaphraseComment') || 
			($field == 'addUserIdMusing') || 
			($field == 'resourceKeywords') || ($field == 'quoteKeywords') ||
			($field == 'paraphraseKeywords') || ($field == 'musingKeywords') ||
			($field == 'creator1') || ($field == 'creator2') 
			 || ($field == 'creator3')  || ($field == 'creator4')  || ($field == 'creator5'))
		{
			if($field == 'type')
				$array = $this->selectBoxes['type'];
			else if($field == 'categories')
				$array = $this->selectBoxes['categories'];
			else if($field == 'publisher')
				$array = $this->selectBoxes['publishers'];
			else if($field == 'conferenceOrganiser')
				$array = $this->selectBoxes['conferenceOrganiser'];
			else if($field == 'collectionTitle')
				$array = $this->selectBoxes['collectionTitle'];
			else if($field == 'collectionTitleShort')
				$array = $this->selectBoxes['collectionTitleShort'];
			else if(($field == 'addUserIdResource') || ($field == 'editUserIdResource') ||
				($field == 'addUserIdQuote') || ($field == 'addUserIdParaphrase') || 
				($field == 'addUserIdQuoteComment') || ($field == 'addUserIdParaphraseComment') || 
				($field == 'addUserIdMusing'))
				$array = $this->selectBoxes['users'];
			else if($field == 'resourceKeywords')
				$array = $this->selectBoxes['resourceKeywords'];
			else if($field == 'quoteKeywords')
				$array = $this->selectBoxes['quoteKeywords'];
			else if($field == 'paraphraseKeywords')
				$array = $this->selectBoxes['paraphraseKeywords'];
			else if($field == 'musingKeywords')
				$array = $this->selectBoxes['musingKeywords'];
			else if($field == 'creator1')
				$array = $this->selectBoxes['creator1'];
			else if($field == 'creator2')
				$array = $this->selectBoxes['creator2'];
			else if($field == 'creator3')
				$array = $this->selectBoxes['creator3'];
			else if($field == 'creator4')
				$array = $this->selectBoxes['creator4'];
			else if($field == 'creator5')
				$array = $this->selectBoxes['creator5'];
			if($selected = unserialize(base64_decode(
				$this->session->getVar("powerSearch_" . $field . "_selectOnly"))))
			{
				$pString .= TABLE::td(FORM::selectedBoxValueMultiple(FALSE, 
				"powerSearch_" . $field . "_selectOnly", $array, $selected, 5) . 
				MISC::br() . $this->messages->text("hint", "multiples"), 
				FALSE, "right", "bottom", FALSE);
			}
			else
				$pString .= TABLE::td(FORM::selectFBoxValueMultiple(FALSE, 
				"powerSearch_" . $field . "_selectOnly", $array, 5) . 
				MISC::br() . $this->messages->text("hint", "multiples"), 
				FALSE, "right", "bottom", FALSE);
			if(($field != 'type') && ($field != 'publisher')  && ($field != 'conferenceOrganiser') 
			&& ($field != 'collectionTitle')
			 && ($field != 'collectionTitleShort') && ($field != 'addUserIdResource') 
			 && ($field != 'editUserIdResource'))
				$pString .= $this->makeAndOr("powerSearch_" . $field . "_selectRadio", "bottom");
		}
		else if($field == 'timestamp')
		{
			if($logic)
			{
				$pString .= TABLE::td(FORM::selectedBoxValue(FALSE, 
				"powerSearch_" . $field . "_logicInteger", $logicInteger, $logic, 3), 
				FALSE, "right", "top");
			}
			else
				$pString .= TABLE::td(FORM::selectFBoxValue(FALSE, 
				"powerSearch_" . $field . "_logicInteger", $logicInteger, 3), 
				FALSE, "right", "top");
			include_once("core/messages/CONSTANTS.php");
			$constant = new CONSTANTS();
			$months = $constant->constants->monthToLongName();
			for($index = 1; $index <= 31; $index++)
				$days[$index] = $index;
			if($day)
				$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "day"),
					"powerSearch_" . $field . "_day", $days, $day, 6), FALSE, "right", "bottom");
			else
				$pString .= TABLE::td(FORM::selectFBoxValue($this->messages->text("resources", "day"),
					"powerSearch_" . $field . "_day", $days, 6), FALSE, "right", "bottom");
			if($month)
				$pString .= TABLE::td(FORM::selectedBoxValue($this->messages->text("resources", "month"), 
					"powerSearch_" . $field . "_month", $months, $month, 6), FALSE, "right", "bottom");
			else
				$pString .= TABLE::td(FORM::selectFBoxValue($this->messages->text("resources", "month"), 
					"powerSearch_" . $field . "_month", $months, 6), FALSE, "right", "bottom");
			$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "year"), 
				"powerSearch_" . $field . "_year", htmlentities(stripslashes($year)), 5, 4), 
				FALSE, "right", "bottom");
		}
		else
			$pString .= TABLE::td(FORM::textInput($this->messages->text("hint", "boolean"), 
				"powerSearch_" . $field . "_string", htmlentities(stripslashes($string)), 50, 255) . 
				MISC::br() . $this->messages->text("search", "partial") . " " . 
				FORM::checkbox(FALSE, "powerSearch_" . $field . "_partial", $check), 
				FALSE, "right", "bottom");
		$this->firstDisplaySet = FALSE;
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd();
		$pString .= TABLE::tdEnd() . TABLE::trEnd() . TABLE::trStart() . TABLE::tdStart();
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		return $pString;
	}
/**
* Make AND / OR / NOT radio buttons
* 
* @author	Mark Grimshaw
* @version	1
*
* @param	string $type	The type of radio button
* @param	string $vAlign
* @return	string
*/
	function makeAndOrNot($type, $vAlign = "top")
	{
		if(base64_decode($this->session->getVar($type)) == 'OR')
		{
			return TABLE::td(FORM::radioButton(FALSE, $type, 'AND') . " AND" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'OR', TRUE) . " OR" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'NOT') . " NOT", 
				"small", FALSE, $vAlign, FALSE, 60);
		}
		else if(base64_decode($this->session->getVar($type)) == 'NOT')
		{
			return TABLE::td(FORM::radioButton(FALSE, $type, 'AND') . " AND" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'OR') . " OR" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'NOT', TRUE) . " NOT", 
				"small", FALSE, $vAlign, FALSE, 60);
		}
// Default
		else
		{
			return TABLE::td(FORM::radioButton(FALSE, $type, 'AND', TRUE) . " AND" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'OR') . " OR" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'NOT') . " NOT", 
				"small", FALSE, $vAlign, FALSE, 60);
		}
	}
/**
* Make AND / OR radio buttons
* 
* @author	Mark Grimshaw
* @version	1
*
* @param	string $type	The type of radio button
* @param	string $vAlign
* @return	string
*/
	function makeAndOr($type, $vAlign = "top")
	{
		if(base64_decode($this->session->getVar($type)) == 'OR')
		{
			return TABLE::td(FORM::radioButton(FALSE, $type, 'AND') . " AND" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'OR', TRUE) . " OR", 
				"small", FALSE, $vAlign, FALSE, 60);
		}
// Default
		else
		{
			return TABLE::td(FORM::radioButton(FALSE, $type, 'AND', TRUE) . " AND" . 
				MISC::br() . FORM::radioButton(FALSE, $type, 'OR') . " OR",  
				"small", FALSE, $vAlign, FALSE, 60);
		}
	}
/**
* Process the form input
* 
* @author	Mark Grimshaw
* @version	1
*
* @return	string
*/
	function process($message = FALSE)
	{
		$this->fieldArrays();
		$this->checkInput();
		$this->createSqlFragments();
		$sqlTotal = $this->createTotalSql();
		$patterns = FALSE;
		if($searchTerms = $this->session->getVar('search_highlight'))
		{
			$searchTerms = explode(",", $searchTerms);
			foreach($searchTerms as $term)
				$patterns[] = "/($term)/i";
		}
		$queryString = "action=powerSearchProcess";
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 
			'powerSearch', $patterns, $message);
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
/**
* Create SQL search fragments
* 
* @author	Mark Grimshaw
* @version	1
*
* @return	string		SQL query string
*/
	function createSqlFragments()
	{
		$this->sqlJoin = $this->conditionAnd = $this->conditionOr = array();
		foreach($this->searchFields as $field)
		{
			if($field == 'notes')
				$thisField = 'WKX_resource_note.text';
			else if(($field == 'collectionTitle') || ($field == 'collectionTitleShort'))
				$thisField = 'collection';
			else if($field == 'conferenceOrganiser')
				$thisField = 'publisher';
			else if($field == 'quotes')
			{
				$thisField = 'WKX_resource_quote_text.text';
				if(!array_key_exists('quotes', $this->sqlJoin))
					$this->sqlJoin['quotes'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote") .  
					" ON " . 
					$this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote.resourceId");
				if(!array_key_exists('quoteText', $this->sqlJoin))
					$this->sqlJoin['quoteText'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote_text") .  
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" .
					$this->db->formatfield("WKX_resource_quote_text.id");
			}
			else if($field == 'quoteComments')
			{
				$thisField = 'WKX_resource_quote_comment.comment';
				if(!array_key_exists('quotes', $this->sqlJoin))
					$this->sqlJoin['quotes'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote") . 
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_quote.resourceId");
				if(!array_key_exists('quoteComments', $this->sqlJoin))
					$this->sqlJoin['quoteComments'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote_comment") .  
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote_comment.quoteId");
			}
			else if($field == 'quoteKeywords')
			{
				$thisField = 'WKX_resource_quote.quote_keywords';
				if(!array_key_exists('quotes', $this->sqlJoin))
					$this->sqlJoin['quotes'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_quote.resourceId");
			}
			else if($field == 'addUserIdQuote')
			{
				$thisField = 'WKX_resource_quote_text.addUserIdQuote';
				if(!array_key_exists('quotes', $this->sqlJoin))
					$this->sqlJoin['quotes'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote.resourceId");
				if(!array_key_exists('quoteText', $this->sqlJoin))
					$this->sqlJoin['quoteText'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote_text") .  
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote_text.id");
			}
			else if($field == 'addUserIdQuoteComment')
			{
				$thisField = 'WKX_resource_quote_comment.addUserIdQuote';
				if(!array_key_exists('quotes', $this->sqlJoin))
					$this->sqlJoin['quotes'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote.resourceId");
				if(!array_key_exists('quoteComments', $this->sqlJoin))
					$this->sqlJoin['quoteComments'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_quote_comment") .  
					" ON " . $this->db->formatfield("WKX_resource_quote.id") . "=" . 
					$this->db->formatfield("WKX_resource_quote_comment.quoteId");
			}
			else if($field == 'numQuotes')
				$thisField = 'quotes';
			else if($field == 'numParaphrases')
				$thisField = 'paraphrases';
			else if($field == 'numMusings')
				$thisField = 'musings';
			else if($field == 'paraphrases')
			{
				$thisField = 'WKX_resource_paraphrase_text.text';
				if(!array_key_exists('paraphrases', $this->sqlJoin))
					$this->sqlJoin['paraphrases'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase.resourceId");
				if(!array_key_exists('paraphraseText', $this->sqlJoin))
					$this->sqlJoin['paraphraseText'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase_text") .  
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" .
					$this->db->formatfield("WKX_resource_paraphrase_text.id");
			}
			else if($field == 'paraphraseComments')
			{
				$thisField = 'WKX_resource_paraphrase_comment.comment';
				if(!array_key_exists('paraphrases', $this->sqlJoin))
					$this->sqlJoin['paraphrases'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_paraphrase.resourceId");
				if(!array_key_exists('paraphraseComments', $this->sqlJoin))
					$this->sqlJoin['paraphraseComments'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase_comment") .  
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase_comment.paraphraseId");
			}
			else if($field == 'paraphraseKeywords')
			{
				$thisField = 'WKX_resource_paraphrase.paraphrase_keywords';
				if(!array_key_exists('paraphrases', $this->sqlJoin))
					$this->sqlJoin['paraphrases'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_paraphrase.resourceId");
			}
			else if($field == 'addUserIdParaphrase')
			{
				$thisField = 'WKX_resource_paraphrase_text.addUserIdParaphrase';
				if(!array_key_exists('paraphrases', $this->sqlJoin))
					$this->sqlJoin['paraphrases'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase.resourceId");
				if(!array_key_exists('paraphraseText', $this->sqlJoin))
					$this->sqlJoin['paraphraseText'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase_text") .  
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" .
					$this->db->formatfield("WKX_resource_paraphrase_text.id");
			}
			else if($field == 'addUserIdParaphraseComment')
			{
				$thisField = 'WKX_resource_paraphrase_comment.addUserIdParaphrase';
				if(!array_key_exists('paraphrases', $this->sqlJoin))
					$this->sqlJoin['paraphrases'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_paraphrase") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_paraphrase.resourceId");
				if(!array_key_exists('paraphraseComments', $this->sqlJoin))
					$this->sqlJoin['paraphraseComments'] = "LEFT JOIN " .
					$this->db->formatTable("WKX_resource_paraphrase_comment") .  
					" ON " . $this->db->formatfield("WKX_resource_paraphrase.id") . "=" . 
					$this->db->formatfield("WKX_resource_paraphrase_comment.paraphraseId");
			}
			else if($field == 'musings')
			{
				$thisField = 'WKX_resource_musing_text.text';
				if(!array_key_exists('musings', $this->sqlJoin))
					$this->sqlJoin['musings'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_musing") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing.resourceId") .  
					" LEFT JOIN " . $this->db->formatTable("WKX_resource_musing_text") .  
					" ON " . $this->db->formatfield("WKX_resource_musing.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing_text.id");
			}
			else if($field == 'musingKeywords')
			{
				$thisField = 'WKX_resource_musing.musing_keywords';
				if(!array_key_exists('musings', $this->sqlJoin))
					$this->sqlJoin['musings'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_musing") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing.resourceId");
			}
			else if($field == 'addUserIdMusing')
			{
				$thisField = 'WKX_resource_musing_text.addUserIdMusing';
				if(!array_key_exists('musings', $this->sqlJoin))
					$this->sqlJoin['musings'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_musing") .  
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing.resourceId");
				if(!array_key_exists('musingText', $this->sqlJoin))
					$this->sqlJoin['musingText'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_musing_text") .  
					" ON " . $this->db->formatfield("WKX_resource_musing.id") . "=" . 
					$this->db->formatfield("WKX_resource_musing_text.id");
			}
			else if($field == 'resourceKeywords')
				$thisField = 'WKX_resource_keyword.keywords';
			else if($field == 'quoteKeywords')
				$thisField = 'WKX_quote_keyword.quote_keywords';
			else if($field == 'paraphraseKeywords')
				$thisField = 'WKX_paraphrase_keyword.paraphrase_keywords';
			else if($field == 'musingKeywords')
				$thisField = 'WKX_musing_keyword.musing_keywords';
// Custom database fields
			else if(preg_match("/^custom_/", $field))
			{
				$split = split("_", $field);
				if($split[2] == 'S') // custom_short
					$sizeName = 'custom_short';
				else
					$sizeName = 'custom_long';
				$thisField = 'WKX_resource_custom.' . $sizeName . '';
				if(!array_key_exists('custom', $this->sqlJoin))
					$this->sqlJoin['custom'] = "LEFT JOIN " . 
					$this->db->formatTable("WKX_resource_custom") . 
					" ON " . $this->db->formatfield("WKX_resource.id") . "=" .
					$this->db->formatfield("WKX_resource_custom.resourceId") .  
					" AND " . $this->db->formatfield("WKX_resource_custom.customId") . 
					"=" . $split[1];
			}
			else
				$thisField = "$field";
// String conditions
			if(array_key_exists('string', $this->$field))
				$this->parseString($thisField, $field, $this->{$field}['string']);
// Integer
			if(array_key_exists('integer', $this->$field))
				$this->parseInteger($thisField, $field, $this->{$field}['integer']);
// Timestamp
			if($field == 'timestamp')
				$this->parseTimestamp($thisField, $field, $this->{'timestamp'});
// 'selectOnly' conditions (category, keyword, collection etc.)
			if(array_key_exists('selectOnly', $this->$field))
				$this->parseSelectOnly($thisField, $field, $this->{$field}['selectOnly']);
			if($this->{$field}['radio'] == 'OR')
				$this->conditionOr[] = " (" . $this->conditions . ")";
			else
				$this->conditionAnd[] = " (" . $this->conditions . ")";
		}
		if(isset($this->searchTerms))
			$this->session->setVar("search_highlight", implode(",", $this->searchTerms));
		else
			$this->session->delVar("search_highlight");
	}
/**
* Create SQL condition fragments for resource timestamp.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field	The full database field we're searching on
* @param	string $fieldArray	The field's array name
* @param	string $integer	The input integer
*/
	function parseTimestamp($field, $fieldArray, $timestampArray)
	{
		$day = ($timestampArray['day'] < 10) ? '0' . $timestampArray['day'] : $timestampArray['day'];
		$month = ($timestampArray['month'] < 10) ? '0' . $timestampArray['month'] : $timestampArray['month'];
		$inputDate = $timestampArray['year'] . '-' . $month . '-' . $day;
		$inputTime = ' 00:00:00';
		if(($this->{'timestamp'}['logicInteger'] == '>') || ($this->{'timestamp'}['logicInteger'] == '<='))
			$inputTime = ' 23:59:59';
/**
* If we are searching on '=' a date, need to add a further condition
*/
		if($this->{'timestamp'}['logicInteger'] == '=')
		{
			$this->conditions = "(" . $field . ">=" . $this->db->tidyInput($inputDate . $inputTime);
			$inputTimestamp2 = $inputDate . ' 23:59:59';
			$this->conditions .= " AND " . $field . "<=" . $this->db->tidyInput($inputTimestamp2) . ")";
		}
		else
			$this->conditions = "(" . $field . $this->{'timestamp'}['logicInteger'] . 
				$this->db->tidyInput($inputDate . $inputTime) . ")";
	}
/**
* Create SQL condition fragments for integer-type fields.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field	The full database field we're searching on
* @param	string $fieldArray	The field's array name
* @param	string $integer	The input integer
*/
	function parseInteger($field, $fieldArray, $integer)
	{
		$typeCondition = array();
		if(array_key_exists('select', $this->$fieldArray))
		{
			foreach($this->{$fieldArray}['select'] as $type)
				$typeCondition[] = $this->db->formatField('type') . 
				"=" . $this->db->tidyInput($type);
		}
		$condition = !empty($typeCondition) ? " AND (" . join(" OR ", $typeCondition) . ")" : FALSE;
		$this->conditions = "(" . $field . $this->{$fieldArray}['logicInteger'] . 
			$integer . $condition . ")";
	}
/**
* Create SQL condition fragments for selectOnly fields such as category, keyword, collection etc.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field	The full database field we're searching on
* @param	string $fieldArray	The field's array name
* @param	array $array	The input array
*/
	function parseSelectOnly($field, $fieldArray, $array)
	{
		$boolean = array_key_exists('selectRadio', $this->$fieldArray) ? 
			" " . $this->{$fieldArray}['selectRadio'] . " " : ' OR ' ;
		foreach($array as $value)
		{
			if(($field == 'creator1') || ($field == 'creator2') || ($field == 'creator3') || 
				($field == 'creator4') || ($field == 'creator5') ||
				($field == 'categories') || 
				($fieldArray == 'resourceKeywords') || ($fieldArray == 'quoteKeywords') ||
				($fieldArray == 'paraphraseKeywords') || ($fieldArray == 'musingKeywords'))
			{
				$typeCondition = array();
				$setCondition = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
				$field . ")";
				if(array_key_exists('select', $this->{$fieldArray}))
				{
					foreach($this->{$fieldArray}['select'] as $type)
						$typeCondition[] = $this->db->formatField('type') . 
						"=" . $this->db->tidyInput($type);
				}
				$typeCondition = !empty($typeCondition) ? " AND (" . 
					join(' OR ', $typeCondition) . ")" : FALSE;
				$condition[] = $setCondition . $typeCondition;
			}
			else
				$condition[] = $field . "=" . $this->db->tidyInput($value);
		}
		$this->conditions = "(" . join($boolean, $condition) . ")";
	}
/**
* Parse the search string for BOOLEAN searches etc. and create the SQL condition fragments
* String can be:
* 	term1 AND term2 OR "term three" NOT "term four" AND term5 etc.
*
* @author	Mark Grimshaw
* @version	1
*
* @param	string $field	The full database field we're searching on
* @param	string $fieldArray	The field's array name
* @param	string $string	The input string
*/
	function parseString($field, $fieldArray, $string)
	{
// Find double-quoted terms first
		$string = preg_replace("/\s{2,}/", " ", stripslashes($string));
		$matches = split(' ', trim($string));
		$index = 0;
		$quoteStart = FALSE;
		foreach($matches as $part)
		{
			$part = trim($part);
			if(($part == 'AND') || ($part == 'OR') || ($part == 'NOT'))
				$merge[$index]['bool'] = $part;
			else if(substr($part, 0, 1) == "\"")
			{
				$merge[$index]['string'] = $part;
				if(!array_key_exists('bool', $merge[$index]))
					$merge[$index]['bool'] = 'AND';
				if(substr($part, -1) == "\"")
				{
					$index++;
					$quoteStart = FALSE;
				}
				else
					$quoteStart = TRUE;
			}
			else if(substr($part, -1) == "\"")
			{
				$merge[$index]['string'] .= ' ' . $part;
				if(!array_key_exists('bool', $merge[$index]))
					$merge[$index]['bool'] = 'AND';
				$index++;
				$quoteStart = FALSE;
			}
			else if($quoteStart)
				$merge[$index]['string'] .= ' ' . $part;
			else
			{
				$merge[$index]['string'] = $part;
				if(!array_key_exists('bool', $merge[$index]))
					$merge[$index]['bool'] = 'AND';
				$index++;
			}
		}
		if(!isset($merge))
			return;
		$firstTime = TRUE;
		foreach($merge as $array)
		{
			if(array_key_exists('partial', $this->$fieldArray))
			{
				$likeStart = " LIKE '%";
				$likeEnd = "%'";
			}
			else
			{
				$likeStart = " REGEXP '[[:<:]]";
				$likeEnd = "[[:>:]]'";
			}
			$bool = $array['bool'];
			$str = str_replace("\"", '', $array['string']);
			if($bool == 'NOT')
				$likeStart = " NOT" . $likeStart;
			if($field == 'title')
				$fragment = $this->db->concat(array(
					" CASE WHEN " . $this->db->formatField('subtitle') . " IS NULL" . 
					" THEN " . $this->db->formatField('WKX_resource.title') . 
					" ELSE " . 
					$this->db->concat(array($this->db->formatField('WKX_resource.title'), 
					$this->db->tidyInputNoTrim(': '), $this->db->formatField('subtitle'))) . 
					" END"
				)) .  $likeStart . trim($str) . $likeEnd;
//				$fragment = "CONCAT_WS(' ', $this->db->formatField('WKX_resource.title'), " . 
//				$this->db->formatField('subtitle') . ")" .  
//				$likeStart . trim($str) . $likeEnd;
			else
				$fragment = $field . $likeStart . trim($str) . $likeEnd;
			if(!$firstTime && ($bool == 'OR'))
				$conditionsOr[] = $fragment;
			else if(!$firstTime)
				$conditions[] = "AND" . ' ' . $fragment;
			else
				$conditions[] = $fragment;
			if($bool != 'NOT')
				$this->searchTerms[] = trim($str);
			$firstTime = FALSE;
		}
		$condition = "(" . join(" ", $conditions) . ")";
		if(isset($conditionsOr))
		{
			$conditionOr = join(" OR ", $conditionsOr);
			$this->conditions = $condition . " OR (" . $conditionOr . ")";
		}
		else
			$this->conditions = $condition;
	}
/**
* Create the SQL query string
* 
* @author	Mark Grimshaw
* @version	1
*
* @return	string		SQL query string
*/
	function createTotalSQL()
	{
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$order = $this->grabOrder();
		if($userBibCondition = $this->common->userBibCondition())
			$userBibCondition = " AND " . $userBibCondition;
		$joinStmt = $stmt->selectJoin() . ' ' . join(' ', $this->sqlJoin);
/**
* We always grab fields from `WKX_resource`
*/
		$sql = $this->db->selectNoExecute(array('WKX_resource'), $stmt->listFields());
		$firstCondition = TRUE;
		foreach($this->conditionAnd as $value)
		{
			if(!$firstCondition)
				$condition .= " AND " . $value;
			else
				$condition = $value;
			$firstCondition = FALSE;
		}
		foreach($this->conditionOr as $value)
		{
			if(!$firstCondition)
				$condition .= " OR " . $value;
			else
				$condition = $value;
			$firstCondition = FALSE;
		}
//		$sql .= $joinStmt . " WHERE (" . $condition . ")" . $userBibCondition . $order;
		$sql .= $joinStmt . " WHERE (" . $condition . ")" . $userBibCondition . 
			" GROUP BY " . $this->db->tidyInputClause("resourceId") . $order;
// write statement to session
		$this->session->setVar('sql_stmt', addslashes($sql));
		return $sql;
	}
/**
* Get the requested SQL ordering
* 
* @author	Mark Grimshaw
* @version	1
*
* @return	string		SQL order clause
*/
	function grabOrder()
	{
		if(!isset($this->order))
			return " ORDER BY " . $this->db->tidyInputClause('surname') . " ASC"; // default
		$index = 0;
		foreach($this->order as $array)
		{
			if(array_key_exists('order', $array))
			{
				$field = ($array['order'] == 'conferenceOrganiser') ? 'publisher' : $array['order'];
				$orderArray[$index] = $this->db->formatField($field);
			}
			if(array_key_exists('upDown', $array))
				$orderArray[$index] .= " " . $array['upDown'];
			$index++;
		}
		if(!isset($orderArray))
			return " ORDER BY " . $this->db->tidyInputClause('surname') . " ASC"; // default
		else
			return " ORDER BY " . join(", ", $orderArray);
	}
/**
* Write input to session if the calling process is NOT a Last Multi View action, paging or 
* add item to user bib function.
* 
* @author	Mark Grimshaw
* @version	1
*
*/
	function writeSession()
	{
// Last multi view only has action in query string
		if((sizeof($this->vars) == 1) || array_key_exists('pagingStart', $this->vars)
			 || ($this->vars['action'] == 'myWikindxBibliography'))
			return FALSE;
		$this->searchStringFound = $this->notInteger = $this->selectOnlyFound = FALSE;
/**
* Main checkboxes that turn on or off fields to search
*/
		foreach(array_keys($this->availableFields) as $field)
		{
			if(array_key_exists("powerSearch_$field", $this->vars))
				$this->searchFields[] = $field;
			else
				$this->session->delVar("powerSearch_" . $field);
		}
		$sessionVars = $this->session->getArray("powerSearch");
		foreach($this->vars as $key => $value)
		{
			if(!is_array($value))
				$value = trim($value);
			if(preg_match("/^powerSearch_/", $key))
			{
// Is this a multiple select box input?  If so, multiple choices are written to session as 
// comma-delimited string (no spaces).
// Don't write any FALSE or '0' values.
				if(is_array($value))
				{
					if(empty($value))
					{
						$this->session->delVar($key);
						continue;
					}
					if(preg_match("/^powerSearch_(.*)_selectOnly/", $key, $matches) && $value)
					{
						$field = $matches[1];
						$this->{$field}['selectOnly'] = $value;
						if(array_key_exists("powerSearch_$field", $this->vars))
							$this->selectOnlyFound = TRUE;
					}
					else if(preg_match("/^powerSearch_(.*)_select/", $key, $matches) && $value)
					{
						$field = $matches[1];
						$this->{$field}['select'] = $value;
					}
					$value = serialize($value);
				}
				else if(preg_match("/^powerSearch_(.*)_string/", $key, $matches) && $value)
				{
					$field = $matches[1];
					$this->{$field}['string'] = $value;
					if(array_key_exists("powerSearch_$field", $this->vars))
						$this->searchStringFound = TRUE;
				}
				else if(preg_match("/^powerSearch_(.*)_integer/", $key, $matches) 
					&& ($value != ''))
				{
					$field = $matches[1];
					$this->{$field}['integer'] = $value;
					if(!is_numeric($this->{$field}['integer']))
						$this->notInteger = TRUE;
					if(array_key_exists("powerSearch_$field", $this->vars))
						$this->searchStringFound = TRUE;
				}
				else if(($key == 'powerSearch_timestamp_year') 
					&& ($value != ''))
				{
					$field = 'timestamp';
					$this->{$field}['year'] = $value;
					if(!is_numeric($this->{$field}['year']) || (strlen($value) != 4))
						$this->notInteger = TRUE;
					if(array_key_exists("powerSearch_$field", $this->vars))
						$this->searchStringFound = TRUE;
				}
				else if(($key == 'powerSearch_timestamp_month') 
					&& ($value != ''))
				{
					$field = 'timestamp';
					$this->{$field}['month'] = $value;
					if(!is_numeric($this->{$field}['month']))
						$this->notInteger = TRUE;
				}
				else if(($key == 'powerSearch_timestamp_day') 
					&& ($value != ''))
				{
					$field = 'timestamp';
					$this->{$field}['day'] = $value;
					if(!is_numeric($this->{$field}['day']))
						$this->notInteger = TRUE;
				}
				else if(preg_match("/^powerSearch_(.*)_partial/", $key, $matches) && $value)
				{
					$field = $matches[1];
					$this->{$field}['partial'] = $value;
				}
				else if(preg_match("/^powerSearch_(.*)_radio/", $key, $matches) && $value)
				{
					$field = $matches[1];
					$this->{$field}['radio'] = $value;
				}
				else if(preg_match("/^powerSearch_(.*)_selectRadio/", $key, $matches) && $value)
				{
					$field = $matches[1];
					$this->{$field}['selectRadio'] = $value;
				}
				else if(preg_match("/^powerSearch_(.*)_logicInteger/", $key, $matches) && $value)
				{
					$field = $matches[1];
					$this->{$field}['logicInteger'] = $value;
				}
				else if(preg_match("/^powerSearch_(.*)_order_upDown/", $key, $matches) && $value)
					$this->order[$matches[1]]['upDown'] = $value;
				else if(preg_match("/^powerSearch_(.*)_order/", $key, $matches) && $value)
					$this->order[$matches[1]]['order'] = $value;
// If this is a different listing to the previous one, reset the paging counter.
				if($this->session->getVar("powerSearch_$key") != $value)
					$this->session->delVar('mywikindx_pagingStart');
				if(($value == '') || (is_array($value) && empty($value)))
					continue;
				$temp[$key] = base64_encode($value);
			}
		}
		if(!isset($this->searchFields))
			return FALSE;
// Write session array removing useless values
		if(isset($temp))
		{
			foreach(array_keys($this->availableFields) as $field)
			{
				if(!array_key_exists("powerSearch_" . $field, $temp))
				{
					if(($unsetKey = array_search($field, $this->searchFields)) !== FALSE)
						unset($this->searchFields[$unsetKey]);
					$this->session->delVar("powerSearch_" . $field);
				}
				if(!array_key_exists("powerSearch_" . $field . "_string", $temp) &&
					!array_key_exists("powerSearch_" . $field . "_integer", $temp) &&
					!array_key_exists("powerSearch_" . $field . "_selectOnly", $temp) &&
					!array_key_exists("powerSearch_" . $field . "_year", $temp))
				{
					$this->session->delVar("powerSearch_" . $field . "_string");
					$this->session->delVar("powerSearch_" . $field . "_integer");
					$this->session->delVar("powerSearch_" . $field);
					unset($temp["powerSearch_$field"]);
				}
				if(!array_key_exists("powerSearch_" . $field . "_partial", $temp))
					$this->session->delVar("powerSearch_" . $field . "_partial");
			}
			$this->session->writeArray($temp);
			return TRUE;
		}
		return FALSE;
	}
/**
* Get input from session if the calling process is a Last Multi View action, paging or 
* add item to user bib function.
* 
* @author	Mark Grimshaw
* @version	1
*
*/
	function getSession()
	{
		$this->searchStringFound = $this->notInteger = $this->selectOnlyFound = FALSE;
		$sessionVars = $this->session->getArray("powerSearch");
/**
* Main checkboxes that turn on or off fields to search
*/
		foreach(array_keys($this->availableFields) as $field)
		{
			if(array_key_exists("$field", $sessionVars))
				$this->searchFields[] = $field;
		}
		foreach($sessionVars as $key => $value)
		{
			$value = base64_decode($value);
// Is this a multiple select box input?
			if($valueArray = @unserialize($value))
			{
				if(preg_match("/^(.*)_selectOnly/", $key, $matches))
				{
					$field = $matches[1];
					$this->{$field}['selectOnly'] = $valueArray;
					if(array_key_exists($field, $sessionVars))
						$this->selectOnlyFound = TRUE;
				}
				else if(preg_match("/^(.*)_select/", $key, $matches))
				{
					$field = $matches[1];
					$this->{$field}['select'] = $valueArray;
				}
			}
			else if(preg_match("/^(.*)_string/", $key, $matches))
			{
				$field = $matches[1];
				$this->{$field}['string'] = $value;
				if(array_key_exists($field, $sessionVars))
					$this->searchStringFound = TRUE;
			}
			else if(preg_match("/^(.*)_integer/", $key, $matches)
				&& ($value != ''))
			{	
				$field = $matches[1];
				$this->{$field}['integer'] = $value;
				if(!is_numeric($this->{$field}['integer']))
					$this->notInteger = TRUE;
				if(array_key_exists($field, $sessionVars))
					$this->searchStringFound = TRUE;
			}
			else if($key == 'timestamp_year')
			{
				$field = 'timestamp';
				$this->{$field}['year'] = $value;
				if(!is_numeric($this->{$field}['year']))
					$this->notInteger = TRUE;
				if(array_key_exists("$field", $sessionVars))
					$this->searchStringFound = TRUE;
			}
			else if($key == 'timestamp_month')
			{
				$field = 'timestamp';
				$this->{$field}['month'] = $value;
				if(!is_numeric($this->{$field}['month']))
					$this->notInteger = TRUE;
				if(array_key_exists("$field", $sessionVars))
					$this->searchStringFound = TRUE;
			}
			else if($key == 'timestamp_day')
			{
				$field = 'timestamp';
				$this->{$field}['day'] = $value;
				if(!is_numeric($this->{$field}['day']))
					$this->notInteger = TRUE;
				if(array_key_exists("$field", $sessionVars))
					$this->searchStringFound = TRUE;
			}
			else if(preg_match("/^(.*)_partial/", $key, $matches))
			{
				$field = $matches[1];
				$this->{$field}['partial'] = $value;
			}
			else if(preg_match("/^(.*)_radio/", $key, $matches))
			{
				$field = $matches[1];
				$this->{$field}['radio'] = $value;
			}
			else if(preg_match("/^(.*)_selectRadio/", $key, $matches))
			{
				$field = $matches[1];
				$this->{$field}['selectRadio'] = $value;
			}
			else if(preg_match("/^(.*)_logicInteger/", $key, $matches))
			{
				$field = $matches[1];
				$this->{$field}['logicInteger'] = $value;
			}
			else if(preg_match("/^(.*)_order_upDown/", $key, $matches) && $value)
				$this->order[$matches[1]]['upDown'] = $value;
			else if(preg_match("/^(.*)_order/", $key, $matches) && $value)
				$this->order[$matches[1]]['order'] = $value;
		}
	}
/**
* Validate user input.
* Input comes either from form input or, when paging, from the session.
* 
* @author	Mark Grimshaw
* @version	1
*
*/
	function checkInput()
	{
		if(!$this->writeSession())
			$this->getSession();
		if(!isset($this->searchFields))
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!$this->searchStringFound && !$this->selectOnlyFound)
			$this->badInput($this->errors->text("inputError", "missing"));
		if($this->notInteger)
			$this->badInput($this->errors->text("inputError", "invalid"));
	}
/**
* Create array of search fields
* 
* @author	Mark Grimshaw
* @version	1
*
*/
	function fieldArrays()
	{
/**
* Fields we can search on and their database tables [0] with the ID [1] that refers to WKX_resource.id.
* FALSE indicates this is handled directly in the code or is `WKX_resource` (so is not JOINed as we always 
* search this table).
*/
		include_once("core/html/HTML.php");
		$html = new HTML();
		$this->availableFields = array(
				'title'		=>	array(FALSE, FALSE),
				'type'		=>	array(FALSE, FALSE),
				'creator1'	=>	array(FALSE, FALSE),
				'creator2'	=>	array(FALSE, FALSE),
				'creator3'	=>	array(FALSE, FALSE),
				'creator4'	=>	array(FALSE, FALSE),
				'creator5'	=>	array(FALSE, FALSE),
				'publisher'	=>	array(FALSE, FALSE),
				'conferenceOrganiser'	=>	array(FALSE, FALSE),
				'collectionTitle'	=>	array(FALSE, FALSE),
				'collectionTitleShort'	=>	array(FALSE, FALSE),
				'year1'		=>	array(FALSE, FALSE),
				'year2'		=>	array(FALSE, FALSE),
				'year3'		=>	array(FALSE, FALSE),
				'categories'	=>	array(FALSE, FALSE),
				'resourceKeywords'	=>	array(FALSE, FALSE),
				'url'		=>	array(FALSE, FALSE),
				'isbn'		=>	array(FALSE, FALSE),
				'abstract'	=>	array('WKX_resource_abstract', 'id'),
				'notes'		=>	array('WKX_resource_note', 'id'),
				'quotes'	=>	array(FALSE, FALSE),
				'numQuotes'	=>	array(FALSE, FALSE),
				'quoteComments'	=>	array(FALSE, FALSE),
				'quoteKeywords'	=>	array(FALSE, FALSE),
				'paraphrases'	=>	array(FALSE, FALSE),
				'numParaphrases'	=>	array(FALSE, FALSE),
				'paraphraseComments'	=>	array(FALSE, FALSE),
				'paraphraseKeywords'	=>	array(FALSE, FALSE),
				'musings'	=>	array(FALSE, FALSE),
				'numMusings'	=>	array(FALSE, FALSE),
				'musingKeywords'	=>	array(FALSE, FALSE),
// In WKX_resource
				'field1'	=>	array(FALSE, FALSE),
				'field2'	=>	array(FALSE, FALSE),
				'field3'	=>	array(FALSE, FALSE),
				'field4'	=>	array(FALSE, FALSE),
				'field5'	=>	array(FALSE, FALSE),
				'field6'	=>	array(FALSE, FALSE),
				'field7'	=>	array(FALSE, FALSE),
				'field8'	=>	array(FALSE, FALSE),
				'field9'	=>	array(FALSE, FALSE),
// In WKX_resource_misc
				'miscField1'	=>	array(FALSE, FALSE),
				'miscField2'	=>	array(FALSE, FALSE),
				'miscField3'	=>	array(FALSE, FALSE),
				'miscField4'	=>	array(FALSE, FALSE),
				'miscField5'	=>	array(FALSE, FALSE),
				'miscField6'	=>	array(FALSE, FALSE),
// In WKX_resource_page
				'pageStart'	=>	array(FALSE, FALSE),
				'pageEnd'	=>	array(FALSE, FALSE),
// In WKX_resource_timestamp
				"timestamp"	=>	array(FALSE, FALSE),
// User operations
				'addUserIdResource'	=>	array(FALSE, FALSE),
				'editUserIdResource'	=>	array(FALSE, FALSE),
				'addUserIdQuote'	=>	array(FALSE, FALSE),
				'addUserIdQuoteComment'	=>	array(FALSE, FALSE),
				'addUserIdParaphrase'	=>	array(FALSE, FALSE),
				'addUserIdParaphraseComment'	=>	array(FALSE, FALSE),
				'addUserIdMusing'	=>	array(FALSE, FALSE),
			);
/**
* Custom database fields
*/
		$recordset = $this->db->select(array("WKX_custom"), array('id', 'custom_label', 'custom_size'));
		while($row = $this->db->loopRecordSet($recordset))
		{
			$fieldName = "custom_" . $row['id'] . "_" . $row['custom_size'];
			$label = $html->dbToFormTidy($row['custom_label']);
			$this->availableFields[$fieldName] = array(FALSE, FALSE);
			$this->selectBoxes['custom'][$fieldName] = $label;
		}
	}
/**
* Create default arrays for the search form display
* 
* @author	Mark Grimshaw
* @version	1
*
*/
	function loadArrays()
	{
/**
* Grab creator names, categories, keywords etc.  If necessary, limit to user bibliography
*/
		$userBib = $this->session->getVar("mywikindx_bibliography_use");
		include_once("core/creator/CREATOR.php");
		$creator = new CREATOR($this->db);
//		$this->selectBoxes['creators'] = $creator->grabAll($userBib);
		$this->selectBoxes['creator1'] = $creator->grabAll($userBib, 'creator1');
		$this->selectBoxes['creator2'] = $creator->grabAll($userBib, 'creator2');
		$this->selectBoxes['creator3'] = $creator->grabAll($userBib, 'creator3');
		$this->selectBoxes['creator4'] = $creator->grabAll($userBib, 'creator4');
		$this->selectBoxes['creator5'] = $creator->grabAll($userBib, 'creator5');
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$this->selectBoxes['categories'] = $group->grabAll();
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$this->selectBoxes['resourceKeywords'] = $keyword->grabAll($userBib);
		$this->selectBoxes['quoteKeywords'] = $keyword->grabAll($userBib, 'WKX_resource_quote');
		$this->selectBoxes['paraphraseKeywords'] = $keyword->grabAll($userBib, 'WKX_resource_paraphrase');
		$this->selectBoxes['musingKeywords'] = $keyword->grabAll($userBib, 'WKX_resource_musing');
		include_once("core/publisher/PUBLISHER.php");
		$publisher = new publisher($this->db);
		$this->selectBoxes['publishers'] = $publisher->grabAll(FALSE, $userBib);
		$this->selectBoxes['conferenceOrganiser'] = $publisher->grabAllConfOrganisers($userBib);
		if($this->selectBoxes['publishers'] && $this->selectBoxes['conferenceOrganiser'])
			$this->selectBoxes['publishers'] = array_diff($this->selectBoxes['publishers'], 
			$this->selectBoxes['conferenceOrganiser']);
		include_once("core/user/USER.php");
		$user = new USER($this->db);
		$this->selectBoxes['users'] = $user->grabAll(TRUE);
		include_once("core/html/HTML.php");
		$html = new HTML();
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			$condition = " (WKX_resource_misc.id = " . 
				implode(" OR WKX_resource_misc.id = ", $bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_collection'), array(array('WKX_collection.id' => 'id'), 
				"collectionTitle", "collectionTitleShort"));
			$join = " LEFT JOIN " . $this->db->formatTable("WKX_resource_misc") . " ON " . 
				$this->db->formatfield("WKX_collection.id") . "=" . $this->db->formatfield("collection");
			$sql .= $join . " WHERE " . $condition . " ORDER BY " . 
				$this->db->tidyInputClause("collectionTitle");
		}
		else
			$sql = $this->db->selectNoExecute(array("WKX_collection"), array("id", "collectionTitle", 
				"collectionTitleShort"), " ORDER BY " . $this->db->tidyInputClause("collectionTitle"));
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$this->selectBoxes['collectionTitle'][$row['id']] = $html->dbToFormTidy($row['collectionTitle']);
			if($row['collectionTitleShort'])
				$this->selectBoxes['collectionTitleShort'][$row['id']] = 
				$html->dbToFormTidy($row['collectionTitleShort']);
		}
		if(!array_key_exists('collectionTitle', $this->selectBoxes))
			$this->selectBoxes['collectionTitle'] = FALSE;
		if(!array_key_exists('collectionTitleShort', $this->selectBoxes))
			$this->selectBoxes['collectionTitleShort'] = FALSE;
		$resourceFields = array('field1', 'field2', 'field3', 'field4', 'field5', 'field6', 'field7', 
			'field8', 'field9');
		$this->fieldArrays();
		$this->createForm = array();
		foreach($this->resourceMap->types as $type)
		{
			foreach($this->resourceMap->{$type}['resource_creator'] as $field => $creatorType)
			{
				if(($field != 'creator1') && 
				array_key_exists($field, $this->resourceMap->{$type}['resource_creator']))
				{
					$this->createForm[$field][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("creators", 
					$this->resourceMap->{$type}['resource_creator'][$field]);
				}
			}
			foreach($resourceFields as $field)
			{
				if(array_key_exists($field, $this->resourceMap->{$type}['resource'])
				&& (!array_key_exists($field, $this->createForm) || 
				(array_search($this->messages->text("resources", 
				$this->resourceMap->{$type}['resource'][$field]), 
				$this->createForm[$field]) === FALSE)))
					$this->createForm[$field][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("resources", 
					$this->resourceMap->{$type}['resource'][$field]);
			}
			if(array_key_exists('miscField4', $this->resourceMap->{$type}['resource_misc'])
				&& (!array_key_exists('miscField4', $this->createForm) || 
				(array_search($this->messages->text("resources", 
				$this->resourceMap->{$type}['resource_misc']['miscField4']), 
				$this->createForm['miscField4']) === FALSE)))
					$this->createForm['miscField4'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("resources", 
					$this->resourceMap->{$type}['resource_misc']['miscField4']);
			if(array_key_exists('year2', $this->resourceMap->{$type}['resource_year'])
				&& (!array_key_exists('year2', $this->createForm) || 
				(array_search($this->messages->text("resources", 
				$this->resourceMap->{$type}['resource_year']['year2']), 
				$this->createForm['year2']) === FALSE)))
			{
/**
* In some cases, the printed value from resourceMap for a particular database field is not very meaningful 
* so here we override those values with something more meaningful.
*/
				if(($type == 'proceedings') || ($type == 'proceedings_article'))
					$this->createForm['year2'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("powerSearch", "conferenceYear");
				else if($type == 'thesis')
					$this->createForm['year2'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("powerSearch", "abstractYear");
				else if(($type == 'web_article') || ($type == 'database'))
					$this->createForm['year2'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("powerSearch", "accessYear");
				else
					$this->createForm['year2'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("resources", 
					$this->resourceMap->{$type}['resource_year']['year2']);
			}
			if(array_key_exists('year3', $this->resourceMap->{$type}['resource_year'])
				&& (!array_key_exists('year3', $this->createForm) || 
				(array_search($this->messages->text("resources", 
				$this->resourceMap->{$type}['resource_year']['year3']), 
				$this->createForm['year3']) === FALSE)))
					$this->createForm['year3'][$type] = $this->messages->text("resourceType", 
					$type) . ": " . 
					$this->messages->text("resources", 
					$this->resourceMap->{$type}['resource_year']['year3']);
			$this->selectBoxes['type'][$type] = $this->messages->text("resourceType", $type);
		}
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($error));
	}
}
?>
