<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*
* LISTSOMERESOURCES class
*
* Lists certain resources from keyword and citation links clicked when viewing a solo resource.
* 
* @author Mark Grimshaw
* @version 1
* $Header: /cvsroot/wikindx/wikindx3/core/list/LISTSOMERESOURCES.php,v 1.9 2005/05/03 00:04:25 sirfragalot Exp $
*/
class LISTSOMERESOURCES
{
// Constructor
	function LISTSOMERESOURCES($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
	}
/*
* citeProcess - display resources citing this one
* 
* @author Mark Grimshaw
* @return string - template-processed browser output
*/
	function citeProcess($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "list"));
		if(!$ids = $this->session->getVar("list_citeIds"))
			$this->badInput($this->errors->text("inputError", "missing"));
		$this->session->delVar('mywikindx_pagingStart');
		$idCondition = implode(" OR WKX_resource.id = ", explode(",", $ids));
		$condition = " WHERE WKX_resource.id = " . $idCondition;
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$sqlTotal = $this->db->selectNoExecute(array("WKX_resource"),  
			$stmt->listFields($this->session->getVar('list_method')), 
			$stmt->listJoin($this->session->getVar('list_method'), $condition));
		$queryString = "action=listCiteProcess";
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 'listCite', 
			FALSE, $message);
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
/*
* keywordProcess - display resources with this keyword
* 
* @author Mark Grimshaw
* @return string - template-processed browser output
*/
	function keywordProcess($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "list"));
		$kId = array_key_exists("id", $this->vars) ? $this->vars["id"] : $this->session->getVar("list_ids");
// If this is a different keyword listing to the previous one, reset the paging counter.
		if($this->session->getVar("list_ids") != $kId)
			$this->session->delVar('mywikindx_pagingStart');
		if(!$kId && (!$kId = $this->session->getVar("list_ids")))
			$this->badInput($this->errors->text("inputError", "missing"));
		$this->session->setVar("list_ids", $kId);
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$join = " LEFT JOIN " . 
				$this->db->formatTable("WKX_resource_keyword") . " ON " . 
				$this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_keyword.id");
		$condition = " WHERE 
				FIND_IN_SET(" . $this->db->tidyInput($kId) . ", " . 
				$this->db->formatField('keywords') . 
				")";
// If we are browsing a user bibliography, we return only results from this bibliography
		if($useBib = $this->session->getVar("mywikindx_bibliography_use"))
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $id)
				$conditionArray[] = $this->db->tidyInput($id);
			$condition .= " AND (WKX_resource.id = " . 
				implode(" OR WKX_resource.id = ", $conditionArray) . ")";
		}
		$sqlTotal = $this->db->selectNoExecute(array("WKX_resource"),  
			$stmt->listFields($this->session->getVar('list_method')), 
			$stmt->listJoin($this->session->getVar('list_method'), $join . $condition));
		$queryString = "action=listKeywordProcess" . htmlentities("&id=" . $kId);
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 'listKeyword', 
			FALSE, $message);
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
/*
* badInput - tidily exit on failure
* 
* @author Mark Grimshaw
* @param string $error - error message
*/
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		$this->template->setVar('body', $error);
		new CLOSE($this->db, $this->template->process());
	}
}
?>
