<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* LISTALL class
*
* List all database resources.
* 
*****/
class LISTRESOURCES
{
// Constructor
	function LISTRESOURCES($db, $vars)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
		include_once("core/list/LISTCOMMON.php");
		$this->common = new LISTCOMMON($this->db, $this->vars);
	}
// display form options
	function display($error = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "list"));
///First check, do we have resources?
		$recordset = $this->db->select(array('WKX_database_summary'), array('totalResources'));
		if(!$this->db->fetchOne($recordset))
		{
			$this->template->setVar('body', $this->messages->text('misc', 'noResources'));
			return $this->template->process();
		}
		include_once("core/html/MISC.php");
		$pString = $error ? $error : FALSE;
		$this->userBib = $this->session->getVar("mywikindx_bibliography_use");
		$bib = FALSE;
		if($this->userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($this->userBib));
			$row = $this->db->fetchRow($recordset);
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
				$row['title'] . ")", "hint"));
		}
		else if($this->session->getVar('setup_multiUser'))
			$bib = MISC::p(MISC::span("(" . $this->messages->text("user", "bibliography") . ": " . 
			$this->messages->text("user", "masterBib") . ")", "hint"));
		$pString .= $bib;
		$this->methods = array(
					"creator" => $this->messages->text("list", "creator"),
					"title" => $this->messages->text("list", "title"),
					"publisher" => $this->messages->text("list", "publisher"),
					"year" => $this->messages->text("list", "year"),
					"timestamp" => $this->messages->text("list", "timestamp"),
				);
		$pString .= $this->makeForm();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// make a self-contained form with a select box
	function makeForm()
	{
//		$this->session->delVar('mywikindx_pagingStart');
		$pString = FORM::formHeader("listProcess");
		if($selected = $this->session->getVar("list_method"))
		{
			$pString .= FORM::selectedBoxValue(
				$this->messages->text("list", "listBy"), 
				"list_method", $this->methods, $selected, "5");
		}
		else
			$pString .= FORM::selectFBoxValue(
				$this->messages->text("list", "listBy"), "list_method", $this->methods, "5");
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= FORM::formSubmit("List");
		$pString .= FORM::formEnd();
		return $pString;
	}
// Display titles....
	function process($message = FALSE)
	{
		$input = $this->checkInput();
		$this->template->setVar('heading', $this->messages->text("heading", "list"));
		if($userBibCondition = $this->common->userBibCondition())
			$userBibCondition = " WHERE " . $userBibCondition;
		include_once("core/sql/STATEMENTS.php");
		$stmt = new STATEMENTS($this->db);
		$sqlTotal = $this->db->selectNoExecute(array("WKX_resource"),  
			$stmt->listFields($this->session->getVar('list_method')), 
			$stmt->listJoin($this->session->getVar('list_method'), $userBibCondition));
		$queryString = "action=listProcess";
		list($pString, $pagingString) = $this->common->listResources($sqlTotal, $queryString, 
			'list', FALSE, $message);
		$this->template->setVar('body', $pString);
		$this->template->setVar('paging', $pagingString);
		return $this->template->process();
	}
// write input to session
	function writeSession()
	{
// First, write all input with 'list_' prefix to session
		foreach($this->vars as $key => $value)
		{
			if(preg_match("/^list_/", $key))
				$temp[$key] = $value;
		}
// If this is a different listing to the previous one, reset the paging counter.
		if(array_key_exists('list_method', $this->vars) && 
		($this->session->getVar("list_method") != $this->vars['list_method']))
			$this->session->delVar('mywikindx_pagingStart');
		if(isset($temp))
			$this->session->writeArray($temp);
	}
// validate user input
// Input comes either from form input or, when paging, from the session.
	function checkInput()
	{
		if(array_key_exists("list_method", $this->vars) && $this->vars["list_method"])
			$type = $this->vars["list_method"];
		else if($this->session->issetVar('list_method'))
			$type = $this->session->getVar("list_method");
		else
			$this->badInput($this->errors->text("inputError", "missing", " (list_method) "));
		$this->writeSession();
		return $this->session->getArray("list");
	}
// Error handling
	function badInput($error)
	{
		include_once("core/html/CLOSE.php");
		new CLOSE($this->db, $this->display($error));
	}
}
?>
