<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*
* LISTCOMMON class - common functions for listing, searching, selecting etc. resources
* 
* @author Mark Grimshaw
* @version 1
* $Header: /cvsroot/wikindx/wikindx3/core/list/LISTCOMMON.php,v 1.9 2005/06/21 23:48:48 sirfragalot Exp $
*/
class LISTCOMMON
{
// Constructor
	function LISTCOMMON($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
	}
/**
* userBibCondition() - return a SQL condition clause if we are browsing a user bibliography to ensure that 
* listed, selected or searched resources come only from that user bibliography. If we are browsing the 
* master WIKINDX bibliography, return FALSE
*
* @return	SQL condition clasue or FALSE
*/
	function userBibCondition()
	{
		$condition = FALSE;
		if($useBib = $this->session->getVar("mywikindx_bibliography_use"))
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$conditionArray[] = $this->db->tidyInput($resourceId);
			$condition .= " (WKX_resource.id = " . implode(" OR WKX_resource.id = ", $conditionArray) . ")";
		}
		return $condition;
	}
/*
* listResources() - list each resource in the query in tabular format with view and edit links as required.
* 
* @author Mark Grimshaw
* 
* @param string $sqlTotal - SQL select statement to grab all resources required.
* @param string $queryString - URL query string such as "action=listProcess"
* @param string $listTYpe - What type of list/search/select process is this being called from?
* @param array $patterns - optional array of search terms to be matched and highlighted in bibstyle->process()
* @param string $message - optional message printed first
* @return string $pString
*/
	function listResources($sqlTotal, $queryString, $listType, $patterns = FALSE, $message = FALSE)
	{
/**
* If this is a new type of list process, reset the paging counter
*/
		if($this->session->getVar('sql_lastMulti') != $listType)
			$this->session->delVar('mywikindx_pagingStart');
		include_once("core/icons/LOADICONS.php");
		$icons = new LOADICONS();
		include_once("core/paging/PAGING.php");
		$paging = new PAGING($this->db, $this->vars, $sqlTotal);
		include_once("core/html/TABLE.php");
		include_once("core/styles/BIBSTYLE.php");
		$bibStyle = new BIBSTYLE($this->db, "html");
		$bibStyle->bibformat->patterns = $patterns;
		include_once("core/html/FORM.php");
		$pString = $message ? $message : '';
// type of CSS class required.
		$icons->getIconInfo('view');
		$icons->getIconInfo('viewmeta');
		$icons->getIconInfo('edit');
		$viewLink = $icons->viewExists ? "imgLink" : "link";
		$editLink = $icons->editExists ? "imgLink" : "link";
// write statement to session in case we need to export to RTF etc.
		$this->session->setVar('sql_stmt', addslashes($sqlTotal));
		$this->session->setVar("sql_lastView", 'multi');
// Display selection of user bibliographies if existing.
		list($string, $form) = $this->displaySelect($paging);
		$pString .= $string;
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
// Create SQL statement limiting no. resources to display based on paging preferences.
		$recordset = $paging->sqlLimit($sqlTotal);
		$index = 0;
		$highlight = $patterns ? htmlentities("&search=highlight") : FALSE;
		while($row = $this->db->loopRecordSet($recordset))
		{
			$links = array();
			$view = ($row['quotes'] || $row['paraphrases'] || $row['musings']) ? 
				$icons->viewmeta : $icons->view;
			$links[] = MISC::a("$viewLink", "&nbsp;" . $view . 
				"&nbsp;", "index.php?action=resourceView" . 
				htmlentities("&id=" . $row['resourceId']) . $highlight);
			if($this->session->getVar('setup_write'))
				$links[] = MISC::a("$editLink", "&nbsp;" . $icons->edit . 
				"&nbsp;", "index.php?action=resourceEdit" . htmlentities("&id=" . $row['resourceId']));
			if($form)
				$checkBox = "&nbsp;" . FORM::checkBox(FALSE, "bib_" . $row['resourceId']);
			else
				$checkBox = FALSE;
			$class = $index % 2 ? 'alternate2' : 'alternate1';
			$pString .= TABLE::trStart();
			$pString .= TABLE::td($bibStyle->process($row), $class);
			$pString .= TABLE::td(implode("&nbsp;&nbsp;", $links) . $checkBox, $class, "right", "top");
			$pString .= TABLE::trEnd();
			$index++;
		}
		$pString .= TABLE::tableEnd();
		if($form)
			$pString .= FORM::formEnd();
		$pagingString = $paging->links($queryString);
// set the lastMulti session variable for quick return to this process.
		$this->session->setVar('sql_lastMulti', $listType);
		return array($pString, $pagingString);
	}
// Display list information and userBib, category and keyword select box to add items to
	function displaySelect($pagingObject)
	{
		include_once("core/resource/RESOURCE.php");
		$resource = new RESOURCE($this->db, $this->vars);
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
		$usingBib = FALSE;
		$bibs = array();
		if($this->session->getVar('mywikindx_bibliographies'))
			$bibs = unserialize($this->session->getVar("mywikindx_bibliographies"));
		$useBib = $this->session->getVar('mywikindx_bibliography_use');
		if($useBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('title'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
			$row = $this->db->fetchRow($recordset);
			$usingBib = $row['title'];
			if(array_key_exists($useBib, $bibs))
			{
				$usingBib = $bibs[$useBib];
				unset($bibs[$useBib]);
			}
		}
		include_once("core/group/GROUP.php");
		$group = new GROUP($this->db);
		$categories = $group->grabAll();
		include_once("core/keyword/KEYWORD.php");
		$keyword = new KEYWORD($this->db);
		$keywords = $keyword->grabAll();
		if(!empty($bibs))
			$array[0] = $messages->text("resources", "addToBib");
		if($this->session->getVar('setup_write'))
		{
			if(sizeof($categories) > 1)
				$array[1] = $messages->text("resources", "addToCategory");
			if($keywords)
				$array[2] = $messages->text("resources", "addToKeyword");
		}
		if(!isset($array) || !$pagingObject->total)
			return array(MISC::p($pagingObject->linksInfo($usingBib)), FALSE);
		$pString = FORM::formHeader("addResourceTo");
		$pString .= FORM::hidden("method", "add");
		$pString .= TABLE::tableStart();
		$pString .= TABLE::trStart();
		if($usingBib)
			$pString .= TABLE::td($pagingObject->linksInfo($usingBib));
		else
			$pString .= TABLE::td($pagingObject->linksInfo());
		$sessVar = $this->session->getVar("resourceAddTo");
		$checkAll = $messages->text("resources", "addAll") . ":&nbsp;&nbsp;" . 
			FORM::checkbox(FALSE, "addAll");
		if($sessVar !== FALSE)
			$pString .= TABLE::td(FORM::selectedBoxValue($messages->text("resources",
				"addSelected"), "resourceAddTo", $array, $sessVar, sizeof($array)) . MISC::br() . 
				$checkAll . "&nbsp;&nbsp;" . 
				FORM::formSubmit("Proceed") . MISC::br() . "&nbsp;" . MISC::br(), FALSE, "right");
		else
			$pString .= TABLE::td(FORM::selectFBoxValue($messages->text("resources",
				"addSelected"), "resourceAddTo", $array, sizeof($array)) . MISC::br() . 
				$checkAll . "&nbsp;&nbsp;" . 
				FORM::formSubmit("Proceed") . MISC::br() . "&nbsp;" . MISC::br(), FALSE, "right");
		return array($pString, TRUE);
	}
}
?>
