<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Keywords class
*****/
class KEYWORD
{
// Constructor
	function KEYWORD($db, $vars = FALSE)
	{
		$this->db = $db;
		$this->vars = $vars;
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/MESSAGES.php");
		$this->messages = new MESSAGES();
		include_once("core/messages/SUCCESS.php");
		$this->success = new SUCCESS();
		include_once("core/messages/ERRORS.php");
		$this->errors = new ERRORS();
		include_once("core/html/MISC.php");
		include_once("core/html/FORM.php");
		include_once("core/html/HTML.php");
		$this->html = new HTML();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('content');
	}
// grab all current keywords
	function grabAll($userBib = FALSE, $table = 'WKX_resource_keyword')
	{
		$condition = FALSE;
		if($userBib)
		{
			$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
				" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($userBib));
			$dbBibs = $this->db->fetchOne($recordset);
			$bibsArray = explode(",", $dbBibs);
			foreach($bibsArray as $resourceId)
				$bibConditionArray[] = $this->db->tidyInput($resourceId);
			if($table == 'WKX_resource_quote')
			{
				$kField = 'quote_keywords';
				$id = 'resourceId';
			}
			else if($table == 'WKX_resource_paraphrase')
			{
				$kField = 'paraphrase_keywords';
				$id = 'resourceId';
			}
			else if($table == 'WKX_resource_musing')
			{
				$kField = 'musing_keywords';
				$id = 'resourceId';
			}
			else
			{
				$kField = 'keywords';
				$id = 'id';
			}
			$condition .= " ($table.id = " . 
				implode(" OR $table" . '.' . $id . " = ", $bibConditionArray) . ")";
			$sql = $this->db->selectNoExecute(array('WKX_keyword'), 
				array(array('WKX_keyword.id' => 'id'), 'keyword'));
			$join = " LEFT JOIN " . $this->db->formatTable($table) . " ON 
				FIND_IN_SET(" . $this->db->formatField("WKX_keyword.id") . ", " . 
				$this->db->formatField($kField) . ")";
			$sql .= $join . " WHERE " . $condition. ' ORDER BY ' . $this->db->tidyInputClause('keyword');
		}
		else
			$sql = $this->db->selectNoExecute(array('WKX_keyword'), 
				array('id', "keyword"), 'ORDER BY ' . $this->db->tidyInputClause('keyword'));
		$recordset = $this->db->query($sql);
		while($row = $this->db->loopRecordSet($recordset))
			$keywords[$row['id']] = $this->html->dbToFormTidy($row['keyword']);
		if(isset($keywords))
			return $keywords;
		return FALSE;
	}
// return a SQL condition clause when selecting by keyword
	function selectCondition($input)
	{
		$condition = '';
		$selectArray = explode(",", $input['keyword']);
		foreach($selectArray as $key => $value)
			$conditionArray[] = "FIND_IN_SET(" . $this->db->tidyInput($value) . ", " . 
			$this->db->formatfield('keywords') . ")";
		$condition .= implode(" " . $input['keywordMethod'] . " ", $conditionArray);
		return $condition;
	}
// write names to WKX_keyword and return leyword id array.
	function writeKeywordTable($sessionVars, $id = FALSE)
	{
		$fields[] = "keyword";
		$ids = $keywords = array();
		if(array_key_exists('keywords', $sessionVars))
			$keywords = explode(',', $sessionVars['keywords']);
		foreach($keywords as $keyword)
		{
			if(!$keyword = trim($keyword))
				continue;
			$values[0] = $keyword;
			if($id = $this->checkExists($keyword))
			{
				$ids[] = $id;
				foreach($fields as $field)
					$updateArray[$field] = array_shift($values);
				$this->db->update('WKX_keyword', $updateArray, 
					" WHERE " . $this->db->formatField('id') . "=" . $id);
			}
// given keyword doesn't exist so now write to db
			else
			{
				$this->db->insert('WKX_keyword', $fields, $values);
				$ids[] = $this->db->lastAutoId('WKX_keyword');
			}
		}
// merge two arrays to remove duplicate ids.
		if(array_key_exists('keyword_ids', $sessionVars) && $sessionVars['keyword_ids'])
			$ids = array_unique(array_merge($ids, explode(',', $sessionVars['keyword_ids'])));
		if(empty($ids))
			return FALSE;
// In case array key 0 ('IGNORE') is there, remove it
		if($id = array_search(0, $ids))
			unset($ids[$id]);
		return $ids;
	}
// Does this keyword already exist in the database?
	function checkExists($keyword)
	{
		$condition = " WHERE LOWER(" . $this->db->formatField('keyword') . ")=" . 
				$this->db->tidyInput(strtolower($keyword));
		$recordset = $this->db->select(array('WKX_keyword'), array('id'), $condition);
		if($this->db->numRows($recordset))
			return $this->db->fetchOne($recordset);
		return FALSE;
	}
	function removeHanging2($checkKeywords)
	{
		$temp = array();
		$recordset = $this->db->select(array("WKX_resource_keyword"), array('keywords'));
		while($row = $this->db->loopRecordSet($recordset))
			$temp = array_merge($temp, split(",", $this->db->fetchOne($recordset)));
		$recordset = $this->db->select(array("WKX_resource_quote"), array('quote_keywords'));
		while($row = $this->db->loopRecordSet($recordset))
			$temp = array_merge($temp, split(",", $this->db->fetchOne($recordset)));
		$recordset = $this->db->select(array("WKX_resource_paraphrase"), array('paraphrase_keywords'));
		while($row = $this->db->loopRecordSet($recordset))
			$temp = array_merge($temp, split(",", $this->db->fetchOne($recordset)));
		$recordset = $this->db->select(array("WKX_resource_musing"), array('musing_keywords'));
		while($row = $this->db->loopRecordSet($recordset))
			$temp = array_merge($temp, split(",", $this->db->fetchOne($recordset)));
		$checkKeywords = array_unique(split(",", $checkKeywords));
		$remainKeywords = array_unique($temp);
		$removeKeywords = array_diff($checkKeywords, $remainKeywords);
		if(!empty($removeKeywords))
		{
			foreach($removeKeywords as $key => $id)
				$removeKeywords[$key] = $this->db->tidyInput($id);
			$condition = $this->db->formatfield('id') . "=" . 
				join(" OR " . $this->db->formatfield('id') . "=", $removeKeywords);
			$this->db->delete("WKX_keyword", " WHERE " . $condition);
		}
		$this->db->optimize('WKX_keyword');
	}
// Remove resource-less keywords
	function removeHanging($resourceId, $newKeywordIds)
	{
		$recordset = $this->db->select(array('WKX_resource_keyword'), array('keywords'), 
			" WHERE " . $this->db->formatField('id') . "=" . $resourceId);
		$oldKeywordIds = explode(',',  $this->db->fetchOne($recordset));
		$lostIds = array_diff($oldKeywordIds, $newKeywordIds);
		foreach($lostIds as $id)
		{
			if($found = $this->checkAttached($id))
			{
				if($found == $resourceId)
					$this->db->delete('WKX_keyword', 
						" WHERE " . $this->db->formatField('id') . "=" . $id);
			}
		}
		$this->db->optimize('WKX_keyword');
	}
// Does this keyword ID have a resource attached to it?
	function checkAttached($keywordId)
	{
		$condition = " WHERE FIND_IN_SET(" . $this->db->tidyInput($keywordId) . ", " . 
			$this->db->formatField('keywords') . ")";
		$recordset = $this->db->select(array('WKX_resource_keyword'), array('id'), $condition);
		if($this->db->numRows($recordset) == 1)
			return $this->db->fetchOne($recordset);
		return FALSE;
	}
// Editing a keyword
// display the list of keywords:
	function editDisplay($message = FALSE)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "keyword") . ")"));
		$pString = $message ? $message : FALSE;
		$keywords = $this->grabAll();
		if(!$keywords)
		{
			$this->template->setVar('body', $this->messages->text("misc", "noKeywords"));
			return $this->template->process();
		}
		$pString .= FORM::formHeader("editKeyword");
		$pString .= FORM::selectFBoxValue(FALSE, "edit_keywordId", $keywords, 20);
		$pString .= MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// display the editing form:
	function editDisplayKeyword()
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "keyword") . ")"));
		$this->checkInput1();
		$sessionVars = $this->fromDbToSession($this->vars['edit_keywordId']);
		$pString = FORM::formHeader("editKeyword");
		$pString .= FORM::hidden("edit_keywordId", $this->vars['edit_keywordId']);
		$pString .= TABLE::tableStart(FALSE, 0, 0, 0, "left");
		$pString .= TABLE::trStart();
		$text = array_key_exists("keyword", $sessionVars) ? $sessionVars["keyword"] : FALSE;
		$pString .= TABLE::td(FORM::textInput($this->messages->text("resources", "keyword"), 
			"edit_keyword", $text, 60, 255) . " " . MISC::span('*', 'required'));
		$pString .= TABLE::trEnd();
		$pString .= TABLE::tableEnd() . MISC::br() . "&nbsp;" . MISC::br();
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database
	function edit()
	{
		if($this->session->getVar('editKeywordLock'))
			$this->badInput($this->errors->text("done", "keyword"));
		$this->checkInput2();
		if($keywordExistId = $this->checkExists($this->vars['edit_keyword']))
		{
			if($keywordExistId != $this->vars['edit_keywordId'])
				return $this->confirmDuplicate($keywordExistId);
		}
		$fields[] = 'keyword';
		$values[] = $this->vars['edit_keyword'];
		foreach($fields as $field)
			$updateArray[$field] = array_shift($values);
		$this->db->update('WKX_keyword', $updateArray, 
			"WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($this->vars['edit_keywordId']));
// lock reload
		$this->session->setVar('editJournalLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("keyword")));
	}
/**
* The new name equals one already in the database. Confirm that this edited one is to be removed and 
* all references to it replaced by the existing one.
*/
	function confirmDuplicate($keywordExistId)
	{
		$this->template->setVar('heading', $this->messages->text("heading", "edit", " (" . 
			$this->messages->text("resources", "keyword") . ")"));
		$pString = $this->errors->text("warning", "keywordExists");
		$pString .= MISC::p($this->messages->text("misc", "keywordExists"));
		$pString .= FORM::formHeader("editKeywordConfirm");
		$pString .= FORM::hidden("edit_keywordId", $this->vars['edit_keywordId']);
		$pString .= FORM::hidden("edit_keywordExistId", $keywordExistId);
		$pString .= MISC::p(FORM::formSubmit("Proceed"), FALSE, "right");
		$pString .= FORM::formEnd();
		$this->template->setVar('body', $pString);
		return $this->template->process();
	}
// write to the database.
	function editConfirm()
	{
		if($this->session->getVar('editKeywordLock'))
			$this->badInput($this->errors->text("done", "keyword"));
		$oldId = $this->vars['edit_keywordId'];
		$existId = $this->vars['edit_keywordExistId'];
// Delete old keyword
		$this->db->delete("WKX_keyword", "WHERE " . $this->db->formatField('id') . "=" . 
			$this->db->tidyInput($oldId));
		$this->updateKeywords($oldId, $existId, "WKX_resource_keyword", "keywords");
		$this->updateKeywords($oldId, $existId, "WKX_resource_musing", "musing_keywords");
		$this->updateKeywords($oldId, $existId, "WKX_resource_paraphrase", "paraphrase_keywords");
		$this->updateKeywords($oldId, $existId, "WKX_resource_quote", "quote_keywords");
// lock reload
		$this->session->setVar('editKeywordLock', TRUE);
// Clear session
		$this->session->clearArray("edit");
// send back to editDisplay with success message
		new CLOSE($this->db, $this->editDisplay($this->success->text("keyword")));
	}
/**
* Update keyword fields in various tables when a keyword has been removed and replaced by another during 'edit keyword' operation
*/
	function updateKeywords($oldId, $existId, $table, $field)
	{
		$condition = " WHERE FIND_IN_SET(" . $this->db->tidyInput($oldId) . ", " . 
			$this->db->formatField($field) . ")";
		$recordset = $this->db->select(array($table), array('id', $field), $condition);
		while($row = $this->db->loopRecordSet($recordset))
		{
			$array = split(",", $row[$field]);
// remove current id
			if(($key = array_search($oldId, $array)) !== FALSE)
				unset($array[$key]);
// array_search() seems to have a problem where there is only one element in an array - this is a cludge solution......... :(
			if($row[$field] === $oldId)
			{
				unset($array);
				$keywordString = $existId;
			}
// if existing id doesn't exist, add it.
			if(isset($array))
			{
				$key = array_search($existId, $array);
				if($key === FALSE)
					$array[] = $existId;
				$keywordString = join(",", $array);
			}
			$this->db->update($table, 
				array($field => $keywordString),  
				"WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($row['id']));
		}
	}
// from database to session
	function fromDbToSession($id)
	{
		$recordset = $this->db->select(array('WKX_keyword'), array("keyword"), 
			" WHERE " . $this->db->formatField('id') . "=" . $this->db->tidyInput($id));
		$keyword = $this->db->fetchRow($recordset);
		$this->session->setVar("edit_keyword", $this->html->dbToFormTidy($keyword['keyword']));
		return $this->session->getArray("edit");
	}
// Check we have appropriate input
	function checkInput1()
	{
		if(!array_key_exists('edit_keywordId', $this->vars) || !$this->vars['edit_keywordId'])
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// Check we have appropriate input
	function checkInput2()
	{
		if(!array_key_exists('edit_keywordId', $this->vars) || !$this->vars['edit_keywordId'])
			$this->badInput($this->errors->text("inputError", "missing"));
		if(!array_key_exists('edit_keyword', $this->vars) || !trim($this->vars['edit_keyword']))
			$this->badInput($this->errors->text("inputError", "missing"));
	}
// return link to other resources having this resource's keyword or just the plain keyword if no other resources found.
	function getKeywordLink($resourceId, $keywordId, $keyword)
	{
		$sql = $this->keywordSql($keywordId);
// If we are browsing a user bibliography, we return only results from this bibliography
		if($useBib = $this->session->getVar("mywikindx_bibliography_use"))
		{
			if($this->userBibKeywords($sql, $resourceId, $useBib))
				return MISC::a("link", $keyword, "index.php?action=listKeywordProcess" . 
					htmlentities("&id=" . $keywordId));
			else
				return $keyword;
		}
// Results from the Master Bibliography
		$masterSql = $sql . " AND (" . $this->db->formatField('WKX_resource.id') . " != " . 
			$this->db->tidyInput($resourceId) . ")";
		$recordset = $this->db->query($masterSql);
		while($line = $this->db->loopRecordSet($recordset))
			$masterKeywordResources[] = $line['resourceId'];
		if(isset($masterKeywordResources))
			return MISC::a("link", $keyword, "index.php?action=listKeywordProcess" . 
				htmlentities("&id=" . $keywordId));
		else
			return $keyword;
	}
// Create basic SQL to find resources with one keyword
	function keywordSql($keywordId)
	{
		return $this->db->selectNoExecute(
			array("WKX_resource"), array(array("WKX_resource.id" => "resourceId")), 
			" LEFT JOIN " . 
				$this->db->formatTable("WKX_resource_keyword") . " ON " . 
				$this->db->formatField("WKX_resource.id") . "=" . 
				$this->db->formatField("WKX_resource_keyword.id") .  
			" WHERE FIND_IN_SET(" . $this->db->tidyInput($keywordId) . ", " . 
				$this->db->formatField('keywords') . ")"
			);
	}
// Scan user bibliography for keywords
	function userBibKeywords($sql, $resourceId, $useBib)
	{
		$recordset = $this->db->select(array('WKX_user_bibliography'), array('bibliography'), 
			" WHERE " . $this->db->formatfield('id') . "=" . $this->db->tidyInput($useBib));
		$dbBibs = $this->db->fetchOne($recordset);
		$bibsArray = explode(",", $dbBibs);
		$bibCondition = "(" . $this->db->formatfield('WKX_resource.id') . " = ";
		foreach($bibsArray as $id)
		{
			if($id == $resourceId)
				continue;
			$conditionArray[] = $this->db->tidyInput($id);
		}
		if(!isset($conditionArray))
			return FALSE;
		$bibCondition .= implode(" OR " . $this->db->formatfield('WKX_resource.id') . " = ", 
			$conditionArray) . ")";
		$sql .= " AND " . $bibCondition;
		while($line = $this->db->loopRecordSet())
			$bibKeywordResources[] = $line['resourceId'];
		if(isset($bibKeywordResources))
			return $bibKeywordResources;
	}
// Error handling - send them back to view creator list.
	function badInput($error)
	{
		new CLOSE($this->db, $this->editDisplay($error));
	}
}
?>
