/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net

$Header: /cvsroot/wikindx/wikindx3/core/javascript/common.js,v 1.9 2005/06/29 20:21:20 sirfragalot Exp $

**********************************************************************************/
// MG 14/Dec/2004 - added licence information.

/* cite scripts */
function init(){ // init() is called in body.tpl
 initCiteLinks();
 initPreviewLinks();
 initCheckAll();
}

/**
* Create the preview link for bibliographic style editing, hiding the link for non-javascript-enabled browsers.
* 
* @author	Jess Collicott
* @editor	Mark Tsikanovski and Mark Grimshaw
* @version	2
*/
function initPreviewLinks(){ // collect any links for style template preview, add onclick events and make them visible
 var citeLinkKeyString = 'action=previewStyle'; // use this string to detect Cite links
 var citeLinkKeyRegEx = new RegExp(citeLinkKeyString,'i');
 var links = document.getElementsByTagName('body').item(0).getElementsByTagName('a'); // get collection of all links
 var linksLength = links.length; // cache

// As of 3.1, style previewing is not working in IE so turn it off all together.
var agt = navigator.userAgent.toLowerCase();
  var is_ie = ((agt.indexOf("msie") != -1));
  if (is_ie)
  {
	for (i=0;i<linksLength;i++)
	{
		if (typeof(links[i].href) != 'undefined' && links[i].href.search(citeLinkKeyRegEx) != -1)
		{
			links[i].className = 'linkCiteHidden';
		}
	}
	return;
  }
  
 for (i=0;i<linksLength;i++){
  if (typeof(links[i].href) != 'undefined' && links[i].href.search(citeLinkKeyRegEx) != -1){
    if (links[i].className == 'imgLink linkCiteHidden') {
	  links[i].className = 'imgLink linkCite';
	}
	else {
      links[i].className = 'link linkCite';
	}
  }
 }
}
/**
* Create the citation link for resource meta data, hiding the link for non-javascript-enabled browsers.
* 
* @author	Jess Collicott
* @editor	Mark Tsikanovski
* @version	2
*/
function initCiteLinks(){ // collect any links for Cite, add onclick events and make them visible
 var citeLinkKeyString = 'action=citeDisplay'; // use this string to detect Cite links
 var citeLinkKeyRegEx = new RegExp(citeLinkKeyString,'i');
 var links = document.getElementsByTagName('body').item(0).getElementsByTagName('a'); // get collection of all links
 var linksLength = links.length; // cache
 for (i=0;i<linksLength;i++){
  if (typeof(links[i].href) != 'undefined' && links[i].href.search(citeLinkKeyRegEx) != -1){
    if (links[i].className == 'imgLink linkCiteHidden') {
	  links[i].className = 'imgLink linkCite';
	}
	else {
      links[i].className = 'link linkCite';
	}
  }
 }
}
function openCiteWindow(url){
 var citeWindow = window.open(url,'winCite','height=655,width=460,status,scrollbars,resizable,dependent');
}
/* end cite scripts */

/**
* pop-up window for style previews
* 
* @Author Mark Grimshaw with a lot of help from Christian Boulanger
*/
function openPopUpStylePreview(url, height, width, templateName)
{
	var fieldArray = new Array ("style_titleCapitalization", "style_primaryCreatorFirstStyle", 
			"style_primaryCreatorOtherStyle", "style_primaryCreatorInitials", 
			"style_primaryCreatorFirstName", "style_otherCreatorFirstStyle", 
			"style_otherCreatorOtherStyle", "style_otherCreatorInitials", "style_dayFormat", 
			"style_otherCreatorFirstName", "style_primaryCreatorList", "style_otherCreatorList",
			"style_primaryCreatorListAbbreviationItalic", "style_otherCreatorListAbbreviationItalic", 
			"style_monthFormat", "style_editionFormat", "style_primaryCreatorListMore", 
			"style_primaryCreatorListLimit", "style_dateFormat", 
			"style_primaryCreatorListAbbreviation", "style_otherCreatorListMore", 
			"style_runningTimeFormat", "style_primaryCreatorRepeatString", "style_primaryCreatorRepeat", 
			"style_otherCreatorListLimit", "style_otherCreatorListAbbreviation", "style_pageFormat", 
			"style_editorSwitch", "style_editorSwitchIfYes", "style_primaryCreatorUppercase", 
			"style_otherCreatorUppercase", "style_primaryCreatorSepFirstBetween", 
			"style_primaryCreatorSepNextBetween", "style_primaryCreatorSepNextLast", 
			"style_otherCreatorSepFirstBetween", "style_otherCreatorSepNextBetween", 
			"style_otherCreatorSepNextLast", "style_primaryTwoCreatorsSep", "style_otherTwoCreatorsSep", 
			"style_userMonth_1", "style_userMonth_2", "style_userMonth_3", "style_userMonth_4", 
			"style_userMonth_5", "style_userMonth_6", "style_userMonth_7", "style_userMonth_8", 
			"style_userMonth_9", "style_userMonth_10", "style_userMonth_11", "style_userMonth_12", 
			"style_dateRangeDelimit1", "style_dateRangeDelimit2", "style_dateRangeSameMonth"
		);
			
	var styleArray = new Array ();
	for (index = 0; index < fieldArray.length; index++)
	{
		var currFormField = document.forms[0][fieldArray[index]];
		if ((currFormField.type == "checkbox") && currFormField.checked)
			styleArray[fieldArray[index]] = "on"; // checkbox
		else if (currFormField.type != "checkbox")
			styleArray[fieldArray[index]] = currFormField.value; // input and textarea
    }
	
//		styleArray[fieldArray[index]] = document.forms[0][fieldArray[index]].value;
    var a_php = "";
    var total = 0;
    for (var key in styleArray)
    {
        ++ total;
        a_php = a_php + "s:" +
                String(key).length + ":\"" + String(key) + "\";s:" +
                String(styleArray[key]).length + ":\"" + String(styleArray[key]) + "\";";
    }
    a_php = "a:" + total + ":{" + a_php + "}";
    url = url + "&style=" + escape(a_php);
	var templateString = document.forms[0][templateName].value; 
	url = url +"&templateName=" + escape(templateName) + "&templateString=" + escape(templateString);
	var popUp = window.open(url,'popUp','height='+height,'width='+width,'status,scrollbars,resizable,dependent');
}

/**
* Set up for icon or text Check All and Uncheck All links in Power Search
* 
* @author	Mark Tsikanovski
* @version	1
*/
function initCheckAll(){ // collect any links for Check All and Uncheck All, add onclick events and make them visible
 var checkAllLinkKeyString = 'checkAll'; // use this string to detect Check All links
 var uncheckAllLinkKeyString = 'uncheckAll'; // use this string to detect Uncheck All links
 var checkAllLinkKeyRegEx = new RegExp(checkAllLinkKeyString,'i');
 var uncheckAllLinkKeyRegEx = new RegExp(uncheckAllLinkKeyString,'i');
 var links = document.getElementsByTagName('body').item(0).getElementsByTagName('a'); // get collection of all links
 var linksLength = links.length; // cache
 for (i=0;i<linksLength;i++){
  if (typeof(links[i].href) != 'undefined' && (links[i].href.search(checkAllLinkKeyRegEx) != -1 || links[i].href.search(checkAllLinkKeyRegEx) != -1)){
    if (links[i].className == 'imgLink linkCiteHidden') {
	  links[i].className = 'imgLink linkCite';
	}
	else {
      links[i].className = 'link linkCite';
	}
  }
 }
}

/**
* Check all field checkboxes in Power Search
* 
* @author	Mark Tsikanovski
* @version	1
*/
function checkAll() { // Check all checkboxes except those with _partial in their name
  var InputElements = document.getElementsByTagName("input");
  for (var i = 0; i < InputElements.length; i++) { //loop through input elements
    var ThisInputElement = InputElements[i];
    if (ThisInputElement.type == "checkbox" && ThisInputElement.name.search(/_partial/) == -1) {
      ThisInputElement.checked = true;
	}
  }
}

/**
* Uncheck all field checkboxes in Power Search
* 
* @author	Mark Tsikanovski
* @version	1
*/
function uncheckAll() { // Uncheck all checkboxes except those with _partial in their name
  var InputElements = document.getElementsByTagName("input");
  for (var i = 0; i < InputElements.length; i++) { //loop through input elements
    var ThisInputElement = InputElements[i];
    if (ThisInputElement.type == "checkbox" && ThisInputElement.name.search(/_partial/) == -1) {
      ThisInputElement.checked = false;
	}
  }
}

/* ===== common JavaScript functions ===== */

// placeholder