<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system. v2.x
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
*	Initialize a few default variables before we truly enter the system.
*****/
class INIT
{
// Constructor
	function INIT()
	{
// Set to error_reporting(0) before release!!!!!!!!!
// For debugging, set to E_ALL
//		error_reporting(E_ALL);
		error_reporting(0);
// buffer printing to browser
		ob_start();
// make sure that Session output is XHTML conform ('&amp;' instead of '&')
		ini_set('arg_separator.output', '&amp;');
		set_magic_quotes_runtime(0);
// Check we have PHP 4.3 and above.
		if(($PHP_VERSION = phpversion()) < '4.3')
			die("WIKINDX requires PHP 4.3 or greater.  Your PHP version is $PHP_VERSION. Please upgrade.");
	}
// Make sure we get HTTP VARS in whatever format they come in
	function getVars()
	{
		if(!empty($_POST))
			$vars = $_POST;
		else if(!empty($_GET))
			$vars = $_GET;
// We now check that phpversion is 4.3 or above so these are no longer necessary
//		else if(!empty($HTTP_POST_VARS))
//			$vars = $HTTP_POST_VARS;
//		else if(!empty($HTTP_GET_VARS))
//			$vars = $HTTP_GET_VARS;
		else
			return FALSE;
		if(!get_magic_quotes_gpc())
			$vars = array_map(array("INIT", "magicSlashes"), $vars);
		return $vars;
	}
// start the SESSION
	function startSession()
	{
// start session
		session_start();
	}
// Add slashes to all incoming GET/POST data.  We now know what we're dealing with and can code accordingly.
	function magicSlashes($element)
	{
		if(is_array($element))
			return array_map(array("INIT", "magicSlashes"), $element);
		else
			return addslashes($element);
	}
// WIKINDX version no., copyright year and URL
	function version()
	{
		 return array("v3.1", "2005", "http://wikindx.sourceforge.net/");
	}
// Database version - checked in core/init/SYSTEMCHECK.php prompting automatic upgrade of database or not
	function dbVersion()
	{
		return "3.1";
	}
// some default variables/constants
	function initDbQueries()
	{
// Initialize the no. of database queries counter
		 return 0;
	}
}
