<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* LOADICONS class
*
*****/
class LOADICONS
{
// Constructor
    function LOADICONS()
    {
        include_once("core/session/SESSION.php");
        $session = new SESSION();
        include_once("core/messages/MESSAGES.php");
        $messages = new MESSAGES();
        include_once("core/html/MISC.php");
        if(!$this->templateDir = $session->getVar("setup_template"))
            $this->templateDir = "default";
// Sometimes a directory may have been removed but that language is still in the session or database preferences 
// ... fall back to default and hope it's still there ;)
        if(!is_dir("templates/" . $this->templateDir))
            $this->templateDir = "default";
// The default state in case icons cannot be found
        $this->view = 'v';
        $this->viewmeta = 'V'; // metadata exists for this resource (quotes etc.)
        $this->edit = 'E';
        $this->delete = 'X';
	$this->next = $messages->text("resources", "next");
	$this->previous = $messages->text("resources", "previous");
	$this->cite = $messages->text("cite", 'cite');
	$this->add = $messages->text("misc", "add");
	$this->file = FALSE;  // The code uses the actual file name in core/resource/RESOURCEVIEW.php
	$this->checkall = $messages->text("powerSearch", "checkAll");
	$this->uncheckall = $messages->text("powerSearch", "uncheckAll");
    }
// Get icon info
    function getIconInfo($input)
    {
// check we have both icons directory and icons themselves
	$exists = $input . "Exists";
	$this->$exists = FALSE;
        if(is_dir("templates/" . $this->templateDir . "/icons"))
        {
            if(is_file("templates/" . $this->templateDir. "/icons/$input.gif"))
            {
// get image size data
		$this->size = GetImageSize("templates/" . $this->templateDir. "/icons/$input.gif");
		if(!empty($this->size))
                {
                    	$this->$input = MISC::img("templates/" . $this->templateDir. "/icons/$input.gif", 
                        	$this->size[0], $this->size[1], $this->$input);
			$this->$exists = TRUE;
               }
            }
        }   
    }
}
?>
