<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms 
of the GNU General Public License as published by the Free Software Foundation; either 
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; 
if not, write to the 
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* HTML <table> widgets class
*****/
class TABLE
{
// constructor
	function TABLE()
	{
	}
// code for starting a table
	function tableStart($class = FALSE, $border = 0, $spacing = 0, $padding = 0, $align = "center", $width="100%")
	{
		$string = <<< END
<table class="$class" border="$border" cellspacing="$spacing" cellpadding="$padding" align="$align" width="$width">
END;
		return $string . "\n";
	}
// code for ending a table
	function tableEnd()
	{
		$string = <<< END
</table>
END;
		return $string . "\n";
	}
// return properly formatted <tr> start tag
	function trStart($class = FALSE, $align = "left", $vAlign = "top")
	{
		$string = <<< END
<tr class="$class" align="$align" valign="$vAlign">
END;
		return $string . "\n";
	}
// return properly formatted <tr> end tag
	function trEnd()
	{
		$string = <<< END
</tr>
END;
		return $string . "\n";
	}
// return properly formatted <td> tag
	function td($data, $class = FALSE, $align = "left", $vAlign = "top", $colSpan = FALSE, $width=FALSE)
	{
		$string = <<< END
<td class="$class" align="$align" valign="$vAlign" colspan="$colSpan" width="$width">
$data
</td>
END;
		return $string . "\n";
	}
// return start TD tag
	function tdStart($class = FALSE, $align = "left", $vAlign = "top", $colSpan = FALSE)
	{
		return "<td class=\"$class\" align=\"$align\" valign=\"$vAlign\" colspan=\"$colSpan\">\n";
	}
// return td end tag
	function tdEnd()
	{
		return "</td>\n";
	}
}
?>
