<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* MISC class
*
* Miscellaneous HTML elements
*****/
class MISC
{
// Constructor
	function MISC()
	{
	}
// <hr>
	function hr($class = FALSE)
	{
		$string = <<< END
<hr class="$class" />
END;
		return $string . "\n";
	}
// <P>
	function p($data = '', $class = FALSE, $align = "left")
	{
		$string = <<< END
<p class="$class" align="$align">$data</p>
END;
		return $string . "\n";
	}
// <BR>
	function br()
	{
		$string = <<< END
<br />
END;
		return $string . "\n";
	}
// <UL>
	function ul($data, $class = FALSE)
	{
		$string = <<< END
<ul class="$class">$data</ul>
END;
		return $string . "\n";
	}
// <OL>
	function ol($data, $class = FALSE, $type = "1")
	{
		$string = <<< END
<ul class="$class" type="$type">$data</ul>
END;
		return $string . "\n";
	}
// <LI>
	function li($data, $class = FALSE)
	{
		$string = <<< END
<li class="$class">$data</li>
END;
		return $string . "\n";
	}
// <STRONG>
	function b($data, $class = FALSE)
	{
		return <<< END
<strong class="$class">$data</strong>
END;
	}
// <EM>
	function i($data, $class = FALSE)
	{
		return <<< END
<em class="$class">$data</em>
END;
	}
// <U>
	function u($data, $class = FALSE)
	{
		return <<< END
<u class="$class">$data</u>
END;
	}
// <SPAN>
	function span($data, $class = FALSE)
	{
		return <<< END
<span class="$class">$data</span>
END;
	}
// <Hx>
	function h($data, $class = FALSE, $level = 4)
	{
		$tag = 'h' . $level;
		$string = <<< END
<$tag class="$class">$data</$tag>
END;
		return $string . "\n";
	}
// <img>
	function img($src, $width, $height, $alt = "")
	{
		$string = <<< END
<img src="$src" border="0" width="$width" height="$height" alt="$alt" />
END;
		return $string . "\n";
	}
// <A>
	function a($class, $label, $link, $target = "_self")
	{
// NB - no blank line before END;
		return <<< END
<a class="$class" href="$link" target="$target">$label</a>
END;
	}
// <A NAME="...">
	function aName($name)
	{
		$string = <<< END
<a name="$name"></a>
END;
		return $string . "\n";
	}
// <script src="...">
	function jsExternal($src)
	{
		$string = <<< END
<script src="$src" type="text/javascript"></script>
END;
		return $string . "\n";
	}
}
?>
