<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* MENU class
*
* Print menus
*
*****/
class MENU
{
// Constructor
	function MENU()
	{
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('menu');
	}
// configure menus
	function configure()
	{
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
// Build arrays of menus items.  First element of array name is main menu item name, subsequent elements are the names
// of the submenu with its
// hyperlink.  This provides easy access for both building CSS menus and for displaying links for non-CSS drop-down
// web browsers.
		$this->wikindx = array(
				'Wikindx'				=>	'index.php?action=frontNoMenu',
				$messages->text("menu", "home")		=>	'index.php',
			);
		if($this->session->getVar("setup_news"))
			$this->wikindx[$messages->text("menu", "news")] = 'index.php?action=viewNews';
		if($this->session->getVar("setup_bibliographies"))
			$this->wikindx[$messages->text("menu", "bibs")] = 'index.php?action=initBibliographies';
		$this->wikindx[$messages->text("menu", "prefs")] = 'index.php?action=preferencesDisplay';
		if($this->session->getVar("setup_userId"))
			$this->wikindx[$messages->text("menu", "myWikindx")] = 'index.php?action=initMyWikindx';
		else if($this->session->getVar("setup_multiUser") && $this->session->getVar("setup_userRegistration") 
			&& !$this->session->getVar("setup_userId"))
				$this->wikindx[$messages->text("menu", "register")] = 'index.php?action=initRegisterUser';
		if(!$this->session->getVar('setup_write'))
			$this->wikindx[$messages->text("menu", "userLogon")] = 'index.php?action=initLogon';
		else if($this->session->getVar("setup_write"))
			$this->wikindx[$messages->text("menu", "logout")] = 'index.php?action=logout';
		$this->file = array(
				$messages->text("menu", "file")		=>	'index.php?action=fileNoMenu',
				$messages->text("menu", "rtfexp")	=>	'index.php?action=exportRtfSetup',
				$messages->text("menu", "risExp")	=>	'index.php?action=exportRis',
				$messages->text("menu", "endnoteExp")	=>	'index.php?action=exportEndnoteStage1',
				$messages->text("menu", "exportBibtex")	=>	'index.php?action=exportBibtexStage1',
				$messages->text("menu", "htmlExp")	=>	'index.php?action=exportHtml',
				$messages->text("menu", "show")		=>	'index.php?action=showFiles',
			);
		$bookmarks = $this->session->getArray("bookmark");
		if((sizeof($bookmarks) > 1) || $this->session->getVar("bookmark_displayAdd"))
			$this->bookmark = array(
				$messages->text("menu", "bookmark")		=>	'index.php?action=bookmarkNoMenu',
			);
		if($this->session->getVar("bookmark_displayAdd"))
		{
			$found = FALSE;
			for($i = 1; $i <= 10; $i++)
			{
				if(array_key_exists($i . "_name", $bookmarks) && $bookmarks[$i . "_id"] 
					== $this->session->getVar('sql_lastSolo'))
				{
					$found = TRUE;
					break;
				}
			}
			if(!$found)
				$this->bookmark[$messages->text("menu", "bookmarkAdd")] = 'index.php?action=bookmarkAddInit';
		}
		if(sizeof($bookmarks) > 1)
		{
			for($i = 1; $i <= 10; $i++)
			{
				if(array_key_exists($i . "_name", $bookmarks))
					$this->bookmark[stripslashes($bookmarks[$i . "_name"])] = 
					htmlentities("index.php?action=resourceView&id=") . $bookmarks[$i . "_id"];
			}
		}
		$this->edit = array(
				$messages->text("menu", "edit")		=>	'index.php?action=editNoMenu',
				$messages->text("menu", "creator")	=>	'index.php?action=editCreator',
				$messages->text("menu", "collection")	=>	'index.php?action=editCollection',
				$messages->text("menu", "publisher")	=>	'index.php?action=editPublisher',
				$messages->text("menu", "keyword")	=>	'index.php?action=editKeyword',
			);
		$this->resource = array(
				$messages->text("menu", "res")		=>	'index.php?action=resourceNoMenu',
				$messages->text("menu", "list")		=>	'index.php?action=listDisplay',
				$messages->text("menu", "select")	=>	'index.php?action=selectDisplay',
				$messages->text("menu", "search")	=>	'index.php?action=searchDisplay',
				$messages->text("menu", "powerSearch")	=>	'index.php?action=powerSearchDisplay',
			);
/*
		$this->wp = array(
				$messages->text("menu", "wp")		=>	'index.php?action=wpNoMenu',
				$messages->text("menu", "newWp")		=>	'index.php?action=wpNew',
			);
*/
		$this->text = array(
				$messages->text("menu", "text")		=>	'index.php?action=textNoMenu',
				$messages->text("menu", "allMusings")	=>	'index.php?action=allMusings',
				$messages->text("menu", "randomMusings")	=>	'index.php?action=randomMusing',
				$messages->text("menu", "allParaphrases")	=> 'index.php?action=allParaphrases',
				$messages->text("menu", "randomParaphrases")	=> 'index.php?action=randomParaphrase',
				$messages->text("menu", "allQuotes")	=>	'index.php?action=allQuotes',
				$messages->text("menu", "randomQuotes")	=>	'index.php?action=randomQuote',
			);
		if($this->session->getVar('sql_lastSolo'))
			$this->resource[$messages->text("menu", "lastSolo")] = 'index.php?action=lastSolo';
		if($this->session->getVar('sql_stmt'))
			$this->resource[$messages->text("menu", "lastMulti")] = 'index.php?action=lastMulti';
		if($this->session->getVar("setup_write"))
		{
			$this->resource[$messages->text("menu", "new")] = 'index.php?action=resourceNew';
			$this->resource[$messages->text("menu", "pasteBibtex")] = 'index.php?action=resourcePasteBibtex';
		}
		$this->admin = array(
				$messages->text("menu", "admin")	=>	'index.php?action=adminNoMenu',
				$messages->text("menu", "conf")		=>'index.php?action=adminConfigureDisplay',
				$messages->text("menu", "styles")	=>	'index.php?action=adminStyle',
				$messages->text("menu", "category")	=>	'index.php?action=adminGroup',
				$messages->text("menu", "delete")	=>'index.php?action=deleteResourceDisplay',
				$messages->text("menu", "customField")	=>	'index.php?action=customDisplay',
				$messages->text("menu", "user")		=>	'index.php?action=adminUser',
				$messages->text("menu", "news")		=>	'index.php?action=adminNews',
				$messages->text("menu", "importBibtex")	=>	'index.php?action=importBibtexStage1',
				$messages->text("menu", "importEndnote") =>	'index.php?action=importEndnoteStage1',
//				$messages->text("menu", "importhelp")	=>	'index.php?action=helpImportDisplay',
//				$messages->text("menu", "confighelp")	=>	'index.php?action=helpConfigDisplay',
//				$messages->text("menu", "stylehelp")	=>	'index.php?action=helpStyleDisplay',
			);
		$this->help = array(
				$messages->text("menu", "help")		=>	'index.php?action=helpNoMenu',
				$messages->text("menu", "wkxhelp")	=>	'index.php?action=helpDisplay',
				$messages->text("menu", "about")	=>	'index.php?action=aboutWikindx',
			);
			if($this->session->getVar("setup_superadmin"))
			{
				$this->help[$messages->text("menu", "importhelp")] = 'index.php?action=helpImportDisplay';
				$this->help[$messages->text("menu", "confighelp")] = 'index.php?action=helpConfigDisplay';
				$this->help[$messages->text("menu", "stylehelp")] = 'index.php?action=helpStyleDisplay';
			}
	}
// Insert available modules into menu system
	function menuInsert()
	{
		include_once("core/modules/LOADMODULES.php");
		$loadmodules = new LOADMODULES();
// no modules to be loaded
		if(!$moduleList = $loadmodules->readModulesDirectory())
			return;
// valid menu headings - for some reason (PHP5?), the first member of array is never found in search below, 
// therefore, we pad it with dummy member
		$menuHeadings = array("dummy", "wikindx", "file", "edit", "resource", "wp", "text", "admin", "help",);
// else, $moduleList is an array of valid directory names in /modules
		foreach($moduleList as $dirName)
		{
			include_once("modules/" . $dirName . '/index.php');
// class name must be in the form $dirName . MODULE
			$module = $dirName . "_MODULE";
			if(!class_exists($module))
				continue;
			$class = new $module(FALSE, FALSE);
// Check we have valid menu plugs, if so, insert into menu
			if(isset($class->menus))
			{
				foreach($class->menus as $menu => $array)
				{
					if(array_search($menu, $menuHeadings) && is_array($array))
					{
						foreach($array as $entry => $action)
						{
							if($entry && $action && method_exists($class, $action))
							{
								$action = $dirName . '_' . $action;
								$this->{$menu}[$entry] = 
								'index.php?action=' . $action;
							}
						}
					}
				}
			}
		}
	}
// print menus
// submenus have to be created before the menu item is
	function menus()
	{
// if setup_language not set, this is an admin about to configure WIKINDX for the first time.
		if(!$this->session->getVar("setup_language"))
			return FALSE;
		$this->configure();
// Check for plug-in modules
		$this->menuInsert();
		$main = each($this->wikindx);
		while(list($key, $value) = each($this->wikindx))
			$this->template->addMenuItem('submenu', $key, $value);
		$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');

		$main = each($this->file);
		while(list($key, $value) = each($this->file))
			$this->template->addMenuItem('submenu', $key, $value);
		$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
		
		if(isset($this->bookmark))
		{
			$main = each($this->bookmark);
			while(list($key, $value) = each($this->bookmark))
				$this->template->addMenuItem('submenu', $key, $value);
			$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
		}
		if($this->session->getVar("setup_write"))
		{
			$main = each($this->edit);
			while(list($key, $value) = each($this->edit))
				$this->template->addMenuItem('submenu', $key, $value);
			$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
		}

		$main = each($this->resource);
		while(list($key, $value) = each($this->resource))
			$this->template->addMenuItem('submenu', $key, $value);
		$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
/*
		if($this->session->getVar("setup_write"))
		{
			$main = each($this->wp);
			while(list($key, $value) = each($this->wp))
				$this->template->addMenuItem('submenu', $key, $value);
			$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
		}
*/
		$main = each($this->text);
		while(list($key, $value) = each($this->text))
			$this->template->addMenuItem('submenu', $key, $value);
		$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');

// If not admin, don't display admin menu
		if($this->session->getVar("setup_superadmin"))
		{
			$main = each($this->admin);
			while(list($key, $value) = each($this->admin))
				$this->template->addMenuItem('submenu', $key, $value);
			$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');
		}

		$main = each($this->help);
		while(list($key, $value) = each($this->help))
			$this->template->addMenuItem('submenu', $key, $value);
		$this->template->addMenuItem('nav', $main['key'], $main['value'], 'submenu');

		return $this->template->process();
	}
// no menu system - produce standard hyperlinks in body of page
	function noMenu($type)
	{
		$this->configure();
		$pString = '';
		if($type == 'bookmark')
		{
			$bookmarks = $this->session->getArray("bookmark");
			if((sizeof($bookmarks) == 1))
				return $pString;
		}
		array_shift($this->$type);
		foreach($this->$type as $key => $value)
			$pString .= MISC::span(MISC::a("link", $key, $value)) . "&nbsp;&nbsp;&nbsp;&nbsp;";
		return $pString;
	}
}
?>
