<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* FORM miscellaneous class
*****/
class FORMMISC
{
// constructor
	function FORMMISC()
	{
		include_once("core/session/SESSION.php");
		$this->session = new SESSION();
	}
// reduce the size of long text (in select boxes usually) to keep web browser display tidy
// optional $override allows the programmer to override the user set preferences
	function reduceLongText($text, $override = FALSE)
	{
		$limit = $override ? $override : $this->session->getVar("setup_stringLimit");
		if(($limit != -1) && ($count = preg_match_all("/./", $text, $throwAway)) > $limit)
		{
			$start = floor(($limit/2) - 2);
			$length = $count - (2 * $start);
			$text = substr_replace($text, " ... ", $start, $length);
		}
		return $text;
	}
}
?>
