<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* FORM widgets class
*****/
class FORM
{
// constructor
	function FORM()
	{
	}
// print form header with hidden action field
	function formHeader($action)
	{
		global $PHP_SELF;
		$pString = <<< END
<form method="post" action="$PHP_SELF">
<input type="hidden" name="action" value="$action" />
END;
		return $pString . "\n";
	}
// end a form
	function formEnd()
	{
		return "</form>\n";
	}
// print form header with hidden action field for multi-part upload forms
	function formMultiHeader($action)
	{
		global $PHP_SELF;
		$pString = <<< END
<form enctype="multipart/form-data" method="post" action="$PHP_SELF">
<input type="hidden" name="action" value="$action" />
END;
		return $pString . "\n";
	}
// print form footer with submit field
	function formSubmit($value = FALSE)
	{
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
		if(!$value)
			$value = $messages->text("submit", "Submit");
		else
			$value = $messages->text("submit", $value);
		$pString = <<< END
<input type="submit" value=" $value " />
END;
		return $pString . "\n";
	}
// print form reset button
	function formReset()
	{
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
		$value = $messages->text("submit", "reset");
		$pString = <<< END
<input type="reset" value=" $value " />
END;
		return $pString . "\n";
	}
// print hidden form input
	function hidden($name, $value)
	{
		$pString = <<< END
<input type="hidden" name="$name" value="$value" />
END;
		return $pString . "\n";
	}
// print radio button
	function radioButton($label, $name, $value = FALSE, $checked = FALSE)
	{
		$checked ? $checked = "checked=\"checked\"" : "";
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<input type="radio" name="$name" value="$value" $checked />
END;
		return $pString . "\n";
	}
// print checkbox
	function checkbox($label, $name, $checked = FALSE)
	{
		$checked ? $checked = "checked=\"checked\"" : "";
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<input type="checkbox" name="$name" $checked />
END;
		return $pString . "\n";
	}
// create select boxes for HTML forms
// requires $name, $array and optional $size.
// First OPTION is always SELECTED
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectFBox($label, $name, $array, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\">\n";
		$value = array_shift($array);
		$string = $formMisc->reduceLongText($value, $override);
		$pString .= "<option value=\"$value\" selected=\"selected\">" . $string . "</option>\n";
		foreach($array as $value)
		{
			$string = $formMisc->reduceLongText($value, $override);
			$pString .= "<option value=\"$value\">$string</option>\n";
		}
		$pString .= "</select>\n";
		return $pString;
	}
// create select boxes for HTML forms
// requires $name, $array, selected value and optional $size.
// 'selected value' is set SELECTED
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectedBox($label, $name, $array, $select, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\">\n";
		foreach($array as $value)
		{
			if($value == $select)
			{
				$string = $formMisc->reduceLongText($value, $override);
				$pString .= "<option value=\"$value\" selected=\"selected\">$string</option>\n";
			}
			else
			{
				$value = $formMisc->reduceLongText($value, $override);
				$pString .= "<option>$value</option>\n";
			}
		}
		$pString .= "</select>\n";
		return $pString;
	}
// create select boxes form HTML forms
// requires $name, $array and optional $size.
// First entry is default selection.
// OPTION VALUE is set so expects assoc. array where key holds this value
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectFBoxValue($label, $name, $array, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		$pString = '';
		if($label)
			$pString = "$label:<br />\n";
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\">\n";
		$pString .= "<option value=\"" . key($array) . "\" selected=\"selected\">" .
			$formMisc->reduceLongText(current($array), $override) . "</option>\n";
		$doneFirst = FALSE;
		foreach($array as $key => $value)
		{
			$value = $formMisc->reduceLongText($value, $override);
			if(!$doneFirst)
			{
				$doneFirst = TRUE;
				continue;
			}
			$pString .= "<option value=\"$key\">$value</option>\n";
		}
		$pString .= "</select>\n";
		return $pString;
	}
// create select boxes form HTML forms
// requires $name, $array and optional $size.
// $select is default selection.
// OPTION VALUE is set so expects assoc. array where key holds this value
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectedBoxValue($label, $name, $array, $select, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		$pString = '';
		if($label)
			$pString = "$label:<br />\n";
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\">\n";
		foreach($array as $key => $value)
		{
			$value = $formMisc->reduceLongText($value, $override);
			($key == $select) ?
				$pString .= "<option value=\"$key\" selected=\"selected\">$value</option>\n" :
				$pString .= "<option value=\"$key\">$value</option>\n";
		}
		$pString .= "</select>\n";
		return $pString;
	}
// create select boxes form HTML forms
// requires $name, $array and optional $size.
// First entry is default selection.
// OPTION VALUE is set so expects assoc. array where key holds this value.
// MULTIPLE values may be selected
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectFBoxValueMultiple($label, $name, $array, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		$pString = '';
		if($label)
			$pString = "$label:<br />\n";
		$name .= '[]';
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\" multiple=\"multiple\">\n";
		$pString .= "<option value=\"" . key($array) . "\" selected=\"selected\">" .
			$formMisc->reduceLongText(current($array), $override) . "</option>\n";
		$doneFirst = FALSE;
		foreach($array as $key => $value)
		{
			$value = $formMisc->reduceLongText($value, $override);
			if(!$doneFirst)
			{
				$doneFirst = TRUE;
				continue;
			}
			$pString .= "<option value=\"$key\">$value</option>\n";
		}
		$pString .= "</select>\n";
		return $pString;
	}
// create select boxes form HTML forms
// requires $name, $array, selected values (array of) and optional $size.
// OPTION VALUE is set so expects assoc. array where key holds this value.
// MULTIPLE values may be selected
// optional $override allows the programmer to override the user set preferences for character limiting in select boxes
	function selectedBoxValueMultiple($label, $name, $array, $values, $size = 3, $override = FALSE)
	{
		include_once("core/html/FORMMISC.php");
		$formMisc = new FORMMISC();
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
		$pString = '';
		if($label)
			$pString = "$label:<br />\n";
		$name .= '[]';
		$pString .= "<select name=\"$name\" id=\"$name\" size=\"$size\" multiple=\"multiple\">\n";
		foreach($array as $key => $value)
		{
			if($value == $messages->text("misc", "ignore"))
			{
				$pString .= "<option value=\"$key\">$value</option>\n";
				continue;
			}
			$value = $formMisc->reduceLongText($value, $override);
			if(array_search($key, $values) !== FALSE)
				$pString .= "<option value=\"" . $key .
					"\" selected=\"selected\">" . $value . "</option>\n";
			else
				$pString .= "<option value=\"$key\">$value</option>\n";
		}
/* This is slow, slow, so slow! MG - 1/April/2005  Above is quicker (much, much quicker!)
		foreach($array as $key => $value)
		{
			$match = FALSE;
			$value = $formMisc->reduceLongText($value, $override);
			foreach($values AS $select)
			{
				if($value == $messages->text("misc", "ignore"))
					break;
				if($key == $select)
				{
					$pString .= "<option value=\"" . $key .
						"\" selected=\"selected\">" . $value . "</option>\n";
					$match = TRUE;
					break;
				}
			}
			if(!$match)
				$pString .= "<option value=\"$key\">$value</option>\n";
		}
*/
		$pString .= "</select>\n";
		return $pString;
	}
// password input type
	function passwordInput($label, $name, $value = FALSE, $size = 20, $maxLength = 255)
	{
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<input type="password" name="$name" value="$value" size="$size" maxlength="$maxLength" />
END;
		return $pString . "\n";
	}
// text input type
	function textInput($label, $name, $value = FALSE, $size = 20, $maxLength = 255)
	{
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<input type="text" name="$name" value="$value" size="$size" maxlength="$maxLength" />
END;
		return $pString . "\n";
	}
// textarea input type
	function textareaInput($label, $name, $value = FALSE, $cols = 30, $rows = 5)
	{
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<textarea name="$name" id="$name" cols="$cols" rows="$rows">$value</textarea>
END;
		return $pString . "\n";
	}
// upload box
	function fileUpload($label, $name, $size = 20)
	{
		$pString = '';
		if($label)
			$pString = "$label:<br />";
		$pString .= <<< END
<input type="file" name="$name" size="$size" />
END;
		return $pString . "\n";
	}
}
?>
