<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* CLOSENOMENU class
*
* Close WIKINDX tidily and print footer (no menu - used for initial logon screen).
* Requires $dbh object to be passed to it.
*
*****/
class CLOSENOMENU
{
// Constructor
	function CLOSENOMENU($db, $pString = FALSE)
	{
		include_once("core/html/HTTPHEADER.php");
		include_once("core/html/OPENBODY.php");
//		include_once("core/html/MENU.php");
		new HTTPHEADER();
		print HTTPHEADER::header();
		new OPENBODY();
		print OPENBODY::body();
//		$menu = new MENU();
//		print $menu->menus();
		// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('footer');

                 // AGN begin left in for compatibility purposes
		if($pString)
			print $pString;
                 // AGN end left in for compatibility purposes
		$this->db = $db;
		$this->footer();
		ob_end_flush();
		die;
	}
// print WIKINDX footer
	function footer()
	{
		include_once("core/init/SCRIPTTIME.php");
		include_once("core/init/INIT.php");
		list($version, $year, $url) = INIT::version();
		$timer = new SCRIPTTIME();
		global $WIKINDX_DB_QUERIES;
		global $WIKINDX_START_TIME;
		$recordset = $this->db->select(array("WKX_database_summary"), array("totalResources"));
		$totalResources = $this->db->fetchOne($recordset);

// Mark: added $version, $year and $url from INIT::version()
                 $this->template->setVar('totalResources', $totalResources);
                 $this->template->setVar('wkx_link', $url);
                 $this->template->setVar('wkx_title', 'wikindx');
                 $this->template->setVar('wkx_version', $version);
                 $this->template->setVar('copyright', "&copy;$year");
                 $this->template->setVar('db_queries_title', 'Database queries');
                 $this->template->setVar('db_queries', $WIKINDX_DB_QUERIES);

                 $this->template->setVar('script_exe_title', 'Script execution');
                 $this->template->setVar('script_exe_time', $timer->elapsedTime($WIKINDX_START_TIME) . " secs");

		print $this->template->process();
	}
}
?>
