<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* CLOSE class
*
* Close WIKINDX tidily and print footer.
* Requires $dbh object to be passed to it.
*
*****/
class CLOSE
{
// Constructor
	function CLOSE($db, $pString = FALSE)
	{
		include_once("core/html/HTTPHEADER.php");
		include_once("core/html/OPENBODY.php");
		include_once("core/html/MENU.php");
		new HTTPHEADER();
		print HTTPHEADER::header();
		new OPENBODY();
// Debugging - print session details
//global $_SESSION;
//print_r($_SESSION); print "<P>";
// End Debugging
		print OPENBODY::body($db);
		$menu = new MENU();
		print $menu->menus();
		// Start the templating system
		include_once("core/template/TEMPLATE.php");
		$this->template = new TEMPLATE('footer');

                 // AGN begin left in for compatibility purposes
		if($pString)
			print $pString;
                 // AGN end left in for compatibility purposes
		$this->db = $db;
		$this->footer($db);
		ob_end_flush();
		$this->tidySession();
		die;
	}
// print WIKINDX footer
	function footer($db)
	{
		include_once("core/init/SCRIPTTIME.php");
		$timer = new SCRIPTTIME();
		global $WIKINDX_START_TIME;
		include_once("core/html/HTML.php");
		$html = new HTML();
		include_once("core/messages/MESSAGES.php");
		$messages = new MESSAGES();
		include_once("core/session/SESSION.php");
		$session = new SESSION();
		include_once("core/init/INIT.php");
		list($version, $year, $url) = INIT::version();
		global $WIKINDX_DB_QUERIES;
		$recordset = $this->db->select(array("WKX_database_summary"), array("totalResources"));
                $totalResources = $this->db->fetchOne($recordset);

// Mark: added $version, $year and $url from INIT::version()
                 $this->template->setVar('totalResources', $totalResources);
                 $this->template->setVar('wkx_link', $url);
                 $this->template->setVar('wkx_title', 'wikindx');
                 $this->template->setVar('wkx_version', $version);
                 $this->template->setVar('copyright', "&copy;$year");
                 $this->template->setVar('db_queries_title', 'Database queries');
                 $this->template->setVar('db_queries', $WIKINDX_DB_QUERIES);

                 $this->template->setVar('script_exe_title', 'Script execution');
                 $this->template->setVar('script_exe_time', $timer->elapsedTime($WIKINDX_START_TIME) . " secs");
// if this is a logged in user, display the username after the heading
		if(($userId = $session->getVar('setup_userId')) && $db)
		{
			$recordset = $db->select(array('WKX_users'), array('username'), 
				" WHERE " . $db->formatfield('id') . "=" . $db->tidyInput($userId));
			$username = $html->dbToHtmlTidy($db->fetchOne($recordset));
			if($username)
				$this->template->setVar('headingUsername', 
					$messages->text("user", "username") . ":&nbsp;" . $username);
		}
		echo $this->template->process();
	}
/*
* tidySession
*
* @author Mark Grimshaw
* @version 1
*
* Added 5/March/2005 as a convenient place to clear certain session values which we definitely don't want 
* the next time around
*/
	function tidySession()
	{
		include_once("core/session/SESSION.php");
		$session = new SESSION();
// This is used in BIBSTYLE to remember the previous primary creator name in case it's repeated in the subsequent
// entry in the bibliographic list and the bibliographic style requires that it be replaced by '____' or equivalent.
// Not clearing it may produce the replacement incorrectly for the next listing.
		$session->delVar("style_previousCreator");
	}
}
?>
